// Fichero de POVRAY 3 por:
// POVRAY 3 file by:
//  Guillermo S. Romero

// E-mail:     famrom@ran.es
// Snail-mail: P.O.Box 35099-28080 Madrid (Espaa)

// Este fichero contiene:
//  Una escena de dibujos animados con POV estandar.
//--
// This file contains:
//  A cartoon scene with standard POV.


#include "colors.inc"
#include "cartoon.inc"

global_settings {
    assumed_gamma 2.4
    max_trace_level 20
}

background { SkyBlue }

sky_sphere {
    pigment {
        bozo
        color_map {
            [ .4 White ]
            [ .4 SkyBlue ]
        }
        scale <1, .2, 1> * .04
        rotate -1 * z
        turbulence .1
    }
}

plane {
    y, 0
    texture {
        pigment { Wheat }
        finish { F_Cartoon9 }
    }
}

light_source {
    <500, 500, -500> White *.5
//    shadowless
    rotate -30 * y
}
light_source {
    <500, 500, -500> White *.5
    shadowless
    rotate 15 * y
}


camera {
    location <0, 1.5, -5>
    look_at <0, 1, 0>
    angle 45
    normal {
        bumps .002
        scale .025
    }
}


// Trees
#declare TreeTrunkY = 2
#declare Branches = 3
#declare Roots = 4
#declare TrunkRand = seed(8000)

#declare LeafRand1 = seed(8100)
#declare LeafRand2 = seed(8200)
#declare LeafRand3 = seed(8300)

#include "tree.inc"
object {
    Tree
    rotate 40 * y
    scale .75
    translate <1, 0, 6>
}

#declare TreeTrunkY = 2
#declare Branches = 4
#declare Roots = 4
#declare TrunkRand = seed(8001)

#declare LeafRand1 = seed(8101)
#declare LeafRand2 = seed(8201)
#declare LeafRand3 = seed(8301)

#include "tree.inc"
object {
    Tree
    scale .6
    translate <3.5, 0, 4>
}

#declare TreeTrunkY = 2.5
#declare Branches = 4
#declare Roots = 5
#declare TrunkRand = seed(8002)

#declare LeafRand1 = seed(8103)
#declare LeafRand2 = seed(8203)
#declare LeafRand3 = seed(8303)

#include "tree.inc"
object {
    Tree
    scale .75
    translate <-2.5, 0, 5.5>
}

#declare TreeTrunkY = .5
#declare Branches = 2
#declare Roots = 2
#declare TrunkRand = seed(8003)

#declare LeafRand1 = seed(8104)
#declare LeafRand2 = seed(8204)
#declare LeafRand3 = seed(8304)

#include "tree.inc"
object {
    Leafes
    translate - (TreeTrunkY + 2) * y
    scale <.75, .6, .75> * .5
    translate <2.75, 0, 10>
}

object {
    Leafes
    translate - (TreeTrunkY + 2) * y
    scale <.75, .6, .75> * .5
    rotate 90 * y
    translate <4.25, 0, 9.5>
}

object {
    Leafes
    translate - (TreeTrunkY + 2) * y
    scale <.75, .6, .75> * .5
    rotate -90 * y
    translate <3.5, .5, 10.5>
}

object {
    Leafes
    translate - (TreeTrunkY + 2) * y
    scale <.75, .6, .75> * .3
    rotate 90 * x
    translate <-5, .5, 6>
}


// Bears
#declare T_BearMain =
    texture {
        pigment { BakersChoc }
        finish { F_Cartoon9 }
    }

#declare T_WhiteZone =
    texture {
        pigment { White }
        finish { F_Cartoon9 }
    }

#include "bear1.inc"

object {
    Bear
    rotate 90*y*.4
}

#declare T_BearMain =
    texture {
        pigment { Tan }
        finish { F_Cartoon9 }
    }

#declare T_WhiteZone =
    texture {
        pigment { White }
        finish { F_Cartoon9 }
    }

#include "bear2.inc"

object {
    Bear
    scale .9
    translate <1, 0, 0>
}

#declare T_BearMain =
    texture {
        pigment { Coral }
        finish { F_Cartoon9 }
    }

#declare T_WhiteZone =
    texture {
        pigment { White }
        finish { F_Cartoon9 }
    }

#include "bear3.inc"

object { Bear
    scale <.6, .5, .6>
    rotate -90*y*.4
    translate <-1, 0, -.5>
}

sphere {
    0, .15
    texture {
        pigment {
            radial
            color_map {
                [ .5 Yellow ]
                [ .5 Blue ]
            }
            frequency 3
        }
        finish { F_Cartoon9 }
    }
    rotate 40 * y
    rotate -45 * x
    translate <0, .15, -1>
    rotate -90*y*.4
    translate <-1, 0, -.5>
}


// House
#include "house.inc"

object {
    House
    rotate -30 * y
    translate <-1.5, 0, 4>
}


// Stones
#include "stone.inc"

object {
    Stone
    scale .5
    translate <1, 0, -1>
}

object {
    Stone
    rotate 90 * x
    scale 1.5
    translate <2.5, 0, 5>
}

object {
    Stone
    rotate 90 * y
//    scale 1.5
    translate <-2.25, 0, 0>
}


// Grass
#declare GrassRand = seed (9000)
#include "grass.inc"

object {
    GrassGroup
    scale 2
    translate <1.25, 0, 4>
}

#declare GrassRand = seed (9001)
#include "grass.inc"

object {
    GrassGroup
    scale 2
    translate <2.5, 0, 3>
}

#declare GrassRand = seed (9002)
#include "grass.inc"

object {
    GrassGroup
    scale 2
    translate <-2.75, 0, 2>
}

#declare GrassRand = seed (9003)
#include "grass.inc"

object {
    GrassGroup
    scale 2
    translate <2.5, 0, 1.5>
}

#declare GrassRand = seed (9003)
#include "grass.inc"

object {
    GrassGroup
    scale 2
    translate <-2, 0, 1.5>
}


// Mountains
#declare Mountains =
    union {
        cone {
            0, 80, <0, 80, 0>, 0
            scale <1, 1, 5>
            translate <-90, 0, -1>
        }
        cone {
            0, 100, <0, 100, 0>, 0
            scale <1, 1, 5>
        }
        cone {
            0, 90, <0, 90, 0>, 0
            scale <1, 1, 5>
            translate <100, 0, -2>
        }
        texture {
            pigment {
                gradient y
                color_map {
                    [ .6 DarkBrown ]
                    [ .6 White ]
                }
                scale <1, 100, 1>
                turbulence .1
            }
            finish { F_Cartoon9 }
        }
    }

object {
    Mountains
    scale <.25, .1, .25>
    translate <50, 0, 300>
}

object {
    Mountains
    scale .25
    translate <-200, 0, 400>
}


// Logo
height_field {
    gif "by-gsr.gif"
    water_level .001
    texture {
        pigment {
            bozo // gradient z+x
            color_map {
                [ 0 color rgb <.25, 1, 1> ]
                [ 1 color rgb <.1, .1, 1> ]
            }
            sine_wave
            scale .25
        }
        finish {
            ambient .2
            diffuse .4
        }
    }
    texture {
        pigment {
            crackle
            color_map {
                [ .05 Black ]
                [ .05 Clear ]
            }
            scale .2
            translate <.5, 0, .5> // To fix big black spots
        }
        finish {
            ambient .1
            diffuse .5
        }
    }
    translate <-.5, 0, -.5>
    scale .4
    rotate -90 * x
    scale <1, .5, 1> * .8
    translate <.95, .125, -1.25>
}


// (C) Guillermo Sanz Romero
// Todos los derechos reservados.
// Si deseas utilizar la totalidad o parte de este fichero puedes hacerlo
//  mientras no sea con fines lucrativos.
// En caso de usarlo para publicidad, recopilaciones de software, inclusin
//  en revistas o alguna otra actividad que suponga una transaccin
//  remunerada (con cualquier tipo de bien, por lo que los trueques y los
//  premios de los concursos tambin quedan incluidos), debes ponerte en
//  contacto utilizando las direcciones de la cabezera para poder acordar las
//  condiciones que te permitan hacer dicho uso de los datos contenidos en
//  este fichero o los generados a partir de l, tanto descripciones de
//  imagenes como las imagenes en si, en cualquier formato y/o medio de
//  almacenamiento.
//--
// All rights reserved.
// If you want to use this file in is enterity or only parts of it you can do
//  it while it is a non-profitable purpose.
// In case of using it for advertisment, software recopilations, bunddling it
//  with magazines or another profitable transaction (any sort of profit, so
//  exchange and prizes won in contests are included), you must get in touch
//  with me through the addresses given above to reach an agreement about the
//  conditions to use the data here contained (this file) or build from it,
//  both new image descriptions and images, whatever the format and/or the
//  storage way.

// No dudes en escribirme si tienes alguna pregunta, tanto sobre la clusula
//  arriba expuesta como sobre el fichero de datos que describe las imgenes
//  y las imgenes en si.
// P.D.: los precios son razonables y el dinero esta destinado bsicamente
//  a mejorar mi ordenador y poder seguir creando ms imagenes.
//--
// Do not doubt to write me if you has any question, about the clausule 
//  written above or the descriptions and the images.
// P.S.: prices are reasonable and money is basically to improve my computer
//  so I can keep making more pictures.

// NOTA IMPORTANTE
//  Este es un extracto de la licencia completa (LICENSE.GSR), lee dicho
//  fichero para conocer todas las condiciones y clusulas.
//--
// IMPORTANT NOTE
//  This is an extract of the complete license (LICENSE.GSR), read that file
//  to know all the conditions and clausules.
