#ifndef (Master)

	#include "colors.inc"
	#include "textures.inc"
	#include "shapes.inc"

	camera {
	   location <0, 0, -5>
	   up <0,1,0>
	   direction z
	   right x* 4/3
	   look_at <0, 0, 0>
	   }

	light_source { <15, 15, -35> color White }

#end


#declare RED_PLASTIC = texture {
    finish { ambient 0.1
             diffuse 0.7
             phong 1.0
             phong_size 70.0 }
    pigment { color Red }
}

#declare YELLOW_PLASTIC = texture {
    finish { ambient 0.8
             diffuse 0.7
             phong 1.0
             phong_size 70.0
					 }
    pigment { color Yellow }
}


#declare Fabric  =
height_field {
    tga "drapemap.tga"
    smooth
    scale <1, 0.2, 4>
    rotate x*90
    translate -x*0.5
}

#declare Rideau1 =
object {
    Fabric
    clipped_by
			{
//        object { Cube scale <0.01, 1, 1> inverse }
      object
				{
				Sphere scale <1.1, 7, 1> translate <-1, 0, 0>
				}
	    }
}

#declare Rideau2 =
object {
    Fabric
    clipped_by
			{
//        object { Cube scale <0.01, 1, 1> inverse }
      object
				{
				Sphere scale <1.1, 7, 1> translate <1, 0, 0>
				}
	    }
}

#declare Valance =
object {
    Fabric
    scale <1, 0.15, 1>
    rotate y*180     // just for variety
}

#declare Rideau =
    union {
        object { Rideau1 scale <1, 1, 1>}
        object { Rideau2 scale <1, 1, 1>}
        object { Valance scale <1, 1, 1> translate <0, -0.075, -0.075>}
    pigment {Red}
	}


#declare Circus1 =
	union {
		cylinder { 0*z, 1*z, 1 }
		box { < 0, -1, 0>, < 8, 1, 1> }
		cylinder { 0*z, 1*z, 1
			translate x*8
		 }
    texture { RED_PLASTIC}
}


#declare Titre =
	text
	{
  	ttf
  	"lcallig.ttf",
  	"Circus",
  	2,
  	0
    texture {YELLOW_PLASTIC}
	}


#declare Circus =
	difference { object {Circus1}
		cylinder { -0.2*z, 0.8*z, 0.8 }
		box { < 0, -0.8, -0.2>, < 7.8, 0.8, 0.8> }
		cylinder { -0.2*z, 0.8*z, 0.8
			translate x*8
		 }
    texture {RED_PLASTIC}
}


#ifndef (Master)

object { Rideau
		scale x*4
    translate <0, 2, 0>
		}
object {Circus
		scale <0.3,0.3,0.2>
    translate <-1.2,1.0,-0.2>
}
object {Titre
		scale <0.7,0.4,1>
    translate <-1.1,0.8,-0.2>
}
#end

