#ifndef (Master)

	#include "colors.inc"
	#include "textures.inc"
	#include "shapes.inc"

camera {
	location <0,5,-16>
	look_at  <0,3,0>
   right x* 4/3
}


light_source
{
  0*x                     // light's position (translated below)
  color White       // light's color
  spotlight               // this kind of light source
  translate <0, 15, -10> // <x y z> position of light
  point_at <0, 3, 8>      // direction of spotlight
  radius 8                // hotspot (inner, in degrees)
  tightness 10            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 15               // intensity falloff radius (outer, in degrees)
}

light_source
{
  0*x                     // light's position (translated below)
  color Gray70       // light's color
  spotlight               // this kind of light source
  translate <-10, 20, -10> // <x y z> position of light
  point_at <0, 0, 0>      // direction of spotlight
  radius 140                // hotspot (inner, in degrees)
  tightness 10            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 160               // intensity falloff radius (outer, in degrees)
}

light_source
{
  0*x                     // light's position (translated below)
  color Gray70       // light's color
  spotlight               // this kind of light source
  translate <10, 20, -10> // <x y z> position of light
  point_at <0, 0, 0>      // direction of spotlight
  radius 140                // hotspot (inner, in degrees)
  tightness 10            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 160               // intensity falloff radius (outer, in degrees)
}

#end

#declare REDYELLOW = texture {
    finish { ambient 0.1
             diffuse 0.7
             phong 1.0
             phong_size 70.0 }
   pigment {
      gradient y
      color_map {
         [0.0 0.33 color Red color Red]
         [0.33 0.66 color Yellow color Yellow]
         [0.66 1.00 color Red color Red]
      }
      quick_color Red
      scale 0.5
      translate 1*y
   }
}

#declare SOCLE=
cone {
  0*y, 1.0,
  1*y, 0.5
//  open
	texture {REDYELLOW}
	}

#ifndef (Master)
	object {SOCLE
		scale <2,2,2>
				}
#end
