
// Persistence of Vision Ray Tracer Scene Description File
// File: truck.pov
// Vers: 1.00
// Desc: Pink and off-white ice cream truck. Has decals on side and
//       rear. 
// Date: 26th Nov 1997. 
// Auth: Chris Hernandez



// ==== Standard POV-Ray Includes ====
#include "colors.inc"


// ******************************************************************************************
//     Define globals - textures, building blocks etc.
// ******************************************************************************************


// ------------------------------------- Define Textures ------------------------------------

#declare ICT_MainTexture = texture {
   pigment {
	  gradient y
	  color_map {
		 [ 0.0 color rgb <0.99, 0.80, 0.80> ]
		 [ 0.5 color rgb <0.99, 0.80, 0.80> ]
		 [ 0.5 color rgb <0.99, 0.96, 0.90> ]
		 [ 1.0 color rgb <0.99, 0.96, 0.90> ]
	  }
	  scale 3
	  translate -y*0.6
   }
   finish {
	  ambient 0.45
	  diffuse 0.35
	  specular 0.15
	  roughness 0.75
	  metallic
	  reflection 0.02
	  crand 0.01
   }
}

#declare DustLayer = texture {
   pigment {
	  bozo
	  color_map {
		 [ 0.0 color rgbt <0.6, 0.6, 0.6, 0.95> ]
		 [ 0.2 color rgbt <0.6, 0.6, 0.6, 1.00> ]
		 [ 0.8 color rgbt <0.6, 0.6, 0.6, 0.98> ]
		 [ 0.9 color rgbt <0.6, 0.6, 0.6, 0.94> ]
		 [ 1.0 color rgbt <0.6, 0.6, 0.6, 0.95> ]
	  }
	  turbulence 0.9 //0.5
   }
   normal { bumps 0.05 scale 0.1 }
   scale 0.03
}


#declare ICT_Decal1 = texture {
   pigment {
	  image_map {
		 gif "decal1c.gif"
		 map_type 0
		 interpolate 2
		 transmit 255 1.0
		 once
	  }
   }
   finish {
	  ambient 0.45
	  diffuse 0.35
	  specular 0.15
	  roughness 0.75
	  metallic
	  reflection 0.02
	  crand 0.01
   }
   scale 1.2
}

#declare ICT_Price_List = texture {
   pigment {
	  image_map {
		 gif "prices.gif"
		 map_type 0
		 interpolate 2
		 once
	  }
   }
   finish {
	  ambient 0.45
	  diffuse 0
	  specular 0.15
	  roughness 0.75
	  metallic
	  reflection 0.02
	  crand 0.01
   }
   //translate <-0.5, -0.5, 0>
   scale <0.6, 0.8, 1>
}

#declare ICTruck_HandleTexture = texture {   // Also used for rear door handle texture
   pigment { color rgb <0.8, 0.78, 0.75> }
   finish {
	  ambient 0.35
	  diffuse 0.35
	  specular 0.5
	  roughness 0.05
	  reflection 0.025
	  metallic
   }
}

#declare ICT_RVMTexture = texture { // ------- Rear view mirror texture
   pigment { color rgb <0.15, 0.15, 0.15> }
   finish  { ambient 0.35 diffuse 0.35 specular 0.1 roughness 0.1 crand 0.1 }
   normal  { bumps 0.35 scale 0.01 }
}

#declare ICT_WindowTexture = texture {
   //pigment { color rgbf<0.9, 0.9, 0.9, 0.9> }
   pigment {
	  bozo
	  color_map {
		 [ 0.0 color rgbf <0.86, 0.86, 0.86, 0.9> ]
		 [ 0.2 color rgbf <0.92, 0.92, 0.92, 0.9> ]
		 [ 0.8 color rgbf <0.92, 0.92, 0.92, 0.9> ]
		 [ 0.9 color rgbf <0.90, 0.90, 0.90, 0.9> ]
		 [ 1.0 color rgbf <0.86, 0.86, 0.86, 0.9> ]
	  }
	  turbulence 0.02
   }
   finish  {
	  specular 1
	  roughness 0.001
	  ambient 0.05
	  diffuse 0.05
	  refraction on
	  reflection 0.15
	  ior 1.5
	  //caustics 0.5
	  brilliance 2 //8
   }
}

#declare ICT_SpkrTexture = texture {
   pigment { color rgb <0.975, 0.975, 0.975>}
   finish  { ambient 0.2 diffuse 0.35 specular 0.5 roughness 0.01 reflection 0.15 }
}




// ------------------------------ Define some building blocks --------------------------------

#declare ICT_MidLength = 2.5

#declare ICT_CurveRad = 0.1
#declare RoundCyl = object {
   union {
	  cylinder { -1*z, 1*z, 1 }
	  torus { 1-ICT_CurveRad, ICT_CurveRad rotate -x*90 translate -1*z }
	  torus { 1-ICT_CurveRad, ICT_CurveRad rotate -x*90 translate  1*z }
	  cylinder { -(ICT_CurveRad+1)*z, (ICT_CurveRad+1)*z, 1-ICT_CurveRad }
   }
}

#declare ICT_CurveRad2 = 0.3
#declare RoundCyl2 = object {
   union {
	  cylinder { -1*z, 1*z, 1 }
	  torus { 1-ICT_CurveRad2, ICT_CurveRad2 rotate -x*90 translate -1*z }
	  torus { 1-ICT_CurveRad2, ICT_CurveRad2 rotate -x*90 translate  1*z }
	  cylinder { -(ICT_CurveRad2+1)*z, (ICT_CurveRad2+1)*z, 1-ICT_CurveRad2 }
   }
}


// *****************************************************************************************
//     First create raw shell of the truck
// *****************************************************************************************

#declare ICTruck_Body = union {

   //------------- Middle section
   box { <0, 0, -1> < ICT_MidLength, 2, 1> }
   box { <0, 0, -(1+ICT_CurveRad)> < ICT_MidLength, 2-ICT_CurveRad, 1+ICT_CurveRad> }
   cylinder { 0*x, ICT_MidLength*x, ICT_CurveRad translate <0,2-ICT_CurveRad,-1> }
   cylinder { 0*x, ICT_MidLength*x, ICT_CurveRad translate <0,2-ICT_CurveRad,+1> }

   //------------- Rear section
   union {
	  object {
		 RoundCyl
		 clipped_by {
		   plane { -y, 0 }
		   plane { x, 0 }
		 }
		 scale < 0.5, 2, 1>
	  }
	  intersection {
		 object {
			RoundCyl
			clipped_by {
			  plane { -y, 0 }
			  plane { x, 0 }
			}
			scale < 0.5, 2, 1>
		 }
		 box { <-10, 0.25, -0.75> <10, 0.65, 0.75> }
		 texture { ICT_MainTexture }
		 texture {
			pigment {
			   image_map {
				  gif "decal2b.gif"
				  map_type 0
				  interpolate 2
				  transmit 125 1.0 //138 1.0
				  once
			   }
			}
			finish {
			   ambient 0.55
			   diffuse 0.35
			   specular 0.15
			   roughness 0.75
			   metallic
			   reflection 0.02
			   crand 0.01
			}
			translate <-0.5, -0.5, 0>
			rotate y*90
			scale <1, 0.4, 1.5>
			translate y*0.45
		 }
		 texture { DustLayer }
		 translate -x*0.0025
	  }
   }

   //------------ Front Section
   object {
	  RoundCyl
	  clipped_by { plane { -y, 0 }  plane { -x, 0 } }
	  scale < 1.2, 1, 1>
	  translate <ICT_MidLength,1,0>
   }
   box { <ICT_MidLength, 0, -(1+ICT_CurveRad)> < ICT_MidLength+1.2,  1,  1+ICT_CurveRad>}
   object{
	  RoundCyl
	  clipped_by {
		 plane { -y, 0 }
		 plane { -x, 0 }
	  }
	  scale < 0.5, 1, 1>
	  translate <ICT_MidLength+1.2,0,0>
   }

   //----------- Undercarriage
   object{
	  RoundCyl
	  scale <0.2,0.2,1>
	  clipped_by {
		 plane { y, 0 }
		 plane { x, 0 }
	  }
	  translate <-0.3,0,0>
   }
   object{
	  RoundCyl
	  scale <0.2,0.2,1>
	  clipped_by {
		 plane { y, 0 }
		 plane { -x, 0 }
	  }
	  translate <ICT_MidLength+1.5,0,0>
   }
   box { <-0.3, -0.2, -(1+ICT_CurveRad)> < ICT_MidLength+1.5,  0,  (1+ICT_CurveRad)> }

   //----------- Wheel covers + skirting board
   object{
	  RoundCyl2
	  scale <0.65,0.7,0.95>
	  clipped_by {
		 plane { -y, 0 }
	  }
	  translate <0.45, -0.15, 0>
   }
   object{
	  RoundCyl2
	  scale <0.65,0.7,0.95>
	  clipped_by {
		 plane { -y, 0 }
	  }
	  translate <3.2, -0.15, 0>
   }
   box { <0.45,-0.15,0> <3.2, -0.1,-1.225> }
   box { <0.45,-0.15,0> <3.2, -0.1, 1.225> }
}


// *****************************************************************************************
//     Now scoop/hollow out to create windows, door joins etc.
// *****************************************************************************************

#declare ICTruck_Shell = object {

   difference {
	  // ---------- Start with body of truck
	  object { ICTruck_Body }

	  // ---------- Side Windows
	  difference {
		 cylinder { -10*z, 10*z, 0.85 }
		 plane { y, 0 }
		 plane { x, 0 }
		 scale < 1.2, 1, 1>
		 translate <ICT_MidLength,1,0>
	  }
	  // ---------- Front Windows
	  box { <0, 0, -0.95> <10, 0.85, -0.05> translate <ICT_MidLength,1,0> }
	  box { <0, 0, 0.05> <10, 0.85, 0.95> translate <ICT_MidLength,1,0> }

	  // ---------- Rear Windows
	  box { <0, -0.1, -0.85> <-10, 0.65, -0.1> translate <ICT_MidLength,1,0> texture { TempTexture} }
	  box { <0, -0.1, 0.1> <-10, 0.65, 0.85> translate <ICT_MidLength,1,0> texture { TempTexture} }

	  // ---------- Serving Window
	  box { <0, -0.35, 0> <0.8, 0.85, -10> translate <1.4,1,0> }

	  // ---------- Hollow out inside of van
	  box { <0, 0, -1.025> < ICT_MidLength+0.05, 2, 1.025> texture { TempTexture } }
	  difference {
		 cylinder { -1.05*z, 1.05*z, 0.95 }
		 plane { y, 0 }
		 plane { -x, 0 }
		 scale < 0.5, 2, 1>
         translate x*0.05
         texture { TempTexture }
	  }

	  // ---------- Wheel hollows
	  cylinder {
		 -10*z, 10*z, 0.45
		 scale <1.05, 1, 1>
		 translate <0.45, -0.2, 0>
	  }
	  cylinder {
		 -10*z, 10*z, 0.45
		 scale <1.05, 1, 1>
		 translate <3.2, -0.2, 0>
	  }

	  // ---------- Front Door join
	  cylinder { -0.1*y, 1.9*y, 0.015 scale <1,1,0.75> translate <2.355, 0,-1.1> }
	  cylinder { 0.35*y, 1*y, 0.015 scale <1,1,0.75> translate <3.6, 0, -1.1> }
	  cylinder { -0.1*y, 1.9*y, 0.015 scale <1,1,0.75> translate <2.355, 0, 1.1> }
	  cylinder { 0.35*y, 1*y, 0.015 scale <1,1,0.75> translate <3.6, 0,  1.1> }

	  // ---------- Rear Door join
	  difference {
		 union {
			difference {
			   box { <-10, 0.245, -0.95> <1, 1.8, 0.95> }
			   box { <-10, 1.7,  0.85> <1, 1.8,  0.95> }
			   box { <-10, 1.7, -0.85> <1, 1.8, -0.95> }
			   box { <-10, 0.245,  0.85> <1, 0.345,  0.95> }
			   box { <-10, 0.245, -0.85> <1, 0.345, -0.95> }
			}
			cylinder { -10*x, 1*x, 0.1 translate <0, 1.7, -0.85> }
			cylinder { -10*x, 1*x, 0.1 translate <0, 1.7,  0.85> }
			cylinder { -10*x, 1*x, 0.1 translate <0, 0.345, -0.85> }
			cylinder { -10*x, 1*x, 0.1 translate <0, 0.345,  0.85> }
		 }
		 cylinder { -10*z, 10*z, 1 scale <0.5, 2, 1> translate x*0.05 }
		 union {
			difference {
			   box { <-10, 0.275, -0.925> <1, 1.775, -0.015> }
			   box { <-10, 1.675, -0.115> <1, 1.775, -0.015> }
			   box { <-10, 1.675, -0.925> <1, 1.775, -0.825> }
			   box { <-10, 0.275, -0.115> <1, 0.375, -0.015> }
			   box { <-10, 0.275, -0.925> <1, 0.375, -0.825> }
			}
			cylinder { -10*x, 1*x, 0.1 translate <0, 1.675, -0.825> }
			cylinder { -10*x, 1*x, 0.1 translate <0, 1.675, -0.115> }
			cylinder { -10*x, 1*x, 0.1 translate <0, 0.375, -0.825> }
			cylinder { -10*x, 1*x, 0.1 translate <0, 0.375, -0.115> }
		 }
		 union {
			difference {
			   box { <-10, 0.275, 0.925> <1, 1.775, 0.015> }
			   box { <-10, 1.675, 0.115> <1, 1.775, 0.015> }
			   box { <-10, 1.675, 0.925> <1, 1.775, 0.825> }
			   box { <-10, 0.275, 0.115> <1, 0.375, 0.015> }
			   box { <-10, 0.275, 0.925> <1, 0.375, 0.825> }
			}
			cylinder { -10*x, 1*x, 0.1 translate <0, 1.675, 0.825> }
			cylinder { -10*x, 1*x, 0.1 translate <0, 1.675, 0.115> }
			cylinder { -10*x, 1*x, 0.1 translate <0, 0.375, 0.825> }
			cylinder { -10*x, 1*x, 0.1 translate <0, 0.375, 0.115> }
		 }
	  }
   }
}


// ******************************************************************************************
//     Define secondary objects
// ******************************************************************************************


// ------------------------- Front and Rear Bumper plus number plate ------------------------

#declare ICTruck_Bumper = object {
   union {
	  difference {
		 union {
			cylinder { -1.1*z, 1.1*z, 0.15 }
			torus { 0.2, 0.15 clipped_by { plane {z,0} } translate <0.2,0,-1.1> }
			torus { 0.2, 0.15 clipped_by { plane {-z,0} } translate <0.2,0,1.1> }
		 }
		 union {
			cylinder { -1.2*z, 1.2*z, 0.075 }
			sphere { <0,0,0> 0.075 scale <1,1,1.5> translate -z*1.2 }
			sphere { <0,0,0> 0.075 scale <1,1,1.5> translate  z*1.2 }
			scale <0.6, 1, 1.1>
			translate -x*0.15
		 }
		 texture {
			pigment { color rgb <0.94, 0.94, 0.95> }
			finish {
			   ambient 0.275
			   brilliance 8
			   diffuse 0.5
			   metallic
			   specular 0.80
			   roughness 1/80
			   reflection 0.35
			}
		 }
		 texture { DustLayer }
	  }
	  box {
		 <-0.01, -0.15, -0.3> <0, -0.375, 0.3>
		 texture {
			pigment {
			   image_map {
				  gif "platemap.gif"
				  map_type 0
				  interpolate 2
				  once
			   }
			}
			normal {
			   bump_map {
				  gif "platebmp.gif"
				  map_type 0
				  interpolate 2
				  use_color
				  once
				  bump_size 5
			   }
			}
			finish {
			   ambient 0.4
			   diffuse 0.3
			   specular 0.35
			   roughness 0.1
			   metallic
			}
			translate <-0.5, -0.5, 0>
			scale <1, 0.875, 1>
			rotate y*90
			scale < 1, 0.275, 0.6>
			translate -y*0.2625
		 }
		 texture { DustLayer }
		 translate -x*0.15
	  }
   }
}


// ------------------------------------ Wheel plus Tyre ------------------------------------

#declare ICTruck_Wheel = object {
   difference {
	  union {
		 difference {
			cylinder { -0.2*z, 0.2*z, 0.4 }
			cylinder { -10*z, 10*z, 0.2 }
			torus { 0.3, 0.1 rotate x*90 scale <1, 1, 0.5> translate -z*0.2 }
			torus { 0.3, 0.1 rotate x*90 scale <1, 1, 0.5> translate  z*0.2 }
			texture {
			   pigment { color rgb <0.05, 0.05, 0.05> }
			   finish {
				 ambient 0.3
				 diffuse 0.2
				 specular 0.1
				 roughness 0.25
			   }
			}
			texture { DustLayer }
		 }
		 union {
			cone { 0*z, 0.2, -0.1*z, 0.165 }
			cone { -0.1*z, 0.155, -0.14*z, 0.115 }
			sphere { 0*z, 0.1 scale <1, 1, 0.5> translate -z*0.14 }
			torus { 0.075, 0.005 rotate x*90 scale <1, 1, 0.5> translate -z*0.18 }
			texture {
			   pigment { color rgb <0.965, 0.95, 0.955> }
			   finish {
				 ambient 0.3
				 diffuse 0.4
				 specular 0.6
				 roughness 0.0015
				 reflection 0.15
				 //metallic
				 brilliance 6
			   }
			}
			texture { DustLayer }
		 }
	  }
	  // ------------ Create Tread
	  torus { 0.4, 0.0075 rotate x*90 translate -z*0.20 }
	  torus { 0.4, 0.0075 rotate x*90 translate -z*0.15 }
	  torus { 0.4, 0.0075 rotate x*90 translate -z*0.10 }
	  torus { 0.4, 0.0075 rotate x*90 translate -z*0.05 }
	  torus { 0.4, 0.0075 rotate x*90 translate  z*0.00 }
	  torus { 0.4, 0.0075 rotate x*90 translate  z*0.05 }
	  torus { 0.4, 0.0075 rotate x*90 translate  z*0.10 }
	  torus { 0.4, 0.0075 rotate x*90 translate  z*0.15 }
	  torus { 0.4, 0.0075 rotate x*90 translate  z*0.20 }
	  texture {
		 pigment { color rgb <0.02, 0.02, 0.02> }
		 finish {
			ambient 0.3
			diffuse 0.2
			specular 0.1
			roughness 0.25
		 }
	  }
	  texture { DustLayer }
   }
   scale <1, 1, 0.7>
}



// ------------------------------------ Front Door Handles ------------------------------------


#declare ICTruck_FDoorHandle1 = object {
   union {
	  cylinder { -0.1*x, 0.05*x, 0.05 translate <0, 0, -0.1> }
	  torus { 0.1, 0.05 clipped_by { plane {x,0} plane {z,0} } translate <-0.1,0,0> }
	  torus { 0.1, 0.05 clipped_by { plane {-x,0} plane {z,0} } translate <0.05,0,0> }
	  cone { 0*z, 0.05, -0.05*z, 0.03 scale <1, 1, 1> translate <-0.15, -0.135, 0.05> }
	  torus { 0.025, 0.0065 rotate x*90 scale <1, 1, 1> translate <-0.15, -0.135, 0> }
   }
   texture { ICTruck_HandleTexture }
   texture { DustLayer }
   scale <0.8, 0.8, 0.6>
}

#declare ICTruck_FDoorHandle2 = object {
   union {
	  cylinder { -0.1*x, 0.1*x, 0.05 translate <0, 0, 0.1> }
	  torus { 0.1, 0.05 clipped_by { plane {x,0} plane {-z,0} } translate <-0.1,0,0> }
	  torus { 0.1, 0.05 clipped_by { plane {-x,0} plane {-z,0} } translate <0.1,0,0> }
	  cone { 0*z, 0.05, 0.05*z, 0.03 translate <-0.15, -0.135, -0.05> }
	  torus { 0.025, 0.0065 rotate x*90 translate <-0.15, -0.135, 0> }
   }
   texture { ICTruck_HandleTexture }
   texture { DustLayer }
   scale <0.8, 0.8, 0.6>
}



// ------------------------------------- Rear Door Handles ------------------------------------

#declare ICTruck_RDoorHandle = object {
   union {
	  cone { 0*z, 0.085, -0.025*z, 0.055 }
	  cylinder { -0.025*z, -0.075*z, 0.035 }
	  intersection {
		 union {
			sphere { 0*x, 0.065 }
			cone { 0*x, 0.05, 0.3*x, 0.02 }
		 }
		 box { <-0.1, -0.07, -0.0375> <0.5, 0.07, 0> }
		 translate -z*0.075
	  }
	  torus { 0.04, 0.0045 rotate x*90 translate -z*0.115 }
	  cylinder { -z*0.115, -z*0.135, 0.02 }
   }
   texture { ICTruck_HandleTexture }
   texture { DustLayer }
   scale <0.7, 0.7, 1>
}


// ------------------------------------ Rear View Mirrors ------------------------------------


#declare ICTruck_RVMirror1 = object {
   union {
	  sphere { 0*x, 0.1 texture { ICT_RVMTexture } }
	  cone { 0*z, 0.035, -0.1*z, 0.025 texture { ICT_RVMTexture } translate -z*0.1 rotate x*25 }
	  union {
		 sphere {
			0*x, 0.165
			clipped_by { plane {-x,0 } }
			scale <0.85, 1, 1.2>
			texture { ICT_RVMTexture }
			translate -x*0.075
			rotate -x*25
		 }
		 torus {
			0.15, 0.015
			rotate z*90
			scale <0.85, 1, 1.2>
			texture { ICT_RVMTexture }
			translate -x*0.075
			rotate -x*25
		 }
		 cylinder {
			-0.005*x, 0*x, 0.16
			scale <0.85, 1, 1.2>
			translate -x*0.075
			rotate -x*25
			texture {
			   pigment { color rgb <1, 1, 1> }
			   finish { diffuse 0 ambient 0.1 reflection 1 specular 0.75 roughness 0.001 }
			}
			texture { DustLayer }
		 }
		 translate -z*0.36
		 rotate x*25
	  }
   }
   texture { ICT_RVMTexture }
   texture { DustLayer }
   scale 0.75
   rotate y*10
}

#declare ICTruck_RVMirror2 = object {
   union {
	  sphere { 0*x, 0.1 texture { ICT_RVMTexture } }
	  cone { 0*z, 0.035, 0.1*z, 0.025 translate z*0.1 rotate -x*25 texture { ICT_RVMTexture } }
	  union {
		 sphere {
			0*x, 0.165
			clipped_by { plane {-x,0 } }
			texture { ICT_RVMTexture }
			scale <0.85, 1, 1.2>
			translate -x*0.075
			rotate x*25
		 }
		 torus {
			0.15, 0.015
			rotate z*90
			texture { ICT_RVMTexture }
			scale <0.85, 1, 1.2>
			translate -x*0.075
			rotate x*25
		 }
		 cylinder {
			-0.0075*x, 0*x, 0.16
			scale <0.85, 1, 1.2>
			translate -x*0.075
			rotate x*25
			texture {
			   pigment { color rgb <1, 1, 1> }
			   finish { diffuse 0 ambient 0.1 reflection 1 specular 0.75 roughness 0.001 }
			}
			texture { DustLayer }
		 }
		 translate z*0.36
		 rotate -x*25
	  }
   }
   texture { ICT_RVMTexture }
   texture { DustLayer }
   scale 0.75
   rotate -y*10
}




// ------------------------------------ Rear Signal Lights ------------------------------------

#declare ICTruck_RLBlock = object {
   difference {
	  object {
		 RoundCyl
		 clipped_by { plane { -y, 0 } plane { x, 0 } }
		 scale < 0.5, 2, 1>
		 scale 1.025
	  }
	  object {
		 RoundCyl
		 clipped_by { plane { -y, 0 } plane { x, 0 } }
		 scale < 0.5, 2, 10>
		 translate x*0.15
	  }
	  object {
		 RoundCyl
		 clipped_by { plane { -y, 0 } plane { x, 0 } }
		 scale < 10, 2, 0.885>
	  }
   }
}

#declare ICTruck_RearLights = object {
   union {
	  intersection {
		 object { ICTruck_RLBlock }
		 box { <-10, 0.25, -10> <10, 0.4,10> }
		 texture {
			pigment { color rgbf <0.9, 0.2, 0.2, 0.15> }
			finish  { ambient 0.4 diffuse 0.3 specular 0.2 roughness 0.025 crand 0.01 }
			normal  { gradient y scallop_wave scale 0.025 }
		 }
		 texture { DustLayer }
	  }
	  intersection {
		 object { ICTruck_RLBlock }
		 box { <-10, 0.425, -10> <10, 0.525,10> }
		 texture {
			pigment { color rgbf <0.98, 0.98, 0.98, 0.05> }
			finish  { ambient 0.5 diffuse 0.4 specular 0.2 roughness 0.025 crand 0.01 }
			normal  { gradient y scallop_wave scale 0.025 }
		 }
		 texture { DustLayer }
	  }
	  intersection {
		 object { ICTruck_RLBlock }
		 box { <-10, 0.55, -10> <10, 0.7, 10> }
		 texture {
			pigment { color rgbf <1.0, 0.6, 0.3, 0.15> }
			finish  { ambient 0.55 diffuse 0.3 specular 0.2 roughness 0.025 crand 0.01 }
			normal  { gradient y scallop_wave scale 0.025 }
		 }
		 texture { DustLayer }
	  }
	  intersection {
		 object { ICTruck_RLBlock }
		 box { <-10, 0.225, -10> <10, 0.725, 10> }
		 scale <0.985, 1, 0.985>
		 texture {
			pigment { color rgb <0.2, 0.2, 0.2> }
			finish  { ambient 0.45 diffuse 0.35 specular 0.2 roughness 0.075 crand 0.075}
		 }
	  }
   }
}


// ---------------------------------------- Windows -----------------------------------------


#declare ICTruck_SideWindow = object {
   difference {
	  cylinder { -0.01*z, 0.01*z, 0.86 }
	  plane { y, 0 }
	  plane { x, 0 }
   }
   scale < 1.2, 1, 1>
   texture { ICT_WindowTexture }
   //texture { DustLayer }
}

#declare ICTruck_FrontWindow = object {
   difference {
	  cylinder { -0.45*z, 0.45*z, 1 }
	  cylinder { -0.5*z, 0.5*z, 0.98 }
	  plane { y, 0 }
	  plane { x, 0 }
	  plane { -y, -0.85 }
   }
   scale < 1.2, 1, 1>
   texture { ICT_WindowTexture }
   //texture { DustLayer }
}

#declare ICTruck_RearWindow = object {
   intersection {
	  difference {
		 cylinder { 2*z, -2*z, 1 }
		 cylinder { 3*z, -3*z, 0.98 }
		 //plane { y, 0 }
		 plane { -x, 0 }
		 scale < 0.5, 2, 1>
	  }
	  box { <-10, 0.9, -0.375> <10, 1.65, 0.375> }
   }
   texture { ICT_WindowTexture }
}

#declare ICTruck_ServingWindow = object {
   union {
	  box { <0, -0.35, 0> <0.39, 0.85, -0.03> texture { ICT_WindowTexture } }
	  cylinder  {
		 -0.35*y, 0.85*y, 0.045
		 scale <0.7, 1, 1>
		 translate x*0.39
		 texture { ICT_MainTexture translate -y*1.5 }
	  }
   }
}

// --------------------------------------- Misc Parts ---------------------------------------

#declare ICTruck_Grille = object {
   intersection {
	  union {
		 box { <0, 0.00, -5> <1, 0.075, 5> }
		 box { <0, 0.15, -5> <1, 0.225, 5> }
		 box { <0, 0.30, -5> <1, 0.375, 5> }
		 box { <0, 0.45, -5> <1, 0.525, 5> }
		 box { <0, 0.60, -5> <1, 0.675, 5> }
		 box { <0, 0.75, -5> <1, 0.825, 5> }
		 box { <0, 0.90, -5> <1, 0.975, 5> }
		 box { <0, 1.05, -5> <1, 1.125, 5> }
		 box { <0, 1.20, -5> <1, 1.275, 5> }
		 box { <0, 1.35, -5> <1, 1.425, 5> }
		 box { <0, 1.50, -5> <1, 1.575, 5> }
		 scale <1, 0.5, 1>
	  }
	  cylinder { -0.6*z, 0.6*z, 1 scale < 0.5, 1, 1> }
   }
   texture {
	  pigment { color rgb <0.65, 0.5, 0.5> }
	  finish  { ambient 0.35 diffuse 0.35 specular 0.1 roughness 0.05 metallic crand 0.02 }
   }
}


#declare ICTruck_ServingLedge = object {
   box { <0, 0, 0.05> <0.8, 0.05, -0.25> }
   texture { ICT_MainTexture translate -y*0.96 }
}


#declare ICTruck_Headlight = object {
   union {
	  sphere { 0*x, 0.075 clipped_by { plane { x, 0 } } scale <0.7, 1, 1> }
	  torus { 0.075, 0.01 rotate x*90 rotate y*90 scale <0.75, 1, 1> }
	  sphere {
		 0*x, 0.075
		 clipped_by { plane { -x, 0 } }
		 scale <0.3, 1, 1>
		 texture {
			pigment { color rgbf<1.0, 1.0, 1.0, 0> }
			finish {
			   specular 1  roughness 0.001  ambient 0.35  diffuse 0.35
			   refraction 1  reflection 0.1  ior 1.5
			}
		 }
	  }
	  texture {
		 pigment { color rgb <0.96, 0.96, 0.96> }
		 finish  {
			ambient 0.45 diffuse 0.35 specular 0.5 roughness 0.01
			metallic brilliance 10 reflection 0.175
		 }
	  }
   }
   scale 2.35
}


#declare ICTruck_Muffler = object {
   union {
	  union {
		 cylinder { 0*x, 0.65*x, 0.2 }
		 torus { 0.185, 0.015 rotate z*90 }
		 scale <1, 0.8, 1.5>
	  }
	  cylinder { 0*x, -0.35*x, 0.075 open }
	  torus { 0.065, 0.02 rotate z*90 scale <1.5, 1, 1> translate -x*0.35 }
	  cylinder { 0*x, 1.75*x, 0.075 translate x*0.65 }
	  torus {
		 0.14, 0.075
		 rotate x*90
		 clipped_by { plane {y,0} plane {-x,0} }
		 translate <2.4, 0.14, 0>
	  }
	  cylinder { 0*y, 0.3*y, 0.075 translate <2.54, 0.14, 0> }
      sphere {
         0*x, 1
         texture {
            pigment { color rgbt <1, 1, 1, 1> }
            halo {
               emitting
               spherical_mapping
               linear
               turbulence 1.0 omega 0.55 lambda 2.3
               color_map {
                  [ 0.00 color rgb <1, 1, 1>*0.55 transmit 1 ]
                  [ 0.33 color rgb <1, 1, 1>*0.25 transmit 0 ]
                  [ 0.66 color rgb <1, 1, 1>*0.60 transmit 1 ]
                  [ 1.00 color rgb <1, 1, 1>*0.20 transmit 0 ]
               }
               samples 10
               scale <0.95, 0.55, 0.55>
            }
         }
         hollow
         scale <1, 0.35, 0.35>
         translate -x*1.35
         scale 1.5
      }
	  scale 0.65
   }
   texture {
	  pigment { color rgb <0.65, 0.50, 0.25> /*<0.7, 0.6, 0.4>*/ }
	  finish {
		 ambient 0.3  diffuse 0.25  specular 0.35
		 roughness 0.05  reflection 0.05
	  }
   }
   texture { DustLayer }
}



#declare ICTruck_FrontSignal = object {
   box { <0, -0.05, -0.0925> <0.03, 0.05, 0.0925> }
   texture {
	  pigment { color rgbf <1.0, 0.5, 0.1, 0.05> }
	  finish  { ambient 0.55 diffuse 0.35 specular 0.2 roughness 0.025 crand 0.05 }
	  normal  { bumps 0.75 scale 0.015 }
   }
   texture { DustLayer }
}


#declare ICTruck_Wiper = object {
   union {
	  cylinder { 0*z, -0.1*z, 0.05 }
	  sphere { 0*z, 0.05 scale <1, 1, 0.6> translate -0.1*z }
	  box { <0, -0.015, -0.05> <0.55, 0.015, -0.1> }
	  cylinder { 0*x, 0.55*x, 0.0085 translate -z*0.1 }
	  cylinder { -0.05*z, -0.1*z, 0.0375 translate x*0.55 }
	  cylinder { -0.035*z, -0.05*z, 0.01 translate x*0.55 }
	  torus { 0.03, 0.005 rotate x*90 translate <0.55, 0, -0.1> }
	  sphere { 0*z, 0.02 scale <1, 1, 0.6> translate <0.55, 0, -0.1> }
	  difference {
		 cylinder { -0.285*x, 0.285*x, 0.01 }
		 plane { z, 0}
		 scale <1, 1, 3.5>
		 rotate -z*9
		 translate <0.55, 0, -0.035>
	  }
	  rotate z*10
	  texture { ICT_RVMTexture }
	  scale <1, 1, 0.75>
   }
}


#declare ICTruck_SideThing = object {
   union {
	  torus {0.15, 0.02 rotate x*90 clipped_by{ plane {x,0} plane {-y,0} } translate<-0.435,0.185,0>}
	  torus {0.15, 0.02 rotate x*90 clipped_by{ plane {-x,0} plane {-y,0} } translate<0.435,0.185,0>}
	  torus {0.15, 0.02 rotate x*90 clipped_by{ plane {x,0} plane {y,0} } translate<-0.435,-0.185,0>}
	  torus {0.15, 0.02 rotate x*90 clipped_by{ plane {-x,0} plane {y,0} } translate<0.435,-0.185,0>}
	  cylinder { -0.45*x, 0.45*x, 0.02 translate <0, 0.335,0> }
	  cylinder { -0.2*y, 0.2*y, 0.02 translate <-0.585, 0, 0> }
	  cylinder { -0.45*x, 0.45*x, 0.02 translate <0, -0.335,0> }
	  cylinder { -0.2*y, 0.2*y, 0.02 translate <0.585, 0, 0> }
   }
   scale <1, 1, 0.25>
}


#declare ICT_SpkrCone = object {
   difference {
	  cylinder { 0*x, 0.25*x, 0.2 }
	  torus { 0.25, 0.2 rotate z*90 scale <1.3, 1, 1> }
   }
}

#declare ICT_Speaker = object {
   union {
	  difference {
		 object { ICT_SpkrCone }
		 object { ICT_SpkrCone translate x*0.02 }
	  }
	  cone { 0*x, 0.065, 0.21*x, 0.025 translate x*0.1 }
	  scale <1.2, 1, 1>
	  texture { ICT_SpkrTexture }
   }
}

#declare ICTruck_Speakers = object {
   union {
	  box {
		 <-0.2, 0, -0.1> <0, 0.4, 0.1>
		 texture {
			pigment { color rgb <0.99, 0.96, 0.90> }
			finish {
			   ambient 0.35  diffuse 0.3  specular 0.15  roughness 0.1
			   metallic  reflection 0.02  crand 0.01
			}
		 }
	  }
	  object { ICT_Speaker translate <-0.05, 0.275, 0> }
	  object { ICT_Speaker rotate y*90 translate <-0.1, 0.275, -0.06> }
	  object { ICT_Speaker rotate -y*90 translate <-0.1, 0.275, 0.06> }
	  sphere {
		 0*x, 0.085
		 scale <1, 1.5, 1>
		 texture {
			pigment { color rgbf <1.0, 0.6, 0.3, 0.15> }
			finish  { ambient 0.55 diffuse 0.3 specular 0.2 roughness 0.025 crand 0.01 }
		 }
		 translate <-0.1, 0.4, 0>
	  }
	  scale 1.05
   }
}



#declare ICTruck_PriceList = object {
   box {
	  <-0.5, -0.5, 0> <0.5, 0.5, 0.005>
	  texture {
		 pigment {
			image_map {
			   gif "prices.gif"
			   map_type 0
			   interpolate 2
			   once
			}
		 }
		 finish {
			ambient 0.5
			diffuse 0.35
			specular 0.15
			roughness 0.75
			metallic
			reflection 0.02
			crand 0.01
		 }
		 translate <-0.5, -0.5, 0>
	  }
   scale <0.63, 0.84, 1>
   scale 0.85
   }
}


// ------------------------------------- Ice Cream! -----------------------------------------

#declare ICTruck_ConeSupport = object {
   difference {
	  union {
		 box { <-0.1, 0, 0> <0.1, 0.05, -0.05> translate <0, 0, -0.35> }
		 cylinder { 0*y, 0.05*y, 0.1 clipped_by { plane {z,0} } translate <0, 0, -0.4> }
		 sphere { 0*y, 0.025 scale <2,1,1> translate <0, 0.05, -0.4> }
		 box { <-0.1, 0, 0> <0.1, 0.05, -0.05> translate <0, 0.35, 0> }
		 cylinder { 0*z, -0.05*z, 0.1 clipped_by { plane {-y,0} } translate <0, 0.4, 0> }
		 box { <-0.1, 0, -0.1> <0.1, 0.035, 1> rotate -x*45 translate -z*0.35 }
		 sphere { 0*y, 0.025 scale <2,1,1> translate <0, 0.4, -0.05> }
	  }
	  plane {  y, 0 }
	  plane { -z, 0 }
	  scale <0.5, 1, 1>
	  texture {
		 pigment { color rgb <0.9, 0.9, 0.8> /*<0.86, 0.7, 0.4>*/ }
		 finish  {
			ambient 0.4 diffuse 0.5 specular 0.5 roughness 0.005
			brilliance 4 metallic reflection 0.075
		 }
	  }
   }
}

#declare ICTruck_ConeBottom = object {
   union {
	  cone { 0*x, 0.45, 0.4*x, 0.25 }
	  cone { 0.4*x, 0.25, 1.6*x, 0.02 }
	  torus { 0.25, 0.025 rotate z*90 translate x*0.4 }
	  torus { 0.45, 0.025 rotate z*90 }
	  sphere {
		 0*z, 0.475
		 translate -x*0.175
		 clipped_by { plane { x,0 } }
		 texture {
			pigment { color rgb <1.00, 0.98, 0.95> }
			finish  { diffuse 0.35 ambient 0.55 specular 0.15 roughness 0.025 }
			normal  { bumps 0.75 scale 0.1 }
			//normal  { gradient x 0.5 scallop_wave scale 0.2 rotate -z*15 }
		 }
	  }
	  texture {
		 pigment { color rgb <0.85, 0.65, 0.35> }
		 finish  { diffuse 0.4 ambient 0.425 specular 0.2 roughness 0.1 }
		 normal  { gradient x 0.1 sine_wave scale 0.075 }
	  }
	  rotate -z*10
   }
}

#declare ICTruck_Cone = object {
   union {
	  object { ICTruck_ConeBottom }
	  object { ICTruck_ConeSupport translate <0.3, -0.55, -0.255> }
	  object { ICTruck_ConeSupport rotate y*180 translate <0.3, -0.525, 0.255> }
	  object {
		 ICTruck_ConeSupport
		 scale <0.85, 0.695, 0.695>
		 translate <1.2, -0.55, -0.074>
	  }
	  object {
		 ICTruck_ConeSupport
		 rotate y*180
		 scale <0.85, 0.695, 0.695>
		 translate <1.2, -0.525, 0.074>
	  }
	  scale 1.1
   }
}




// ******************************************************************************************
//     Finally, define primary object
// ******************************************************************************************

// ------------------------------------- Main Object ----------------------------------------

#declare IceCreamTruck = object {
   union {
	  object { ICTruck_Shell }
	  object { ICTruck_Bumper scale <0.7, 1, 0.83> translate <-0.55, 0.05, 0> }
	  object { ICTruck_Bumper scale <0.7, 1, 0.80> rotate y*180 translate <4.25, 0.05, 0> }
	  object { ICTruck_Wheel translate <0.45, -0.15, -1> }
	  object { ICTruck_Wheel translate <3.20, -0.15, -1> }
	  object { ICTruck_Wheel rotate y*180 translate <0.45, -0.15, 1> }
	  object { ICTruck_Wheel rotate y*180 translate <3.20, -0.15, 1> }
	  object { ICTruck_Headlight translate <4.15, 0.55, -0.82> }
	  object { ICTruck_Headlight translate <4.15, 0.55,  0.82> }
	  object { ICTruck_FDoorHandle1 translate <2.75, 0.825, -1.125> }
	  object { ICTruck_FDoorHandle2 translate <2.75, 0.825,  1.125> }
	  object { ICTruck_Grille translate <ICT_MidLength+1.235,0,0> }
	  object { ICTruck_ServingLedge translate <1.4, 0.65, -1> }
	  object { ICTruck_RDoorHandle rotate y*90 translate <-0.5, 0.725, -0.2> }
	  object { ICTruck_RDoorHandle rotate y*90 rotate x*180 translate <-0.5, 0.725, 0.2> }
	  object { ICTruck_RVMirror1 translate <3.35, 0.925, -1.1> }
	  object { ICTruck_RVMirror2 translate <3.35, 0.925,  1.1> }
	  object { ICTruck_SideThing translate <0.575, 1.3, -1.1> }
	  object { ICTruck_SideThing translate <0.575, 1.3,  1.1> }
	  object { ICTruck_RearLights }
	  object { ICTruck_Muffler translate <-0.35, -0.175, -0.6> }
	  object { ICTruck_FrontSignal translate <4.2, 0.28, -0.795> }
	  object { ICTruck_FrontSignal translate <4.2, 0.28,  0.795> }
	  object { ICTruck_Wiper rotate -y*90 translate <3.65, 0.975, -0.815> }
	  object { ICTruck_Wiper rotate -y*90 translate <3.65, 0.975,  0.150> }
	  object { ICTruck_SideWindow translate <ICT_MidLength, 0.65, -1.05> }
	  object { ICTruck_SideWindow translate <ICT_MidLength, 0.50,  1.05> }
	  object { ICTruck_FrontWindow translate <ICT_MidLength-0.02, 1, -0.5> }
	  object { ICTruck_FrontWindow translate <ICT_MidLength-0.02, 1,  0.5> }
	  object { ICTruck_RearWindow translate <0.02, 0, -0.475> }
	  object { ICTruck_RearWindow translate <0.02, 0,  0.475> }
	  object { ICTruck_ServingWindow translate <1.4,1,-1.025> }
	  object { ICTruck_Cone rotate y*180 translate <1.6, 2.55, 0> }
	  object { ICTruck_Speakers texture { RedT } translate <2.65, 1.95, 0> }
	  object { ICTruck_PriceList translate <1.8, 0.265, -1.105> }
      texture { ICT_MainTexture }
      texture { ICT_Decal1 translate <-0.075, 0.6, 0> }
      texture { DustLayer }
      translate y*0.55
   }
}



// =========================== END OF FILE
