//Basket.pov

#include "colors.inc"
#include "metals.inc"
#include "Glass.inc"
#include "finish.inc"
#include "Floor.inc"

#declare Lumin = color rgb <1, .82, .67>

camera {
       location <32, 12, -22>
       look_at <-20, -7, -5>
       }

#declare holes = union {
         box {<-.275, -.275, -2>,<.275, .275, 2> rotate 45*z}
         box {<-.275, -.275, -2>,<.275, .275, 2> rotate 45*z rotate 45*y}
         box {<-.275, -.275, -2>,<.275, .275, 2> rotate 45*z rotate 90*y}
         box {<-.275, -.275, -2>,<.275, .275, 2> rotate 45*z rotate 135*y}
         }

#declare net = difference {
         cone { 0, 1.5, <0, -2.5, 0>, .6 }
         cone { <0, .1, 0>, 1.5, <0, -2.6, 0>, .45 }
         object { holes }
         object { holes rotate -22.5*y translate -.4*y }
         object { holes translate -.85*y }
         object { holes scale <.9, .9, .9> rotate -22.5*y translate -1.3*y }
         object { holes scale <.75, .75, .75> translate -1.75*y }
         object { holes scale <.6, .6, .6> rotate -22.5*y translate -2.1*y }
         object { holes scale <.9, .9, .9> translate -2.4*y }
         pigment { White }
         finish { ambient .4 }
         }

#declare nut = union {
         box {<-.15, -.082, 0>,<.15, .082, .15>}
         box {<-.15, -.082, 0>,<.15, .082, .15> rotate 60*z}
         box {<-.15, -.082, 0>,<.15, .082, .15> rotate -60*z}
         pigment { White }
         }

#declare rim = union {
         torus {1.5, .075}
         cylinder {<.5, -.75, 1.5>,<1.5, -.05, .25>, .05 }
         cylinder {<-.5, -.75, 1.5>,<-1.5, -.05, .25>, .05}
         cylinder {<.55, -.75, 1.5>,<-.55, -.75, 1.5>, .05}
         box {<1, -1, 1.5>,<-1, .75, 1.6>}
         cylinder {<0, 0, 1.5>,<0, 0, 2.8>, .05 translate <.5, .33, 0>}
         cylinder {<0, 0, 1.5>,<0, 0, 2.8>, .05 translate <.5, -.66, 0>}
         cylinder {<0, 0, 1.5>,<0, 0, 2.8>, .05 translate <-.5, .33, 0>}
         cylinder {<0, 0, 1.5>,<0, 0, 2.8>, .05 translate <-.5, -.66, 0>}
         object { nut translate <.5, .33, 2.6> }
         object { nut translate <-.5, .33, 2.6> }
         object { nut translate <.5, -.66, 2.6> }
         object { nut translate <-.5, -.66, 2.6> }
         object { net }
         pigment { Orange }
         finish { metallic ambient .4}
         }

#declare backboard = union {
         difference {
                    superellipsoid {<.25, .25> scale <5, 3.5, .55> translate <0, 2, 2.1> pigment { Gray45 } normal { dents .25 }}
                    box {<-4.5, -1, 0>,<4.5, 5, 3>}
                    }
         difference {
                    box {<-1.5, 0, 1.75>,<1.5, 2.75, 1.9>}
                    box {<-1.3, .2, 0>,<1.3, 2.55, 3>}
                    pigment { Red }
                    finish { ambient .4 }
                    }
         box {<-4.5, -1, 1.6>,<4.5, 5, 2.6>}
         pigment { color rgbf<.75, .85, 1.0, .95>}
         finish {
                ambient 0
                diffuse 0
                reflection 0.5
                refraction 1.33
                ior 1.5
                phong 0.3
                phong_size 60
                }
         }

#declare suc_cup = difference {
         sphere { 0, .5 }
         box {<-1, -1, 0>, <1, 1, -3>}
         }

#declare stand = union {
         object { suc_cup translate <-4, 2.5, -3> }
         object { suc_cup translate <-4, -2.5, -3> }
         object { suc_cup translate <4, 2.5, -3> }
         object { suc_cup translate <4, -2.5, -3> }
         cylinder {<-4, 2.5, -2.75>, 0, .25}
         cylinder {<-4, -2.5, -2.75>, 0, .25}
         cylinder {<4, 2.5, -2.75>, 0, .25}
         cylinder {<4, -2.5, -2.75>, 0, .25}
         box {<-1, -1, -1>, <1, 1, 1>}
         box {<-.5, 0, 0>, <.5, 1, 7> rotate 45*x}
         cylinder {<-1, -5, 5>, <1, -5, 5>, .75}
         box {<-.5, -5, 4.5>, <.5, -16, 5.5>}
         box {<-2.5, -15.5, 3.5>,<2.5, -17.5, 6.5>}
         cylinder {<-2.5, -16.75, 1>, <-2.5, -16.75, 9>, .4}
         cylinder {<2.5, -16.75, 1>, <2.5, -16.75, 9>, .4}
         }

#declare goal = union {
         object { rim }
         object { backboard }
         object { stand translate <0, 2, 5.5> pigment { Blue } finish { metallic }}
         translate 5.9*y
         }

#declare ExitSign = union {
      box {<-.9, -.65, .01>, <.9, .65, .3> pigment { rgb 0 } }
      box {<-.75, -.5, 0>, <.75, .5, .25>
          pigment { rgb <0, .75, 0> }
          finish { ambient .25 }
          }
      text { ttf "timrom.ttf" "EXIT" .3, 0
           pigment { White }
           finish { ambient .7 }
           scale <.55, 1.1, 1>
           translate <-.6, -.35, 0>
           }
      }

#declare wall = union {
            difference {
                 union {
                       box {<-40, -10, 20>, <40, 30, 21> pigment { brick rgb <.8, .8, .8>, White mortar .2 rotate 90*y}}
                       box {<-40, -10, 21>, <-41, 30, -200> pigment { brick rgb <.8, .8, .8>, White mortar .2}}
                       box {<-40, 30, -200>, <40, -10, -200> pigment { brick rgb <.8, .8, .8>, White mortar .2 rotate 90*y}}
                       box {<40, 30, -200>, <40, -10, 21> pigment { brick rgb <.8, .8, .8>, White mortar .2 }}
                       normal {
                              brick
                              turbulence 1
                              mortar .2
                              }
                       normal {
                              bumps .5
                              turbulence .75
                              lambda 1.5
                              omega .8
                              octaves 8
                              }
                       finish {
                              diffuse .8
                              phong .1
                              phong_size 1
                              }
                       }
                 box {<-39, -9, 5>,<-41, 2, -5> texture { T_Silver_2C }}
                 }
      box {<-40.5, -10, -5>, <-41, 2, -.1> pigment { Blue } finish { metallic }}
      box {<-40.5, -10, 5>, <-41, 2, .1> pigment { Blue } finish { metallic }}
      box {<-40.5, -10, -.1>, <-41, 2, .1> texture { T_Silver_2C }}
      box { <-.5, -.5, -.5>, <.5, .5, .5> texture {T_Silver_2C} rotate 45*z translate <-40.5, -4, 4> }
      box { <-.5, -.5, -.5>, <.5, .5, .5> texture {T_Silver_2C} rotate 45*z translate <-40.5, -4, 1> }
      box { <-.5, -.5, -.5>, <.5, .5, .5> texture {T_Silver_2C} rotate 45*z translate <-40.5, -4, -4> }
      box { <-.5, -.5, -.5>, <.5, .5, .5> texture {T_Silver_2C} rotate 45*z translate <-40.5, -4, -1> }
      cylinder {<-39.75, -4, 4>, <-39.75, -4, 1>, .2 texture { T_Silver_2C }}
      cylinder {<-39.75, -4, -4>, <-39.75, -4, -1>, .2 texture { T_Silver_2C }}
      box {0, <25, 10, .25>
          pigment {
                  image_map {
                            gif "IRTCtitl.gif"
                            once
                            }
                  scale <25, 10, 1>
                  }
          rotate -90*y
          translate <-39.5, -4, -35>
          }
      box {<-39.8, -4.5, -9.5>, <-40, 6.5, -35.5> texture { T_Silver_2C }}
      object { ExitSign rotate -90*y translate <-39.8, 4, 0> }
      }

#declare lines = intersection {
          box {<-40, -8.95, 20>, <40, -9.1, -200>}
          union {
                difference {            //Out-of-bounds
                           box {<-30, -5, 2.5>, <30, -15, -80.5>}
                           box {<-29, -4, 1.5>, <29, -16, -79.5>}
                           }
                difference {            //Bottom of 3-point line
                           box {<-25, -5, 2>, <25, -15, -5>}
                           box {<-24, -4, 4>, <24, -16, -6>}
                           }
                difference {            //Key
                           box {<-9, -5, 2>, <8.5, -15, -21.5>}
                           box {<-8, -4, 4>, <7.5, -16, -20.5>}
                           }
                difference {            //Top of 3-point line
                           cylinder {<0, -5, -5>, <0, -15, -5>, 25}
                           cylinder {<0, -4, -5>, <0, -16, -5>, 24}
                           box {<-30, -4, -5>, <30, -16, 25>}
                           }
                difference {            //Top of key
                           cylinder {<0, -5, -21.5>, <0, -15, -20>, 8.5}
                           cylinder {<0, -4, -21.5>, <0, -16, -20>, 7.5}
                           box {<-4.2, -4, -18>, <-1.4, -16, 0>}
                           box {<4.2, -4, -18>, <1.4, -16, 0>}
                           }
                box {<-11.5, -5, -2.5>,<-8, -15, -5.5>}
                box {<11.5, -5, -2.5>,<8, -15, -5.5>}
                box {<-11.5, -5, -11>,<-8, -15, -12>}
                box {<11.5, -5, -11>,<8, -15, -12>}
                box {<-11.5, -5, -16.5>,<-8, -15, -17.5>}
                box {<11.5, -5, -16.5>, <8, -15, -17.5>}
                }
          pigment { Red }
          finish { ambient .3 }
          }

#declare trim = union {
         box {<-40, -8, 19.8>,<40, -9, 20>}
         box {<-40, -8, 20>,<-39.8, -9, -200>}
         box {<-40, -8, -200>,<40, -9, -198.8>}
         box {<40, -8, -200>,<39.8, -9, 20>}
         pigment { rgb 0 }
         finish {
                phong .5
                phong_size 75
                reflection .25
                }
         }

#declare ball = difference {
           sphere { 0, 1 texture {
                                 pigment { Orange }
                                 normal { bumps .2
                                          bump_size .2
                                        }
                                 finish { ambient .3 }
                                 }
                  }
           torus { 1.025, .05 pigment { rgb 0 }}
           torus { 1.025, .05 pigment { rgb 0 } rotate 90*z }
           difference {
                      torus { 1.025, .05 }
                      box {<-.4, -.4, -3>,<.4, .4, 3>}
                      pigment { rgb 0 }
                      rotate -45*z
                      }
           difference {
                      torus { 1.025, .05 }
                      box {<-.4, -.4, -3>,<.4, .4, 3>}
                      pigment { rgb 0 }
                      rotate 45*z
                      }
           torus { .55, .05 rotate 107.25*x translate <0, .745, -.8> pigment { rgb 0 }}
           torus { .55, .05 rotate 107.25*x translate <0, -.745, .8> pigment { rgb 0 }}
           torus { .55, .05 rotate -107.25*x translate <0, .745, .8> pigment { rgb 0 }}
           torus { .55, .05 rotate -107.25*x translate <0, -.745, -.8> pigment { rgb 0 }}
           }

#declare light_bulb = sphere { 0, 1
    pigment { color rgbt <1, 1, 1, 1> }
    halo {
      emitting
      spherical_mapping
      linear
      color_map {
          [ 0 color rgbt <1, 1, 0,  1> ]
          [ 1 color rgbt <1, 1, 1, -1> ]
          }
      samples 10
      }
    hollow
    scale .5
    }

#declare PowerSource = union {
//         object { light_bulb translate <-20, 31, 0> }
         light_source { <-20, 29, 0> color White*.1}
//         object { light_bulb translate <20, 31, 0> }
         light_source { <20, 29, 0> color White*.1}
//         object { light_bulb translate <0, 31, -20> }
         light_source { <0, 29, -20> color White*.1}
//         object { light_bulb translate <-20, 31, -40> }
         light_source { <-20, 29, -40> color White*.1}
//         object { light_bulb translate <20, 31, -40> }
         light_source { <20, 29, -40> color White*.1}
//         object { light_bulb translate <0, 31, -60> }
         light_source { <0, 29, -60> color White*.1}
//         object { light_bulb translate <-20, 31, -80> }
         light_source { <-20, 29, -80> color White*.1}
//         object { light_bulb translate <20, 31, -80> }
         light_source { <20, 29, -80> color White*.1}
//         object { light_bulb translate <0, 31, -100> }
         light_source { <0, 29, -100> color White*.1}
//         object { light_bulb translate <-20, 31, -120> }
         light_source { <-20, 29, -120> color White*.1}
//         object { light_bulb translate <20, 31, -120> }
         light_source { <20, 29, -120> color White*.1}
//         object { light_bulb translate <0, 31, -140> }
         light_source { <0, 29, -140> color White*.1}
//         object { light_bulb translate <-20, 31, -160> }
         light_source { <-20, 29, -160> color White*.1}
//         object { light_bulb translate <20, 31, -160> }
         light_source { <20, 29, -160> color White*.1}
//         object { light_bulb translate <0, 31, -180> }
         light_source { <0, 29, -180> color White*.1}
         }

#declare ceiling = difference {
         union {
               box {<-41, 30, 21>, <41, 35, -201> finish { phong .5 }}
               box {<-41, 29.5, 19.75>, <41, 31, 20>}
               box {<-41, 29.5, .25>, <41, 31, -.25>}
               box {<-41, 29.5, -19.75>, <41, 31, -20.25> }
               box {<-41, 29.5, -39.75>, <41, 31, -40.25> }
               box {<-41, 29.5, -59.75>, <41, 31, -60.25> }
               box {<-41, 29.5, -79.75>, <41, 31, -80.25> }
               box {<-41, 29.5, -99.75>, <41, 31, -100.25> }
               box {<-41, 29.5, -119.75>, <41, 31, -120.25> }
               box {<-41, 29.5, -139.75>, <41, 31, -140.25> }
               box {<-41, 29.5, -159.75>, <41, 31, -160.25> }
               box {<-41, 29.5, -179.75>, <41, 31, -180.25> }
               box {<-41, 29.5, -199.75>, <41, 31, -200> }
               box {<-40, 29.5, 11>, <-39.25, 31, -201> }
               box {<-30.25, 29.5, 11>, <-29.75, 31, -201> }
               box {<-20.25, 29.5, 11>, <-19.75, 31, -201> }
               box {<-10.25, 29.5, 11>, <-9.75, 31, -201> }
               box {<-.25, 29.5, 11>, <.25, 31, -201> }
               box {<30.25, 29.5, 11>, <29.75, 31, -201> }
               box {<20.25, 29.5, 11>, <19.75, 31, -201> }
               box {<10.25, 29.5, 11>, <9.75, 31, -201> }
               box {<40, 29.5, 11>, <39.75, 31, -201> }
               pigment { White }
               }
         sphere {<-20, 30, 0>, 2 texture { T_Silver_2C }}
         sphere {<-20, 30, 0>, 2 texture { T_Silver_2C }}
         sphere {<0, 30, -20>, 2 texture { T_Silver_2C }}
         sphere {<-20, 30, -40>, 2 texture { T_Silver_2C }}
         sphere {<20, 30, -40>, 2 texture { T_Silver_2C }}
         sphere {<0, 30, -60>, 2 texture { T_Silver_2C }}
         sphere {<-20, 30, -80>, 2 texture { T_Silver_2C }}
         sphere {<20, 30, -80>, 2 texture { T_Silver_2C }}
         sphere {<0, 30, -100>, 2 texture { T_Silver_2C }}
         sphere {<-20, 30, -120>, 2 texture { T_Silver_2C }}
         sphere {<20, 30, -120>, 2 texture { T_Silver_2C }}
         sphere {<0, 30, -140>, 2 texture { T_Silver_2C }}
         sphere {<-20, 30, -160>, 2 texture { T_Silver_2C }}
         sphere {<20, 30, -160>, 2 texture { T_Silver_2C }}
         sphere {<0, 30, -180>, 2 texture { T_Silver_2C }}
         }

object { PowerSource }
object { ceiling }
object { goal }
object { HardWoodFloor }
box {<-40, -8.98, 20>, <40, -8.99, -200> pigment { color rgbf<1.0, 1.0, 1.0, 1.0> }
    finish {
           ambient 0
           diffuse 0
           phong .5
           phong_size 75
           reflection .1
           ior 1.5
           }
    }
object { wall }
object { lines }
object { ball rotate -90*y translate <-5, -8.3, -10>}
object { trim }
