#declare Gate =
union {
	// hollow bar
	difference {
		prism {
    		linear_sweep
    		linear_spline
    		0, 0.30,
    		9,
			<0,0>,<4.9,0>,<5.70,-0.75>,<7.35,-0.75>,<7.35,-1.13>,
			<5.55,-1.13>,<4.75,-0.38>,<0,-0.38>,<0,0>
		}
		prism {
    		linear_sweep
    		linear_spline
    		0.04, 0.26,
    		9,
			<0.04,0>,<4.9,0>,<5.70,-0.75>,<7.31,-0.75>,<7.31,-1.13>,
			<5.55,-1.13>,<4.75,-0.38>,<0.04,-0.38>,<0.04,0>
			translate -0.06*z
		}
		#if (d_Gate = 2)
		// large cutout on bar
		prism {
    		linear_sweep
    		linear_spline
    		-0.10, 0.10,
    		5,
			<2.02,-0.18>,<3.57,-0.18,>,<3.70,-0.40>,<2.00,-0.40>,<2.02,-0.18>
		}
		// small cutout on bar
		prism {
    		linear_sweep
    		linear_spline
    		0.20, 0.40,
    		5,
			<3.21,-0.26>,<3.62,-0.26>,<3.70,-0.40>,<3.15,-0.40>,<3.21,-0.26>
		}
		#end
		translate 0.19*z
	}
	// pivot point on bottom
	#if (d_Gate = 2)
	box {<1.72,-0.6,-0.16><1.78,0,0.16> }
	box {<1.59,-0.6,-0.03><1.91,0,0.03> }
	// cylindrical internal supports
	cylinder { <0,0,-0.19><0,0,0.18> 0.06
		clipped_by { plane {-y,0} }
		translate <0.06,0.30,0>
	}
	cylinder { <0,0,-0.19><0,0,0.18> 0.05 translate <0.06,0.15,0> }
	cylinder { <0,0,-0.19><0,0,0.18> 0.05 translate <1.75,0.24,0> }
	cylinder { <0,0,-0.19><0,0,0.18> 0.05 translate <2.85,0.24,0> }
	cylinder { <0,0,-0.19><0,0,0.18> 0.05 translate <4.25,0.24,0> }
	cylinder { <0,0,-0.19><0,0,0.18> 0.05 translate <5.82,0.15,-0.75> }
	cylinder { <0,0,-0.19><0,0,0.18> 0.05 translate <7.29,0.15,-0.75> }
	// webbing on cylinders
	box { <-0.02,0.03,0.10><0.02,0.27,0.18> translate <1.75,0,0> }
	box { <-0.02,0.03,0.10><0.02,0.27,0.18> translate <4.25,0,0> }
	box { <-0.02,0.03,-0.18><0.02,0.27,0.18> translate <5.82,0,-0.75> }
	// peg on bar
	cylinder { <0,0,-0.19><0,0,0.03> 0.05 translate <4.25,0.55,0> }
	box { <-0.03,0.0,0.-0.19><0.03,0.27,0> translate <4.25,0.3,0> }
    sphere { <4.25,0.55,0.03> 0.05 }
	// stop sign
	// leg 1
	prism {
    	linear_sweep
    	linear_spline
    	0.0, 0.10,
    	7,
		<0,0.38>,<2.05,0.12>,<2.05,-0.15>,<1.25,-0.15>,<1.1,0>,<0,0>,<0,0.38>
		rotate 90*z
		rotate 6*x
		translate <7.34,0.3,-0.935>
	}
	// leg 2
	prism {
    	linear_sweep
    	linear_spline
    	0.0, 0.10,
    	7,
		<0,0.38>,<2.05,0.12>,<2.05,-0.15>,<1.25,-0.15>,<1.1,0>,<0,0>,<0,0.38>
		rotate 90*z
		rotate 6*x
		translate <6.54,0.3,-0.935>
	}
	#end
	// sign
	prism {
    	linear_sweep
    	linear_spline
    	0.0, 0.05,
    	7,
		<-0.88,0>,<-0.44,-0.75>,<0.44,-0.75>,<0.88,0>,<0.44,0.75>,<-0.44,0.75>,<-0.88,0>
		rotate 96*x
		translate <6.90,2.3,-0.927>
	}
	// center on pivot
	translate -1.75*x
	#if (d_Gate = 2)
		texture { pigment { Red }
 		  	finish { phong 0.8 phong_size 20 }
		}
	#else
		texture { pigment { Red } }
	#end
}

#declare Gate_Rubber_Band =
union {
	box { <-1.25,-0.03,-0.02><1.25,0.03,0.02> translate 0.05*z }
	box { <-1.25,-0.03,-0.02><1.25,0.03,0.02> translate -0.05*z }
	// loops on end
	difference {
		cylinder { <0,-0.03,0><0,0.03,0> 0.07 }
		cylinder { <0,-0.04,0><0,0.04,0> 0.03 }
		clipped_by { plane {x,0} }
		translate -1.25*x
	}
	difference {
		cylinder { <0,-0.03,0><0,0.03,0> 0.07 }
		cylinder { <0,-0.04,0><0,0.04,0> 0.03 }
		clipped_by { plane {-x,0} }
		translate 1.25*x
	}
	texture {
		pigment {
			color rgb<0.550,0.170,0.05>
		}
		normal { dents 0.5 }
		finish { Dull }
		scale 0.03
		rotate  0*z
	}
	translate 1.25*x
}
