#declare Lamppost_Vertical =
union {
	// pole
	cone { <0,0,0> 0.12, <3.0,0,0> 0.08 }
	cylinder { <3.0,0,0><5.6,0,0> 0.08 }
	// rings
	sphere { <0,0,0> 0.22 scale <0.35,1,1> }
	union {
		cylinder { <0,0,0><0.03,0,0> 0.122 }
		cylinder { <0.03,0,0><0.28,0,0> 0.103 }
		cylinder { <0.28,0,0><0.31,0,0> 0.128 }
		translate 2.55*x
	}
	union {
		cylinder { <0,0,0><0.03,0,0> 0.128 }
		cylinder { <0.03,0,0><0.28,0,0> 0.103 }
		cylinder { <0.28,0,0><0.31,0,0> 0.122 }
		translate 2.91*x
	}
	cylinder { <0,0,0><0.10,0,0> 0.100 translate 3.75*x }
	// horizontal brace
	cylinder {<4.88,0,0.03><4.88,0,0.08> 0.23 }
	cylinder {<4.88,0,-0.03><4.88,0,-0.08> 0.23 }
	sphere { <0,0,0> 0.15 scale <0.4,1,1> translate 5.6*x }
}

#declare Lamppost_Horizontal =
union {
	// pole
	cylinder { <0,0,0><3.75,0,0> 0.08 }
	// rings
	sphere { <0,0,0> 0.12 scale <0.4,1,1> }
	cylinder { <0,0,0><0.10,0,0> 0.100 translate 1.55*x }
	cylinder { <0,0,0><0.10,0,0> 0.100 translate 2.44*x }
	sphere { <0,0,0> 0.16
		scale <1.1,1,1>
		clipped_by { plane {x,0} }
		translate 3.28*x
	}
	cylinder { <3.69,0.08,-0.02><3.69,0.08,0.02> 0.04 }
	cone { <3.75,0,0> 0.08, <3.87,0,0> 0.03 }
	sphere { <3.90,0,0> 0.07 }
	// vertical hanging bar
	union {
		// pole
		cylinder { <0,0,0><1.20,0,0> 0.08 }
		// rings
		cylinder { <0,0,0><0.10,0,0> 0.100 translate 0.33*x }
	  	cone { <0.59,0,0> 0.08, <0.70,0,0> 0.18 }
		cylinder { <0.70,0,0><0.75,0,0> 0.18 }
		sphere { <0,0,0> 0.21 scale <0.20,1,1> translate 0.90*x }
		// oval
		union {
			torus { 0.27, 0.10 }
			cylinder { <0,-0.04,0><0,0.04,0>0.27 }
			scale <1,1,0.50>
			translate 1.50*x
		}
		rotate 90*x
		rotate -90*z
		translate 2.85*x
	}
}

#declare Lamppost_Scrollwork =
union {
	//loops at pole junction
	union {
		torus { 1.0, 0.08
			rotate 90*x
			clipped_by { plane {y,0} }
		}
		torus { 0.45, 0.08
			rotate 90*x
			clipped_by { plane {-y,0} }
			translate -0.55*x
		}
		torus { 0.3, 0.08
			rotate 90*x
			clipped_by { plane {-y,0} }
			translate 0.7*x
		}
		scale <1,0.8,1>
		rotate 65*z
		scale <0.50,0.60,0.50>
	}
	// balls on ends of loop
	sphere { <0,-0.05,0> 0.07 }
	sphere { <0.1,0.22,0> 0.07 }
	// small loop in corner
	union {
		torus { 0.60, 0.08
			rotate 90*x
			clipped_by { plane {-y,0} }
			clipped_by { plane {-x,0} }
			//translate -0.55*x
		}
		torus { 0.30, 0.08
			rotate 90*x
			clipped_by { plane {y,0} }
			translate 0.30*x
		}
		cylinder { <0,0,0><0,0.1,0> 0.08 }
		sphere { <0,0.1,0> 0.13 }
		scale <0.45,0.45,0.45>
		translate <1.05,0.33,0>
	}
	// piece joining 2 loops
	torus { 2.0, 0.08
		rotate 90*x
		clipped_by { plane {-y,0} }
		clipped_by { plane {-x,-0.4} }
		rotate 90*z
		scale <0.36,0.45,0.45>
		translate <1.1,-0.30,0>
	}
	// small points
	union {
		torus { 1.5, 0.05
			rotate 90*x
			clipped_by { plane {-y,0} }
			clipped_by { plane {-x,0} rotate -45}
		 	scale <0.30,0.30,0.30>
		 	rotate 90*z
		}
		prism {
  			linear_sweep
  			linear_spline
  			-0.05, 0.05,
  			4,
			<0,0>,<0,-0.02>,<0.07,0>,<0,0>
			rotate -90*x
			scale <3,3,0.2>
			translate <-0.23,0.46,0>
		}
		sphere { <0,0.45,0> 0.03 }
 	 	translate <0.60,-0.67,0>
	}
	union {
		torus { 1.5, 0.05
			rotate 90*x
			clipped_by { plane {-y,0} }
			clipped_by { plane {-x,0} rotate -45}
		 	scale <0.30,0.30,0.30>
		 	rotate   90*z
		}
		prism {
  			linear_sweep
  			linear_spline
  			-0.05, 0.05,
  			4,
			<0,0>,<0,-0.02>,<0.07,0>,<0,0>
			rotate -90*x
			scale <3,3,0.2>
			translate <-0.23,0.46,0>
		}
		sphere { <0,0.45,0> 0.03 }
		rotate -90*z
		rotate 180*y
 	 	translate <1.25,0.28,0>
	}
}

#declare Lamppost_Shoe =
difference {
	union {
		cylinder { <0,0.03,0><0,0.80,0> 0.25 }
		// wrinkle on front
		sphere { <0,0,0> 0.26 scale <1,0.20,0.9> rotate 18*z translate <-0.03,0.62,0> }
		// bulge in back
		sphere { <0,0,0> 0.28 scale <1,0.9,1> rotate 30*z translate <0.02,.25,0> }
		// wrinkles in back
		sphere { <0,0,0> 0.26 scale <1,0.25,1> rotate 15*z translate <0.02,.38,0> }
		sphere { <0,0,0> 0.26 scale <1,0.25,1> rotate 15*z translate <0.02,.46,0> }
		// middle
		cylinder { <-0.45,0.25,0><0,0.25,0> 0.15 rotate -10*z scale <1,0.8,1.5> }
		// bulge in front
		union {
			sphere { <0,0,0> 0.27
				clipped_by { plane {-y,0.07} }
				scale <1.2,0.5,0.9>
			 }
			sphere { <0,0,0> 0.20
				scale <1,0.85,1>
				clipped_by { plane {-y,0.07} }
				translate <-0.14,0.02,0>
			}
			// sole
			cylinder { <0,-0.06,0><0,0,0> 0.2 rotate -5*z scale <1.5,0.95,1.1> translate <-0.07,-0.04,0> }
			rotate -6*z
			translate <-0.42,.25,0>
		}
		// wrinkles on top
		sphere { <0,0,0> 0.21 scale <0.20,0.6,1.1> rotate 5*z translate <-0.39,.27,0> }
		sphere { <0,0,0> 0.21 scale <0.20,0.6,1.1> rotate 8*z translate <-0.34,.27,0> }
		sphere { <0,0,0> 0.21 scale <0.20,0.6,1.1> rotate 11*z translate <-0.27,.27,0> }
	}
	// heel
	box { <-1,-1,-1><0,0.0,1> }
	// dip in top
	cylinder { <0,0,-1><0,0,1> 0.35 translate <0.04,0.95,0> }
	box { <-1,-1,-1><1,0.07,1> }
	scale <1,1,0.7>
}

#declare Lamppost_Shoe_Pole =
union {
	// pole
	cylinder { <-0.16,0,0><0.16,0,0> 0.12 }
	cylinder { <0,0,0><0,-3,0> 0.07 }
	// shoe
	object { Lamppost_Shoe rotate -60*y translate -3.5*y }

	#if (d_Lamppost = 2)
	texture {
		pigment { rgb <0.0,0.30,0.0> }
		finish { phong 0.8 phong_size 20 }
	}
	#else
	pigment { Green }
	#end
}

#declare Lamppost =
union {
	object { Lamppost_Vertical rotate 90*z rotate 90*y }
	object { Lamppost_Horizontal translate <-1,4.88,0> }
	#if (d_Lamppost = 2)
	object { Lamppost_Scrollwork translate <0.422,4.18,0> }
	object { Lamppost_Shoe_Pole rotate 10*x translate <2.47,4.88,0> }
	#end

	#if (d_Lamppost = 2)
	texture {
		pigment { Yellow }
		finish { phong 0.8 phong_size 20 }
	}
	#else
	pigment { Yellow }
	#end
}

