
// Persistence of Vision Ray Tracer Scene Description File
// File: .inc
// Vers: 3.02
// Desc: PARTS FOR THE "CADILLAC'59" MODEL KIT
// Date: 30.12.1997
// Auth: (C) N.B. 1997


//#declare SIDE = -1

// TRUNK

#declare TRUNK01=
difference{
   cone{<-72*SIDE,0,0>0.78<0*SIDE,0,0>1.05 //}
      scale <1,5,53>
      rotate z*.5*SIDE
      rotate x*-3
      translate <38.5*SIDE,2.5,50>
   }
   box{<0*SIDE,15,150><100*SIDE,-10,-10>}
   box{<-26*SIDE,15,45><-26.5*SIDE,0,5>}
   box{<0*SIDE,15,.5><28*SIDE,0,0> rotate y*1*SIDE translate <-23*SIDE,0,48>}
   difference{
       cylinder {<0,0,0><0,15,0>3.5}
       cylinder {<0,-1,0><0,16,0>3}
       box{<-4*SIDE,-1,0><1*SIDE,16,-4>}
       box{<0*SIDE,-1,4><4*SIDE,16,-4> rotate y*1*SIDE}
       translate <-23*SIDE,0,45>
   }
}

// HOOD

#declare HOOD01=
union{
   cone{<-33.5*SIDE,0,0>0.75<0*SIDE,0,0>1.05 }
   prism { linear_sweep linear_spline
      3,
      0,
      5,
      <-33.5*SIDE, 0.75>, <0*SIDE, 1.05>,
      <0*SIDE, -1.05>, <-33.5*SIDE, -0.75>, <-33.5*SIDE, 0.75>
      rotate x*-97
   }
   scale <1,6.3,20>
   rotate x*3
   translate <0,0,206>
}

// SIDE

#declare BLOB_DENS01 = .5
#declare BLOB_STRN01 = .7
#declare BLOB_A_R01 = sqrt ( 1 - sqrt ( abs ( BLOB_DENS01 / BLOB_STRN01 ) ) )

#declare B_SIDE01=
difference{
   intersection{
      blob{ threshold BLOB_DENS01
         cylinder{<0,-1,0><0,1,0> 1/BLOB_A_R01, BLOB_STRN01 scale <1,.7,34.3>*<1.7,1.78,1>
            translate <-1.57*SIDE,-1.5,0>
            scale 12/3
            translate <0,0,200>
         }
         cylinder{<-1*SIDE,0,0><1*SIDE,0,0> 1/BLOB_A_R01, BLOB_STRN01 scale <.7,1,34.3>*<1.7,1.78,1>
            translate <-1.57*SIDE,-1.5,0>
            scale 12/3
            translate <0,0,200>
         }
         #declare BLOB_STRN01 = 1
         #declare BLOB_A_R01 = sqrt ( 1 - sqrt ( abs ( BLOB_DENS01 / BLOB_STRN01 ) ) )
         cylinder {<0,0,-1><0,0,1>, 1/BLOB_A_R01, BLOB_STRN01 scale <1,2.8,20>
            translate <-1.57*SIDE,-1.5,0>
            scale 12/3
            translate <0,-4,200>
         }
         #declare BLOB_STRN01 = -1.7
         #declare BLOB_A_R01 = sqrt ( 1 - sqrt ( abs ( BLOB_DENS01 / BLOB_STRN01 ) ) )
         sphere{0, 1/BLOB_A_R01, BLOB_STRN01 scale <2,10,50>
            rotate z*7*SIDE
            translate <-1.57*SIDE,-1.5,0>
            scale 12/3
            translate <-13.6*SIDE,1,190>
         }
         #declare BLOB_STRN01 = 3
         #declare BLOB_A_R01 = sqrt ( 1 - sqrt ( abs ( BLOB_DENS01 / BLOB_STRN01 ) ) )
         cylinder{<0,0,250><0,0,-2> .8/BLOB_A_R01, BLOB_STRN01 scale <.65,2,1.1>
            translate <-1.57*SIDE,-1.5,0>
            scale <12/3,12/3,1>
            translate <0,-4,0>
         }
         #declare BLOB_STRN01 = 3
         #declare BLOB_A_R01 = sqrt ( 1 - sqrt ( abs ( BLOB_DENS01 / BLOB_STRN01 ) ) )
         cylinder{<0,0,134/1.1><0,0,-2> .8/BLOB_A_R01, BLOB_STRN01 scale <.3,8,1.1>
            translate <-1.57*SIDE,-1.5,0>
            scale <12/3,12/3,1>
            translate <0,16,0>
         }
         #declare BLOB_STRN01 = -1.5
         #declare BLOB_A_R01 = sqrt ( 1 - sqrt ( abs ( BLOB_DENS01 / BLOB_STRN01 ) ) )
         sphere{0, 1/BLOB_A_R01, BLOB_STRN01 scale <40,2,40>
            translate <-1.57*SIDE,-1.5,0>
            scale 12/3
            translate <-13.6*SIDE,22.5,225>
         }
         #declare BLOB_STRN01 = -2
         #declare BLOB_A_R01 = sqrt ( 1 - sqrt ( abs ( BLOB_DENS01 / BLOB_STRN01 ) ) )
         cylinder{<-20*SIDE,0,0><20*SIDE,0,0> 1/BLOB_A_R01, BLOB_STRN01 scale <1,5,.5>*10
            rotate x*-40
            rotate y*-20*SIDE
            translate <-40*SIDE,0,219>
         }
         #declare BLOB_STRN01 = -1.5
         #declare BLOB_A_R01 = sqrt ( 1 - sqrt ( abs ( BLOB_DENS01 / BLOB_STRN01 ) ) )
         cylinder{<-20*SIDE,0,0><20*SIDE,0,0> 1/BLOB_A_R01, BLOB_STRN01 scale <1,5,.5>*10
            rotate x*-40
            translate <-30*SIDE,0,229>
         }
         #declare BLOB_STRN01 = -1
         #declare BLOB_A_R01 = sqrt ( 1 - sqrt ( abs ( BLOB_DENS01 / BLOB_STRN01 ) ) )
         sphere{0, 1/BLOB_A_R01, BLOB_STRN01 scale <2,.1,6>*10
            translate <-40*SIDE,-1,224>
         }
         #declare BLOB_STRN01 = -.7
         #declare BLOB_A_R01 = sqrt ( 1 - sqrt ( abs ( BLOB_DENS01 / BLOB_STRN01 ) ) )
         sphere{0, 1/BLOB_A_R01, BLOB_STRN01 scale <2,.13,2>*10
            translate <-45*SIDE,-1.5,224>
         }
         #declare BLOB_STRN01 = -.6
         #declare BLOB_A_R01 = sqrt ( 1 - sqrt ( abs ( BLOB_DENS01 / BLOB_STRN01 ) ) )
         sphere{0, 1/BLOB_A_R01, BLOB_STRN01 scale <2,.17,1>*10
            translate <-30*SIDE,-9.5,224>
         }
         #declare BLOB_STRN01 = .7
         #declare BLOB_A_R01 = sqrt ( 1 - sqrt ( abs ( BLOB_DENS01 / BLOB_STRN01 ) ) )
         sphere{0, 1/BLOB_A_R01, BLOB_STRN01 scale <7,10,15>
            translate <-28*SIDE,-6,224>
         }
         #declare BLOB_STRN01 = 20
         #declare BLOB_A_R01 = sqrt ( 1 - sqrt ( abs ( BLOB_DENS01 / BLOB_STRN01 ) ) )
         cylinder{<-.8*SIDE,0,0><.8*SIDE,0,0> .8/BLOB_A_R01, BLOB_STRN01 scale <2,2,28/.8>
            translate <-6*SIDE,6.5,5.7>
         }
         translate <-26.5*SIDE, 0, 0>
      }
      box{ <-40.0*SIDE,50,224><38.5*SIDE,-51,0> }
   }
   prism { linear_sweep linear_spline
      -10,
      10,
      11,
      <-2, 60>, <-2, 0>
      <5.7, 5.7>, <5.7, 9.7>, <0, 15.5>, <24, 14.7>, <79,  8.7>,
      <79+55, 8.0>, <200, 8.0>, <200, 60>, <-2, 60>
      rotate x*-90
      rotate y*-90
      translate <-28*SIDE,-1,0>
   }
   superellipsoid{ <.1, .1>
      translate <0,-1,1>
      scale <30,30,40>
      translate <-28*SIDE,-17,-4>
   }
   box{ <-50*SIDE,0,-150><0,-20,150>
      translate <0,-20,120>
   }
   box{ <-50*SIDE,0,250><50*SIDE,-30,224-7>
      translate <-28*SIDE,0,0>
   }
   box{ <-50*SIDE,0,250><50*SIDE,-30,224-30>
      translate <-28*SIDE,-9,0>
      texture{ T_Chrome_4D }
   }
   cylinder{<-50*SIDE,0,0><50*SIDE,0,0>3
      translate <-28*SIDE,-9,199>
      texture{ T_Chrome_4D }
   }
   cylinder{<-50*SIDE,0,0><50*SIDE,0,0>8
      translate <-28*SIDE,-9-5,224-39>
      texture{ T_Chrome_4D }
   }
   box{ <-50*SIDE,0,199><50*SIDE,-30,224-39>
      translate <-28*SIDE,-6,0>
      texture{ T_Chrome_4D }
   }
   box{ <-50*SIDE,0,20><50*SIDE,-30,-8>
      rotate x*39
      translate <-28*SIDE,-9-5,224-39>
      texture{ T_Chrome_4D }
   }
   superellipsoid {<.8,.2>
      scale <7,14,20>
      rotate z*7*SIDE
      translate <-31*SIDE,-9,224-36>
   }
   box{<-31.5*SIDE,-2,0><-30*SIDE,10,100>
      rotate y*.5*SIDE
      translate <0,0,145>
   }

   difference{
      superellipsoid{ <.1, .01>
        rotate y*90
        scale 19
      }
      superellipsoid{ <.1, .01>
        rotate y*90
        scale <20,18.5,18.5>
      }
      translate <-1*SIDE,-1,-1>*19
      translate <-32*SIDE,-10,78>
   }

// door:

   difference{
      superellipsoid{ <.2, .01>
        rotate y*90
        scale 24.5
      }
      superellipsoid{ <.2, .01>
        rotate y*90
        scale <36,24,24>
      }
      box{<-35,10,-35><35,-35,0>}
      translate <-1*SIDE,-1,-1>*24.5
      translate <-32*SIDE,8,149>
   }

   intersection{
      difference{
        superellipsoid{ <.1, .01>
          rotate y*90
          scale 24.5
        }
        superellipsoid{ <.1, .01>
          rotate y*90
          scale <36,24,24>
        }
      }
      box{<-35,-10,-35><35,-35,0>}
      translate <-1*SIDE,-1,-1>*24.5
      translate <-32*SIDE,32,149>
   }

   box{<-24.5,-24.5,-5><24.5,-24,24.5>
      translate <-1*SIDE,-1,-1>*24.5
      translate <-32*SIDE,32,149>
   }
   translate z*4.5
}

// FIN_CHROME

#declare FIN_CHROME01=
union{
   cylinder{ <5.7,7.5,-1.6> <3.7,7.5,-1.6> 0.8*2 }
   cylinder{ <5.7,7.5,1.6> <3.7,7.5,1.6> 0.8*2 }
   box{<5.7,7.5+0.8*2,1.6><3.7,7.5-0.8*2,-1.6>}

   cone{ <3.7,7.5,-1.6>0.75*2 <2.2,7.5,-1.6> 0.7*2}
   cone{ <3.7,7.5,1.6>0.75*2 <2.2,7.5,1.6> 0.7*2}

   intersection{
      union{
         sphere{ 0, 0.72*2 scale <4.5,1,1> translate <5,7.5,-1.6> }
         sphere{ 0, 0.72*2 scale <4.5,1,1> translate <5,7.5,1.6> }
         pigment{color rgb<1,0,0>}
      }
      box{<0,-10,-10><10,10,10>translate x*-5}
   }
   union{
      cone{ <-2, 0>1.4 <5.7, 5.7> 1 }
      sphere{ <5.7, 5.7> 1 }
      cylinder{ <5.7, 5.7> <5.7, 9.7> 1 }
      sphere{ <5.7, 9.7> 1 }
      cylinder{ <5.7, 9.7> <0, 15.5> 1 }
      sphere{ <0, 15.5> 1 }
      cylinder{ <0, 15.5> <24, 14.7> 1 }
      sphere{ <24, 14.7> 1 }
      cylinder{ <24, 14.7> <79,  8.7> 1 }
      sphere{ <79,  8.7> 1 }
      cylinder{ <79,  8.7> <79+55, 8.0> 1 }
      sphere{ <79+55, 8.0> 1 }
      scale <1,1,.8>
   }
   rotate y*-90
   translate <-28*SIDE,-1,0>
   translate z*4.5
   translate x*-4.75*SIDE
   texture{ T_Chrome_4D }
}

// HOOD_CHROME

#declare HOOD_CHROME01=
union{
   box{<-31.5*SIDE,3,5><-30.5*SIDE,6.7,67>}
   intersection{
      cylinder{<-31.5*SIDE,6.7-14,67><-30.5*SIDE,6.7-14,67>14}
      box{<-32*SIDE,0,67+15><-30*SIDE,10,67>}
   }
   difference{
      intersection{
         sphere{0, 14 scale <1.5,1,1.02> translate <-31*SIDE,6.7-14,67>}
         box{<-27*SIDE,2,67+16><-35*SIDE,3,67+10>}
         //rotate y*-.5*SIDE
      }
      box{<-30*SIDE,-1,67><-30.5*SIDE,6.7,67+16>}
   }
   difference{
      box{<-31.3*SIDE,3,59><-30.8*SIDE,8.2,66>}
      cylinder{<-32*SIDE,6.7+4,59><-30*SIDE,6.7+4,59>4}
   }
   cylinder{<-31.3*SIDE,8.2-5,66><-30.8*SIDE,8.2-5,66>5}
   rotate y*.5*SIDE
   translate <0,0,145>
   translate z*4.5
   texture{ T_Chrome_4D }
}

// DOOR HANDLE

#declare HANDLE01=
difference{
   union{
      #declare BLOB_DENS01 = .5
      #declare BLOB_STRN01 = .7
      #declare BLOB_A_R01 = sqrt ( 1 - sqrt ( abs ( BLOB_DENS01 / BLOB_STRN01 ) ) )
      intersection{
         blob{ threshold BLOB_DENS01
            cylinder{<5,0,0><-5,0,0> 2.5/BLOB_A_R01, BLOB_STRN01 scale <.5,.5/2.5,1>}
            #declare BLOB_STRN01 = -2
            #declare BLOB_A_R01 = sqrt ( 1 - sqrt ( abs ( BLOB_DENS01 / BLOB_STRN01 ) ) )
            cylinder{<1,0,0><-1,0,0> 1.1/BLOB_A_R01, BLOB_STRN01 scale <.5,1,1>}
         }
         box{<0,-5,-5><5,5,5>}
      }
      #declare BLOB_DENS01 = .5
      #declare BLOB_STRN01 = .7
      #declare BLOB_A_R01 = sqrt ( 1 - sqrt ( abs ( BLOB_DENS01 / BLOB_STRN01 ) ) )
      intersection{
         blob{ threshold BLOB_DENS01
            cylinder{<2.5,0,0><-2.5,0,0> 2.5/BLOB_A_R01, BLOB_STRN01 scale <1,.5/2.5,1>}
            #declare BLOB_STRN01 = -2
            #declare BLOB_A_R01 = sqrt ( 1 - sqrt ( abs ( BLOB_DENS01 / BLOB_STRN01 ) ) )
            cylinder{<1,0,0><-2.5,0,0> 1.1/BLOB_A_R01, BLOB_STRN01 scale <1,1,1>}
         }
         box{<-5,-5,-5><0,5,5>}
      }
      superellipsoid{<.8, .3> scale <1.2,.75,1.3>*1.1 translate <2.2,-.8,0>}
      superellipsoid{<.8, .15> scale <1.2,.75,2.8>*.8 translate <2.2,-.8,0>}
   }
   box{<-10,-5,5*SIDE><10,5,0>}
   rotate y*90
   //scale 5
   translate <-38*SIDE,3,111>
   texture{ T_Chrome_4D }
}

// SIDE CHROME

#declare BLOB_DENS01 = .5
#declare BLOB_STRN01 = .7
#declare BLOB_A_R01 = sqrt ( 1 - sqrt ( abs ( BLOB_DENS01 / BLOB_STRN01 ) ) )

#declare SIDE_CHROME01=
difference{
   intersection{
      blob{ threshold BLOB_DENS01
         cylinder{<0,-1,0><0,1,0> 1/BLOB_A_R01, BLOB_STRN01 scale <1,.7,34.3>*<1.7,1.82,1>
            translate <-1.57*SIDE,-1.5,0>
            scale 12/3
            translate <0,0,200>
         }
         cylinder{<-1*SIDE,0,0><1*SIDE,0,0> 1/BLOB_A_R01, BLOB_STRN01 scale <.7,1,34.3>*<1.7,1.82,1>
            translate <-1.57*SIDE,-1.5,0>
            scale 12/3
            translate <0,0,200>
         }
         #declare BLOB_STRN01 = 1
         #declare BLOB_A_R01 = sqrt ( 1 - sqrt ( abs ( BLOB_DENS01 / BLOB_STRN01 ) ) )
         cylinder {<0,0,-1><0,0,1>, 1/BLOB_A_R01, BLOB_STRN01 scale <1,2.8,20>
            translate <-1.57*SIDE,-1.5,0>
            scale 12/3
            translate <0,-4,200>
         }
         #declare BLOB_STRN01 = -1.7
         #declare BLOB_A_R01 = sqrt ( 1 - sqrt ( abs ( BLOB_DENS01 / BLOB_STRN01 ) ) )
         sphere{0, 1/BLOB_A_R01, BLOB_STRN01 scale <2,10,50>
            rotate z*7*SIDE
            translate <-1.57*SIDE,-1.5,0>
            scale 12/3
            translate <-13.6*SIDE,1,190>
         }
         #declare BLOB_STRN01 = 3
         #declare BLOB_A_R01 = sqrt ( 1 - sqrt ( abs ( BLOB_DENS01 / BLOB_STRN01 ) ) )
         cylinder{<0,0,250><0,0,-2> .8/BLOB_A_R01, BLOB_STRN01 scale <.65,2,1.1>
            translate <-1.57*SIDE,-1.5,0>
            scale <12/3,12/3,1>
            translate <0,-4,0>
         }
         #declare BLOB_STRN01 = 3
         #declare BLOB_A_R01 = sqrt ( 1 - sqrt ( abs ( BLOB_DENS01 / BLOB_STRN01 ) ) )
         cylinder{<0,0,79+55><0,0,79+45> .8/BLOB_A_R01, BLOB_STRN01 scale <.302,8,1>
            translate <-1.57*SIDE,-1.5,0>
            scale <12/3,12/3,1>
            translate <0,16,0>
         }

         #declare BLOB_STRN01 = .7
         #declare BLOB_A_R01 = sqrt ( 1 - sqrt ( abs ( BLOB_DENS01 / BLOB_STRN01 ) ) )
         sphere{0, 1/BLOB_A_R01, BLOB_STRN01 scale <7,10,15>
            translate <-28*SIDE,-6,224>
         }
         translate <-26.5*SIDE, 0, 0>
      }
      box{ <-40.0*SIDE,50,224><-(28+4.75)*SIDE,-51,0.1> }
   }
   superellipsoid{ <.1, .1>
      translate <0,-1,1>
      scale <30,30,40>
      translate <-28*SIDE,-17,-4>
   }

   box{ <-50*SIDE,0,20><50*SIDE,-30,-8>
      rotate x*39
      translate <-28*SIDE,-9-5,224-39>
   }
   box{ <-50*SIDE,30,50><50*SIDE,-30,-8>
      translate <-28*SIDE,-9-5,224-39>
   }
   difference{
      box{ <-50*SIDE,20,150><50*SIDE,-10,-10>}
      cylinder { <-51*SIDE,0,0><51*SIDE,0,0>5
         translate <0,5,-5>
         scale <1,1,2>
         translate <0,-14.5+19,0>
      }
      translate <-28*SIDE,0,79+55>
   }
   box{ <-50*SIDE,7,150><50*SIDE,0,0>
      translate <-28*SIDE,-15,38>
   }
   superellipsoid {<.1,.6>
      translate <0,1,1>
      scale <50,6,90>
      translate <-28*SIDE,-15,3.5>
   }
   box{ <-50*SIDE,9.5*2,150><50*SIDE,0,0>
      translate <-28*SIDE,-14.5,110>
   }
   superellipsoid {<.1,.85>
      translate <0,1,1>
      scale <50,9.5,110>
      translate <-28*SIDE,-14.5,3.5>
   }

   box{ <-50*SIDE,30,79+60><50*SIDE,0,79+40>
      translate <-28*SIDE,8,0>
   }

   superellipsoid {<.1,.6>
      translate <0,0,1>
      scale <50,7.5,50>
      translate <-28*SIDE,-7.5,3.5>
   }

// door:

   difference{
      superellipsoid{ <.2, .01>
        rotate y*90
        scale 24.5
      }
      superellipsoid{ <.2, .01>
        rotate y*90
        scale <36,24,24>
      }
      box{<-35,10,-35><35,-35,0>}
      translate <-1*SIDE,-1,-1>*24.5
      translate <-32*SIDE,8,149>
   }

   intersection{
      difference{
        superellipsoid{ <.1, .01>
          rotate y*90
          scale 24.5
        }
        superellipsoid{ <.1, .01>
          rotate y*90
          scale <36,24,24>
        }
      }
      box{<-35,-10,-35><35,-35,0>}
      translate <-1*SIDE,-1,-1>*24.5
      translate <-32*SIDE,32,149>
   }

   box{<-24.5,-24.5,-5><24.5,-24,24.5>
      translate <-1*SIDE,-1,-1>*24.5
      translate <-32*SIDE,32,149>
   }
   translate z*4.5
   texture{ T_Chrome_4D }
}
