// Play horse with spring
// by Robert Fremin 1997
//
//	objects:
//		Horse
//		HorseGrass


#declare horse =
union
{
	superellipsoid { <.1,.3> scale <30,15,10> translate y*15 }
	cylinder { <-37.5, 37.5, -2> <-37.5, 37.5, 2> 7.5 }
	cylinder { <-50,     30, -2> <-50,   30,   2>   5 }
	box { <0,-5,-2> <15,5,2> rotate z*41 translate <-50,30,0> }
	box { <0,-5,-2> <15,5,2> rotate z*20 translate <-50,30,0> }
	box { <0,-7.5,-2> <30,7.5,2> rotate z*-50 translate <-37.5,37.5,0> }  // neck
	box { <0,-7.5,-2> <30,7.5,2> rotate z*-60 translate <-37.5,37.5,0> }
	// ear
	intersection {
		box { <-1,-1,-2> <1,1,2> rotate z*45 scale <2,5,1> rotate z*-30 }
		cylinder { z*-10 z*10 5 }
		translate <-35,44,0>
	}
	sphere { <-40,40,-2> 1.5 pigment { White } }
	sphere { <-40,40,2> 1.5 pigment { White } }

	// spots
	cylinder { z*-10.00001 z*10.00001 3 translate <-9,12,0> pigment { White } }
	cylinder { z*-10.00001 z*10.00001 5 translate <5,15,0> pigment { White } }
	cylinder { z*-10.00001 z*10.00001 2 translate <15,10,0> pigment { White } }

	// saddle
	intersection
	{
		superellipsoid { .1 scale <30,15,10> translate y*15 }
		cylinder { <0,30,-50> <0,30,50> 10 }
		scale <1.5,1.001,1.001>
		pigment { color <.7,.5,.3> }
	}

	// handle
	torus { 12 1.5 scale <1,1,1> rotate z*90 translate <-15,25,0> pigment { White } finish { Phong_Shiny } }

	// spring
	blob {
		threshold .3
		#declare c = 0
		#while (c < 200)
			sphere { <10, -c*.1, 0> 1.5 1 rotate y*c*5 }
			#declare c = c + 1
		#end
		pigment { color <.1,.1,1> }
		finish { specular .4 phong .5 metallic }
	}

	// tail
	#declare R = seed(4913678)
	#declare c = 0
	#while (c < 20)
		cylinder { 0 y*-20 .2 rotate <10*rand(R)-5,0,5+15*rand(R)>
				   translate <30+rand(R),25+2*rand(R),2*rand(R)-1> pigment { Yellow } }
		#declare c = c + 1
	#end

	// plate
	box { <-20,-20,-20> <20,-25,20> pigment { Gray70 } normal { dents } }

	translate y*22

	pigment { Red }
	finish { specular .2 phong .5 reflection .05 }
}


#declare HorseGrass =
union
{
	object { #include "hgrass.inc" translate y*-25+z*-22 }
	object { #include "hgrass.inc" translate y*-25+z*22 }
	object { #include "hgrass.inc" rotate y*90 translate y*-25+x*-22 }
	object { #include "hgrass.inc" rotate y*-90 translate y*-25+x*22 }

	translate y*22
}
