// persienn
// Robert Fremin 1997
// objects:
//		#include this file
//		set "ClosedFactor" from 0 to 1
//			percentage pulled down from top of window
//		set "WhichWindow" from 0 to NumWins
//			related to the building
//		set "DrawnFactor" from 0 to 1
//			amount of rotation on the blades
//
// used by building.inc


union
{
	#declare K = 8	// radius of each part

	#declare c = 0
	#while (c < ClosedFactor*WinHeight/K)
		cylinder
		{
			<5,0,0> <WinWidth*2-5,0,0> K/2
			scale <1,.1,1>
			rotate x*-DrawnFactor*80
			translate <WinStart+WhichWindow*WinDist-WinWidth,WinHeight-K/2-c*K+200,1+10+K+20>

			pigment { White }
			finish { specular .2 phong .4 reflection .1 }
		}
		#declare c = c + 1
	#end

	cylinder
	{
		<0,WinHeight-5,0> <0,(1-ClosedFactor)*WinHeight,0> 1
		translate <WinStart+WhichWindow*WinDist-WinWidth/2,200,1+10+20>
		pigment { Grey }
	}

	cylinder
	{
		<0,WinHeight-5,0> <0,(1-ClosedFactor)*WinHeight,0> 1
		translate <WinStart+WhichWindow*WinDist+WinWidth/2,200,1+10+20>
		pigment { Grey }
	}
}
