
// Persistence of Vision Ray Tracer Scene Description File
// File: walker.pov
// Vers: 3
// Desc: Joshua's walker model
// Date: 11/11/97
// Auth: Tony Ewen
//
/*
The measurement convention I've used is inches, so the camera
position would reflect Joshua looking apon the objects.
*/

#version 3

#include "colors.inc"
#include "textures.inc"
#include "walker.inc"
#include "stripeball.inc"
#include "blox.inc"
#include "kidsmike.inc"
#include "rhammer.inc"
#include "spade.inc"
#include "scrapbook.inc"
#include "crayons.inc"

global_settings
{
  assumed_gamma 1.0
}
background { color rgb 1 }

// ----------------------------------------
#declare Cam_Pos =
 < 35, 35, -35 >

camera
{
  location Cam_Pos
  direction 1.5*z
  right     4/3*x
  look_at <3, 5, 5>
}

// Put the final light way overhead in a more natural position for a light bulb
// This is multiplied for super-intensity
#declare LightCount=1
#while (LightCount <= 2)
light_source
{
  0*x // light's position (translated below)
  color rgb 1.0  // light's color
  area_light vrotate(x * 30, 40), vrotate (z, 40), 10, 1
  adaptive 1
  translate <-30, 84, -20 + (1.5 * (LightCount - 1))>
}
#declare LightCount = LightCount + 1
#end

light_source { 0 * x color rgb 1.0  translate Cam_Pos shadowless}
//light_source { 0 * x color rgb 0.1  translate Cam_Pos shadowless}

// Place the objects

// First the walker
object { Childs_Walker rotate y * -50 translate <17, -1, 0>}

// Now a red crate
#declare Crate_Color = Red

// If you comment out the declaration of Solid - the crate sides
// are perforated.  This slows the render down dramatically ( about 60 * ? )
// but is the desired final result (we want to see the spade!)
//#declare Solid = 1
#include "toycrate.inc"
object { Crate rotate y * 35 translate x * -20}

// colorful ball
sphere { 0.0, 1 texture {pigment {bozo frequency 4} finish{specular .25}}
  scale 3.6 translate <8, 3.6, 10>}

// and Joshua's grip ball
object { GripBall rotate y * -15 translate <-4, 2, -14 > }

// Toy Microphone - makes a rattle noise
object { KidsMike rotate < 90, 0, 0> translate <18, 4.3, 0 > }

// A toy squeeky hammer ( one of Joshua's favourite toys )
object { KidsHammer pigment { color Red} rotate y * 25 translate <10.5, 3.5, -1 >}

// A sand bucket in the box with default coloring
#declare HandleColor = Green * 0.8
#include "sandbucket.inc"
object { SandBucket  translate < -11, 3.5, 2.5 >}
object { Spade rotate y * 105 translate < -6, 3.5, -4 > pigment { color Blue }}

// A set of "grid markers" - remove these before final run
/*
cylinder { <-50, .25, 0 > <50, .25, 0 > .125 rotate y * 45 translate x * -5}
cylinder { <-50, .25, 0 > <50, .25, 0 > .125 }
cylinder { <0, .25, -50 > <0, .25, 50 > .125 }
*/
// some strewn blocks
object { Blox pigment { Green } translate <2, 0, -12 > scale <2, 1, 1>}
object { Blox pigment { Green } scale <2, 1, 1> rotate <0, 45, 0 > translate <6, 0, -8 > }
object { Blox pigment { Green } scale <2, 1, 1> rotate z * 90 translate <6, 0, -16 > }
object { Blox pigment { Yellow } scale < 3, 1, 1> rotate <0, -45, 0 > translate < 1, 0, -13 >  }
object { Blox pigment { Yellow } scale < 3, 1, 1> rotate <0, -15, 0 > translate < -4, 0, -17 >  }
object { Blox pigment { Yellow } scale < 3, 1, 1> rotate <0, 25, 0 > translate < -6, 0, -19 >  }
object { Blox pigment { Red } scale < 4, 1, 1> rotate <0, 20, 0 > translate < 4.5, 0, -10 >  }
object { Blox pigment { Red } scale < 4, 1, 1> rotate <0, 75, 0 > translate < 1, 0, -16 >  }

// a scribble book
object { Book rotate x * 15 translate <3, 0, 19 >}

// and some crayons to match
object { Crayon pigment { Red } translate <-5.0, 0.25 ,13> }
object { Crayon pigment { Green } rotate y * 40 translate  < -3.0, 0.25, 17> }
object { Crayon pigment { Navy } rotate y * 150 translate < -3.0, 0.25, 16> }
object { Crayon pigment { Orange } rotate y * -40 translate < -5.0, 0.25, 20> }
//object { Crayon pigment { DarkGreen } rotate y * -75 translate < 2, 0.25, 6> }
object { Crayon pigment { DarkGreen } rotate y * 15 translate < 0, 0.25, 4> }
object { Crayon pigment { Yellow } rotate y * 100 translate < 20.0, 2.25, 5> }


// The room itself
// Add a carpet ground plane and some surrounding walls.
// ----------------------------------------

// carpet
plane
{
  y, 0
  texture
  {
    //pigment {checker color rgb 1 color blue 1 scale 2}
    //normal { bumps 0.4 scale 0.2 }
    //finish {roughness 0.2}
    pigment { agate agate_turb 1
     color_map
     {
      [ 0.0 color red 1 green 1 blue 0.5 ]
      [ 0.8 color red 1 green 1 blue 0.5 ]
      [ 1.0 color DarkBrown ]
      }}

    normal { bumps 0.4 scale 0.1 }
  }
  rotate y * -40
}

// walls
plane
{
 z, 0
 texture
 {
  pigment { color red 1 green 1 blue 0.5 }
  //normal { bumps 0.1 scale 0.1 }
 }
 rotate y * -40
 translate z * 30
 hollow
}
plane
{
 x, 0
 texture
 {
  pigment { color red 1 green 1 blue 0.5 }
  //normal { bumps 0.1 scale 0.1 }
 }
 rotate y * -40
 translate x * 33
 hollow
}

// fascia boards
box
{ <-80, 0, -.5> < 80, 3, 0>
 texture
 {
  pigment { color Blue }
 }
 rotate y * -40
 translate z * 30.5
}
box
{ <-.5, 0, -80> < 0, 3, 80>
 texture
 {
  pigment { color Blue }
 }
 rotate y * -40
 translate x * 33
}

// Any last touches?

