
// Persistence of Vision Ray Tracer Object Description File
// File: sandbucket.inc
// Vers: 3
// Desc: This file describes a child's sand bucket and spade
// Date: 16/11/97
// Auth: Tony Ewen

// Define the default colors, but let the user change them
#ifndef ( BucketColor )
 #declare BucketColor = Yellow
#end
#ifndef ( HandleColor )
 #declare HandleColor = Red
#end

#declare SandBucket =
union
{
 merge
 {
  // the bucket sides
  cone
  {
   0*y,  2.0,
   7*y, 3.35
   open
  }
  // The bucket floor
  cylinder { 0 , y * 0.1, 2 }
  // The bucket lip
  torus
  {
   3.15,
   0.1
   translate y * 7
  }
  // Rings around the bucket
  cylinder { y * 1.5, y * 1.7, 2.20 open }
  cylinder { y * 1.7, y * 1.9, 2.25 open }
  cylinder { y * 3.0, y * 3.2, 2.45 open }
  cylinder { y * 3.2, y * 3.4, 2.50 open }
  cylinder { y * 4.7, y * 4.9, 2.85 open }
  cylinder { y * 4.9, y * 5.1, 2.90 open }
  pigment { color BucketColor }
 }
 // Every bucket must have a handle
 difference
 {
  difference
  {
   cylinder { 0, y * .5,  3.575 }
   // Make sure the inner exceeds the outer to avoid artifacts
   cylinder { y * -1, y * 1, 3.5 }
  }
  box { < -3.6, -1, -3.6 > <0, 1, 3.6 > }
  rotate z * -32.5 translate y * 6.75
  pigment { color HandleColor }
 }
}
