
// Persistence of Vision Ray Object Scene Description File
// File: scrapbook.inc
// Vers: 3
// Desc: A child's scrapbook with scribble added
// Date: 22/11/97
// Auth: Tony Ewen


// 3D curved FINITE (no CSG) surface created from a mesh of triangles
#declare Book =
union
{
 union
 {
  bicubic_patch
  {
    type 1 // patch_type (0..1)
    // 0 = Bezier patch, just store the triangular vertices
    // 1 = Bezier patch, store all plane equations defined by
    //       the triangulation of the patch into sub patches
    //       (faster, uses more memory)
     flatness 0.0 // flatness value
    //       flatness_value = 0.0 to 1.0, with higher values
    //        giving flatter, less smooth results
    u_steps 5 // # of triangles to subdivide (1-5)
    v_steps 5 // # of triangles to subdivide (1-5)
    <0, 0, 0  > <3.5, 1.5,  0 > <6.5, 1.5, 0  > <8.27, 0, 0  >
    <0, 0, -4 > <3.5, 1.5, -4 > <6.5, 1.5, -4 > <8.27, 0, -4 >
    <0, 0, -8 > <3.5, 1.5, -8 > <6.5, 1.5, -8 > <8.27, 0, -8 >
    <0, 2, -12> <3.5, 0.5, -12> <6.5, 1.5, -12> <8.27, 0, -12>
    texture { pigment { color White } }
    texture { pigment { image_map { tga "scrbl1.tga" } rotate  x * 90 scale <8.27, 1, 12 > }}
  }
  union
  {
   triangle { <0,0,0> < 8.27, 0, 0> < 0, 0, -12> }
   triangle { <0, 0, -12 > <8.27, 0, 0> < 8.27, 0, -12> }
   pigment { color Gray40 }
  }
   rotate x * -90
   translate y * 12
 }
 union
 {
  bicubic_patch
  {
    type 0
    flatness 0.0
    u_steps 5
    v_steps 5
    <0,0,0  > < 2, 1, 0  > <5.5, 3.5, 0  > <8.27, 2.5, 0  >
    <0,0,-4 > < 2, 1, -4 > <5.5, 3.5, -4 > <8.27, 0.5, -4 >
    <0,0,-8 > < 2, 1, -8 > <5.5, 3.5, -8 > <8.27, 0.5, -8 >
    <0,0,-12> < 2, 1, -12> <5.5, 3.5, -12> <8.27, 2.5, -12>
    texture { pigment { color White } }
    texture { pigment { image_map { tga "scrbl1.tga" } rotate  x * 90 scale <8.27, 1, 12 > }}
  }
  union
  {
   triangle { <0,0,0> < 8.27, 0, 0> < 0, 0, -12> }
   triangle { <0, 0, -12 > <8.27, 0, 0> < 8.27, 0, -12> }
   pigment { color Gray40 }
  }
  rotate <-90, 35, 0 >
  translate <8.27,12,0>
 }
}
