
// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3
// Desc: INC file for 13geng.pov
// Date: Feb 98
// Auth: Nathan O'Brien
// Mail: no13@ozemail.com.au
// Webp: http://www.ozemail.com.au/~no13

#declare End_window =
union {
	box {<4,0,0><4.5,23.5,.5>}
	box {<-4,0,0><-4.5,23.5,.5>}
	box {<-8,23.5,0><8,24,.5>}
	box {<4.5,3.5,0><8,4,.5>}
	box {<-4.5,3.5,0><-8,4,.5>}
	box {<4.5,7.5,0><8,8,.5>}
	box {<-4.5,7.5,0><-8,8,.5>}
	box {<4.5,11.5,0><8,12,.5>}
	box {<-4.5,11.5,0><-8,12,.5>}
	box {<4.5,15.5,0><8,16,.5>}
	box {<-4.5,15.5,0><-8,16,.5>}
	box {<4.5,19.5,0><8,20,.5>}
	box {<-4.5,19.5,0><-8,20,.5>}
}

#declare End_cut1 =
union {
	box {<0,0,4><-40,8,-4>}
	cylinder {<0,8,0><-40,8,0>,4}
}

#declare End_cut2 =
union {
	box {<0,0,8><-40,24,-8>}
	cylinder {<0,24,0><-40,24,0>,8}
}

#declare End_cut3 =
union {
	object {End_cut2 translate <0,23,0> texture{T_Render}}
	object {End_cut2 translate <0,65,0> texture{T_Render}}
}

#declare End_plate1 =
union {
	box {<0,-3,11><-28,24,-11>}
	cylinder {<0,24,0><-28,24,0>,11}
}

#declare End_plate2 =
union {
	object {End_plate1 translate <0,23,0>}
	object {End_plate1 translate <0,65,0>}
}

#declare End_infill =
difference {
	union {
		object {End_plate2}
		object {End_plate2 rotate <0,60,0>}
		object {End_plate2 rotate <0,-60,0>}
	}
	object {End_cut3}
	object {End_cut3 rotate <0,60,0>}
	object {End_cut3 rotate <0,-60,0>}
	cylinder {<0,-20,0><0,100,0>,27.8}
}

#declare End_roof =
difference {
	sphere {<-170,108,0>,35}
	sphere {<-170,108,0>,28}
	box {<400,0,400><-400,108,-400>}
	box {<-170,-10,-500><0,500,500>}

	object {End_cut1 translate <-170,112,0>}
	object {End_cut1 rotate <0,30,0> translate <-170,112,0>}
	object {End_cut1 rotate <0,60,0> translate <-170,112,0>}
	object {End_cut1 rotate <0,-30,0> translate <-170,112,0>}
	object {End_cut1 rotate <0,-60,0> translate <-170,112,0>}
}

#declare End_bay =
union {
	difference {
  		cylinder {<-170,0,0><-170,108,0>,35 texture{Spec_tex3}}
   		cylinder {<-170,-10,0><-170,120,0>,28 texture{Spec_tex3}}
   		box {<-170,-20,-50><0,140,50> texture{Spec_tex3}}

		object {End_cut3 translate <-170,0,0> texture{T_Render}}
		object {End_cut3 rotate <0,60,0> translate <-170,0,0> texture{T_Render}}
		object {End_cut3 rotate <0,-60,0> translate <-170,0,0> texture{T_Render}}

	}
	object {End_roof texture{T_Top_dome}}
	object {End_infill translate <-170,0,0> texture{T_Render}}
	object {End_window rotate <0,-90,0> translate <-198,23,0> texture{T_fin}}
	object {End_window rotate <0,-90,0> translate <-198,65,0> texture{T_fin}}
	
}
