
// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3
// Desc: Texture definition file for 13geng.pov
// Date: Feb 98
// Auth: Nathan O'Brien
// Mail: no13@ozemail.com.au
// Webp: http://www.ozemail.com.au/~no13

#declare Column_stone =
texture {
  pigment
  {
    granite
    color_map
    {
      [0.00 color rgb<0.000, 0.000, 0.000>]
      [0.07 color rgb<0.522, 0.435, 0.322>]
      [0.15 color rgb<0.741, 0.471, 0.251>]
      [0.24 color rgb<0.745, 0.486, 0.227>]
      [0.43 color rgb<0.380, 0.329, 0.118>]
      [0.49 color rgb<0.886, 0.584, 0.282>]
      [0.64 color rgb<0.694, 0.573, 0.416>]
      [0.68 color rgb<0.447, 0.369, 0.020>]
      [0.78 color rgb<0.573, 0.412, 0.251>]
      [1.00 color rgb<0.671, 0.302, 0.039>]
    }
    scale 25
  }
}
texture {
  pigment
  {
    bozo
    turbulence 0.8
    color_map
    {
      [0.00 color rgbf<0.843, 0.655, 0.482, 0.514>]
      [0.06 color rgbf<1.000, 1.000, 1.000, 1.000>]
      [0.12 color rgbf<0.616, 0.482, 0.224, 0.090>]
      [0.16 color rgbf<0.800, 0.784, 0.675, 0.337>]
      [0.36 color rgbf<0.667, 0.435, 0.114, 0.624>]
      [0.46 color rgbf<0.906, 0.722, 0.569, 0.416>]
      [0.55 color rgbf<0.910, 0.827, 0.608, 1.000>]
      [0.65 color rgbf<0.659, 0.490, 0.259, 0.741>]
      [0.79 color rgbf<0.886, 0.608, 0.349, 0.196>]
      [0.87 color rgbf<0.678, 0.439, 0.247, 0.188>]
      [0.92 color rgbf<0.973, 0.780, 0.565, 0.533>]
      [1.00 color rgbf<1.000, 1.000, 1.000, 1.000>]
    }
	scale 5
  }
  finish {crand 0.2}
  normal {brick 2 scale 4}
}

#declare T_Render =
texture {
  pigment
  {
    bozo
    turbulence 1.2
    color_map
    {
      [0.00 color rgb<0.780, 0.612, 0.435>]
      [0.09 color rgb<0.863, 0.737, 0.663>]
      [0.38 color rgb<1.000, 1.000, 1.000>]
      [0.82 color rgb<0.831, 0.671, 0.498>]
      [0.88 color rgb<0.918, 0.839, 0.741>]
      [1.00 color rgb<0.953, 0.835, 0.682>]
    }
	scale 5
  }
  finish {
    phong 0.5
  }
}

#declare T_Top_dome =
texture {pigment {
	color <0.9,0.8,0.4>
	}
	normal{crackle 1.5 scale 2}
	finish{phong 1 reflection 0.15 metallic}
}

#declare T_Top_pend =
texture {pigment {
	color <0.9,0.8,0.4>
	}
	normal{quilted 1.5 scale 2}
	finish{phong 1 reflection 0.15 metallic}
}

#declare T_Top_pend2 =
texture {pigment {
	color <0.3,0.1,0.1>
	}
	normal{quilted 1.5 scale 2}
	finish{phong 1 reflection 0.15 metallic}
}

#declare T_Pend =
texture {
	radial
	texture_map {
		[0.0 T_Top_pend]
		[0.5 T_Top_pend]
		[0.5 T_Top_pend2]
		[1.0 T_Top_pend2]
	}
	frequency 30
}

#declare T_Pend2 =
texture {
	radial
	texture_map {
		[0.0 T_Top_pend]
		[0.5 T_Top_pend]
		[0.5 T_Top_pend2]
		[1.0 T_Top_pend2]
	}
	frequency 60
}

#declare T_Column1 =
texture {
  pigment
  {
    crackle
    color_map
    {
      [0.00 color rgb<1.000, 1.000, 1.000>]
      [0.07 color rgb<0.737, 0.706, 0.784>]
      [0.16 color rgb<0.604, 0.518, 0.647>]
      [0.43 color rgb<0.333, 0.298, 0.451>]
      [0.68 color rgb<0.247, 0.188, 0.314>]
      [0.92 color rgb<0.208, 0.137, 0.235>]
      [1.00 color rgb<0.078, 0.075, 0.082>]
    }
	scale 1.5
	turbulence 0.5
  }
}
texture {
  pigment
  {
    agate
    color_map
    {
      [0.00 color rgbf<1.000, 1.000, 1.000, 1.000>]
      [0.56 color rgbf<0.824, 0.675, 0.882, 0.482>]
      [0.60 color rgb<1.000, 1.000, 1.000>]
      [0.64 color rgbf<0.847, 0.737, 0.976, 0.412>]
      [1.00 color rgbf<1.000, 1.000, 1.000, 1.000>]
    }
    scale <5.0, 5.0, 5.0>
  }
  finish {
    phong 1.0
    reflection 0.2
  }
}

#declare T_Render2 =
texture {
  pigment
  {
    spotted
    turbulence 1.2
    color_map
    {
      [0.00 color rgb<0.780, 0.612, 0.435>]
      [0.09 color rgb<0.925, 0.800, 0.518>]
      [0.38 color rgb<0.945, 0.769, 0.490>]
      [0.82 color rgb<0.773, 0.651, 0.396>]
      [0.88 color rgb<0.925, 0.675, 0.424>]
      [1.00 color rgb<0.953, 0.835, 0.682>]
    }
  }
}
texture {
  pigment
  {
    agate
    color_map
    {
      [0.00 color rgbf<0.757, 0.655, 0.510, 0.400>]
      [0.24 color rgbf<0.918, 0.745, 0.455, 0.886>]
      [0.44 color rgb<0.902, 0.831, 0.431>]
      [0.60 color rgbf<0.933, 0.831, 0.769, 0.216>]
      [0.64 color rgbf<0.973, 0.745, 0.451, 0.533>]
      [0.80 color rgbf<0.855, 0.757, 0.663, 1.000>]
      [1.00 color rgbf<1.000, 1.000, 1.000, 0.612>]
    }
    scale <2.0, 2.0, 2.0>
  }
  finish {
    phong 0.5
  }
}

#declare T_Wall2 =
texture {
  pigment
  {
    agate
    agate_turb 1.2
    color_map
    {
      [0.00 color rgb<0.745, 0.655, 0.569>]
      [0.13 color rgb<0.863, 0.737, 0.663>]
      [0.38 color rgb<1.000, 1.000, 1.000>]
      [0.76 color rgb<0.831, 0.671, 0.498>]
      [0.80 color rgb<0.918, 0.839, 0.741>]
      [1.00 color rgb<0.953, 0.835, 0.682>]
    }
  }
}
texture {
  pigment
  {
    agate
    color_map
    {
      [0.00 color rgbf<1.000, 1.000, 1.000, 1.000>]
      [0.34 color rgbf<1.000, 1.000, 1.000, 1.000>]
      [0.52 color rgbf<0.718, 0.431, 0.196, 0.251>]
      [0.56 color rgb<0.949, 0.745, 0.541>]
      [0.61 color rgbf<0.780, 0.588, 0.435, 0.259>]
      [0.66 color rgbf<1.000, 1.000, 1.000, 1.000>]
      [1.00 color rgbf<1.000, 1.000, 1.000, 1.000>]
    }
    scale <5.0, 5.0, 5.0>
  }
  finish {
    phong 0.5
  }
}

#declare T_Wall1 = texture
{
  pigment
  {
    agate
    color_map
    {
      [0.00 color rgb<0.588, 0.404, 0.161>]
      [0.04 color rgb<0.973, 0.690, 0.322>]
      [0.21 color rgb<0.965, 0.875, 0.725>]
      [0.24 color rgb<0.690, 0.529, 0.255>]
      [0.41 color rgb<0.714, 0.451, 0.110>]
      [0.46 color rgb<0.514, 0.278, 0.027>]
      [0.51 color rgb<0.600, 0.424, 0.216>]
      [0.69 color rgb<0.902, 0.796, 0.569>]
      [0.75 color rgb<0.380, 0.231, 0.035>]
      [0.92 color rgb<0.569, 0.408, 0.137>]
      [1.00 color rgb<0.965, 0.725, 0.416>]
    }
    scale <3.0, 3.0, 3.0>
  }
  finish {
    phong 0.
  }
}

#declare T_fin =
texture { pigment { color <0.2,0.1,0.1>} finish{phong .5}}

#declare T_shield =
texture { pigment { color <0.2,0.1,0.1>} finish{phong 1 reflection .2}}

#declare T_rail =
texture { pigment { color <0.6,0.5,0.2>} finish{phong 1 reflection 0.3 metallic}}

#declare T_rail2 =
texture { pigment { color <0.9,0.8,0.5>} finish{phong 1 reflection 0.3 metallic}}


#declare Spec_tex =
texture {
	gradient x+z
	texture_map {
		[0.0 T_Render scale 0.1]
		[0.1 T_Render scale 0.1]
		[0.1 T_fin scale 0.1]
		[0.12 T_fin scale 0.1]
		[0.12 T_Render2 scale 0.1]
		[0.25 T_Render2 scale 0.1]
		[0.25 T_fin scale 0.1]
		[0.27 T_fin scale 0.1]
		[0.27 T_Wall1 scale 0.1]
		[0.4 T_Wall1 scale 0.1]
		[0.42 T_fin scale 0.1]
		[0.42 T_fin scale 0.1]
		[0.45 T_Wall2 scale 0.1]
		[0.7 T_Wall2 scale 0.1]
		[0.7 T_fin scale 0.1]
		[0.72 T_fin scale 0.1]
		[0.72 T_Wall1 scale 0.1]
		[0.85 T_Wall1 scale 0.1]
		[0.85 T_fin scale 0.1]
		[0.87 T_fin scale 0.1]
		[0.87 T_Render2 scale 0.1]
		[1.0 T_Render2 scale 0.2]
	}
}

#declare Spec_tex2 =
texture {
	gradient y
	texture_map {
		[0.0 T_Render2  scale 0.2]
		[0.2 T_Render2  scale 0.2]
		[0.2 T_fin scale 0.2]
		[0.22 T_fin scale 0.2]
		[0.22 T_Render  scale 0.2]
		[0.3 T_Render  scale 0.2]
		[0.3 T_fin scale 0.2]
		[0.32 T_fin scale 0.2]
		[0.32 Spec_tex scale 2]
		[0.98 Spec_tex scale 2]
		[0.98 T_fin scale 0.2]
		[1.0 T_fin scale 0.2]
	}
	scale 15
}

#declare T_Floor1 = texture
{
  pigment
  {
    bozo
    color_map
    {
      [0.00 color rgb<0.929, 0.792, 0.667>]
      [1.00 color rgb<0.851, 0.698, 0.545>]
    }
  }
  finish {
    phong 1.0
    reflection 0.2
  }
}

#declare T_Floor2 = texture
{
  pigment
  {
    bozo
    color_map
    {
      [0.00 color rgb<0.929, 0.714, 0.525>]
      [1.00 color rgb<0.765, 0.584, 0.404>]
    }
    rotate <0.0, 90.0, 0.0>
  }
  finish {
    phong 1.0
    reflection 0.2
  }
}

#declare Ascale = 0.05

#declare Spec_tex3 =
texture {
	gradient y
	texture_map {
		[0.0 T_Wall1 scale Ascale]
		[0.028 T_Wall1 scale Ascale]
		[0.028 T_Render scale Ascale]
		[0.157 T_Render scale Ascale]
		[0.157 T_Wall1 scale Ascale]
		[0.185 T_Wall1 scale Ascale]
		[0.185 T_Render scale Ascale]
		[0.213 T_Render scale Ascale]
		[0.213 T_Wall1 scale Ascale]
		[0.407 T_Wall1 scale Ascale]
		[0.407 T_Render scale Ascale]
		[0.435 T_Render scale Ascale]
		[0.435 T_Wall1 scale Ascale]
		[0.574 T_Wall1 scale Ascale]
		[0.574 T_Render scale Ascale]
		[0.602 T_Render scale Ascale]
		[0.602 T_Wall1 scale Ascale]
		[0.796 T_Wall1 scale Ascale]
		[0.796 T_Render scale Ascale]
		[0.824 T_Render scale Ascale]
		[0.824 T_Wall1 scale Ascale]
		[0.972 T_Wall1 scale Ascale]
		[0.972 T_Render scale Ascale]
		[1.0   T_Render scale Ascale]
	}
	scale 108
}
