//--------------------------------------------------
// include standards
//--------------------------------------------------

#include "colors.inc"
#include "woods.inc"
#include "metals.inc"
#include "stones.inc"
#include "textures.inc"

//--------------------------------------------------
// commutateurs
//--------------------------------------------------

#declare livre_com = on
#declare textu_livre_com = on
#declare tvis_com = on
#declare lego_com = on
#declare mecano_com = on
#declare sky_com = on
#declare tiling_com = on
#declare jour = 6 //6
#declare textu_tiling = 1 // 1 = assez contraste, 2 = gris, 3 = preview
#declare sphere_coupe_com = on
#declare plan_com = off

//--------------------------------------------------
// parametres globaux
//--------------------------------------------------

#declare pos_camera = <0, 5, -13.5>

global_settings {
  adc_bailout 0.003922
  ambient_light <1, 1, 1>
  assumed_gamma 1.8
  hf_gray_16 off
  irid_wavelength <0.25, 0.18, 0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

#declare finish_brillant = finish {
  ambient 0.0
  diffuse 1.0
  reflection 0.1
  specular 1.0
  roughness 0.001
}

#declare finish_medium = finish {
  ambient 0.0
  diffuse 0.8
  reflection 0.05
  specular 1.0
  roughness 0.001
}

//--------------------------------------------------
// livre
//--------------------------------------------------

#declare lng_livre = 1.26 * 21/3
#declare larg_livre = 1.26 * 29.7/3

#declare haut_gd_feuilles = 0.5

#declare gd_feuilles = union {
  #declare i = 1
  #declare nb_feuilles = 30
  #while (i < nb_feuilles)
    triangle {
      <-(lng_livre+0.5+(0.2-pow(i, 2)*0.2/pow(nb_feuilles, 2))), -(haut_gd_feuilles-pow(i, 2)*haut_gd_feuilles/pow(nb_feuilles, 2)), larg_livre>,
      <-(lng_livre+0.5+(0.2-pow(i, 2)*0.2/pow(nb_feuilles, 2))), -(haut_gd_feuilles-pow(i, 2)*haut_gd_feuilles/pow(nb_feuilles, 2)), 0>,
      <lng_livre+0.5+(0.2-pow(i, 2)*0.2/pow(nb_feuilles, 2)), -(haut_gd_feuilles-pow(i, 2)*haut_gd_feuilles/pow(nb_feuilles, 2)), larg_livre>
    }
    triangle {
      <-(lng_livre+0.5+(0.2-pow(i, 2)*0.2/pow(nb_feuilles, 2))), -(haut_gd_feuilles-pow(i, 2)*haut_gd_feuilles/pow(nb_feuilles, 2)), 0>,
      <lng_livre+0.5+(0.2-pow(i, 2)*0.2/pow(nb_feuilles, 2)), -(haut_gd_feuilles-pow(i, 2)*haut_gd_feuilles/pow(nb_feuilles, 2)), larg_livre>,
      <lng_livre+0.5+(0.2-pow(i, 2)*0.2/pow(nb_feuilles, 2)), -(haut_gd_feuilles-pow(i, 2)*haut_gd_feuilles/pow(nb_feuilles, 2)), 0>
    }
    #declare i = i + 1
  #end
  pigment {
    color White
  }
}

#declare couverture = difference {
  #declare larg_livre_reliure = 1.7
  #declare haut_livre_reliure = 0.15
  union {
    box {
      <-(lng_livre+0.5+0.2)-0.5, -haut_gd_feuilles-haut_livre_reliure, larg_livre+0.4>, <(lng_livre+0.5+0.2)+0.5, -haut_gd_feuilles, -0.4>
    }
    cylinder {
      <-larg_livre_reliure/2, -haut_gd_feuilles-0.05, larg_livre+0.4>, <-larg_livre_reliure/2, -haut_gd_feuilles-0.05, -0.4>, haut_livre_reliure
    }
    cylinder {
      <larg_livre_reliure/2, -haut_gd_feuilles-0.05, larg_livre+0.4>, <larg_livre_reliure/2, -haut_gd_feuilles-0.05, -0.4>, haut_livre_reliure
    }
  }
  union {
    cylinder {
      <-larg_livre_reliure/2, -haut_gd_feuilles-0.2, larg_livre+0.45>, <-larg_livre_reliure/2, -haut_gd_feuilles-0.2, -0.45>, 0.12
    }
    cylinder {
      <larg_livre_reliure/2, -haut_gd_feuilles-0.2, larg_livre+0.45>, <larg_livre_reliure/2, -haut_gd_feuilles-0.2, -0.45>, 0.12
    }
  }
}

#declare livre = union {
  union {
    object {
      #declare nb_patchs = 100 //50
      #declare patch_stop = 3 * nb_patchs / 5
      #declare hauteur_ondule = 1.3
      #include "ondule.inc"
      pages_ondulees
    }
    object {
      #declare nb_patchs = 50
      #declare patch_stop = nb_patchs + 1
      #declare hauteur_ondule = 1.7
      #include "ondule.inc"
      pages_ondulees
      translate <0, 0, -larg_livre/2>
      rotate <0, 180, 0>
      translate <0, 0, larg_livre/2>
    }
    object {
      gd_feuilles
    }
    pigment {
      color White
    }
  }
  object {
    couverture
    //pigment {
    //  color Violet
    //}
    pigment {
      Firebrick
    }
  }
}

//--------------------------------------------------
// generation du tiling
//--------------------------------------------------

#declare texture_tile1 = texture {
  #switch (textu_tiling)
  #case (1)
    T_Stone23
    scale 2.4
    rotate <0, 70, 0>
    translate <0, 0.1, 0>
  #break
  #case (2)
    T_Stone23
    scale 3
  #break
  #case (3)
    pigment {
      color White
    }
  #break
  #end
  finish {
    finish_brillant
    ambient -0.25
  }
}

#declare texture_tile2 = texture {
  #switch (textu_tiling)
  #case (1)
    pigment {
      gradient x
      color_map {
        [0  color Turquoise]
        [1  color NavyBlue]
      }
    }
  #break
  #case (2)
    T_Stone13
    translate <-0.16, -0.05, 0>
    scale 3.5
  #break
  #case (3)
    pigment {
      color White
    }
  #break
  #end
  finish {
    finish_brillant
    ambient -0.4
  }
}

#declare larg_tiling = 0.15  // 0.2

#declare ang = 36
#declare ang_ = ang*pi/180;
#include "paralelo.inc"
#declare paralelo1 = paralelo

#declare ang = 2*36
#declare ang_ = ang*pi/180;
#include "paralelo.inc"
#declare paralelo2 = paralelo

#declare nb_tiles = 0
#declare ang36 = 36
#declare ang36_ = 36*pi/180
#include "paralelo.inc"
#declare tile = 1
#declare uav = 2
#declare uap = uav / (2*cos(ang36_))
#declare tiling =  union {
  #include "penrose.inc"
  #debug concat("\n>> Number of caculed tiles = ", str(nb_tiles, 9, 0), " <<\n\n")
}

#declare uav = uav / (2*cos(ang36_))
#declare uap = uap / (2*cos(ang36_))
#declare jour = jour - 1

//---------------------------------------------------------
// sphere coupee
//---------------------------------------------------------

#declare r_sphere = 2.5
#declare ang_haut_coupe = 40
#declare ang_haut_coupe_ = ang_haut_coupe*pi/180
#declare inclin_coupe = 18

#declare textu_sphere_coupe = texture {
  T_Wood14
  rotate <0, 0, 10>
  translate 1 * z
  scale <3, 1, 2>
  finish {
    specular 0.35
    roughness 0.05
  }
}

#declare x_pos_fin = 0.71 * lng_livre
#declare y_pos_fin = -0.81
#declare z_pos_fin = larg_livre/3

#declare sphere_coupe = union {
  #declare translate_y = r_sphere * sin(ang_haut_coupe_)
  #declare v_camera = vnormalize(pos_camera - (translate_y + <x_pos_fin, y_pos_fin, z_pos_fin>))
  object {
    sphere {
      <x_pos_fin, y_pos_fin, z_pos_fin>, r_sphere
      clipped_by {
        plane {
          <0, -1, 0>, 0
          rotate <-(180/pi) * atan2(v_camera.y, v_camera.z), 0, 0>
          translate <x_pos_fin, y_pos_fin + translate_y, z_pos_fin>
        }
      }
    }
    texture {
      textu_sphere_coupe
      translate -x_pos_fin * x
    }
  }
  union {
    #declare delta = 1.09
    #declare c1 = - x * r_sphere * delta * cos(ang_haut_coupe_)
    #declare c2 = - <1, 0, 1> * v_camera * r_sphere * cos(ang_haut_coupe_)
    #declare c3 = <1, 0, 1> * v_camera * r_sphere * cos(ang_haut_coupe_)
    #declare c4 = x * r_sphere * (1+(delta-1)/3) * cos(ang_haut_coupe_)
    #declare c1 = vaxis_rotate(c1, x, -inclin_coupe)
    #declare c2 = vaxis_rotate(c2, x, -inclin_coupe)
    #declare c3 = vaxis_rotate(c3, x, -inclin_coupe)
    #declare c4 = vaxis_rotate(c4, x, -inclin_coupe)
    #declare c1 = c1 + y * translate_y + <x_pos_fin, y_pos_fin, z_pos_fin>
    #declare c2 = c2 + y * translate_y + <x_pos_fin, y_pos_fin, z_pos_fin>
    #declare c3 = c3 + y * translate_y + <x_pos_fin, y_pos_fin, z_pos_fin>
    #declare c4 = c4 + y * translate_y + <x_pos_fin, y_pos_fin, z_pos_fin>
    #declare c1 = c1 + r_sphere * vnormalize(pos_camera - c1)
    #declare c2 = c2 + r_sphere * vnormalize(pos_camera - c2)
    #declare c3 = c3 + r_sphere * vnormalize(pos_camera - c3)
    #declare c4 = c4 + r_sphere * vnormalize(pos_camera - c4)
    #include "carre.inc"
    no_shadow
    texture {
      textu_sphere_coupe
      finish {
        reflection .2
      }
      scale 1 - 0.03 * x
      translate -x_pos_fin * x
    }
  }
}

#declare ang_support = 70
#declare ang_support_ = ang_support * pi/180
#declare major = r_sphere * cos(ang_support_)
#declare minor = r_sphere * (1 - sin(ang_support_))

#declare textu_repose_sphere_socle = texture {
  pigment {
    color HuntersGreen
  }
  finish {
    finish_medium
  }
}

#declare textu_etiquette = texture {
  pigment {
    color red 1.3 green 0.576471 - 0.1 blue 0.439216 - 0.1 //Firebrick
  }
  finish {
    finish_medium
  }
}

#declare textu_socle = texture {
  T_Stone14
}

#declare etiquette_socle = union {
  #include "etiquet.inc"
  object {
    etiquette
    scale <1.367/3.461, 0.45/1.136, 1>
    scale <0.9 - 0.05, 0.8 - 0.15, 1>
  }
  union {
    #declare text_scale = 0.3
    text {
      ttf "TIMES.TTF",
      "Sculpture made by an",
      0.1, -0.06 * x
      scale text_scale - 0.023 * x
      translate <-0.99, 0.1, -0.001>
    }
    text {
      ttf "TIMES.TTF",
      "unknown engineer",
      0.1, -0.06 * x
      scale text_scale + 0.02 * x
      translate <-1, -0.17, -0.001>
    }
    pigment {
      Black
    }
    translate -0.03333
  }
  translate <0, -0.45, -1.367>
}

#declare repose_sphere_socle = union {
  torus {
    major + 0.15
    minor/2
  }
  torus {
    major + 0.15 - minor/2
    minor/2
    translate 3*minor/4 * y
  }
  torus {
    major + 0.15 - 2 * minor/2
    minor/2
    translate 2 * (3*minor/4 * y)
  }
  texture {
    textu_repose_sphere_socle
  }
  translate (0.14-minor/2) * y
}

#declare support = union {
  #include "socle.inc"
  object {
    socle
  }
  //object {
  //  pyramid_socle
  //}
  object {
    repose_sphere_socle
  }
  object {
    etiquette_socle
  }
  scale 1.5
  translate <x_pos_fin, y_pos_fin - 0.2 - r_sphere * sin(ang_support_) - minor, z_pos_fin>
}

//--------------------------------------------------
// mecano
//--------------------------------------------------

#declare epaisseur_mecano = 0.05
#declare r_trous_mecano = 0.2
#declare pif = 0

#declare mecano = union {
  object {
    #declare long_mecano = 0
    #declare larg_mecano = 0
    #include "mecano.inc"
    equerre
  }
  object {
    #declare long_mecano = 7
    #declare long_plaque_bas = long_mecano
    #declare larg_mecano = 2
    #include "mecano.inc"
    plaque
  }
  object {
    #declare long_mecano = 3
    #declare larg_mecano = 0
    #include "mecano.inc"
    tige
    rotate <0, 0, 90>
    translate <-0.5 - epaisseur_mecano, 0.5 + epaisseur_mecano, 1>
  }
  union {
    #declare i = 0
    #while (i<4)
      object {
        #declare pif = 30 + i*100
        #include "mecano.inc"
        vis_boulon
        rotate <90, 0, 0>
        rotate <0, 90, 0>
        translate <-0.5 - epaisseur_mecano, 0.5 + epaisseur_mecano + i, 1>
      }
      #declare i = i + 1
    #end
  }
  object {
    #declare long_mecano = 0
    #declare larg_mecano = 0
    #include "mecano.inc"
    equerre
    rotate <180, 0, 0>
    translate <0, 4, 2>
  }
  object {
    #declare long_mecano = 2
    #declare long_plaque_haut = long_mecano
    #declare larg_mecano = 2
    #include "mecano.inc"
    plaque
    translate <0, 4 - epaisseur_mecano, 0>
  }
  union {
    object {
      #declare pif = 5
      #include "mecano.inc"
      vis_boulon
      scale <0.9, 1, 0.9>
      rotate <180, 0, 0>
      translate <0, 4, 0>
    }
    object {
      #declare pif = 310
      #include "mecano.inc"
      vis_boulon
      scale <0.9, 1, 0.9>
      rotate <180, 0, 0>
      translate <0, 4, 2>
    }
    object {
      #declare pif = 50
      #include "mecano.inc"
      vis_boulon
      scale <0.85, 1, 0.85>
      rotate <0, 0, 0>
      translate <long_plaque_haut, 4+2*epaisseur_mecano, 0>
    }
    object {
      #declare pif = 185
      #include "mecano.inc"
      vis_boulon
      scale <0.85, 1, 0.85>
      rotate <0, 0, 0>
      translate <long_plaque_haut, 4+2*epaisseur_mecano, 2>
    }
  }
  object {
    #declare long_mecano = 7
    #declare larg_mecano = 0
    #include "mecano.inc"
    tige
    rotate <0, 90, 0>
    scale <0.75, 1, 0.97>
    translate <long_plaque_haut, 4 + epaisseur_mecano, 2>
    clipped_by {
      plane {
        <0, 0, -1>, 0
        rotate <-70, 0, 0>
        translate <long_plaque_haut, 4 + 1.5 * epaisseur_mecano, -(long_mecano-2.8)>
      }
    }
    no_shadow
  }
  object {
    #declare long_mecano = 7
    #declare larg_mecano = 0
    #include "mecano.inc"
    tige
    rotate <0, -90, 0>
    scale <1.18, 1.15, 1>  // 1.07 pour un look_at <0, 1, 0>
    translate <long_plaque_bas, epaisseur_mecano, 0>
    clipped_by {
      plane {
        <0, 0, 1>, 0
        translate <long_plaque_bas, 0.5 * epaisseur_mecano, long_mecano - 0.9>
      }
    }
  }
  union {
    object {
      #declare pif = 270
      #include "mecano.inc"
      vis_boulon
      rotate <0, 0, 0>
      translate <0, 2*epaisseur_mecano, 0>
    }
    object {
      #declare pif = 230
      #include "mecano.inc"
      vis_boulon
      rotate <0, 0, 0>
      translate <0, 2*epaisseur_mecano, 2>
    }
    object {
      #declare pif = 340
      #include "mecano.inc"
      vis_boulon
      scale <1.15, 1, 1.15>
      rotate <0, 0, 0>
      translate <long_plaque_bas, 2*epaisseur_mecano, 0>
    }
    object {
      #declare pif = 65
      #include "mecano.inc"
      vis_boulon
      scale <1.15, 1, 1.15>
      rotate <0, 0, 0>
      translate <long_plaque_bas, 2*epaisseur_mecano, 2>
    }
  }
}

#declare elts_mecano = union {
  union {
    object {
      #declare long_mecano = 0
      #declare larg_mecano = 0
      #include "mecano.inc"
      equerre
      translate <0, epaisseur_mecano, 0>
    }
    object {
      #declare long_mecano = 0
      #declare larg_mecano = 0
      #declare pif = 72
      #include "mecano.inc"
      vis_boulon
      rotate <-90, 0, 0>
      rotate <0, 90, 0>
      translate <-0.5 - epaisseur_mecano, 0.5 + epaisseur_mecano, 1>
    }
    rotate <0, 90 - 50, 0>
    translate <-1, 0, -4>
  }
  object {
    #declare long_mecano = 0
    #declare larg_mecano = 0
    #declare pif = 250
    #include "mecano.inc"
    vis
    translate <3, hauteur_tete_vis, -1.5>
  }
  object {
    #declare long_mecano = 0
    #declare larg_mecano = 0
    #declare pif = 350
    #include "mecano.inc"
    boulon
    translate <2, larg_boulon/2, -2>
  }
  object {
    #declare long_mecano = 0
    #declare larg_mecano = 0
    #declare pif = 350
    #include "mecano.inc"
    boulon
    translate <-2.5, larg_boulon/2, -6>
  }
  object {
    #declare long_mecano = 0
    #declare larg_mecano = 0
    #declare pif = 55
    #include "mecano.inc"
    vis
    rotate <110, 0, 0>
    rotate <0, 80, 0>
    translate <-1.5, hauteur_tete_vis, -1.5>
  }
}

//--------------------------------------------------
// lumiere
//--------------------------------------------------

#declare pos_light = <-100, 50, -100>
#declare dist_fade = vlength(pos_light) * 5
light_source {
  pos_light
  color White
  fade_distance dist_fade
  fade_power 2
}

#declare pos_light = <100, 40, -40>
#declare dist_fade = vlength(pos_light) * 2
light_source {
  pos_light
  color Gray30
  fade_distance dist_fade
  fade_power 2
}

#declare pos_light = <0, 200, 0>
#declare dist_fade = vlength(pos_light) * 4
#declare lum_haut_angx = 0
#declare lum_haut_angz = 0
light_source {
  pos_light
  color Gray30
  fade_distance dist_fade
  fade_power 2
  rotate <lum_haut_angx, 0, lum_haut_angz>
}

light_source {
  #declare hauteur_spot = 5
  <0, hauteur_spot, 0>
  color White * 0.8
  spotlight
  point_at <0, 0, 0>
  radius (abs(c2.z) + abs(c3.z)) / 20
  falloff 12
  tightness 10
  fade_distance hauteur_spot * 1.5
  fade_power 2
  rotate <inclin_coupe, 0, 0>
  translate c3 //(c1 + c2 + c3 + c4)/4
}

//--------------------------------------------------
// ciel
//--------------------------------------------------

#if (sky_com = on)
sky_sphere {
  pigment {
    gradient z
    color_map {
      #declare choix = 4
      #switch (choix)
      #case (1)
        #declare col_0 = <0.3, 0, 0.3>
        #declare col_1 = <0.9, 0.5, 0>
        #declare col_2 = <1, 1, 0>
        #declare col_3 = <1, 1, 1>
        #break
      #case (2)
        #declare col_0 = <0, 0, 0.3>
        #declare col_1 = <0.7, 0, 0.7>
        #declare col_2 = <1, 1, 0.2>
        #declare col_3 = <1, 1, 1>
        #break
      #case (3)
        #declare col_0 = <0, 0, 0>
        #declare col_1 = <0.8789, 0.9258, 0.6758>
        #declare col_2 = <1, 1, 1>
        #declare col_3 = <1, 1, 1>
        #break
      #case (4)
        #declare col_0 = <0, 0, 0>
        #declare col_1 = <0.6563, 0.7891, 0.8359>
        #declare col_2 = <1, 1, 1>
        #declare col_3 = <1, 1, 1>
        #break
      #end
      #declare dist = vlength (col_1 - col_0) + vlength (col_2 - col_1) +
                      vlength (col_3 - col_2)
      #declare x1 = vlength(col_1 - col_0) / dist
      #declare x2 = vlength(col_2 - col_1) / dist + x1
      #declare x3 = 1
      //#debug concat(str(x1, 3, 5)," ",str(x2, 3, 5)," ",str(x3, 3, 5),"\n")
      [0   color Black] [0.1 color col_0]
      [0.1 color col_0] [x1  color col_1]
      [x1  color col_1] [x2  color col_2]
      [x2  color col_2] [1   color col_3]
    }
  }
  rotate <-65, 0, -20>
}
#end

//--------------------------------------------------
// quadripoutre en lego
//--------------------------------------------------

#declare textu_lego_1 = texture {
  pigment {
    color <1, 0.1, 0.13>
  }
  finish {
    Shiny
  }
}

#declare textu_lego_2 = texture {
  pigment {
    color <0.9, 0.9, 0.9>
  }
  finish {
    Shiny
  }
}

#declare quadri_lego = union {
  #declare pos_z_lego = 2
  #declare haut_poutre_derriere = 8
  #declare haut_poutre_devant = 9
  #declare nb_unite_ecart = 6
  #declare i = 1
  #while (i < haut_poutre_derriere)
    object {
      #declare nb_unite_lego = 1
      #include "lego.inc"
      #declare long_lego_unite = long_lego
      lego
      translate <0, i * haut_lego, pos_z_lego>
      #if (int(i/2) = i/2)
        texture {
          textu_lego_1
        }
      #else
        texture {
          textu_lego_2
        }
      #end
    }
    #declare i = i + 1
  #end
  object {
    #declare nb_unite_lego = nb_unite_ecart
    #include "lego.inc"
    lego
    translate <0, haut_poutre_derriere * haut_lego, pos_z_lego>
    texture {
      textu_lego_1
    }
  }
  object {
    #declare nb_unite_lego = nb_unite_ecart
    #include "lego.inc"
    lego
    rotate <0, 90, 0>
    translate <0, 0, pos_z_lego + long_lego_unite>
    texture {
      textu_lego_1
    }
  }
  #declare i = 0
  #while (i < haut_poutre_devant)
    object {
      #declare nb_unite_lego = 1
      #include "lego.inc"
      #declare long_lego_unite = long_lego
      lego
      #declare scale_y = 1.02
      scale <1, scale_y, 0.75>
      translate <0,
                 haut_lego + i * haut_lego * scale_y,
                 pos_z_lego - (nb_unite_ecart-1) * long_lego_unite>
      clipped_by {
        plane {
          <0, 1, 0>, 0
        }
        rotate <8, 0, 0>
        translate <0, (1+haut_poutre_devant-0.88) * haut_lego,
                   pos_z_lego - (nb_unite_ecart-1) * long_lego_unite>
      }
      #if (i<haut_poutre_devant/2-1)
        #if (int(i/2) = i/2)
          texture {
            textu_lego_2
          }
        #else
          texture {
            textu_lego_1
          }
        #end
      #end
      #if (i>haut_poutre_devant/2-1)
        texture {
          textu_lego_1
        }
      #end
      #if (i>haut_poutre_devant/2)
        #if (int(i/2) = i/2)
          texture {
            textu_lego_1
          }
        #else
          texture {
            textu_lego_2
          }
        #end
      #end
    }
    #declare i = i + 1
  #end
}

#declare elts_lego = union {
  object {
    #declare nb_unite_lego = 2
    #include "lego.inc"
    lego
    rotate <90, -15, 0>
    translate <-5, larg_lego, 0>
    texture {
      textu_lego_1
    }
  }
  object {
    #declare nb_unite_lego = 1
    #include "lego.inc"
    lego
    rotate <-90, 30, 0>
    translate <-1.2, 0, -1>
    texture {
      textu_lego_2
    }
  }
}

//--------------------------------------------------
// scene
//--------------------------------------------------

#declare pos_livre = <0, -5, -0.6>
#declare pos_y_tiling = pos_livre.y - haut_gd_feuilles - haut_livre_reliure
#if (livre_com = on)
  object {
    livre
    translate pos_livre
  }
#end
#if (plan_com = on)
  plane {
    <0, 1, 0>, pos_y_tiling - larg_tiling
    clipped_by {
      plane {
        <0, 0, 1>, 70
      }
    }
    texture {
      //T_Wood35
      T_Stone24
      scale 20
      rotate <0, 35, 0>
      translate <10, 0, 0>
    }
  }
#end
#if (tiling_com = on)
  object {
    tiling
    rotate <0, 0, -36/2>
    //scale 6
    rotate <90, 0, 0>
    scale <38, 1, 38>
    translate <0, pos_y_tiling - larg_tiling/2, 10>
  }
#end
#if (sphere_coupe_com = on)
  union {
    object {
      sphere_coupe
    }
    object {
      support
    }
  }
#end
#if (mecano_com = on)
  union {
    object {
      mecano
      translate <0, hauteur_tete_vis, 0>
    }
    object {
      elts_mecano
    }
    scale <1.2, 0.9, 1.2>
    rotate <0, -49.6, 0> //-51.2   -49.7   -49.1 pour un look_at <0, 1, 0>
    translate <-larg_livre - 2.4, pos_y_tiling, lng_livre + 2>
  }
#end
#if (lego_com = on)
  union {
    object {
      quadri_lego
      rotate <0, -38.7, 0>
    }
    object {
      elts_lego
    }
    scale 1.5
    translate <0, pos_y_tiling, lng_livre + 10>
  }
#end
#if (tvis_com = on)
  #declare textu_axe_vis = texture {
    T_Chrome_4A
  }
  #declare textu_manche_vis = texture {
    pigment {
      color HuntersGreen
    }
    finish {
      finish_medium
    }
  }
  object {
    #include "t_vis.inc"
    tvis
    scale 1.7
    rotate <0, -175, 0>
    translate <-3, pos_y_tiling, -2.3>
  }
#end

//--------------------------------------------------
// camera
//--------------------------------------------------

camera {
  location pos_camera
  look_at <0, 0.2, 0>
  //focal_point <x_pos_fin, y_pos_fin, z_pos_fin>
  //aperture 35
  //blur_samples 25
}
