
// Persistence of Vision Ray Tracer Scene Description File
// File: cathadrl.pov
// Vers: 3
// Desc: A cathedral
// Date: 02-28-98
// Auth: ?
//

#version 3

#include "finish.inc"
#include "colors.inc"
#include "textures.inc"
#include "golds.inc"
#include "metals.inc"
#include "stones.inc"

#include "in_sect.inc"
#include "outsect.inc"
#include "backwall.inc"
#include "mainflor.inc"
#include "aislearc.inc"
#include "banners.inc"
#include "lamp2.inc"
#include "tourist.inc"

global_settings
{
  assumed_gamma 2.3
}

// ----------------------------------------




camera //current
{
  location  <-27,10,0>
  direction 1.0*z
  right     3/4*x
  look_at   <-1-3,26,70>
}


light_source{
  <-10000,7000,-4000>
  color rgb <1,1,1>*1.5
  cylinder
  radius 150
  falloff  170
  tightness .0001
  point_at <0,80, 115>
}

light_source{
  <-10000,7000,-4000>/10
  color rgb <1,1,1>*.1
  shadowless
}

light_source{
  <-10000,100,5000>
   color White*.5
  shadowless
}

light_source{
  <10000,100,5000>
   color White*.15
  shadowless
}


light_source{
  <10000,100,-5000>
   color White*.10
  shadowless
}

light_source{
  <-10,30,-35>
   color White*.25

  area_light
  <3, 0, 0> <0, 0, 3> // lights spread out across this distance (x * z)
  4, 4                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 1          // 0,1,2,3...
//  jitter              // adds random softening of light

}


#declare xx=-1
#while (xx< 6)
  object{lightFixture translate<-29+(36.75/12),20,35*xx+17.5>}
  object{lightFixture rotate<0,180,0> translate<29-(36.75/12),20,35*xx+17.5>}
  #declare xx=xx+1
#end




// Create an infinite sphere around scene and allow any texture on it
sky_sphere
{
  pigment
  {
    gradient y
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}





// ----------------------------------------


#declare graniteMult=0.9
#declare granite1 =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.154   color rgb <0.800, 0.651, 0.557>*graniteMult
                    color rgb <0.996, 0.835, 0.737>*graniteMult]
    [0.154, 0.308   color rgb <0.996, 0.835, 0.737>*graniteMult
                    color rgb <0.800, 0.651, 0.557>*graniteMult]
    [0.308, 0.444   color rgb <0.800, 0.651, 0.557>*graniteMult
                    color rgb <0.694, 0.624, 0.604>*graniteMult]
    [0.444, 0.615   color rgb <0.694, 0.624, 0.604>*graniteMult
                    color rgb <0.800, 0.651, 0.557>*graniteMult]
    [0.615, 0.812   color rgb <0.800, 0.651, 0.557>*graniteMult
                    color rgb <0.725, 0.655, 0.651>*graniteMult]
    [0.812, 1.001   color rgb <0.725, 0.655, 0.651>*graniteMult
                    color rgb <0.800, 0.651, 0.557>*graniteMult]
   }
 }
 }





#declare granite2Mult=0.5
#declare granite2 =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.154   color rgb <0.800, 0.651, 0.557>*graniteMult
                    color rgb <0.996, 0.835, 0.737>*graniteMult]
    [0.154, 0.308   color rgb <0.996, 0.835, 0.737>*graniteMult
                    color rgb <0.800, 0.651, 0.557>*graniteMult]
    [0.308, 0.444   color rgb <0.800, 0.651, 0.557>*graniteMult
                    color rgb <0.694, 0.624, 0.604>*graniteMult]
    [0.444, 0.615   color rgb <0.694, 0.624, 0.604>*graniteMult
                    color rgb <0.800, 0.651, 0.557>*graniteMult]
    [0.615, 0.812   color rgb <0.800, 0.651, 0.557>*graniteMult
                    color rgb <0.725, 0.655, 0.651>*graniteMult]
    [0.812, 1.001   color rgb <0.725, 0.655, 0.651>*graniteMult
                    color rgb <0.800, 0.651, 0.557>*graniteMult]
   }
 }
 }


// ----------------------------------------

plane
{
  y, - .15/12

  texture{
    pigment { color rgb <1, 1, 0.9>}
    finish {reflection 0.2}
  }
}




#declare CP1=<-29.728, 0.0, 17.16392>
#declare CP2=<-29.728, 0.0, 17.16392>
#declare CP3=<-29.728, 0.0, 17.16392>
#declare CP4=<-29.728, 0.0, 17.16392>

#declare CP5=<-30, 4,  9>
#declare CP6=<-28, 7,  9>
#declare CP7=<-25, 10,  9>
//#declare CP8=<-22.5, 16.5, 14.5>
#declare CP8=<-25.5, 21.0, 14.5>

#declare CP9 =<-30, 7.5,5>
#declare CP10=<-23, 19, 5>
#declare CP11=<-14, 21, 5>
//#declare CP12=<-10, 30.5, 5.4>
#declare CP12=<-10, 31.5, 5.4>

#declare CP13=<-30, 10, 0>
#declare CP14=<-20, 17, 0>
#declare CP15=<-10, 24, 0>
#declare CP16= < 0, 29.15, 0>

//=================================================
#declare CP21=<-29.728, 0.0, -17.16392>
#declare CP22=<-29.728, 0.0, -17.16392>
#declare CP23=<-29.728, 0.0, -17.16392>
#declare CP24=<-29.728, 0.0, -17.16392>

#declare CP25=<-30, 4,  -9>
#declare CP26=<-28, 7,  -9>
#declare CP27=<-25, 10,  -9>
//#declare CP28=<-22.5, 16.5, -14.5>
#declare CP28=<-25.5, 21.0, -14.5>

#declare CP29 =<-30, 7.5,-5>
#declare CP210=<-23, 19, -5>
#declare CP211=<-14, 21, -5>
//#declare CP212=<-10, 30.5, -5.4>
#declare CP212=<-10, 31.5, -5.4>

#declare CP213=<-30, 10, 0>
#declare CP214=<-20, 17, 0>
#declare CP215=<-10, 24, 0>
#declare CP216= < 0, 29.15, 0>//=================================================

#declare patch_1=
  bicubic_patch {
    type 1
    flatness 0.0
    u_steps 5
    v_steps 5
    CP1, CP2, CP3, CP4,
    CP5, CP6, CP7, CP8,
    CP9, CP10,CP11,CP12
    CP13,CP14,CP15,CP16
    texture{granite1 scale .1 }
  }

/*
sphere{CP1, 1 pigment{Cyan*2}  translate<0,130,0>}
sphere{CP2, 1 pigment{White*2} translate<0,130,0>}
sphere{CP3, 1 pigment{Magenta *2} translate<0,130,0>}
sphere{CP4, 1 pigment{Green   *2} translate<0,130,0>}
sphere{CP5, 1 pigment{Cyan*2} translate<0,130,0>}
sphere{CP6, 1 pigment{White*2} translate<0,130,0>}
sphere{CP7, 1 pigment{Magenta *2} translate<0,130,0>}
sphere{CP8, 1 pigment{Green   *2} translate<0,130,0>}
sphere{CP9, 1 pigment{Cyan*2} translate<0,130,0>}
sphere{CP10, 1 pigment{White*2} translate<0,130,0>}
sphere{CP11, 1 pigment{Magenta *2} translate<0,130,0>}
sphere{CP12, 1 pigment{Green   *2} translate<0,130,0>}
sphere{CP13, 1 pigment{Cyan*2} translate<0,130,0>}
sphere{CP14, 1 pigment{White*2} translate<0,130,0>}
sphere{CP15, 1 pigment{Magenta *2} translate<0,130,0>}
sphere{CP16, 1 pigment{Green   *2} translate<0,130,0>}
*/


#declare patch_2=
  bicubic_patch {
    type 1
    flatness 0.0
    u_steps 5
    v_steps 5
    CP21, CP22, CP23, CP24,
    CP25, CP26, CP27, CP28,
    CP29, CP210,CP211,CP212
    CP213,CP214,CP215,CP216
    texture{granite1 scale .1}
  }

#declare patch_3=
  bicubic_patch {
    type 1
    flatness 0.0
    u_steps 5
    v_steps 5
    <30.728, 0.0, -17.16392>,   <24.31867, 21.36430+4.64, -11.44231>,   <9.90933, 28.05561, -05.72115>,  <0.0, 30.0,  0.00000>,
    <30.728, 0.0, -17.41392>,   <24.31867, 21.62885+4.64, -13.59951>,   <9.90933, 28.04635, -09.78541>,  <0.0, 30.0, -5.88797>,
    <30.728, 0.0, -17.66392>,   <24.31867, 21.89340+4.64, -15.75671>,   <9.90933, 28.03709, -13.84966>,  <0.0, 30.0, -11.77595>,
    <30.728, 0.0, -17.91392>,   <24.31867, 22.15794+4.64, -17.91392>,   <9.90933, 28.02783, -17.91392>,  <0.0, 30.0, -17.91392>
    texture{granite1 scale .1}
  }
#declare patch_4=
  bicubic_patch {
    type 1
    flatness 0.0
    u_steps 5
    v_steps 5
    <30.728, 0.0, 17.16392>,   <24.31867, 21.36430+4.64, 11.44231>,   <9.90933, 28.05561, 05.72115>,  <0.0, 30.0,  0.00000>,
    <30.728, 0.0, 17.41392>,   <24.31867, 21.62885+4.64, 13.59951>,   <9.90933, 28.04635, 09.78541>,  <0.0, 30.0, 5.88797>,
    <30.728, 0.0, 17.66392>,   <24.31867, 21.89340+4.64, 15.75671>,   <9.90933, 28.03709, 13.84966>,  <0.0, 30.0, 11.77595>,
    <30.728, 0.0, 17.91392>,   <24.31867, 22.15794+4.64, 17.91392>,   <9.90933, 28.02783, 17.91392>,  <0.0, 30.0, 17.91392>
    texture{granite1 scale .1}
  }



#declare rib_1 =
object{
  torus { 34.64, 1.0 rotate<90,0,0>}
  clipped_by{plane{y,4.64102 inverse}}
  translate<0,-4.64,0>
//  pigment{Red}
  texture{granite2 scale .1}
}

#declare rib_2=
object{
  torus { 29.728, .95 rotate<90,0,0>}
  clipped_by{plane{y,0 inverse}}
//  pigment{Red}
  texture{granite2 scale .1}
}




#declare vault=
union{
  object{rib_1 rotate<0,30,0>}
  object{rib_1 rotate<0,-30,0>}
//  object{rib_2 translate<0,0, 17.91392>}
  object{rib_2 translate<0,0,-17.91392>}
  patch_1
  object{patch_1 rotate<0,180,0>}
  patch_2
  object{patch_2 rotate<0,180,0>}
  patch_3
  object{patch_3 rotate<0,180,0>}
  patch_4
  object{patch_4 rotate<0,180,0>}
}

#declare xx=-1
#while (xx< 9)
  object{vault translate<0,130,35.82784*xx>}
  #declare xx=xx+1
#end


#declare xx=-1
#while (xx < 9)
  object{insideWallSection rotate<0,90,0> translate<34,0,35.076*xx>}
  object{insideWallSection rotate<0,-90,0> translate<-34,0,35.076*xx>}
  object{outsideWallSection rotate<0,90,0> translate<68,0,35.076*xx>}
  object{outsideWallSection rotate<0,90,0> translate<-68,0,35.076*xx>}
  object{aisleArch translate<51.5380,0,(35.076*xx)+17.538>}
  object{aisleArch translate<-51.5380,0,(35.076*xx)+17.538>}
  #declare xx=xx+1
#end


object{ mainColumn scale<2,1,2> rotate<0,-90,0> translate<34,0,(35.076*8)+17.538>}
object{ mainColumn scale<2,1,2> rotate<0,-90,0> translate<68,0,(35.076*8)+17.538>}
object{ mainColumn scale<2,1,2> rotate<0,-90,0> translate<-68,0,(35.076*8)+17.538>}


box{<34,63,-55>,<68,63,306> pigment{White*10}}
box{<-34,63,-55>,<-68,63,306> pigment{White*10}}
 box{<-34,0,-52>,<34,160,-54> texture{T_Grnt11}}
 box{<-34,0,-52>,<-70,64,-54> texture{T_Grnt11}}
 box{<34,0,-52>,<70,64,-54> texture{T_Grnt11}}

object{TheBackWall translate<0,0,0>}
object{mainFloor}

object{tourist translate <0,0.348417,0>  scale 1/.348417*3 rotate<0,45,0> translate<0,0,50>}

  object{banner1 translate<22,33,(35.076*1)>}
  object{banner1 rotate<0,180,0 >translate<-22,33,(35.076*1)>}
  object{banner2 translate<22,33,(35.076*2)>}
  object{banner2 rotate<0,180,0 >translate<-22,33,(35.076*2)>}
  object{banner1 translate<22,33,(35.076*3)>}
  object{banner1 rotate<0,180,0 >translate<-22,33,(35.076*3)>}
  object{banner1 translate<22,33,(35.076*4)>}
  object{banner1 rotate<0,180,0 >translate<-22,33,(35.076*4)>}
  object{banner1 translate<22,33,(35.076*5)>}
  object{banner1 rotate<0,180,0 >translate<-22,33,(35.076*5)>}


/*
object{
  difference{
    cylinder{<0,0,307>,<0,0,-55>, 33}
    cylinder{<0,0,310>,<0,0,-60>, 32}
  }
  clipped_by{plane{y,0 inverse}}
  pigment{Black}
  translate<0,130,0>
}
*/
/*
height=160 width=120 output_to_file=off
height=320 width=240 output_to_file=off
height=480 width=360 output_to_file=off
height=512 width=384 output_to_file=off

height=600 width=450 output_to_file=off +sr300 +er500 +sc150 +ec300 +A0.1
height=760 width=570 output_to_file=off

height=600 width=450 +QR output_to_file=on +b1024 +A0.1

*/




