// Persistence of Vision Ray Tracer Scene Description File
// File: in_sect.inc
// Vers: 3
// Desc: Basic Scene Example
// Date: 02-28-98
// Auth: Bob Franke
//

#include "colors.inc"
#include "golds.inc"
#include "stones.inc"
#include "tracry.inc"

/*
global_settings
{
  assumed_gamma 2.2
}

// ----------------------------------------
camera
{
  location  <0.01, 100, -75>
  direction 1*z
  right     4/3*x
  look_at   <0.0, 100,  0.0>
}

sky_sphere
{
  pigment
  {
    gradient y
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <-40,150, -100>
}
light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <0,150, -100>
}

// ----------------------------------------

plane { y, -1 pigment {color rgb <0.7,0.5,0.3>}}

*/



#declare mainColumn=
merge{
  cylinder{<-1,0,1>,<-1,150,1>, 1}
  cylinder{<-1,0,-1>,<-1,150,-1>, 1}

  cylinder{<1,0,1>, <1,150,1>, 1}
  cylinder{<1,0,-1>, <1,150,-1>, 1}

  cylinder{<0,0,-1.5>,<0,150,-1.5>, 1}
  cylinder{<0,0,1.5>,<0,150,1.5>, 1}

  box{<-2,0,2>,<0,150,-2>}
  box{<2,0,2>,<0,150,-2>}
  texture{T_Grnt11 scale .1 finish { crand 0.2 }}
}



#declare cly_1=
difference{
  cylinder{<0,00,4>,<0,00,-4>,20}
  cylinder{<0,00,-10>,<0,00,10>,19.0}
  texture{T_Grnt11 scale .1 finish { crand 0.2 }}
}
#declare cly_2=
difference{
  cylinder{<0,00,3.75>,<0,00,-3.75>,19}
  cylinder{<0,00,-10>,<0,00,10>,18.0}
   texture{T_Grnt11 scale .1 finish { crand 0.2 }}
}
#declare cly_3=
difference{
  cylinder{<0,00,3.5>,<0,00,-3.5>,18}
  cylinder{<0,00,-10>,<0,00,10>,17.0}
   texture{T_Grnt11 scale .1 finish { crand 0.2 }}
}


#declare bigArchDoor=
union{
  object{
    cly_1  translate<6.462,36,0>
    clipped_by{plane{y,36 inverse }}
    clipped_by{plane{x,0 } }
  }
  object{
    cly_1  translate<-6.462,36,0>
    clipped_by{plane{y,36 inverse }}
    clipped_by{plane{x,0 inverse} }
  }
  object{
    cly_2  translate<6.462,36,0>
    clipped_by{plane{y,36 inverse }}
    clipped_by{plane{x,0 } }
  }
  object{
    cly_2  translate<-6.462,36,0>
    clipped_by{plane{y,36 inverse }}
    clipped_by{plane{x,0 inverse} }
  }
  object{
    cly_3  translate<6.462,36,0>
    clipped_by{plane{y,36 inverse }}
    clipped_by{plane{x,0 } }
  }
  object{
    cly_3 translate<-6.462,36,0>
    clipped_by{plane{y,36 inverse }}
    clipped_by{plane{x,0 inverse} }
  }

  box{<-13.538,0,-4.00>, <-12.538,36,4.00> texture{T_Grnt11 scale .1 finish { crand 0.2 }}}
  box{<-12.538,0,-3.75>, <-11.538,36,3.75> texture{T_Grnt11 scale .1 finish { crand 0.2 }}}
  box{<-11.538,0,-3.50>, <-10.538,36,3.50> texture{T_Grnt11 scale .1 finish { crand 0.2 }}}
  box{< 13.538,0,-4.00>, <12.538,36,4.00> texture{T_Grnt11 scale .1 finish { crand 0.2 }}}
  box{< 12.538,0,-3.75>, <11.538,36,3.75> texture{T_Grnt11 scale .1 finish { crand 0.2 }}}
  box{< 11.538,0,-3.50>, <10.538,36,3.50> texture{T_Grnt11 scale .1 finish { crand 0.2 }}}
}


#declare triAngle_1=
object{
  box{<-13.538,-3.7,-3.7>,<13.538,3.7,3.7> rotate<45,0,0>}
  clipped_by{plane{y,0 inverse }}
  translate<0,65.5,0>
  texture{T_Grnt11 scale .1 finish { crand 0.2 }}
}

#declare wall_1 =
merge{
  difference{
    box{<-13.538,36,3>,<0,63,-3>}
    cylinder{<6.836,36,4>,<6.836,36,-4>,20}
  }
  difference{
    box{<0,36,3>,<13.538,63,-3> }
    cylinder{<-6.836,36,4>,<-6.836,36,-4>,20}
  }
  texture{T_Grnt11 scale .1 finish { crand 0.2 }}
}


#declare halfCurl=
union{
  object{
    difference{
      cylinder{<0,00,0.125>,<0,00,-0.33>,2}
      cylinder{<0,00,-1>,<0,00,1>,1.25}
    }
    clipped_by{plane{x,0}}
  }

  object{
    difference{
      cylinder{<0,-.5,0.125>,<0,-.5,-0.33>,1.5}
      cylinder{<0,-.5,-1>,<0,-.5,1>,0.75}
    }
    clipped_by{plane{x,0 inverse}}
  }
  box{<0,1.25,-0.33>,<2,2,0.125>}
  texture{
    T_Gold_5A
    finish { crand 0.2 }
  }
}

#declare oneCurl=
union{
  object{halfCurl translate<-2,0,0>}
  object{halfCurl rotate<180,180,0> translate<2,0,0>}
  scale<.5,.5,1>
}


#declare cap_1 =
merge{
  box{<-13.538,63,-5>,<21.538,65.5,5> texture{T_Grnt11 scale .1 finish { crand 0.2 }}}
  #declare xx= -11.25
  #while (xx < 21)
    object{oneCurl translate<xx,64.15,-5.125>}
    #declare xx=xx+4.37
  #end
}

#declare thinWall_1=
box{<-13.538,65.5,-2>,<13.538,92.5,2>texture{T_Grnt11 scale .1 finish { crand 0.2 }} }

#declare topWall =
merge{
  difference{
    box{<-13.538,36+83,3>,<0,63+83,-3>}
    cylinder{<11.836,36+80,4>,<11.836,36+80,-4>,25}
  }

  difference{
    box{<0,36+83,3>,<13.538,63+83,-3> }
    cylinder{<-11.836,36+80,4>,<-11.836,36+80,-4>,25}
  }
  texture{T_Grnt11 scale .1 finish { crand 0.2 }}
}

//============================================


#declare topWall =
union{
  merge{
    difference{
      box{<-13.538,36+83,3>,<0,142,-3>}
      cylinder{<11.836,36+80,4>,<11.836,36+80,-4>,25}
    }

    difference{
      box{<0,36+83,3>,<13.538,142,-3> }
      cylinder{<-11.836,36+80,4>,<-11.836,36+80,-4>,25}
    }

    texture{T_Grnt11 scale .1 finish { crand 0.2 }}
  }
 //==============
  object{
    difference{
      cylinder{<11.836,36+80,4>,<11.836,36+80,-4>,26.5}
      cylinder{<11.836,36+80,10>,<11.836,36+80,-10>,25}
    }
    clipped_by{plane{y,36+80 inverse }}
    clipped_by{plane{x,0 }}
    clipped_by{plane{x,-13.538 inverse }}
    texture{T_Grnt11 scale .1 finish { crand 0.2 }}
  }

  object{
    difference{
      cylinder{<-11.836,36+80,4>,<-11.836,36+80,-4>,26.5}
      cylinder{<-11.836,36+80,10>,<-11.836,36+80,-10>,25}
    }
    clipped_by{plane{y,36+80 inverse }}
    clipped_by{plane{x,0 inverse }}
    clipped_by{plane{x,13.538 }}
    texture{T_Grnt11 scale .1 finish { crand 0.2 }}
  }
//=====================

  object{
    difference{
      cylinder{<11.836,36+80,3>,<11.836,36+80,-3>,25}
      cylinder{<11.836,36+80,10>,<11.836,36+80,-10>,24}
    }
    clipped_by{plane{y,36+80 inverse }}
    clipped_by{plane{x,0 }}
//    clipped_by{plane{x,-13.538 inverse }}
    texture{T_Grnt11 scale .1 finish { crand 0.2 }}
  }

  object{
    difference{
      cylinder{<-11.836,36+80,3>,<-11.836,36+80,-3>,25}
      cylinder{<-11.836,36+80,10>,<-11.836,36+80,-10>,24}
    }
    clipped_by{plane{y,36+80 inverse }}
    clipped_by{plane{x,0 inverse }}
    texture{T_Grnt11 scale .1 finish { crand 0.2 }}
  }
//=====================
  object{
    difference{
      cylinder{<11.836,36+80,2>,<11.836,36+80,-2>,24}
      cylinder{<11.836,36+80,10>,<11.836,36+80,-10>,23}
    }
    clipped_by{plane{y,36+80 inverse }}
    clipped_by{plane{x,0 }}
    texture{T_Grnt11 scale .1 finish { crand 0.2 }}
  }

  object{
    difference{
      cylinder{<-11.836,36+80,2>,<-11.836,36+80,-2>,24}
      cylinder{<-11.836,36+80,10>,<-11.836,36+80,-10>,23}
    }
    clipped_by{plane{y,36+80 inverse }}
    clipped_by{plane{x,0 inverse }}
    texture{T_Grnt11 scale .1 finish { crand 0.2 }}
  }
//=====================




box{<-13.538,117,-2>,<-12.538,112,0> texture{T_Grnt11 scale .1 finish { crand 0.2 }}}
box{<13.538,117,-2>,<12.538,112,0> texture{T_Grnt11 scale .1 finish { crand 0.2 }}}
box{<-12.538,117,-2>,<-11.538,115,0> texture{T_Grnt11 scale .1 finish { crand 0.2 }}}
box{<12.538,117,-2>,<11.538,115,0> texture{T_Grnt11 scale .1 finish { crand 0.2 }}}


object{ smallTracery translate<0,34.5,1>}
object{ smallTracery translate<13.538,34.5,1>}

  box{<-10.5,65.5-7+34,-1.9>,<-10.6,77+34,-1.8>  pigment{Black}}
  box{<-8.5,65.5-7+34,-1.9>,<-8.4,77+34,-1.8>  pigment{Black}}

  box{<-10.5,65.5-7+34,-1.9>,<-10.6,77+34,-1.8>  translate<6,0,0> pigment{Black}}
  box{<-8.5,65.5-7+34,-1.9>,<-8.4,77+34,-1.8> translate<6,0,0> pigment{Black}}

  box{<-10.5,65.5-7+34,-1.9>,<-10.6,77+34,-1.8> translate<13,0,0> pigment{Black}}
  box{<-8.5,65.5-7+34,-1.9>,<-8.4,77+34,-1.65>  translate<13,0,0> pigment{Black}}

  box{<-10.5,65.5-7+34,-1.9>,<-10.6,77+34,-1.8>  translate<19,0,0> pigment{Black}}
  box{<-8.5,65.5-7+34,-1.9>,<-8.4,77+34,-1.8> translate<19,0,0> pigment{Black}}

  box{<-13,110.9,-1.9>,<13,111,-1.8>  pigment{Black}}
  box{<-13,107,-1.9>,<13,106.9,-1.8>  pigment{Black}}
  box{<-13,103,-1.9>,<13,102.9,-1.8>  pigment{Black}}
  box{<-13,99,-1.9>,<13,98.9,-1.8>  pigment{Black}}

#declare cly_10=
difference{
  cylinder{<0,00,0>,<0,00,2>,8.2}
  cylinder{<0,00,-10>,<0,00,10>,7.7}
  texture{T_Grnt11 scale .1 finish { crand 0.2 }}
}
#declare cly_11=
difference{
  cylinder{<0,00,0>,<0,00,2>,8.0}
  cylinder{<0,00,-10>,<0,00,10>,7.5}
  texture{T_Grnt11 scale .1 finish { crand 0.2 }}
}

#declare smallRose=
object{
  difference{
    object{
      union{
        object{cly_10}
        #declare zz=0
        #while (zz < 360)
          object{ cly_11 translate<-7.8,0,0> rotate<0,0,zz>}
          #declare zz=zz+30
        #end
       cylinder{<0,0,0>,<0,00,2>,3 texture{T_Grnt11 scale .1 finish { crand 0.2 }}}

      }
      clipped_by{cylinder{<0,0,-10>,<0,00,10>,8.2 }}
    }
    cylinder{<0,0,-10>,<0,00,10>,2.25}
  }
}
object{smallRose translate<0,124.9,0>}

}

//===========================================

#declare insideWallSection=
union{
  object{ mainColumn scale<2,1,2> translate <17.538,0,0>}
  object{wall_1}
  bigArchDoor
  cap_1
  object{cap_1 translate<0,29.5,0>}
  thinWall_1
  object{smallTracery translate<0,5,0>}
  object{ smallTracery translate<13.538,5,0>}
  topWall
}

//insideWallSection
