
// Persistence of Vision Ray Tracer Scene Description File
// File: mainflor.inc
// Vers: 3
// Desc: Basic Scene Example
// Date: 02-28-98
// Auth: Bob Franke
//

#version 3

#include "colors.inc"
#include "textures.inc"
#include "finish.inc"
#include "golds.inc"
#include "in_sect.inc"

/*
global_settings
{
  assumed_gamma 2.2
}

// ----------------------------------------


camera //current
{
  location  <-27,10,0>
  direction 2*z
  right     4/3*x
  look_at   <6,0,70>
}

camera //current
{
  location  <-27,10,0>
  direction 1.0*z
  right     3/4*x
  look_at   <-1-3,26,70>
}



sky_sphere
{
  pigment
  {
    gradient y
    color_map { [0.0 color blue 0.6] [1.0 color rgb .75] }
  }
}

light_source
{
  0*x // light's position (translated below)
  color red 1  green 1  blue 1  // light's color
  translate <-30, 100, -50>
}

*/

#declare pewTexture=
  texture{
    pigment{Brown*1.5}
    finish{Shiny}
  }

#declare railTexture=
  texture{
    pigment{color rgb <0.667, 0.502, 0.396>*1.5}
    finish{Shiny}
  }

#declare halfPost=
merge{
  cylinder{<0,0,0>,<0,.5,0>,1.5}
  cone{<0,0.5,0>, 1.0, <0,11.0,0>, 1.5}
  box{<-2,11,-2>,<2,14,2>}
  texture{railTexture}
}


#declare post=
merge{
  object{halfPost}
  object{halfPost rotate<180,0,0>}
  scale 1/12
}


#declare frontRailing=
union{
  box{<0,0,0>,<4/12,3,.5,> texture{railTexture}}
  box{<0,0,0>,<25-4,4/12,.5> texture{railTexture}}
  box{<0,32/12,0>,<25-4,3,.5> texture{railTexture}}
  box{<24.666-4,0,0>,<25-4,3,0> texture{railTexture}}
  #declare idx=0
  #declare xx=.875
  #while (idx < 26)
    object{post translate<xx,19/12,0>}
    #declare xx=xx+.8
    #declare idx=idx+1
  #end
}


#declare pew=
union{
  box{<0,33/12,0>,<25-4,36/12,-1.5/12>
    texture{
      pigment{Brown*1.15}
      finish{Shiny}
    }
  }

  box{<3/12,17/12,0>,<25-4,18/12,-19/12> texture{pewTexture}}
  //box{<0,5/12,0>,<25-4,36/12,-1/12> texture{pewTexture}}


  box{<0,5/12,0>,<25-4,36/12,-1/12> pigment{DMFLightOak rotate<-89,0,0>}}


  box{<0,0,1.5/12>,<3/12,36/12,-1.5/12> texture{pewTexture}}
  box{<0,19/12,0>,<3/12,22/12,-16/12> texture{pewTexture}}
  box{<0,0,-14/12>,<3/12,22/12,-16/12> texture{pewTexture}}

  box{<25-4,0,1.5/12>,<249/12,36/12,-1.5/12> texture{pewTexture}}

  box{<25-4,19/12,0>,<249/12,22/12,-16/12> texture{pewTexture}}
  box{<25-4,0,-14/12>,<249/12,22/12,-16/12> texture{pewTexture}}
}


#declare brownTile=
union{
  box{<-1,-.005/12,-1>,<1,-1/12,1> texture { pigment{ color BrightGold*2} finish{ Metal }}}
  box{<-1,0,-1>,<1,-1/12,1> scale<.96,1,.96>
    texture{
      pigment{color rgb <0.580, 0.294, 0.141>*.5}
      finish {reflection 0.2}
    }
  }
}
#declare whiteTile=
union{
  box{<-1,-.005/12,-1>,<1,-1/12,1> texture { pigment{ color BrightGold*.5 } finish{ Metal }}}
  box{<-1,0,-1>,<1,-1/12,1> scale<.96,1,.96>
    texture{
      pigment{color rgb <1, 1, 1>*3}
      finish {reflection 0.2}
    }
  }
}




#declare oneTriSide=
  triangle { <-1/12,0,-1/12>, <-1/12,0,1/12>, <0,4/12,0> texture{T_Gold_5C } }

#declare cap=
union{
  object{oneTriSide}
  object{oneTriSide rotate<0,90,0>}
  object{oneTriSide rotate<0,180,0>}
  object{oneTriSide rotate<0,270,0>}
}

#declare oneBar=
  box{<-.5/12,.5/12,-.5/12>,<.5/12,3,.5/12> texture{T_Gold_5C }}


#declare frontGate=
union{
  box{<-60/12,0,-1/12>,<-58/12,3,1/12>  texture{T_Gold_5C }}
  box{<58/12,0,-1/12>,<60/12,3,1/12>  texture{T_Gold_5C }}


  box{<-58/12,0,-1/12>,<-60/12,3,1/12>  texture{T_Gold_5C }}

  box{<-2.5/12,1/12,-1/12>,<-.5/12,3,1/12>  texture{T_Gold_5C }}
  box{<.5/12,1/12,-1/12>,<2.5/12,3,1/12>   texture{T_Gold_5C }}



  box{<60/12,35/12,-1.5/12>,<.5/12,3,1.5/12>  texture{T_Gold_5C }}
  box{<-60/12,35/12,-1.5/12>,<-.5/12,3,1.5/12>  texture{T_Gold_5C }}

  box{<60/12,.5/12,-1.5/12>,<.5/12,1.5/12,1.5/12>  texture{T_Gold_5C }}
  box{<-60/12,.5/12,-1.5/12>,<-.5/12,1.5/12,1.5/12>  texture{T_Gold_5C }}

  object{cap translate<-59/12,3,0>}
  object{cap translate<59/12,3,0>}
  object{cap translate<-1.5/12,3,0>}
  object{cap translate<1.5/12,3,0>}

  #declare xx=-50.5/12
  #while (xx < -8/12)
    object{oneBar translate<xx,0,0>}
    #declare xx=xx+8/12
  #end

  #declare xx=50.5/12
  #while (xx > 8/12)
    object{oneBar translate<xx,0,0>}
    #declare xx=xx-8/12
  #end
}


#declare mainFloor=
union{
  object{frontRailing translate<5,0,56>}
  object{frontRailing translate<-26,0,56>}


#declare zz=60
#while (zz < 150)
  object{pew translate<5,0,zz>}
  object{pew translate<-30+4,0,zz>}
  #declare zz=zz+4
#end


// lay down center aisle
#declare xx=-3
#declare zz= 52
#while (zz < 160)
  #while (xx < 4)
    object{brownTile translate<xx,0,zz>}
    #declare xx=xx+2
  #end
  #declare xx=-3
  #declare zz=zz+2
#end

// lay down front aisle
#declare xx=-30
#declare zz= 52
#while (zz > 44)
  #while (xx < 39)
    object{brownTile translate<xx+1,0,zz>}
    #declare xx=xx+2
  #end
  #declare xx=-30
  #declare zz=zz-2
#end


 // lay down front white aisle
#declare xx=-30
#declare zz= 44
#while (zz > 32)
  #while (xx < 39)
    object{whiteTile translate<xx+1,0,zz>}
    #declare xx=xx+2
  #end
  #declare xx=-30
  #declare zz=zz-2
#end



// lay down back aisle
#declare xx=-30
#declare zz= 48+112
#while (zz > 40+112)
  #while (xx < 39)
    object{brownTile translate<xx+1,0,zz>}
    #declare xx=xx+2
  #end
  #declare xx=-30
  #declare zz=zz-2
#end


// lay down right aisle
#declare xx= 30
#declare zz= 42
#while (zz < 228)
  #while (xx < 39)
    object{brownTile translate<xx,0,zz>}
    #declare xx=xx+2
  #end
  #declare xx=30
  #declare zz=zz+2
#end



// lay down left white aisle
#declare xx= -29
#declare zz= 54
#while (zz < 154)
  #while (xx < -4)
    object{whiteTile translate<xx,0,zz>}
    #declare xx=xx+2
  #end
  #declare xx=-29
  #declare zz=zz+2
#end


// lay down right white aisle
#declare xx= 29
#declare zz= 54
#while (zz < 154)
  #while (xx > 4)
    object{whiteTile translate<xx,0,zz>}
    #declare xx=xx-2
  #end
  #declare xx=29
  #declare zz=zz+2
#end

// lay down left white aisle
#declare xx= -29
#declare zz= 162
#while (zz < 302)
  #while (xx < 31)
    object{whiteTile translate<xx,0,zz>}
    #declare xx=xx+2
  #end
  #declare xx=-29
  #declare zz=zz+2
#end

object{frontGate translate<0,0,56+1/12>}

} //end mainfloor

/*

//#include "in_sect.inc"
//#include "backwall.inc"
//object{TheBackWall translate<0,0,0>}


#declare xx=1
#while (xx < 9)
  object{insideWallSection rotate<0,90,0> translate<34,0,35.076*xx>}
  object{insideWallSection rotate<0,-90,0> translate<-34,0,35.076*xx>}
  #declare xx=xx+1
#end

mainFloor

*/
