// ----------------------------------------
// This is the JF motion control camera
// ----------------------------------------

//  External Variable definitions
//
//  CameraMode      - Mode the camera is in
//                    0 = Standard
//                    1 = Panning - stationary location, fixed distance
//                    2 = Traking - moving location, fixed distance, fixed direction
//                        from CameraViewPoint
//  CameraDistance  - Distance for camera to be from the At point when camera is in
//                    tracking mode
//  CameraRotate    - Direction around the Y axis for directional tracking
//  CameraAngle     - Horizon angle for directional tracking
//  CameraLocation  - Vector of the camera location for Standard and panning mode,  this
//                    is calculated for tracking mode
//  CameraViewPoint - Vector of the point the camera is aimed at

//------------------------------------------------------------
// Camera Default Values
//------------------------------------------------------------

#ifndef (CameraMode)
  #declare CameraMode = Tracking
#end
#ifndef (CameraDistance)
  #declare CameraDistance = 5
#end
#ifndef (CameraRotate)
  #declare CameraRotate = 0
#end
#ifndef (CameraAngle)
  #declare CameraAngle = 0
#end
#ifndef (CameraLocation)
  #declare CameraLocation = <0,1,-5>
#end
#ifndef (CameraViewPoint)
  #declare CameraViewPoint = <0,1,0>
#end

global_settings
{
  assumed_gamma 1.0
}

#if (CameraMode=Panning)

  #declare LocAtDistance = vlength(<CameraLocation.x,CameraLocation.y,CameraLocation.z>-<CameraViewPoint.x,CameraViewPoint.y,CameraViewPoint.z>)
  #declare CameraXCalc = CameraViewPoint.x+(((CameraLocation.x-CameraViewPoint.x)*CameraDistance)/LocAtDistance)
  #declare CameraYCalc = CameraViewPoint.y+(((CameraLocation.y-CameraViewPoint.y)*CameraDistance)/LocAtDistance)
  #declare CameraZCalc = CameraViewPoint.z+(((CameraLocation.z-CameraViewPoint.z)*CameraDistance)/LocAtDistance)

#else

  #if (CameraMode=Tracking)

    #declare CameraTempVector = vrotate(<0,0,-10>,<CameraAngle,CameraRotate,0>)
    #declare CameraTempVector = CameraTempVector + <CameraViewPoint.x,CameraViewPoint.y,CameraViewPoint.z>
    #declare CameraLocation = CameraTempVector
    #declare LocAtDistance = vlength(<CameraLocation.x,CameraLocation.y,CameraLocation.z>-<CameraViewPoint.x,CameraViewPoint.y,CameraViewPoint.z>)
    #declare CameraXCalc = CameraViewPoint.x+(((CameraLocation.x-CameraViewPoint.x)*CameraDistance)/LocAtDistance)
    #declare CameraYCalc = CameraViewPoint.y+(((CameraLocation.y-CameraViewPoint.y)*CameraDistance)/LocAtDistance)
    #declare CameraZCalc = CameraViewPoint.z+(((CameraLocation.z-CameraViewPoint.z)*CameraDistance)/LocAtDistance)

  #else  // CameraMode=Standard

    #declare CameraXCalc = CameraLocation.x
    #declare CameraYCalc = CameraLocation.y
    #declare CameraZCalc = CameraLocation.z

  #end

#end

#declare CameraLocation = <CameraXCalc,CameraYCalc,CameraZCalc>

camera
{
  location  CameraLocation
  direction 1.5*z
  right     4/3*x
  look_at   CameraViewPoint
}
