
// ******************************************************************
// *
// *       Genetic Engineering: Here a Dolly, There a Dolly ...
// *
// ******************************************************************

#include "colors.inc"

global_settings
{
  assumed_gamma 1.0
}

// ----------------------------------------

sky_sphere
{
  pigment
  {
    gradient y
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <-300, 300, -300>
}

// ----------------------------------------

plane { y, 0 pigment {color Green }}

// ----------------------------------------

#declare R1 = seed(1965)

#declare SheepBody = object
{
  union
  {
    #declare NumberOfRings = 0
    #while (NumberOfRings < 21)

      union
      {
        #declare BallRadius = 0.18

        #declare RingAngle = radians(NumberOfRings*18)
        #declare BallRingRadius = cos(asin(1.97*(-0.5+(NumberOfRings*0.125)/2.5)))*0.75

        #declare BallAngle = 0
        #while (BallAngle < 360)
          #declare NumberOfBalls = int(16+rand(R1)*4)
          #declare BallLocation = <0,BallRingRadius,0>
          #declare BallLocation = vrotate(BallLocation,<BallAngle,0,0>)

          sphere
          {
            BallLocation,BallRadius
          }

          #declare BallAngle = BallAngle+360/NumberOfBalls
        #end
        rotate < 360*rand(R1),0,0> translate <-1+NumberOfRings*0.1,0,0>
      }

      #declare NumberOfRings = NumberOfRings+1
    #end
  }
}

#declare dolly = object
{
  union
  {
    // --- Hair ---
    object
    {
      SheepBody
      texture
      {
        pigment { color White }
      }
      scale 0.4
      rotate <0,90,0>
      translate <-0.9,2,0>
    }
    // --- Nose ---
    sphere
    {
      <0,0,0>,0.1
      texture
      {
        pigment { color Black }
      }
      translate <-1.55,1.7,0>
    }
    // --- Left Eye ---
    sphere
    {
      <0,0,0>,0.06
      texture
      {
        pigment { color Black }
      }
      translate <-1.35,2,0.1>
    }
    // --- Right Eye ---
    sphere
    {
      <0,0,0>,0.06
      texture
      {
        pigment { color Black }
      }
      translate <-1.35,2,-0.1>
    }
    // --- Head ---
    sphere
    {
      <0,0,0>,0.3
      texture
      {
        pigment { color White }
      }
      scale <2,1.5,1.5>
      rotate <0,0,30>
      translate <-1,1.7,0>
    }
    // --- Body ---
    object
    {
      SheepBody
      texture
      {
        pigment { color White }
      }
      scale <0.75,1,1>
      rotate <0,90,0>
      scale <1.33333,0.8,0.8>
      translate <0,1,0>
    }
    // --- Leg ---
    cylinder
    {
      <0,0,0>,<0,1,0>,0.1
      pigment { color Black }
      translate <-0.5,0,-0.25>
    }
    // --- Leg ---
    cylinder
    {
      <0,0,0>,<0,1,0>,0.1
      pigment { color Black }
      translate <-0.5,0,0.25>
    }
    // --- Leg ---
    cylinder
    {
      <0,0,0>,<0,1,0>,0.1
      pigment { color Black }
      translate <0.5,0,-0.25>
    }
    // --- Leg ---
    cylinder
    {
      <0,0,0>,<0,1,0>,0.1
      pigment { color Black }
      translate <0.5,0,0.25>
    }
  }
}

// --- Camera placement ---

#include "constant.inc"

#declare CameraLocation = <0,1,0>
#declare CameraRotate = 90
#declare CameraAngle = 20
#declare CameraDistance = 10

#include "camera.inc"

// --- All of the Dolly Sheep ---

#declare SheepRows = 25
#declare SheepRowSpacing = 3
#declare SheepColSpacing = 3
#declare SheepRow = 1

#while (SheepRow<=SheepRows)
  #declare SheepCounter=0
  #while (SheepCounter < SheepRow)
    object { dolly translate <-3+(SheepRow-1)*SheepRowSpacing , 0 , ((SheepRow-1)*SheepColSpacing)/2 - SheepCounter*SheepColSpacing>}
    #declare SheepCounter = SheepCounter+1
  #end
  #declare SheepRow=SheepRow+1
#end
