#include "colors.inc"
#include "woods.inc"

#declare Ground_Texture = texture {
         pigment {color <1, 0.9, 0.5>}
         normal {ripples 0.1 turbulence 0.5 scale <6, 3, 3>}
         finish {roughness 10}
}

#declare Pyrtext = texture {
            pigment {color <1, 0.9, 0.5>}
            finish {roughness 10}
}

background {color White }



sky_sphere {
           pigment {
                   bozo
                   color_map {
                             [0 color White * 50]
                             [1 color White transmit 1]
                             }
                   turbulence 1
                   scale 0.1
           }
}

/*camera {
        location <-300, 40, 0>
        look_at <0, 40, 0>
      rotate -10 * y
      translate <200, 0, 300>
}*/


camera {
       location <0, 10, -10>
       look_at <0, 10, 0>
//       orthographic
}

light_source {
             <-10000, 10000, -7000>
             White * 2
             atmosphere off
}

plane {y, 0
      texture {Ground_Texture}
}

fog {
    color <1, 0.9, 0.5>
    filter 1
    transmit 0.01
    distance 600
    turbulence 0.5
}

#declare Count = 0
#declare Height = 40
#declare Block_Height = 5

#declare Pyramid = union {
#while (Count < Height)
       box {<-(Height - Count) * 4, Count * Block_Height, -(Height - Count) * 4>
            <4 * (Height - Count), Block_Height + Count * Block_Height, 4 * (Height - Count)>
            texture {Pyrtext}
       }
       #declare Count = Count + 1
#end
}


#declare ABrown = pigment {color rgb <0.6, 0.25, 0.15>}

#declare Hoop = texture {
         pigment {color rgb <0.2, 0.1, 0.1>}
         finish {
                ambient 0.3
                brilliance 4
                diffuse 0.5
                specular 0.8
                roughness 1/80
                reflection 0.2
                metallic
         }
}

#declare Hook = difference {
         torus {
               0.6
               0.2
               texture {Hoop}
         }
         box {
               <0, -0.21, -0.61>
               <-1.61, 0.21, 0.61>
               texture {Hoop}
         }
}


#declare Wood_Text = texture {T_Wood12}


#declare Wheel = union {
         cylinder { <0, 0, 0>
                  <0, 0, -0.5>
                  1.5
                  texture {Wood_Text}
         }
         cylinder {
                  <0, 1, -0.6>
                  <0, -1, -0.6>
                  0.2
                  texture {Wood_Text}
         }
}

#declare Axle = cylinder {
         <0, 0, -1.2>
         <0, 0, 7.2>
         0.5
         texture {Wood_Text}
}



#declare Cart = union {
         difference {
                    box {
                        <0, 0, 0>
                        <9, 0.8, 6>
                        texture {Wood_Text}
                    }
                    box {
                        <0.5, 0.4, 0.5>
                        <8.5, 1, 5.5>
                        texture {Wood_Text}
                    }
                    translate 2 * y
         }



       object {Wheel rotate z * 24 translate <2.5, 1.5, 0>}
       object {Wheel rotate z * 94 translate <6.5, 1.5, 0>}
       object {Wheel rotate z * 43 rotate y * 180 translate <2.5, 1.5, 6>}
       object {Wheel rotate z * 140 rotate y * 180 translate <6.5, 1.5, 6>}


       object {Axle translate <2.5, 1.5, 0>}
       object {Axle translate <6.5, 1.5, 0>}

       object {Hook translate <9, 2.4, 4.5>}
       object {Hook translate <9, 2.5, 1.5>}

}


#declare Cart_Block = union {
         object {Cart}
         box {
             <0, 0, 0>
             <8, 4, 5>
             texture {Pyrtext}
             translate <0.5, 2, 0.5>
         }
}

#declare Skin = pigment {color rgb <0.3, 0.1, 0>}



#declare Slave = blob {
         threshold 0.5


// Left Foot

         cylinder {
                  <0, 0, 0>
                  <2/3, 0, 0>
                  0.4
                  1
                  pigment {Skin}
         }



// Right Foot


         cylinder {
                  <1, 0, 0.5>
                  <5/3, 0, 0.5>
                  0.4
                  1
                  pigment {Skin}
         }

// Left Shin

         cylinder {
                  <0, 0, 0>
                  <0, 1.1, 0>
                  0.3
                  1
                  pigment {Skin}
                  rotate z * 30
                  translate <0.55, 0.05, 0>
          }

// Left Thigh

          cylinder {
                  <0, 0, 0>
                  <0, 1.1, 0>
                  0.4
                  1
                  pigment {Skin}
                  rotate z * -60
                  translate <0, 1, 0>
                  rotate z * 30
                  translate <0.55, 0.05, 0>
          }

// Arse

          sphere {
                 <0, 0, 0>
                 1
                 1
                 pigment {Skin}
                 scale x * 0.75
                 rotate z * 15
                 translate <2/3, 2.1, 0.25>

          }

// Right Shin

         cylinder {
                  <0, 0, 0>
                  <0, 1.1, 0>
                  0.3
                  1
                  pigment {Skin}
                  rotate z * 30
                  translate <5/3, 0.05, 0.5>
         }

// Right Thigh

          cylinder {
                  <0, 0, 0>
                  <0, 1.1, 0>
                  0.4
                  1
                  pigment {Skin}
                  rotate z * -15
                  translate <0, 1, 0>
                  rotate z * 30
                  translate <5/3, 0.05, 0.5>
          }

// Torso

          cylinder {
                    <0, 0, 0>
                    <0, 1.5, 0>
                    1
                    1
                    pigment {Skin}
                    scale x * 0.75
                    rotate z * 35
                    translate <2/3, 2.1, 0.25>

          }


// Head

        sphere {
               <0, 0.8, 0>
               0.55
               2
               pigment {Skin}
               rotate z * 10
               translate <0, 0.2, 0>
               rotate z * 5
               translate <0, 1.5, 0>
               rotate z * 35
               translate <2/3, 2.1, 0.25>
         }

// Left Shoulder

         cylinder {
                  <0, 0, 0>
                  <0, -0.8, 0>
                  0.25
                  3
                  pigment {Skin}
                  rotate x * 30
                  translate <0, 1.5, 0>
                  rotate z * 35
                  translate <2/3, 2.1, -0.15>

        }

// Left Forearm

        cylinder {
                  <0, 0, 0>
                  <0, 0.8, 0>
                  0.2
                  3
                  pigment {Skin}

                  rotate z * 40
                  rotate y * 5
                  translate <0, -0.8, 0>
                  rotate x * 30
                  translate <0, 1.5, 0>
                  rotate z * 35
                  translate <2/3, 2.1, -0.15>
        }

//Right Shoulder

         cylinder {
                  <0, 0, 0>
                  <0, -0.8, 0>
                  0.25
                  3
                  pigment {Skin}
                  rotate z * -40
                  translate <0, 1.5, 0>
                  rotate z * 35
                  translate <2/3, 2.1, 0.62>
        }

//Right Forearm

         cylinder {
                  <0, 0, 0>
                  <0, 0.8, 0>
                  0.2
                  3
                  pigment {Skin}
                  rotate z * 90
                  rotate y * -80
                  translate <0, -0.8, 0>

                  rotate z * -40
                  translate <0, 1.5, 0>
                  rotate z * 35
                  translate <2/3, 2.1, 0.62>
        }


}


#declare Builder = blob {
         threshold 0.5


// Left Foot

         cylinder {
                  <0, 0, -0.0>
                  <2/3, 0, -0.0>
                  0.4
                  1
                  pigment {Skin}
         }



// Right Foot


         cylinder {
                  <1, 0, 0.5>
                  <5/3, 0, 0.5>
                  0.4
                  1
                  pigment {Skin}
         }

// Left Shin

         cylinder {
                  <0, 0, 0>
                  <0, 1.1, 0>
                  0.3
                  1
                  pigment {Skin}
//                  rotate x * -15
                  translate <0.55, 0.05, 0>
          }

// Left Thigh

          cylinder {
                  <0, 0, 0>
                  <0, 1.1, 0>
                  0.4
                  1
                  pigment {Skin}
///                  rotate z * -60
                  translate <0, 1, 0>
//                  rotate x * -15
                  translate <0.55, 0.05, 0>
          }

// Arse

          sphere {
                 <0, 0, 0>
                 1
                 1
                 pigment {Skin}
                 scale x * 0.75
                 rotate z * 15
                 translate <2/3, 2.3, 0.25>

          }

// Right Shin

         cylinder {
                  <0, 0, 0>
                  <0, 1.1, 0>
                  0.3
                  1
                  pigment {Skin}
                  rotate z * 30
                  translate <5/3, 0.05, 0.5>
         }

// Right Thigh

          cylinder {
                  <0, 0, 0>
                  <0, 1.1, 0>
                  0.4
                  1
                  pigment {Skin}
                  rotate z * -15
                  translate <0, 1, 0>
                  rotate z * 30
                  translate <5/3, 0.05, 0.5>
          }

// Torso

          cylinder {
                    <0, 0, 0>
                    <0, 1, 0>
                    1
                    1
                    pigment {Skin}
                    scale x * 0.75
//                    rotate z * 35
                    translate <2/3, 2, 0.25>

          }

// Head

        sphere {
               <0, 0.8, 0>
               0.55
               2
               pigment {Skin}
//               rotate z * 10
//               translate <0, 0.2, 0>
//               rotate z * 5
               translate <0, 1, 0>
//               rotate z * 35
               translate <2/3, 2.1, 0.25>
         }

// Left Shoulder

         cylinder {
                  <0, 0, 0>
                  <0, -0.8, 0>
                  0.25
                  3
                  pigment {Skin}
                  rotate x * 45
                  translate <0, 1, 0>
//                  rotate z * 35
                  translate <2/3, 2.1, -0.15>

        }

// Left Forearm

        cylinder {
                  <0, 0, 0>
                  <0, 0.8, 0>
                  0.2
                  3
                  pigment {Skin}


                  rotate x * -45
                  translate <0, -1.2, 0>
                  translate <0, 1, 0>
//                  rotate z * 35
                  translate <2/3, 2.1, -0.15>
        }
//Right Shoulder

         cylinder {
                  <0, 0, 0>
                  <0, .8, 0>
                  0.25
                  3
                  pigment {Skin}
                  rotate x * -45
                  translate <0, 0.5, 1>
//                  rotate z * 35
                  translate <2/3, 2.1, 0.15>

        }

//Right Forearm

         cylinder {
                  <0, 0, 0>
                  <0, .8, 0>
                  0.2
                  3
                  pigment {Skin}
                  translate <2/3, 1.7, 1.15>
        }


}




#declare Ropetext = texture {
         pigment {Yellow * 0.6}
         normal {bumps 1 scale 0.01}
}



#declare Cart_Block_Slaves = union {
         object {Cart_Block}
         object {Slave rotate y * 180 translate <20, 0, 1.3> }
         object {Slave rotate y * 180 translate <20, 0, 4.3> }
         object {Slave rotate y * 180 translate <25, 0, 2> }
         object {Slave rotate y * 180 translate <25, 0, 5> }

         torus {
               0.3
               0.1
               texture {Ropetext}
               rotate x * 90
               translate <9.6, 2.4, 1.5>
         }

         cylinder {
                  <9.6, 2.4, 1.5>
                  <21, 3.8, 1.5>
                  0.1
                  texture {Ropetext}
         }

         cylinder {
                  <9.6, 2.4, 1.5>
                  <26, 3.8, 1.9>
                  0.1
                  texture {Ropetext}
         }

          cylinder {
                  <9.6, 2.4, 4.5>
                  <21, 3.8, 4.5>
                  0.1
                  texture {Ropetext}
         }

         cylinder {
                  <9.6, 2.4, 4.5>
                  <26, 3.8, 4.9>
                  0.1
                  texture {Ropetext}
         }



}

#declare Sand_Dune = height_field {
         tga "dunes.tga"
         texture {Ground_Texture}
         smooth
}


//-----------------------------------------------------------------------


object {Sand_Dune scale <3000, 200, 1000> translate <-1500, 0, 2000>}

union {
      difference {
           object {Pyramid}

           union {
                  box {
                      <-1000, 45, 40>
                      <0, 100, -40>
                      texture {Pyrtext}
                  }
                  object {Pyramid scale 0.9}
           }


      }
      box {
          <0, 0, 0>
          <-200, -40, 80>
          texture {Pyrtext}
          rotate z * 20
          translate <-124, 45, -40>

       }
      rotate -10 * y
      translate <200, 0, 300>
}

#declare Builder = object {Builder scale 1.3}


object {Builder rotate z * -20
                translate <-16, 0, -2>
                rotate z * 20
                translate <-124, 45,-15>
                rotate -10 * y
                translate <200, 0, 300>
                }

object {Builder rotate z * -20
                translate <-18, 0, -4>
                rotate z * 20
                translate <-124, 45, -15>
                rotate -10 * y
                translate <200, 0, 300>
                }

object {Builder rotate z * -20
                translate <-20, 0, 3>
                rotate z * 20
                translate <-124, 45, -15>
                rotate -10 * y
                translate <200, 0, 300>
                }

object {Builder rotate z * -20
                translate <-6, 0, 1>
                rotate z * 20
                translate <-124, 45, -15>
                rotate -10 * y
                translate <200, 0, 300>
                }
object {Builder rotate z * -20
                translate <-3, 0, 1>
                rotate z * 20
                translate <-124, 45, -15>
                rotate -10 * y
                translate <200, 0, 300>
                }
object {Builder rotate z * -20
                translate <-4, 0, 0>
                rotate z * 20
                translate <-124, 45, -15>
                rotate -10 * y
                translate <200, 0, 300>
                }
object {Builder rotate z * -20
                translate <-9, 0, 0>
                rotate z * 20
                translate <-124, 45, -15>
                rotate -10 * y
                translate <200, 0, 300>
                }

object {Pyramid translate <-500, 0, 1500>}

object {Pyramid translate <-600, 0, 900>}


object {Cart_Block_Slaves translate x * -50 rotate z * 20 translate <-124, 45, 0> rotate -10 * y translate <200, 0, 300>}
object {Cart_Block_Slaves translate x * -100 rotate z * 20 translate <-124, 45, 0> rotate -10 * y translate <200, 0, 300>}

object {Cart_Block_Slaves translate <-140, 0, 300>}
object {Cart_Block_Slaves translate <-100, 0, 300>}

object {Cart_Block_Slaves rotate -45 * y translate <-60, 0, 100>}
object {Cart_Block_Slaves rotate 180 * y translate <10, 0, 30>}
object {Cart_Block_Slaves rotate 180 * y translate <40, 0, 30>}
object {Cart_Block_Slaves rotate 180 * y translate <-20, 0, 30>}

object {Cart translate <5, 0, 0>}
