// Persistence Of Vision Raytracer version 3.0 file.

#include "colors.inc"
#include "textures.inc"
#include "earth4.inc"
#include "hst2.inc"

camera {
        location <25, 0, 0>
        rotate 45*y // B
        direction <-2, 0,  0>
        look_at <0, 0, 0>
}


//light_source {<1000, 0, 0> color rgb <.7, .75, .9> // A
light_source {<0, 1000, 0> color rgb <.7, .75, .9> rotate <-90, 45, 0> // B
             spotlight
             point_at <0, 0, 0>
             radius 90
             falloff 90
             tightness 10
             //area_light <0, 0, -500>, <0, 500, 0>, 3, 3 // A
             area_light <500, 0, 0>, <0, 0, -500>, 3, 3 // B
             adaptive 1
             jitter
}


//light_source {<-20000000, 20000000, 10000000> color red 2 blue 2 green 2} // A
light_source {<0, -20000000, 0> color red 2 blue 2 green 2  // B
          area_light <500000, 0, 0>, <0, 0, -500000>, 3, 3 // B
          adaptive 1 //B
          jitter //B
          rotate <-90, 45, 0>
}

plane { -z, 0 hollow texture {
        pigment {
                image_map {gif "stars3.gif"
                        map_type 0
                        interpolate 2
                }
        translate <-.5, -.5, 0>
        scale <13500, 10000, 1>
        }
}
no_shadow
rotate <0, -90, 0>
translate <-20000, 0, 0>
rotate 45*y // B
finish {ambient 1 diffuse 0}
}

object {earth
       scale 3
       //translate <14000, 0, 0> // A
       rotate 90*z translate <0, 14000, 0> rotate <-90, 45, 0> // B
}

object {hst
       //scale .8 // A
       scale 1.3 // B
       //rotate -17*x // A
       //rotate 90*y // A
       //rotate 25*x // A
       //translate <0, .5, 1> // A
       rotate <-45, 180, 0> translate <2, -.5, -2> // B
}
