#declare Lamp =
union {
	// base
	box { <-9,-1.5,-14><9,0,14>
		texture {
			pigment { Gray35 }
			finish { phong 0.2 }
			normal { dents 0.3 scale 0.5 }
		}
	}
	// back legs
	box { <8.2,-1,-14><9,-20,-13.2> }
	box { <8.2,-1,14><9,-20,13.2> }
	// front legs
	box { <-0.4,0,-1><0.4,-30,1> rotate 43*z translate <-9.1,-0.2,-10.0>}
	box { <-0.4,0,-1><0.4,-30,1> rotate 43*z translate <-9.1,-0.2,10.0>}
	// cross pieces
	box { <-0.5,-10.5,-13.4><9,-9.3,-14>
		texture {
			pigment { Gray35 }
			finish { Dull }
			normal { dents 0.3 scale 0.5 }
		}
	}
	box { <-0.5,-10.5,13.4><9,-9.3,14>
	texture {
			pigment { Gray35 }
			finish { Dull }
			normal { dents 0.3 scale 0.5 }
		}
	}
	// lamp
	union {
		cylinder { <-7,0,0><7,0,0> 7 }
		box { <-7,-12,-7><7,0,7> }
		// flute
		lathe {
  		linear_spline
  		8,
			<2, 0>,<2, 5>,<2.25,5.5>,<2.5, 6>,<2.75,6.25>,<3,6.5>,<3.25,6.75>,<3.65,7>
			texture { T_Chrome_3B }
			scale <0.8,1,0.8>
			translate <-2,5.5,0>
		}
		texture {
			pigment { Gray15 }
			finish { phong 0.1 }
			normal { dents 0.3 scale 1 }
		}
		translate <-1,12,0>
	}
	// handles
	union {
		cylinder { <0,0,0><0,4,0> 0.5 }
		sphere { <0,4,0> 0.9 }
		texture { T_Wood28 }
		translate <-7,0,-12>
	}
	union {
		cylinder { <0,0,0><0,4,0> 0.5 }
		sphere { <0,4,0> 0.9 }
		texture { T_Wood12 }
		translate <-7,0,28>
	}
	texture {
		pigment { Gray45 }
		finish { Dull }
		normal { dents 0.3 scale 0.5 }
	}
}

#declare Fluted_Triangle =
difference {
	prism {
  	linear_sweep
  	linear_spline
		0,2
		4,
		<1,0>,<0,1.8>,<-1,0>,<1,0>
	}
	sphere { <0,0,0> 2 }
	sphere { <0,0,0> 2.2 inverse }
	rotate -90*x
}

#declare Smoke_Stack =
union {
	cylinder { <0,0,0><0,70,0> 7.5 }
	// fluted triangles
	#declare Ang = 0
	#while (Ang < 360)
		object { Fluted_Triangle rotate 10*x scale <1.1,1.7,1.2> translate <0,69.3,9.3> rotate Ang*y }
		#declare Ang = Ang + 20
	#end
	texture {
		pigment { Black }
		finish {
			specular 1
			roughness 0.001
			reflection 0.10
		}
	}
}

#declare Bell =
union {
	union {
		// bell
		lathe {
  		linear_spline
  		13,
			<0,0>,<6.5, 0>,<6.2,0.5>,<5,1.2>,<4.5,2>,<4,3>,<3.5,4>,<3.25,5>,<3.0,6>,
			<2.75,7>,<2,7.5>,<1,7.7>,<0,7.8>
			scale <1,1.3,1>
		}
		// stem
		cylinder { <0,0,0><0,6,0> 0.6 translate 7.5*y }
		// sleeve
		cylinder { <0,0,-1><0,0,1> 0.8 translate 11.8*y }
		// clacker
		union {
			cylinder { <0,0,0><0,-3,0> 0.35 }
			sphere { <0,-3,0> 0.9 }
			texture { T_Silver_2C }
			rotate -8*z
			translate <-0.3,2.3,0>
		}
		texture { T_Brass_1C }
		rotate 0*z
		translate <1,0,0>
	}
	// bell holder
	union {
		// axle
		cylinder { <0,0,-7><0,0,7> 0.40 texture { T_Silver_1B } translate 11.8*y }
		// braces
		box { <-0.35,-18,-0.25><0.35,0,0.25> rotate -16*z translate <0,12.5,-7> }
		box { <-0.35,-18,-0.25><0.35,0,0.25> rotate 16*z translate <0,12.5,-7> }
		box { <-0.35,-18,-0.25><0.35,0,0.25> rotate -16*z translate <0,12.5,7> }
		box { <-0.35,-18,-0.25><0.35,0,0.25> rotate 16*z translate <0,12.5,7> }
		// anchors
		box { <-0.7,0,-0.7><0.7,1,0.7> rotate -30*x translate <4.8,-5.1,-6.9> texture { Rusty_Iron } }
		box { <-0.7,0,-0.7><0.7,1,0.7> rotate -30*x translate <-4.8,-5.1,-6.9> texture { Rusty_Iron } }
		box { <-0.7,0,-0.7><0.7,1,0.7> rotate 30*x translate <4.8,-5.1,6.9> texture { Rusty_Iron } }
		box { <-0.7,0,-0.7><0.7,1,0.7> rotate 30*x translate <-4.8,-5.1,6.9> texture { Rusty_Iron } }
	}
	texture { T_Brass_2C }
	scale 0.96
}

#declare Bell_Cord_Holder_1 =
union {
	box {<-0.3,-10,-0.3><0.3,12,0.3> texture { T_Copper_2D } }
	cylinder { <0,11.2,0><0,12,0> 0.65 texture { T_Chrome_1A } }
	cylinder { <0,9.4,0><0,10.2,0> 0.65 texture { T_Chrome_1A } }
	box {<-0.7,-10,-0.7><0.7,-2.3,0.7> texture { T_Chrome_1A } }
	// cord from bell
	cylinder { <-12,0,0><0,0,0> 0.3
		rotate <0,33,-10.6>
		translate 11.6*y
		texture {
			pigment { Tan }
			finish { Dull }
		}
	}
}

#declare Pressure_Valve =
union {
	union {
		// wooden cylinder
		#declare R1 = seed(543)
		#declare Ang = 0
		#while (Ang < 360)
			box { <-0.85,0,0><0.85,24,-0.5>
				translate 7.5*z
				rotate Ang*y
				#if (d_Attachments > 1)
				#declare z1 = rand(R1)*5
				#declare z2 = rand(R1)*5
				#declare z3 = rand(R1)*5
				#declare q1 = rand(R1)*100
				#declare q2 = rand(R1)*100
				#declare q3 = rand(R1)*100
				texture {
					T_Wood14
					scale (rand(R1)*3)+12
					rotate <-1+z1,89+z2,-1+z3>
					translate <q1,q2,q3>
				}
				#else
				pigment { Brown }
				#end
			}
			#declare Ang = Ang + 13.5
		#end
		// lower band
		cylinder { <0,0,0><0,1.8,0> 7.7 texture { T_Copper_2B } }
		// cone
		union {
			cylinder { <0,0,0><0,0.5,0> 8.1 }
			cone { <0,0.5,0> 8.1 <0,1.8,0> 7.0 }
			cone { <0,0.5,0> 8.0 <0,8,0> 0.1
				texture {
					pigment { Black }
					finish { Dull }
				}
			}
			texture { T_Copper_2B }
			translate 23.8*y
		}
		// chamber
		union {
			cone { <0,0,0> 4.2 <0,1.0,0> 3.3 }
			cylinder { <0,0,0><0,7.0,0> 3.3 }
			cone { <0,7,0> 3.3 <0,7.85,0> 1.5 }
			texture { T_Copper_2B }
			translate 29.3*y
		}
		// pipe
		union {
			cylinder { <0,0,0><0,8.5,0> 1.35 }
			cone { <0,8.5,0> 1.35 <0,10.5,0> 2.05 }
			texture { T_Copper_2B }
			translate 36.8*y
		}
		// valve ??
		cylinder { <0,-20,0><0,21,0> 0.5 pigment {Black} translate <4.5,9.5,10> }
		rotate 5*y
		rotate -2*z
	}
	// bottom collar
	union {
		cylinder { <0,12,0><0,15,0> 9.5 }
		cylinder { <0,10,0><0,12,0> 8.8 texture { T_Copper_2B } }
		cylinder { <0,0,0><0,10,0> 9.5 }
		texture {
			pigment {Black}
			finish { Shiny }
			normal { bumps 0.1 scale 0.1 }
		}
		translate -15*y
	}
}

#declare Small_Plate =
union {
	box {<-2,0,-1><2,10,1> pigment { VeryDarkBrown } }
	sphere { <0,0,0> 0.6 translate <-0.8,8.1,-1> pigment {Black} }
	sphere { <0,0,0> 0.6 translate <0.8,6.6,-1> pigment {Black} }
}

#declare Vent =
union {
	// chamber
	union {
		cone { <0,0,0> 5.5 <0,1.3,0> 4.3 }
		cylinder { <0,0,0><0,10.0,0> 4.3 }
		cone { <0,10,0> 4.3 <0,10.95,0> 2.5 }
		texture { T_Copper_2B }
	}
	// pipe
	union {
		cylinder { <0,0,0><0,45,0> 1.90 }
		cone { <0,45,0> 1.90 <0,48,0> 2.50 }
		texture { T_Copper_2B }
		translate 3*y
	}
	// small pipe
	cylinder { <0,-10,0><0,0,0> 2.25 pigment {Black} }
}

#declare Pipe_Radius = 1.5

#declare Angled_Pipe_Left =
union {
	torus { 4 Pipe_Radius
		clipped_by { plane {-x,0} }
		clipped_by { plane {-z,0} rotate -6*y }
 		rotate 90*x
		translate <15,4,0>
	}
	cylinder {<-16.5,0,0><15,0,0> Pipe_Radius }
	torus { 4 Pipe_Radius
		clipped_by { plane {-x,0} }
		clipped_by { plane {-z,0} rotate -28*y }
 		rotate 180*y
		translate <-16.5,0,4>
	}
}

#declare Angled_Pipe_Right =
union {
	torus { 4 Pipe_Radius
		clipped_by { plane {-x,0} }
		clipped_by { plane {-z,0} rotate -6*y }
 		rotate 90*x
		translate <15,4,0>
	}
	cylinder {<-16.5,0,0><15,0,0> Pipe_Radius }
	torus { 4 Pipe_Radius
		clipped_by { plane {-x,0} }
		clipped_by { plane {-z,0} rotate -28*y }
 		rotate 180*y
		translate <-16.5,0,4>
		rotate 180*x
	}
}

#declare Flange =
union {
	cylinder { <0,0,-0.4><0,0,0.4> 3 texture { T_Silver_2B } }
	#declare Ang = 0
	#while (Ang < 360)
		sphere { <0,0,0> 0.6
			scale <1,1,0.5>
			translate <2.25,0,-0.4>
			rotate Ang*z
			texture {
		 		pigment {Black}
				finish { Dull }
			}
		}
		#declare Ang = Ang + 60
	#end
}

#declare Pipe_Anchor =
union {
	cylinder {<0,-15,0><0,0,0> 3
		texture {
			pigment { Gray05 }
			finish { Shiny }
			normal { bumps 0.5 scale 0.3 }
		}
	}
	object { Flange rotate 90*x }
}

#declare Pipe_Assembly =
union {
	#declare Separation = 4.5
	object { Angled_Pipe_Right rotate <180,0,-6> translate <0,5.5+Separation,0> }
	object { Angled_Pipe_Left rotate 6*z translate <0,-5.5-Separation,0> }
	cylinder { <0,-Separation,0><0,Separation,0> Pipe_Radius translate <18.5,0,0> }
	union {
		cylinder { <0,0,0><9.5,0,0> Pipe_Radius }
		object { Flange rotate 90*y translate 7*x }
		object { Flange rotate -90*y translate 8.05*x }
		cylinder { <9,0,0><14.5,0,0> 0.9 texture { T_Copper_3A} }
		// loop
		torus { 4, 0.4
			clipped_by { plane {-x,0} }
			clipped_by { plane {-z,0} }
		 	scale <1.2,1,0.6>
			translate <8.4,0,0>
			texture { T_Copper_3A}
		}
		// control rod
		union {
			cylinder { <14.5,0,0><125,0,0> 0.5 }
			cylinder { <124.5,0,-0.5><124.5,0,0.5> 1.8 }
			// handle
			union {
				box { <-0.5,0,-0.3><0.5,-8,0.3> }
				intersection {
					difference {
						cylinder { <-0.5,0,0><0.5,0,0> 3 }
						cylinder { <-0.6,0,0><0.6,0,0> 2.5 }
					}
					box { <-10,-10,0><10,0,10> }
					scale <1,1.3,1>
					translate <0,-2.8,-2.8>
				}
				texture { T_Chrome_3D }
				rotate <-105,0,90>
				translate <124.5,0,0>
			}
			rotate -2*z
			texture {T_Chrome_2B}
		}
		rotate -28*y
		translate <18.5,-3,0>
	}
	object { Flange rotate <-90,6,0> translate <18.5,-Separation,0> }
	object { Flange rotate <-90,6,0> translate <18.5,Separation,0> }
	texture { T_Copper_1B }
	rotate 90*x
	rotate 28*z
}

#declare Smoke =
cone { <0,-0.5,0> 0.25 <0,2.5,0> 2.5
	pigment { color rgbt <1, 1, 1, 1> }
  halo {
		glowing
		cylindrical_mapping
    linear
    turbulence 1.5
    color_map {
    	[ 0.0 color rgbt <0.2, 0.2, 0.2, 1> ]
      [ 0.5 color rgbt <0.5, 0.5, 0.5, -0.7> ]
      [ 1.0 color rgbt <0, 0, 0, 1> ]
    }
		samples 30
    frequency 2
    scale 0.5
  }
  hollow
  scale <1.4,0.9,1.4>
	scale 20
}

#declare Steam =
cylinder { <0,-1,0><0,1,0> 1
	pigment { color rgbt <1, 1, 1, 1> }
	halo {
		linear
    cylindrical_mapping
    emitting
    turbulence <0.7,0,0.0>
    colour_map {
    	[0 color rgbt <0,0,0,1> ]
      [1 color rgbt <1,1,1, -0.7>]
    }
		scale <0.2,0.1,0.2>
  }
	hollow
	scale <4,2,4>
	scale 5
}

#declare Attachments =
// origin of attachments is top/front of boiler
union {
	object { Lamp translate <-9,8,0> }
	object { Smoke_Stack translate <13,-10,0> }
	#if (d_Attachments > 1)
	object { Smoke rotate 280*y translate <13,70,0> }
	object { Steam rotate -2*z translate <45.7,62,0> }
	#end
	object { Bell translate <75.5,1,0> }
	object { Bell_Cord_Holder_1 translate <86,0,-6> }
	object { Pressure_Valve translate <44,4,0> }
	object { Small_Plate translate <64,-7,0> }
	object { Vent translate <110,0,0> }
	object { Pipe_Assembly translate <37,8,0> }
	object { Pipe_Anchor translate <20.5,-2.25,-11.9> }
	object { Pipe_Anchor translate <20.5,-2.25,11.9> }

	translate <16.5,30,0>
}
