#declare T_Boiler_Black =
texture {
	pigment { Black }
	finish {
		specular 1
		roughness 0.001
		reflection 0.07
	}
	normal { bumps 0.1 scale 0.2 }
}

#declare T_Rivet =
texture {
	pigment { color rgb <0.07,0.09,0.10> }
	finish {
 		phong 0.9
 		phong_size 60
	}
}

#declare T_Rivet_Base =
texture {
	pigment { Gray15 }
	normal { bumps 0.5 scale 0.4 }
}
	
#declare Rivet_3 =
sphere { <0,0,0> 0.80
	scale <1,1,0.8>
	texture {
		pigment { color rgb <0.07,0.09,0.10> }
		finish {
   		phong 0.9
   		phong_size 60
 		}
	}
}	

#declare Rivet_Dome =
sphere { <0,0,0> 0.80
	scale <1,1.3,0.8>
	texture { T_Rivet }
}
	
#declare Band =
cylinder { <-1.25,0,0><1.25,0,0> 16.5
	texture { T_Silver_3A }
}

#declare R1 = seed(123)

#declare Wooden_Cylinder =
union {
	#declare Board_Height = 1.72
	#declare Ang = 0
	#while (Ang < 360)
		#declare z1 = rand(R1)*5
		#declare z2 = rand(R1)*5
		#declare z3 = rand(R1)*5
		#declare q1 = rand(R1)*100
		#declare q2 = rand(R1)*100
		#declare q3 = rand(R1)*100
		box { <0,Board_Height,1><120,-Board_Height,-1>
			#if (d_Boiler > 1)
			texture {
				T_Wood34
				scale (rand(R1)*1)+12
				rotate <-1+z1,89+z2,-1+z3>
				translate <q1,q2,q3>
			}
			#else
			texture { pigment {Brown} }
			#end

			translate -15*z
			rotate Ang*x
		}
		#declare Ang = Ang + (360/28)
	#end
	// metal bands
	object { Band translate 12*x }
	object { Band translate 40*x }
	object { Band translate 68*x }
	object { Band translate 95*x }
}

#declare Domed_Cylinder =
union {
	cylinder { <0,-22,0><0,31,0> 24 }
	// collar around bottom of cylinder
	cylinder { <0,-23.5,0><0,-16.5,0> 26 }
	// dome
	union {
		sphere { <0,0,0> 24 }
		#if (d_Boiler > 1)
		// rivets on dome
		union {
			cylinder { <-0.85,0,0><0.85,0,0> 24.2
				clipped_by { plane {-y, 0.1} }
				texture { T_Rivet_Base }
			}
			#declare Ang_Diff = 7
			#declare Ang = 3
			#while (Ang < 177)
				object { Rivet_Dome
					translate 24.2*z
					rotate (Ang+180)*x
				}
				#declare Ang = Ang + Ang_Diff
			#end
		}
		union {
			cylinder { <-0.85,0,0><0.85,0,0> 24.2
				clipped_by { plane {-y, 0.1} }
				texture { T_Rivet_Base }
			}
			#declare Ang = 3
			#while (Ang < 179)
				object { Rivet_Dome
					translate 24.2*z
					rotate (Ang+180)*x
				}
				#declare Ang = Ang + Ang_Diff
			#end
			rotate 90*y
		}
		union {
			cylinder { <-0.85,0,0><0.85,0,0> 24.2
				clipped_by { plane {-y, 0.1} }
		 		texture { T_Rivet_Base }
			}
			#declare Ang = 3
			#while (Ang < 179)
				object { Rivet_Dome
					translate 24.2*z
					rotate (Ang+180)*x
				}
				#declare Ang = Ang + Ang_Diff
			#end
			rotate 45*y
		}
		union {
			cylinder { <-0.85,0,0><0.85,0,0> 24.2
				clipped_by { plane {-y, 0.1} }
		 		texture { T_Rivet_Base }
			}
			#declare Ang = 3
			#while (Ang < 179)
				object { Rivet_Dome
					translate 24.2*z
					rotate (Ang+180)*x
				}
				#declare Ang = Ang + Ang_Diff
			#end
			rotate -45*y
		}
		#end
		rotate 45*y
		scale <1,0.60,1>
		translate 31*y
	}
	// collar on bottom-rear
	union {
		cylinder { <0,0,0><0,5.5,0> 27 }
		torus { 27 0.7 translate 6*y }
		clipped_by { plane{-x,-10} }
		scale <1,1,0.85>
		translate <2,0,0>
	}
	#if (d_Boiler > 1)
	// rivets on cylinder
	union {
		// side
		box { <-0.85,-23,-0.2><0.85,31,2>
			translate -24*z
			texture { T_Rivet_Base }
		}
		#declare Pt = 28
		#while (Pt > -20)
			object { Rivet_3 translate <0,Pt,-24.2> }
			#declare Pt = Pt - 2.2
		#end
		// top and bottom
		cylinder { <0,29.3,0><0,31,0> 24.2
			texture { T_Rivet_Base }
		}
		#declare Ang = 0
		#while (Ang < 360)
			object { Rivet_3 translate <0,30.15,24.2> rotate Ang*y }
			object { Rivet_3 translate <0,-22.4,26.0> rotate Ang*y }
			object { Rivet_3 translate <0,-17.9,26.0> rotate Ang*y }
			#declare Ang = Ang + 6
		#end
		rotate 10*y
	}
	// attaching collar
	difference {
		cylinder { <0,0,0><35,0,0> 16.5 }
		cylinder { <0,-50,0><0,50,0> 24 }
		rotate 90*x
		translate <-44,12,0>
	}
	// rivets
	#declare Ang = 0
	#while (Ang < 360)
		object { Rivet_3
			translate <-22,0,-16.5>
			rotate Ang*x
			translate <cos(radians(Ang*2))*3.3,12,0>
		}
		#declare Ang = Ang + 9
	#end
	#end
	texture { T_Boiler_Black }
}

#declare Front_Cylinder_Rivet =
sphere { <0,0,0> 0.55
	scale <1,1,0.4>
	texture {
		pigment { color rgb <0.06,0.08,0.09> }
		finish {
 			phong 0.9
 			phong_size 60
		}
	}	
}

#declare Front_Cylinder =
union {
	cylinder { <0,0,0><25,0,0> 18 }
	box { <0,-33,-18><25,0,18> translate <0,0,0> }
	#if (d_Boiler > 1)
	// rivets around perimeter
	#declare Ang = 3
	#while (Ang < 179)
		object { Front_Cylinder_Rivet
			translate <1,0,18>
			rotate (Ang+180)*x
		}
		object { Front_Cylinder_Rivet
			translate <24,0,18>
			rotate (Ang+180)*x
		}
		#if (mod(Ang,21) = 3)
		object { Front_Cylinder_Rivet
			translate <12.5,0,18>
			rotate (Ang+180)*x
		}
		#end
		#declare Ang = Ang + 7
	#end
	// rivets down vertical side
	#declare Offset = -1.5
	#while (Offset > -33)
		object { Front_Cylinder_Rivet translate <1,Offset,-18> }
		object { Front_Cylinder_Rivet translate <24,Offset,-18> }
		#declare Offset = Offset - 2.5
	#end
	// horizontal rivets
	#declare Offset = 3.4
	#while (Offset < 22)
		object { Front_Cylinder_Rivet translate <Offset,-4,-18> }
		object { Front_Cylinder_Rivet translate <Offset,-11.5,-18> }
		#declare Offset = Offset + 2.6
	#end
	#end
	texture { T_Boiler_Black }
}

#declare Below_Boiler =
union {
	cylinder { <0,0,0><130,0,0> 3
		texture {
			pigment { DarkBrown }
		  normal { dents 1 }
		}
	}
	cylinder { <0,0,0><130,0,0> 2
		texture {
			pigment { Gray15 }
		  normal { dents 1 }
		}
		translate <0,3,-8>
	}
	cylinder { <0,0,0><130,0,0> 2
		texture {
			pigment { Gray15 }
		  normal { dents 1 }
		}
		translate <0,3,8>
	}
	cylinder { <0,0,0><50,0,0> 2
		texture {
			pigment { Gray10 }
		  normal { dents 1 }
		}
		rotate 14*z
		rotate -3.5*y
		translate <0,-5,-6>
	}
	cylinder { <0,0,0><50,0,0> 2
		texture {
			pigment { Gray10 }
		  normal { dents 1 }
		}
		rotate 14*z
		rotate 3.5*y
		translate <0,-5,6>
	}
	cylinder { <0,0,0><130,0,0> 1
		texture {
			pigment { Gray35 }
		  normal { dents 1 }
		}
		translate <0,-5,-10>
	}
	cylinder { <0,0,0><130,0,0> 1
		texture {
			pigment { Gray35 }
		  normal { dents 1 }
		}
		translate <0,-5,10>
	}
}

#declare Boiler =
union {
 	object { Front_Cylinder translate -39*x}
 	object { Wooden_Cylinder rotate 10*x translate -15*x }
	object { Domed_Cylinder translate <110,-12,0> }
	object { Below_Boiler translate <-20,-26,0> }
	scale 1.05
}



