// modify T_Wood1 to look like a black painted wood

#declare M_Wood1AZ =
color_map {
  [0.0, 0.1 color rgb <0.88, 0.60, 0.40> * 0.14
            color rgb <0.88, 0.60, 0.40> *.0.14]
  [0.1, 0.9 color rgb <0.88, 0.60, 0.40> * 0.14
            color rgb <0.60, 0.30, 0.20> * 0.14]
  [0.9, 1.0 color rgb <0.60, 0.30, 0.20> * 0.05
            color rgb <0.60, 0.30, 0.20> * 0.05]
}

#declare T_Wood1Z =
texture {
	pigment { P_WoodGrain1A
		color_map {
			M_Wood1AZ
		}
	}
}

#declare T_Black_Wood =
texture {
	T_Wood1Z
	rotate 91*y
}

/////////////////////////////////////////////////////////////////

// modify T_Wood6 to look like darker

#declare Dark_Factor = 0.5

#declare M_Wood6AZ =
color_map {
	[0.0, 0.3 color rgb <0.25, 0.10, 0.10> * Dark_Factor
            color rgb <0.25, 0.10, 0.10> * Dark_Factor ]
  [0.3, 0.6 color rgb <0.25, 0.10, 0.10> * Dark_Factor
            color rgb <0.60, 0.15, 0.10> * Dark_Factor ]
  [0.6, 1.0 color rgb <0.60, 0.15, 0.10> * Dark_Factor
            color rgb <0.25, 0.10, 0.10> * Dark_Factor ]
}

#declare M_Wood6BZ =
color_map {
  [0.0, 0.3 color rgbf <0.25, 0.10, 0.10, 0.00> * Dark_Factor
            color rgbf <0.25, 0.10, 0.10, 0.40> * Dark_Factor ]
  [0.3, 0.5 color rgbf <0.25, 0.10, 0.10, 0.40> * Dark_Factor
            color rgbf <0.60, 0.15, 0.10, 1.00> * Dark_Factor ]
  [0.5, 0.7 color rgbf <0.60, 0.15, 0.10, 1.00> * Dark_Factor
            color rgbf <0.25, 0.10, 0.10, 0.40> * Dark_Factor ]
  [0.7, 1.0 color rgbf <0.60, 0.15, 0.10, 0.40> * Dark_Factor
            color rgbf <0.25, 0.10, 0.10, 0.00> * Dark_Factor ]
}

#declare T_Dark_Wood =
  texture { pigment { P_WoodGrain6A  color_map { M_Wood6AZ }}}
  texture { pigment { P_WoodGrain6B  color_map { M_Wood6BZ }}}

/////////////////////////////////////////////////////////////////

#declare Small_Wheel =
union {
	difference {
		union {
			// outer rim - 1
			cylinder { <0,0,-3.9><0,0,-1.4> 28
			 	texture { T_Copper_2A
					normal { dents .5 }
				}
			}
			// outer rim - 2
			cylinder { <0,0,1.4><0,0,3.9> 28
				texture { T_Copper_2A
					normal {dents .4 } }
			}
			// worn area on outer rim
			cylinder { <0,0,-1.6><0,0,1.6> 28
				texture { T_Silver_3A
					normal { dents 7 }
				 	scale 0.6
				}
			}
			// flange
			cylinder { <0,0,3.9><0,0,3> 30.5
				texture { T_Copper_2A
					normal { dents .35 }
				}
			}
			// inner part of outer rim
			cylinder { <0,0,-4><0,0,4> 27 }
		}
		// subtract this
		cylinder { <0,0,-4.5><0,0,4.5> 24.5 }
	}
	// inner rim
	cylinder { <0,0,-2><0,0,2> 8.2 }
	// axle
	cylinder { <0,0,-10><0,0,30> 2.7
		texture {
			pigment { color rgb <0.07,0.07,0.09> }
			finish {
    		phong 0.9
    		phong_size 60
  		}
		}
	}
	#if (d_Wheel > 1)
	// spokes
	#declare ang = 0
	#while (ang < 360)
		object { Spoke rotate ang*z }
		#declare ang = ang + (360/14)
	#end
	#end

	texture { T_Wheel_Black }
	scale <0.547,0.547,1>
	translate ((1-0.547)*-28)*y
}

#declare Big_Wheel_Brace_Half =
union {
	difference {
		box { <-5,0.2,-1><5,5,1> }
		cylinder { <-5,5,-2><-5,5,2> 3.2 }
		cylinder { <5,5,-2><5,5,2> 3.2 }
		texture { T_Chrome_1A }
	}
	sphere { <0,0,0> 1.0 scale <1,1,1> translate <-3.7,2.0,0> pigment {Black} }
	sphere { <0,0,0> 1.0 scale <1,1,1> translate <3.7,2.0,0> pigment {Black} }
}

#declare Cow_Catcher_Arm =
union {
	difference {
		prism {
  		linear_sweep
  		linear_spline
			-1.5, 1.5,
  			8,
			<0,0>,<-74,0.0>,<-120,8.5>,<-112,13.0>,<-80,10.5>,<-3,9>,<0,6>,<0,0>
			rotate <-90,0,9.9>
		}
		cylinder { <0,0,4><0,0,-4> 2.7 translate <-12.3,8.4,0> }
	}
	// brace for small wheel
	union {
		difference {
			cylinder { <0,0,-1><0,0,1> 5 }
			box { <-6,3.5,-2><-2.0,6,2> }
			box { <6,3.5,-2><2.0,6,2> }
			texture { T_Chrome_1A }
			scale <1,0.9,1>
		}
		sphere { <0,0,0> 0.9 scale <1,0.8,1> translate <-3.1,3.5,0> pigment {Black} }
		sphere { <0,0,0> 0.9 scale <1,0.8,1> translate <3.1,3.5,0> pigment {Black} }
		rotate 6*z
		translate <-89.7,-6,0>
	}
	// brace for big wheel
	union {
		object { Big_Wheel_Brace_Half }
		object { Big_Wheel_Brace_Half rotate 180*z }
		rotate 10.3*z
		translate <-12.3,8.3,0>
	}
	texture {
		T_Dark_Wood
		scale <.5,1,1>
		scale 7
	  rotate 90*y
		rotate 20*z
	}
}

#declare Cow_Catcher_Front =
difference {
	union {
		difference {
			union {
				box { <-30,0,-27><20,5,27> }
				box { <-30,7,-27><20,10,27> }
				box { <-30,13,-27><20,15,27> }
			}
			object { plane {x,-12} rotate <0,-45,-45> }
			object { plane {x,-12} rotate <0,45,-45> }
		}
		union {
			box { <-0.8,-2,-0.8><0.8,30,0.8>
				texture {
					pigment { Gray35 }
					finish { phong 0.1 }
					normal { dents 2 scale 0.3 }
				}
			}
			sphere { <0,0,0> 0.8 scale <0.7,1,1> translate <-0.8,19,0.8> }
			sphere { <0,0,0> 0.8 scale <0.7,1,1> translate <-0.8,12,0.8> }
			sphere { <0,0,0> 0.8 scale <0.7,1,1> translate <-0.8,5,0.8> }
			rotate <0,-45,-45>
			translate <-25,0,0>
			texture { T_Rivet }
		}
		union {
			box { <-0.8,-2,-1.8><0.8,25.5,1.8>
				texture {
					pigment { Gray35 }
					finish { phong 0.1 }
					normal { dents 2 scale 0.3 }
				}
			}
			sphere { <0,0,0> 0.7 scale <0.7,1,1> translate <-0.8,3.5,0.5> }
			sphere { <0,0,0> 0.7 scale <0.7,1,1> translate <-0.8,10,0.5> }
			sphere { <0,0,0> 0.7 scale <0.7,1,1> translate <-0.8,17,0.5> }
			rotate <10.1,-45,-45>
			translate <4,0,-19.1>
			texture { T_Rivet }
		}
		union {
			box { <-0.8,-2,-1.8><0.8,25.5,1.8>
				texture {
					pigment { Gray35 }
					finish { phong 0.1 }
					normal { dents 2 scale 0.3 }
				}
			}
			sphere { <0,0,0> 0.7 scale <0.7,1,1> translate <-0.8,3.5,0.5> }
			sphere { <0,0,0> 0.7 scale <0.7,1,1> translate <-0.8,10,0.5> }
			sphere { <0,0,0> 0.7 scale <0.7,1,1> translate <-0.8,17,0.5> }
			rotate <-10.1,45, -45>
			translate <4,0,19.1>
			texture { T_Rivet }
		}
	}
	box { <-100,-100,-100><100,0,100> }
	box { <-100,15,-100><100,100,100> }
	box { <-10,-30,-100><10,30,100> rotate -38*z translate <13,-5,0> }
	// cutout for wheels
	box { < 11,-20,-9><50,50,-15> }
	box { < 11,-20,15><50,50,9> }
	scale <1.45,0.85,2.1>
	texture { T_Black_Wood }

}

#declare Cow_Catcher_Platform =
union {
	box { <0,0,-19><40,6,19> texture { T_Black_Wood } }
	// connecting frame
	union {
		box { <39.5,0,-38><42.5,9.7,38> }
		box { <39.5,0,-11><42.5,11,11> }
		texture {
			T_Black_Wood
			rotate 90*y
		}
	}
	// fillet to arm
	box { <-6.1,-1.5,-3><7,1.5,3>
		rotate <0,-40,-3>
		translate <-4,-2,-33.5>
		texture { T_Black_Wood }
	}
	// box
	box { <-10,0,-10><10,16.9,10>
		translate <10,6,0>
		texture {
			pigment { Gray40 }
			finish { phong 0.2 }
			normal { dents 1.5 scale 0.2 }
		}
	}
	// top
	box { <-10.8,0,-10.8><10,0.9,10.8>
		translate <10,22.7,0>
		texture {
			pigment { Gray30 }
			finish { phong 0.4 }
		}
	}
	// hinge
	cylinder { <0,0,-10><0,0,10> 0.3
		translate <20,22.9,0>
		texture { T_Chrome_1A }
	}
	rotate 3*z
}

#declare Cow_Catcher =
union {
	object { Small_Wheel translate <-78,0,0> }
	object { Wheel translate <0,0,0> }
	#if (1=1)
		object { Small_Wheel rotate 180*y translate <-78,0,51> }
		object { Wheel rotate 180*y translate <0,0,51> }
		object { Cow_Catcher_Arm translate <12,-8.5,59> }
	#end
	object { Cow_Catcher_Arm translate <12,-8.5,-8> }
	object { Cow_Catcher_Front translate <-114,-22,25.5> }
	object { Cow_Catcher_Platform translate <-95,-16,25.5> }
}
