#if (d_Frame > 1)
#declare T_Frame =
texture {
	pigment { color rgb <0.03,0.02,0.04> }
	finish {
    phong 0.9
    phong_size 60
  }
	normal {dents 0.5 }
	scale 0.3
}

#declare T_Axle_Attachment =
texture {
	pigment { color rgb <0.05,0.05,0.02> }
	finish {
    phong 0.9
    phong_size 60
  }
	normal {dents 0.5 }
	scale 0.1
}
#declare T_Axle_Attachment_Plate =
texture {
	pigment { color rgb <0.05,0.07,0.04> }
	finish {
    phong 0.3
    phong_size 20
  }
	normal { bumps 0.1 }
	scale 0.3
}
#declare T_Upper_Attachment =
texture {
	pigment { color rgb <0.16,0.15,0.16> }
	finish {
    phong 0.9
    phong_size 60
  }
	normal {dents 0.5 }
	scale 0.3
}
#declare T_Triangle =
texture {
	pigment { color rgb <0.03,0.02,0.02> }
	finish {
    phong 0.9
    phong_size 60
	}
	normal {dents 0.3 }
	scale <10,0.1,0.1>
}
#declare T_Hand_Rail_Knob =
texture {
	pigment { color rgb <0.05,0.09,0.07> }
	finish {
    phong 0.9
    phong_size 60
	}
	normal {dents 0.3 }
	scale <10,0.1,0.1>
}
#declare T_Hand_Rail =
texture {
	pigment { color rgb <0.03,0.04,0.05> }
	finish {
    phong 0.9
    phong_size 60
	}
	normal {dents 0.3 }
	scale <10,0.1,0.1>
}
#else
#declare T_Frame = texture { pigment { Tan }  }
#declare T_Axle_Attachment = texture { pigment { Green } }
#declare T_Axle_Attachment_Plate = texture { pigment { Blue } }
#declare T_Upper_Attachment = texture { pigment { Red } }
#declare T_Triangle = texture { pigment { Blue } }
#declare T_Hand_Rail_Knob = texture { pigment { Yellow } }
#declare T_Hand_Rail = texture { pigment { Green } }
#end

#declare Rivet =
sphere { <0,0,0> 0.9 scale <1,1,0.8>
	texture {
		pigment { color rgb <0.06,0.08,0.09> }
		finish {
   		phong 0.9
   		phong_size 60
 		}
	}
}

#declare Rivet_2 =
sphere { <0,0,0> 0.9 scale <1,1,0.8>
	texture {
		pigment { color rgb <0.16,0.18,0.19> }
		finish {
   		phong 0.9
   		phong_size 60
 		}
	}
}

#declare Axle_Attachment_Half =
union {
	prism {
  	linear_sweep
  	linear_spline
  	-1,1,
  	9,
		<0,0>,<0,-6>,<5,-6>,<8,-16>,<11,-15.5>,<11,-6>,<16,-5.2>,<16,0>,<0,0>
		rotate -90*x
	}
	#if (d_Frame >1)
	// gusset
	difference {
		box { <0,0,-1><3,3,1> }
		cylinder { <3,2.95,-5><3,2.95,5> 3 }
		scale <1.4,1.4,1>
		rotate <180,180,0>
		translate <6,-6,0>
	}
	#end
}

#declare Triangle_Journal =
union {
	union {
		box { <-1.3,0,-0.6><1.3,16,0.6> translate 3*z }
		box { <-1.3,0,-0.6><1.3,16,0.6> translate -3*z }
		difference {
			cylinder { <-2.5,0,0><1.3,0,0> 3.6 }
			cylinder { <-3.5,0,0><1.8,0,0> 2.4 }
			cylinder { <-2.9,0.0,-5><-2.9,0.0,5> 1.6 }
			clipped_by { plane {-y,0} }
			scale <1,0.8,1>
			translate 16*y
		}
		scale <1,1,0.55>
	}
	object { Rivet translate <0,1.5,-2> }
	object { Rivet translate <0,1.5,2> }
	rotate 3*z
}

// -- Back Wheel Assembly  -------------------------------------------

#declare Axle_Attachment_Back =
union {
	object { Axle_Attachment_Half translate -14.5*x}
	object { Axle_Attachment_Half rotate 180*y translate 14.5*x}
	#if (d_Frame > 1)
	// Plate
	union {
		box { <-5,-2.8,-0.5><5,3.8,0.5> }
		cylinder { <0,0,0><0,0,-1.5> 2.6 }
		translate <0,-10.8,1.5>
		texture { T_Axle_Attachment_Plate }
	}
	object { Rivet translate <-12.9,-4.3,-1> }
	object { Rivet translate <-3.5,-4.3,-1> }
	object { Rivet translate <12.9,-4.3,-1> }
	object { Rivet translate <3.5,-4.3,-1> }
	object { Rivet scale 0.7 translate <-5.0,-14.8,-1> }
	object { Rivet scale 0.7 translate <5.0,-14.8,-1> }
	#end
	texture { T_Axle_Attachment }
}

#declare Upper_Attachment_Back =
union {
	// yoke
	box { <-1.3,0,-0.3><1.3,17,0.3> translate 3*z }
	box { <-1.3,0,-0.3><1.3,17,0.3> translate -3*z }
	prism {
  	linear_sweep
  	linear_spline
  	-0.3, 0.3,
  	5,
		<0,1.3>,<10,0.7>,<10,-0.7>,<0,-1.3>,<0,1.3>
		rotate < 90,-14, 90>
		translate <0,16.7,-3>
	}
	prism {
  	linear_sweep
  	linear_spline
  	-0.3, 0.3,
  	5,
		<0,1.3>,<10,0.7>,<10,-0.7>,<0,-1.3>,<0,1.3>
		rotate < 90,14, 90>
		translate <0,16.7,3>
	}
	cylinder { <0,0,0><0,4,0> 0.8 translate <0,26,0> }
	// triangle
	prism {
  	linear_sweep
  	linear_spline
  	-0.8,0.8,
  	4,
		<-18,0>,<0,-7>,<18,0>,<-18,0>
		rotate -90*x
		translate 15.9*y
		texture { T_Triangle }
	}
	// axle
	cylinder { <0,13.5,-3><0,14.5,3> 0.4 }
	object { Triangle_Journal scale <1,1.05,1> translate <-16.3,-1,0> }
	object { Triangle_Journal scale <1,1.05,1> rotate 180*y translate <16.3,-1,0> }
	// knob at top
	union {
			cylinder { <0,0,0><0,2,0> 1.05  }
			sphere { <0,2.4,0> 1.4 }
			texture { T_Hand_Rail_Knob }
			translate 30*y
	}
	object { Rivet_2 translate <0,1.5,-3> }
	texture { T_Upper_Attachment }
}

// -- Front Wheel Assembly  ------------------------------------------

#declare Axle_Attachment_Front =
union {
	object { Axle_Attachment_Half translate -14.5*x}
	object { Axle_Attachment_Half rotate 180*y translate 14.5*x}
	#if (d_Frame > 1)
	// Plate
	union {
		box { <-5,-2.8,-0.5><5,3.8,0.5> }
		cylinder { <0,0,0><0,0,-1.5> 2.6 }
		translate <0,-10.8,1.5>
		texture { T_Axle_Attachment_Plate }
	}
	object { Rivet translate <-3.5,-4.3,-1> }
	object { Rivet translate <3.5,-4.3,-1> }
	object { Rivet scale 0.7 translate <-5.0,-14.8,-1> }
	object { Rivet scale 0.7 translate <5.0,-14.8,-1> }
	#end
	texture { T_Axle_Attachment }
}

#declare Upper_Attachment_Front =
union {
	// yoke
	box { <-1.3,0,-0.3><1.3,18,0.3> translate 3*z }
	box { <-1.3,0,-0.3><1.3,18,0.3> translate -3*z }
	prism {
  	linear_sweep
  	linear_spline
  	-0.3, 0.3,
  	5,
		<0,1.3>,<10,0.7>,<10,-0.7>,<0,-1.3>,<0,1.3>
		rotate < 90,-14, 90>
		translate <0,16.7,-3>
	}
	prism {
  	linear_sweep
  	linear_spline
  	-0.3, 0.3,
  	5,
		<0,1.3>,<10,0.7>,<10,-0.7>,<0,-1.3>,<0,1.3>
		rotate < 90,14, 90>
		translate <0,16.7,3>
	}
	cylinder { <0,0,0><0,4,0> 0.8 translate <0,26,0> }
	// triangle
	prism {
  	linear_sweep
  	linear_spline
  	-1.5,1.5,
  	4,
		<-15,0>,<0,-6>,<15,0>,<-15,0>
		rotate -90*x
		translate 14.9*y
		texture { T_Triangle }
	}
	// axle
	cylinder { <0,12.5,-3><0,13.5,3> 0.4 }
	object { Triangle_Journal scale <0.75,0.97,1.6> translate <-14.0,-1,0> }
	object { Triangle_Journal rotate 180*y scale <0.75,0.97,1.6> translate <14.0,-1,0> }
	// knob at top
	union {
			cylinder { <0,0,0><0,2,0> 1.1  }
			sphere { <0,2.2,0> 1.4 }
			translate 30*y
	}
	object { Rivet_2 translate <0,1.5,-3> }
	texture { T_Upper_Attachment }
}

#declare Frame_Far_Side =
union {
	// update if front frame changes
	box { <15,-3,14><214,-11,20> }
	box { <15,-3,14><214,-1.5,26> }
	object { Wheel rotate <0,180,31> translate <118,-14.5,10> }
	object { Wheel rotate <0,180,101> translate <53,-14.5,10> }
}

#declare Frame_Front =
union {
	prism {
  	linear_sweep
    linear_spline
  	-11, -3,
  	5,
		<-22,-3>,<-37,15>,<37,15>,<22,-3>,<-22,-3>
		rotate 90*y
		translate <0,0,35>
	}
	union {
		object { Rivet rotate 47*y scale 1.5 translate <5.5,-4.8,5.1> }
		object { Rivet rotate 47*y scale 1.5 translate <10,-4.8,1.5> }
		object { Rivet rotate 47*y scale 1.5 translate <5.5,-8.5,5.1> }
		object { Rivet rotate 47*y scale 1.5 translate <10,-8.5,1.5> }
		texture {
			pigment { Gray10 }
			finish { phong 0.2 }
			normal { bumps 0.3 }
		}
	}
}

#declare Boiler_Support_1 =
union {
	union {
		box { <-2,6,0><2,30,2>
			texture {
				pigment { Gray15 }
				normal { bumps 0.3 }
			}
		}
		// upper part
		box { <-2,25,-0.5><2,30,5>
			texture {
				pigment { Gray20 }
				normal { bumps 0.4 }
			}
		}
		// rivets on upper part
		object { Rivet scale 0.5 translate <-1.1,26.0,-0.5> }
		object { Rivet scale 0.5 translate <1.1,26.0,-0.5> }
		object { Rivet scale 0.5 translate <-1.1,28.2,-0.5> }
		object { Rivet scale 0.5 translate <0,27.1,-0.5> }
		object { Rivet scale 0.5 translate <1.1,28.2,-0.5> }
		rotate 46*x
	}
	// frame
	union {
		box { <-4,2.5,-3><4,4.3,3>
			texture {
				pigment { Black }
				finish { Shiny }
				normal { bumps 0.2 scale 0.7 }
			}
		}
		box { <-2.3,2.5,-1.3><2.3,5.2,1.3>
			texture {
				pigment { Gray15 }
				finish { Shiny }
				normal { bumps 0.2 scale 0.7 }
			}
		}
		object { Rivet scale 0.85 rotate 90*x translate <-3.0,4.3,-2.2> }
		object { Rivet scale 0.85 rotate 90*x translate <3.0,4.3,-2.2> }
		object { Rivet scale 0.85 rotate 90*x translate <-3.0,4.3,2.2> }
		object { Rivet scale 0.85 rotate 90*x translate <3.0,4.3,2.2> }
		translate 5*z
	}
}

#declare Boiler_Support_2 =
union {
	union {
		box { <-2,6,0><2,30,2>
			texture {
				pigment { Gray15 }
				normal { bumps 0.3 }
			}
		}
		// upper part
		box { <-2,15,-1><2,30,0>
			texture {
				pigment { Gray20 }
				normal { bumps 0.4 }
			}
		}
		// rivets on upper part
		object { Rivet scale 0.5 translate <-1.1,18,-1> }
		object { Rivet scale 0.5 translate <1.1,18,-1> }
		object { Rivet scale 0.5 translate <-1.1,16,-1> }
		object { Rivet scale 0.5 translate <1.1,16,-1> }
		// rivets on lower part
		object { Rivet scale 0.5 translate <-1.1,11,0> }
		object { Rivet scale 0.5 translate <1.1,11,0> }
		object { Rivet scale 0.5 translate <-1.1,9,0> }
		object { Rivet scale 0.5 translate <1.1,9,0> }
		rotate 52*x
	}
	// frame
	union {
		box { <-4,0,-3><4,4.3,3>
			texture {
				pigment { Black }
				finish { Shiny }
				normal { bumps 0.2 scale 0.7 }
			}
		}
		box { <-2.3,0,-1.3><2.3,5.2,1.3>
			texture {
				pigment { Gray15 }
				finish { Shiny }
				normal { bumps 0.2 scale 0.7 }
			}
		}
		object { Rivet scale 0.85 rotate 90*x translate <-3.0,4.3,-2.2> }
		object { Rivet scale 0.85 rotate 90*x translate <3.0,4.3,-2.2> }
		object { Rivet scale 0.85 rotate 90*x translate <-3.0,4.3,2.2> }
		object { Rivet scale 0.85 rotate 90*x translate <3.0,4.3,2.2> }
		translate 5*z
	}
	pigment {Red}
}

#declare Boiler_Attachment_Front =
union {
	box { <-0.7,0,-2><0.7,25,2>
		rotate -40*z
		texture {
			pigment { Gray50 }
			normal { dents 0.5 }
	  }
	}
  cylinder { <0,-0.5,-3.0><0,-0.5,3.0> 1.10 texture { T_Chrome_2A } }
	cylinder { <0,-4,0><0,-0.5,0> 0.7
		texture {
			pigment { Black }
			normal { dents 0.5 }
			finish { phong 0.3 }
	  }
	}
}

#declare Cow_Catcher_Pin =
union {
	cylinder { <0,0,0><0,27,0> 0.5 texture { T_Chrome_1A } }
	cylinder { <0,8.0,0><0,21,0> 1.0 }
	cylinder { <0,21.2,0><0,22,0> 1.4 }
	cylinder { <0,-2,0><0,5.5,0> 1.0 }
	texture {
		pigment { Gray20 }
		finish { Shiny }
		normal { dents 0.5 }
	}
}

#declare Lower_Pipe_Front =
union {
	torus { 70 , 0.95
		clipped_by { plane {x,0} }
		clipped_by { plane {-x,-2} rotate 20*y }
	  rotate 90*x
		translate < 25.0,-70,0>
	}
	torus { 70 , 0.95
		clipped_by { plane {x,0} }
		clipped_by { plane {-x,0} rotate 20*y }
	  rotate 90*x
		rotate 180*z
		translate <-22.6,61.65,0>
	}
	//straight piece
  cylinder { <-26,0,0><0,0,0> 0.95 translate <-22.4,-8.35,0> }
	// part that curves up
	torus { 10 , 0.95
		clipped_by { plane {x,0} }
	  clipped_by { plane {-z,0} }
	  rotate 120*x
		translate <-48,0.3,5.1>
	}
	// end cap
	cylinder { <-0.5,0,0><0.5,0,0> 1.3
		texture {
			pigment { Gray10 }
			normal { bumps 0.5 scale 0.4 }
		}
	 	translate <24.5,0,0>
	}
	// attachment rod - back
	union {
		cylinder { <-0.6,0,0><0.6,0,0> 1.20 }
		cylinder { <0,0,0><0,19,0> 0.6 }
		texture { T_Chrome_2B }
	 	translate 23*x
	}
	// valve attachment
	union {
		sphere { <0,0,0> 1.9 scale <0.6,1.2,0.9> }
		cylinder { <-1.15,0,0><1.15,0,0> 1.15 }
		cylinder { <0,-2.1,0><0,2.1,0> 0.5 }
		cylinder { <0,0,0><0,23,0> 0.5 texture { T_Chrome_1A } }
		// handle
		cylinder { <-0.7,0,0><4.5,0,0> 0.35
			texture {
				pigment { Black }
				normal { bumps 0.5 scale 0.4 }
				finish { Dull }
			}
	 		rotate -15*y
			translate 22*y
		}
		texture { T_Copper_3B }
	 	translate <21,0,0>
	}
	// T-connector
	union {
		cylinder { <-2.2,0,0><2.2,0,0> 1.35 }
		cylinder { <0,0,0><0,4.5,0> 1.1 }
		cylinder { <0,0,0><0,22,0> 0.5 texture { T_Copper_1A } }
		texture { T_Copper_1B }
		rotate 18*z
		translate <0.5,-4.5,-0.2>
	}
	texture {
		pigment { Gray30 }
		finish { Shiny }
		normal { bumps 0.5 }
	}
	translate -25*x
}

#declare Lower_Pipe_Back =
union {
	torus { 70 , 0.95
		clipped_by { plane {x,0} }
		clipped_by { plane {-x,0} rotate 20*y }
	  rotate 90*x
		translate < 25.0,-70,0>
	}
	torus { 70 , 0.95
		clipped_by { plane {x,0} }
		clipped_by { plane {-x,0} rotate 20*y }
	  rotate 90*x
		rotate 180*z
		translate <-22.6,61.65,0>
	}
	//straight piece
  cylinder { <-26,0,0><0,0,0> 0.95 translate <-22.4,-8.35,0> }
	// part that curves up
	torus { 10 , 0.95
		clipped_by { plane {x,0} }
	  clipped_by { plane {-z,0} }
	  rotate 120*x
		translate <-48,0.3,5.1>
	}
	// end cap
	cylinder { <-0.5,0,0><0.5,0,0> 1.3
		texture {
			pigment { Gray10 }
			normal { bumps 0.5 scale 0.4 }
		}
		translate <24.5,0,0>
	}
	// attachment rod - back
	union {
		cylinder { <-0.6,0,0><0.6,0,0> 1.20 }
		cylinder { <0,0,0><0,19,0> 0.6 }
		texture { T_Chrome_2B }
		translate 23*x
	}
	// valve attachment
	union {
		sphere { <0,0,0> 1.9
			scale <0.6,1.2,0.9>
			texture {
				pigment { Gray40 }
			}
		}
		cylinder { <-1.15,0,0><1.15,0,0> 1.15 }
		cylinder { <0,-2.1,0><0,2.1,0> 0.5 }
		cylinder { <0,0,0><0,23,0> 0.5  texture { T_Chrome_1A } }
		// handle
		cylinder { <-0.7,0,0><4.5,0,0> 0.35
			texture {
				pigment { Black }
				normal { bumps 0.5 scale 0.4 }
				finish { Dull }
			}
	  	rotate 15*y
			translate 22*y
		}
		texture {
			pigment { Gray10 }
			normal { bumps 0.5 scale 0.4 }
			finish { Shiny }
		}
		translate <21,0,0>
	}
	union {
		cylinder { <-2.2,0,0><2.2,0,0> 1.35 }
		cylinder { <0,0,0><0,3.5,0> 1.1 }
		cylinder { <0,0,0><0,22,0> 0.5 texture { T_Copper_1A } }
		texture { T_Copper_1B }
		rotate 18*z
		translate <0.5,-4.5,-0.2>
	}
	texture {
		pigment { Gray30 }
		finish { Shiny }
		normal { bumps 0.5 }
	}
	translate -25*x
}

#declare Frame =
union {
	// main beam
	box { <15,-3,-2><214,-11,4> }
	// extension
	box { <15,-3,-8><214,-1.5,4> }
	// back wheel
	union {
		#declare Wheel_Angle = 3
		object { Wheel rotate Wheel_Angle*z translate <0,-14.5,10.0> }
		#if (d_Frame > 1)
		object { Axle_Attachment_Back translate <0,-3,-3> }
		object { Upper_Attachment_Back translate <0,-8,-1> }
		object { Wheel_Plate rotate Wheel_Angle*z translate <0,-14.5,10> }
		#end
		translate 118*x
	}
	// front wheel
	union {
		object { Wheel rotate 54*z translate <0,-14.5,10> }
		#if (d_Frame > 1)
		object { Axle_Attachment_Front translate <0,-3,-3> }
		object { Upper_Attachment_Front translate <0,-8,-1> }
		#end
		translate 53*x
	}
	#if (d_Frame > 1)
	#declare Hand_Rail_Diameter = 0.40
	// rail - top
	union {
		cylinder { <0,0,0><41,0,0> Hand_Rail_Diameter rotate 43*z translate <22.5,-3.1,-1> }
		cylinder { <0,0,0><65,0,0> Hand_Rail_Diameter translate <53,24.35,-1> }
		cylinder { <0,0,0><63,0,0> Hand_Rail_Diameter rotate 153.8*z translate <175,-3.1,-1> }
		// rail braces
		prism {
  		linear_sweep
  		linear_spline
  		-0.5, 0.5,
  		4,
			<0,0>,<2.5,0>,<2.5,2.5>,<0,0>
			rotate -90*x
		  	translate <21.9, -3.1,-1> pigment {Tan}
		}
		prism {
  		linear_sweep
  		linear_spline
  		-0.5, 0.5,
  		4,
			<0,0>,<2.5,0>,<2.5,1.6>,<0,0>
			rotate <-90,180,0>
		 	translate <175.7, -3.1,-1> pigment {Tan}
		}
		// rail - bottom
		cylinder { <0,0,0><78,0,0> Hand_Rail_Diameter translate <48,-18.3,3> }
		union {
			torus { 20, Hand_Rail_Diameter
				clipped_by { plane {-x,0} }
				clipped_by { plane {x,0} rotate 20*y }
				rotate 90*x
				translate 18*y
			}
			cylinder { <0,0,0><18,0,0> Hand_Rail_Diameter rotate -162*z translate <23.9,4.752,0> }
			translate <126,-16.30,3>
		}
		texture {
			pigment { Gray60 }
			finish { Shiny }
			normal { bumps 0.7 scale 0.5 }
		}
	}
	#end
	// far side of frame
	#if (d_Far_Side > 0)
	object { Frame_Far_Side translate 51*z }
	#end
	// back part of frame
	box { <152,-11,-2><214,-1.5,70> }
	// front of frame
	object { Frame_Front }
	#if (d_Frame > 1)
	// supports between boiler and frame
	object { Boiler_Attachment_Front translate <1.5,0,35> }
	object { Boiler_Support_1 translate <23,-5,-4> }
	object { Boiler_Support_2 translate <85,-5,-4> }
	object { Cow_Catcher_Pin translate <-1.15,-21.5,35> }
	object { Lower_Pipe_Front rotate 15*y translate <210,-22.5,0> }
	#if (d_Far_Side > 1)
	object { Lower_Pipe_Back rotate -15*y translate <210,-22.5,67> }
	#end
	#end
	texture { T_Frame }
}

