/*
 Persistence of Vision Ray Tracer Scene Description File
 Filename    : pv_guzzi.pov
 Version     : 3
 Author      : Panagiotis Vossos
 E-mail      : pvossos@otenet.gr
 Date        : 27/02/98
 Equipment   : Cyrix 150 MHz,32 MB RAM
 Render Time : just under 40 minutes
 Credits     : everything by me

 As long as you make NO money using any of this stuff here,you can
 do whatever you want with it.All I am asking is to let me know.
 If you want to use this stuff in a commercial way , then you should
 contact me FIRST.Thanks.
*/


#include "pv_guzzi.inc"

#include "v8 levies.inc"
#include "v8 anartisi.inc"
#include "v8 chassis.inc"
#include "v8 fork.inc"
#include "v8 exhaust1.inc"
#include "v8 exhaust2.inc"

#declare S_Cam = 5
         // katakorifi,orizontia,3d,vides,looks final,chassis
#declare S_TestPos3f = 2
         // test gia tin sosti topothetisi ton trion proton patches
#declare S_Fairing = 1
#declare S_Reservoir = 1
#declare S_Seat = 1
#declare S_Wheels = 1
#declare S_GlassFairing = 1
#declare S_Back_Plane = 1

#switch(S_Cam)
#case(1)
camera {  //  Camera katakorifi
  location  <0.200, -0.001, 20.000>
  direction <0.0,     0.0,  2.5650>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  look_at   <0.200, 0.000, 1.000>
}
#break
#case(2)
camera {  //  Camera Orizontia
  location  <0.000, -14.906, 0.232>
  direction <0.0,     0.0,  1.8883>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  look_at   <-0.243, -0.182, 0.187>
}
#break
#case(3)
camera {  //  Camera real_3d
  location  <8.793, -14.712, 5.911>
  direction <0.0,     0.0,  2.5650>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  look_at   <1.225, -1.570, 0.907>
}
#break
#case(4)
camera {  //  Camera Check That Vides !
  location  <1.000, -8.954, 1.348>
  direction <0.0,     0.0,  2.5650>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  look_at   <1.376, -0.190, -0.527>
}
#break
#case(5)
camera {  //  This One Looks Final
  location  <9.493, -13.785, 0.899>
  direction <0.0,     0.0,  2.5560>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  look_at   <0.824, -1.016, -0.201>
}
#break
#case(6)
camera {  //  Check Chassis Textures
  location  <-4.113, -9.737, -1.730>
  direction <0.0,     0.0,  2.5650>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  look_at   <-3.317, -0.700, -0.734>
}
#break
#end

light_source { <0.38, -10.3, 6.3> color rgb 1  } //shadowless }
light_source { <-5, -16.3, -5.3> color rgb 0.4 } //shadowless }
//light_source { <-3.376, 8.266, -5.316> color rgb 0.4 }

union {
#switch(S_Fairing)
#case(1)
#include "v8 fairing.inc"
object { V8_fairing no_shadow}
#end
#switch(S_Seat)
#case(1)
#include "v8 seat.inc"
object { V8_seat no_shadow}
#end
#switch(S_Reservoir)
#case(1)
#include "v8 reservoir.inc"
object { V8_reservoir no_shadow}
#end
#switch(S_Wheels)
#case(1)
#include "v8 wheel.inc"
object { V8_wheel translate <-3.94,0,-1.2> no_shadow}
object { V8_wheel translate <2.15,0,-1.2> no_shadow}
#break
#end
//scale <1,-1,1.2>
//rotate <-90,0,0>
//translate <-0.6,0.3,0.6>
}

#switch(S_TestPos3f)
// Testing Cube gia tin sosti topothetisi ton trion proton meron tou v8
#case(1)
box {<-1, -1, -1>, <1, 1, 1>
    texture { Glass1 }
    scale <4.54, 1.2, 2.0> }
#end


#switch(S_Back_Plane)
#case(1)
plane { y,10
      texture { T_Italia }
      }
#break
#end

object { Levies no_shadow }
object { Anartisi no_shadow }
object { Chassis no_shadow}
object { Fork no_shadow}
object { Exhaust_1 no_shadow}
object { Exhaust_2 no_shadow}

/* the end */
