
// Persistence of Vision Ray Tracer Scene Description File
// File: reminder.pov
// Vers: 1.00
// Desc: A submersible viewing the wreck of the Titanic.
         Created for the Jan-Feb 98 round of the IRTC.
// Date: 15th Feb 98.
// Auth: Chris hernandez.


// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
//#include "textures.inc"	// Standard Texture definitions


// ==== Additional Includes ====
//#include "CHARS.INC"   // FIXME-add comments describing each of these
//#include "CONSTS.INC"
//#include "METALS.INC"
//#include "SHAPES.INC"
//#include "SHAPES2.INC"
//#include "SHAPESQ.INC"
//#include "SKIES.INC"
//#include "STONES.INC"
//#include "STONES2.INC"
//#include "WOODMAPS.INC"
//#include "WOODS.INC"



// ------------- Some housekeeping def's.

global_settings { max_trace_level 10 assumed_gamma 1.00 /*1.15 1.15 1.9*/ }

background { color rgb /*<0.20, 0.20, 0.35>*/ <0.8, 0.9, 1.0>*0.75 }

#declare TempTexture = texture {
	pigment { color rgb < 0.7, 0.7, 0.8 > }
	finish {
           ambient 0.35
           diffuse 0.35
	   specular 0.3
       roughness 0.01
	   //reflection 0.05
	}
    //normal { crackle -1.0 scale 0.05 }
}


#declare RedT = texture { pigment { color rgb <1,0,0> } finish { ambient 0.6 } }

#declare BlackT = texture { pigment { color rgb <0,0,0> } finish { ambient 0.6 } }


#declare Dimmer = 0.05 //0.75
light_source { 0*x  color rgb 0.65*Dimmer translate <-30, 60, -30> atmosphere off }
light_source { 0*x  color rgb 0.99*Dimmer translate < 20, 70, -50> atmosphere off }
light_source { 0*x  color rgb 0.65*Dimmer translate <-50,-40, -20> atmosphere off }
light_source { 0*x  color rgb 0.65*Dimmer translate <  0,  0, -40> atmosphere off }
light_source { 0*x  color rgb 0.20*Dimmer translate <  0, 20,  30> atmosphere off }


//---Put reference lines on origin for placement purposes.
//cylinder { -100*x, 100*x, 0.01 texture { RedT } }
//cylinder { -100*x, 100*x, 0.01 translate -z*3.5 texture { RedT } }

//#default { texture { TempTexture } }



#declare Rust =
texture {
    pigment {
        granite
        color_map {
            [0.0, 0.4 color rgb <0.89, 0.51, 0.28>
                      color rgb <0.70, 0.13, 0.00>]
            [0.4, 0.5 color rgb <0.70, 0.13, 0.00>
                      color rgb <0.69, 0.41, 0.08>]
            [0.5, 0.6 color rgb <0.69, 0.41, 0.08>
                      color rgb <0.49, 0.31, 0.28>]
            [0.6, 1.0 color rgb <0.49, 0.31, 0.28>
                      color rgb <0.89, 0.51, 0.28>]
        }
    }
    finish { ambient 0.25 diffuse 0.5 }
}

#declare Ship_RustyIron =
texture {
    pigment {
        granite
        color_map {
            [0.0, 0.5 color rgb <0.21, 0.10, 0.10> * 3
                      color rgb <0.25, 0.25, 0.01> * 3 ]
            [0.5, 0.6 color rgb <0.25, 0.25, 0.01> * 4
                      color rgb <0.30, 0.10, 0.10> * 4 ]
            [0.6, 1.0 color rgb <0.15, 0.10, 0.10> * 2
                      color rgb <0.15, 0.10, 0.10> * 2 ]
        }
        turbulence 0.15
        scale 0.15
    }
    //finish { ambient 0.15 diffuse 0.55 crand 0.1 specular 0.1 roughness 0.01 }
    finish { ambient 0.05 diffuse 0.35 crand 0.1 specular 0.05 roughness 0.01 }
    normal { average normal_map { [ 1.00 wrinkles 1 ] [ 1.00 crackle 0.75 ] } scale 0.1 }
}

#declare Ship_RustedMetal = //texture {
   texture { Rust }
   texture { Ship_RustyIron }


//#default { texture  { TempTexture } }
#default { texture  { Ship_RustyIron } }

//==================================== Scene Controls ======================================

//   * These controls make it easier to debug the scene. They enable quick switching from
//     high to low quality renders, and also make it easy to change environments. You can
//     also toggle on/off the scene elements which take up a lot of memory.

   #declare FogSwitch = on
   #declare FogType   = 2          // 1=Fog,  2=Atmosphere

   #declare Ship_Switch = on         //-------- Switch on/off scene elements
   #declare Explorer_Switch = on
   #declare Rock_Switch = off
   #declare Ground_Switch = on
   #declare Mountain_Switch = off
   #declare Debris_Switch = on

   #declare AreaLights = off         //-------- Rendering controls
   #declare FillerLights = off
   #declare FocalBlur = off

//==========================================================================================

camera {
  //location  <-5.0 , 1 , -50.0>  look_at   <0 , 0.5 , 0.0>
  //location <-3, 0.2, -50> look_at <1.0, 0.15, 0>
  //location <-3.5, -0.7, -50> look_at <0.85, 0.15, 0> angle 7.2  //<----- STD CAM 1b
  location <-1.1, 0.65, -10> look_at <0.90, 0.15, 0> angle 35.5  //<----- STD CAM 1b
  //location <-3.5, -1.0, -50> look_at <1.35, 0.15, 0> angle 8.2  //<----- STD CAM 1
  //location <-50, 0.2, -70> look_at <-1.35, 0.15, -4> angle 8    //<----- STD CAM 2 - oblique
  //location <0, 50, 0>  look_at <0, 0, 0> rotate y*90 angle 18   //<----- ABOVE
  //location <0, 0, -50>  look_at <0, 0, 0> angle 10   //<----- FRONT
  //angle 18 //10
  #if ( FocalBlur = on )
     blur_samples 10 //50
     aperture 0.5 //0.025
     confidence 0.985
     focal_point <0.85, 0.15, 0>
  #end
}

#if ( Ship_Switch = on )

#include "SHIP.INC"
object { Ship rotate y*89 rotate z*5.5 }
#end

/*
cylinder { -x*100, x*100, 0.02 translate <0, -0.6, 1.3> texture { RedT } }
cylinder { -x*100, x*100, 0.02 translate <0, -0.6, -1.3> texture { RedT } }
cylinder { -z*100, z*100, 0.02 translate <3.25, -0.6, 0> texture { RedT } }
cylinder { -z*100, z*100, 0.02 rotate -y*55 translate <3.3, -0.6, 1.3> texture { RedT } }
*/


// ------------------- Explorer Object

#if ( Explorer_Switch = on )

#include "EXPLORER.INC"

union {
   object {
      Explorer
      //no_shadow
      scale 0.08 //0.115
   }
   //cylinder { 0*x, 100*x, 0.01 texture { RedT } }
   //light_source { 1.2*y color rgb 1*0.45 atmosphere off atmospheric_attenuation on fade_distance 2.5 fade_power 2 }
   light_source {
      0.35*y color rgb <0.8, 0.8, 1.0>*0.50
      atmosphere off atmospheric_attenuation on
      fade_distance 2.5 fade_power 2
   }
   light_source {
      <-0.1, 0.125, 0> color rgb <0.75, 0.75, 1.0>*0.125 //0.15
      atmosphere on atmospheric_attenuation on
      fade_distance 1.0 fade_power 2
   }
   light_source {
      <-0.1, -0.125, 0> color rgb <0.8, 0.8, 1.0>*0.09 //0.10
      atmosphere on atmospheric_attenuation on
      fade_distance 1.0 fade_power 2
   }


   //rotate -z*2 rotate y*235 //231
   //translate <4, 1.2, -3.5>*0.8
   //rotate -z*2 rotate y*235  translate <4.5, 0.6, 2.25>
   //rotate -z*2 rotate y*248 translate <3.5, 0.6, -5.25>
   //rotate -z*2 rotate y*248 translate <2.8, 0.45, -4.25>
   rotate -z*2 rotate y*260 translate <2.8, 0.75, -4.25>*0.75
}

/*
   light_source {
      0.4*y color rgb 1*0.60
      atmosphere on atmospheric_attenuation on
      fade_distance 2.5 fade_power 2
      looks_like {
         object {
            Explorer
            scale 0.09 //0.115
            rotate -z*2 rotate y*260 translate <2.8, 0.75, -4.25>*0.75
         }
      }
   }
*/
#end


// ----------------------------------------------------------------------------------------
//                                  Rocks and Ground Plane
// ----------------------------------------------------------------------------------------


//plane { y, 0 translate -y*1.5 texture { TempTexture normal { bozo 3.5 scale 0.1 } } }

// ------------------------- Ground Plane

#if ( Ground_Switch = on )

height_field {
   //pot "seaflr5.pot"     // the file name to read
   //gif "seaflr5b.gif"
   gif "seaflr6.gif"
   //smooth
   //inverse
   translate <-0.5, 0, -0.5>
   texture {
      pigment {
         bozo
         color_map {
            [ 0.00 color rgb 0.10 ]
            [ 0.30 color rgb 0.25 ]
            [ 0.70 color rgb 0.15 ]
            [ 1.00 color rgb 0.05 ]
         }
         turbulence 1.5
         scale 1
      }
      finish { ambient 0.05 /*0.15*/ diffuse 0.05 crand 0.1 specular 0.1 roughness 0.05 }
      normal { wrinkles 1.0 scale 0.1 }
      /*
      normal {
         average
         normal_map {
            [ 1.00 wrinkles 1.5 scale 1.5 ]
            [ 1.50 crackle  1.5 scale 1.2 ]
         }
      }
      */
   }
   rotate y*180
   scale <65, 4.1, 65>
   translate <0, -3.4, -2>
}

/*

height_field {
   //pot "seaflr5.pot"     // the file name to read
   //gif "seaflr5b.gif"
   gif "seaflr6.gif"
   //smooth
   //inverse
   translate <-0.5, 0, -0.5>
   texture {
      pigment {
         bozo
         color_map {
            [ 0.00 color rgb 0.65 ]
            [ 0.30 color rgb 0.35 ]
            [ 0.70 color rgb 0.55 ]
            [ 1.00 color rgb 0.45 ]
         }
         turbulence 1.5
         scale 3
      }
      finish { ambient 0.35 diffuse 0.35 crand 0.1 specular 0.1 roughness 0.05 }
      //normal { crackle 1.5 scale 0.5 }
      /*
      normal {
         average
         normal_map {
            [ 1.00 wrinkles 1.5 scale 1.5 ]
            [ 1.50 crackle  1.5 scale 1.2 ]
         }
      }
      */
   }
   rotate y*180
   scale <65, 6, 65>
   translate <0, -4.7, -2>
}
*/

#end


#if ( Rock_Switch = on )

// ------------------------- Rock 1 - Foreground.
height_field {
   gif "rock2.gif"
   water_level 0.05
   translate <-0.5, 0, -0.5>
   texture {
      pigment {
         bozo
         color_map {
            [ 0.00 color rgb 0.65 ]
            [ 0.30 color rgb 0.35 ]
            [ 0.70 color rgb 0.55 ]
            [ 1.00 color rgb 0.45 ]
         }
         turbulence 1.5
         scale 0.3
      }
      finish { ambient 0.05 diffuse 0.15 crand 0.15 specular 0.1 roughness 0.05 }
      normal { crackle 1.5 scale 0.5 }
   }
   rotate y*180
   scale <2, 0.30, 1.5>
   translate <-3, -1.2, -33>
}

// ------------------------- Rock 2 - Right Midground.
height_field {
   gif "rock2.gif"
   water_level 0.05
   translate <-0.5, 0, -0.5>
   texture {
      pigment {
         bozo
         color_map {
            [ 0.00 color rgb 0.65 ]
            [ 0.30 color rgb 0.35 ]
            [ 0.70 color rgb 0.55 ]
            [ 1.00 color rgb 0.45 ]
         }
         turbulence 1.5
         scale 0.3
      }
      finish { ambient 0.25 diffuse 0.25 crand 0.1 specular 0.1 roughness 0.05 }
      normal { crackle 1.5 scale 0.5 }
   }
   rotate y*180
   scale <1.2, 0.3, 1.2>
   translate <0.35, -1.2, -25>
}

// ------------------------- Rock 3 - Middle Background.
height_field {
   gif "rock1.gif"
   water_level 0.05
   translate <-0.5, 0, -0.5>
   texture {
      pigment {
         bozo
         color_map {
            [ 0.00 color rgb 0.65 ]
            [ 0.30 color rgb 0.35 ]
            [ 0.70 color rgb 0.55 ]
            [ 1.00 color rgb 0.45 ]
         }
         turbulence 1.5
         scale 0.5
      }
      finish { ambient 0.10 diffuse 0.20 crand 0.1 specular 0.1 roughness 0.05 }
      normal { crackle 1.5 scale 0.5 }
   }
   rotate y*180
   scale <1, 0.15, 1>
   translate <-0.3, -1.2, -17>
}

#end

#if ( Mountain_Switch = on )

height_field {
   gif "seamnt2.gif"
   //smooth
   translate <-0.5, 0, -0.5>
   texture {
      pigment {
         bozo
         color_map {
            [ 0.00 color rgb 0.65 ]
            [ 0.30 color rgb 0.35 ]
            [ 0.70 color rgb 0.55 ]
            [ 1.00 color rgb 0.45 ]
         }
         turbulence 1.5
         scale 3
      }
      finish { ambient 1.0 diffuse 0.65 crand 0.1 /*specular 0.1 roughness 0.05*/ }
      normal {
         average
         normal_map {
            [ 1.00 wrinkles 1.5 scale 1.2 ]
            [ 1.50 crackle  1.5 scale 1.1 ]
         }
      }
   }
   //rotate y*180
   scale <200, 30, 150>
   translate <-20, -7, 450>
}

#end


// ----------------------------------------------------------------------------------------
//                                       Environment
// ----------------------------------------------------------------------------------------


#if ( FogSwitch = on )

#if ( FogType = 1 )

   fog {
      fog_type   2
      distance   35 //21
      color      rgb <0.02, 0.02, 0.05> //<0.15, 0.15, 0.35, 0> //Gray
      fog_offset -1.5
      fog_alt    10
      turbulence 0.9
   }

#else

   //background { color rgb <0,0,1> }

   #if ( FillerLights = on )
   light_source {
      <0, 30, 45> color rgb <0.005, 0.005, 0.0065>*0.65 atmosphere on
      spotlight point_at <0, 0, 0>  radius 80 falloff 120 tightness 100
   }
   light_source {
      <0, 20, -35> color rgb <0.005, 0.005, 0.0065>*0.55 atmosphere on
      spotlight point_at <0, 0, 0>  radius 80 falloff 120 tightness 100
   }
   light_source {
      <-40, 10, -45> color rgb <0.005, 0.005, 0.0065>*0.60 atmosphere on
      spotlight point_at <0, 0, 0>  radius 80 falloff 120 tightness 100
   }
   #end

   atmosphere {
      type 4
      distance 5 //4.5
      scattering 0.35 //0.35
      color      rgbft <0.6, 0.6, 1.0, 1.0, 0.005> //<0.5, 0.5, 0.95, 1.0, 0.005> // 0.005 //0.02 //0.35
      jitter 1.5 //0.85 //0.55 //0.4
      //aa_threshold 0.10 aa_level 3 samples 75   //----- High Quality
      //aa_threshold 0.15 aa_level 2 samples 50   //----- Med Quality
      //aa_threshold 0.20 aa_level 2 samples 20   //----- Low Quality
      //samples 5 //----- Super Low
      aa_threshold 0.15 aa_level 2 samples 20
    }

#end

#end


#if ( Debris_Switch = on )

#declare R1 = seed (12345)
#declare R2 = seed (54321)
#declare R3 = seed (67890)
#declare R4 = seed (09876)

#declare DebrisMax = 1000 // 750 //500 //250 //200
#declare DebrisXSize = 4.0 //3.5
#declare DebrisYSize = 2.5
#declare DebrisZSize = 3
#declare DebrisMaxRad = 0.011 //0.010 //0.015

#declare DebrisTexture = texture {
   pigment { color rgb 0.65 }
   finish  { ambient 0.10 diffuse 0.10 specular 0.1 roughness 0.1 }
}

#declare DebrisCounter = 0

#while ( DebrisCounter != DebrisMax )
   #declare Random1 = rand(R1)
   #declare Random2 = rand(R2)
   #declare Random3 = rand(R3)
   #declare Random4 = rand(R4)

   sphere {
      <DebrisXSize*Random1,  DebrisYSize*Random2, -DebrisZSize*Random3>, DebrisMaxRad*Random4
      texture { DebrisTexture }
   }
   sphere {
      <DebrisXSize*Random1, -DebrisYSize*Random2, -DebrisZSize*Random3>, DebrisMaxRad*Random4
      texture { DebrisTexture }
   }
   sphere {
      <-DebrisXSize*Random1, DebrisYSize*Random2, -DebrisZSize*Random3>, DebrisMaxRad*Random4
      texture { DebrisTexture }
   }
   sphere {
      <-DebrisXSize*Random1, -DebrisYSize*Random2, -DebrisZSize*Random3>, DebrisMaxRad*Random4
      texture { DebrisTexture }
   }
   #declare DebrisCounter = DebrisCounter + 1

#end

#end
