// Persistence of Vision Ray Tracer Scene Description File
// File: vertigo.pov
// Titl: Vertigo
// Vers: 1
// Desc:  Great Engineering Achievements: Archimedes' Screw
// Date: 18 February 1998
// Auth: T.N.
#version 3.02
#include "colors.inc"
#include "archim.inc"
background {color rgb <1,1,1>}
global_settings
{ assumed_gamma 2.2
  ambient_light rgb <3, 3, 3>
  adc_bailout 0.003922
  max_trace_level 10
}
// ----------------------------------------

// TEXTURES
#declare Ctex1=
  color_map {
    [0.0,  0.1  color rgb <2.0, 1.0, 0.0>
                color rgb <0.0, 0.0, 0.0>]
    [0.1,  0.4  color rgb <0.0, 0.0, 0.0>
                color rgb <1.7, 1.7, 1.9>]
    [0.4,  0.45 color rgb <1.7, 1.7, 1.9>
                color rgb <1.7, 1.7, 1.9>]
    [0.45, 0.5  color rgb <1.7, 1.7, 1.9>
                color rgb <1.5, 1.5, 1.5>]
    [0.5,  0.55 color rgb <1.5, 1.5, 1.5>
                color rgb <1.64, 1.14, 0.92>]
    [0.55, 0.8  color rgb <1.64, 1.14, 0.92>
                color rgb <1.64, 1.14, 0.92>]
    [0.8,  1.0  color rgb <1.64, 1.14, 0.92>
                color rgb <2.0, 1.0, 0.0>]
 }

#declare Ttex1=
  texture {
    pigment {waves turbulence 0.01 color_map {Ctex1}}
    finish {specular 0.35}
  }

#declare Ttex2a=
  texture {
    pigment { color rgbf <0.90, 0.90, 0.90, 0.9> }
    finish {
      ambient 0.1
      diffuse 0.1
      caustics 0.2
      reflection 0.1
      refraction 1
      ior 1.33
      specular 0.8
      roughness 0.003
      phong 1
      phong_size 400
    }
  }

#declare Ttex2b=
  texture {
    pigment { color rgbf <0.85, 0.85, 0.85, 0.9> }
    finish {
      ambient 0.1
      diffuse 0.1
      refraction 1.35
      ior 1.0
      specular 0.8
      roughness 0.003
    }
  }

#declare Ttex2c=
  texture {
    pigment { color rgbf <0.85, 0.85, 0.85, 0.9> }
    finish {
      ambient 0.3
      diffuse 0.3
      refraction 1.2
      ior 1.33
      specular 0.1
      roughness 0.003
    }
  }

#declare Ttex3=
  texture {
	pigment { rgb <0.5, 0.75, 0.4> }
	finish { phong 0.9 }
  }

#declare Ttex4=
  texture {
    pigment {
      granite
      color_map {
      [0.00, 0.60 color rgb <0.93, 0.71, 0.532>
                  color rgb <0.98, 0.81, 0.60>]
      [0.60, 0.65 color rgb <0.50, 0.30, 0.20>
                  color rgb <0.50, 0.30, 0.20>]
      [0.65, 1.00 color rgb <0.80, 0.53, 0.46>
                  color rgb <0.85, 0.75, 0.35>]
      }
    }
    finish { specular 0.1 roughness 0.5 }
    scale 0.15
 }
// ----------------------------------------

// LIGHTS, CAMERA
camera {
  location  <60.0, 40, -60.0>
  direction 7*z
  up        1*y
  right     4/3*x
  look_at   <-5.0, 2,  5.0>
}

light_source {
  0*x
  color rgb <1.0,0.5,0.0>
  spotlight
  translate <0, 8, 0>
  point_at <0, 12, 0>
  radius 179
  tightness 1
  falloff 180
}

light_source { < 0, 100, -200 > color rgb <1, 1, 1> }
light_source { < 200, 10, 0 > color rgb <0.4, 0.5, 0.4> }
light_source { < -50, 10, 200 > color rgb <0.4, 0.25, 0.25> }
// ----------------------------------------

// TERRAIN
union {
  difference {
    box {<-300,-3,-300><300,0,300>}
    cylinder {<0,-2,0><0,1,0>, 1.75}
    cylinder {<0,-0.25,0><0,0.01,0>, 2.0}
  }
  torus {2.0, 0.25 translate y*-0.25}
    texture {Ttex1}
}
// ----------------------------------------

// BOTTLE
merge {
  merge {
    cylinder {<0,-3,0><0,7.03,0>,1.1}
    sphere {<0,7.03,0>,1.1}
  }
  difference {
    torus {0.20, 0.15 translate y*8.24}
    cylinder {<0,8.16,0><0,8.39,0>,0.25}
  }
    texture {Ttex2a}
}
// ----------------------------------------

// STOPPER
//cone {<0,-0.375,0>,0.25<0,0.375,0>,0.28 rotate <-25,0,10> translate <-8,5,2> texture {Ttex4}}
// ----------------------------------------

// CREATE VORTEX OBJECT
union {

// FIRST VORTEX
intersection {
merge {
   #declare Recount= 0
   #while (Recount<=2)
     sphere {<0,0,0>, 0.05+(Recount/4)
       scale <1,0.5+(Recount/20),1>
       translate <0.05,6.6+(Recount/3),0>
       rotate y*(360*Recount)
     }
   #declare Recount= Recount + 0.25
   #end
}
merge {
   #declare Recount= 0
   #while (Recount<=2)
     sphere {<0,0,0>, 0.05+(Recount/4)
       scale <1,0.5+(Recount/20),1>
       translate <0.05,6.7+(Recount/3),0>
       rotate y*(360*Recount)
     }
   #declare Recount= Recount + 0.25
   #end
}
}

// SECOND VORTEX
   #declare T1= 0.5                        // threshold
   #declare S1= 0.53                       // strength
   #declare vRad= sqrt(1-sqrt(abs(T1/S1))) // virtual radius
   #declare RA= radians(-90)               // -pi/2 : sine evaluates to -1
   #declare RB= radians(360)               // 2*pi  : sine evaluates to 0
   #declare RC= radians(-90)               // -pi/2 : sine evaluates to -1
   #declare F1= 0.05                       // may be used for flattening sine wave
   #declare F2= 0.04                       // may be used for flattening sine wave
   #declare F3= 0.04                       // may be used for flattening sine wave
   #declare X1= -0.04                      // original x location
   #declare Y1= 0                          // original y location
   #declare Z1= 0                          // original z location
   #declare Recount= 15                    // first Recount value
   #declare distY= 1.25/15                 // projected height divided by first Recount value:
                                           // translates "1.25/15"
   #declare distR= RB/15                   // 2*pi/15; radians(360) divided by first Recount
   #declare distT= -0.05/15                // distT*(15-Recount) approaches "-0.05"

blob { threshold T1
   #while (Recount >=0)

// MULTIPLES OF Recount MUST BE DECLARED WITHIN LOOP

   #declare X1=sin(RC)*F3                                                 // translate "-0.04"
   #declare aRad=0.10+(sin(RA+(RB*(Recount/15)))*F2)+(distT*(15-Recount)) // actual radius
   sphere{0,aRad/vRad, S1 scale <1,(0.02/aRad),1> translate <X1,Y1,Z1>}   // aRad/vRad= radius;
                                                                          // "0.02/aRad * y"
                                                                          // scales height of
                                                                          // each component

// COMPONENTS ARE SHIFTED 1.25/15 UNITS APART

   #declare Y1=Y1+distY           // 1.25/15 in second loop, (1.25/15)+(1.25/15) in third...
                                  // translates components up "n/15" of height
   #declare RC=(RC+distR)         // loop 2: sine of ((-90 degrees) + (360/15 degrees))
                                  // pushes components in positive x direction
   #declare Recount=Recount-1
   #end
     translate <0,6.7,0>
}
   texture {Ttex2b}
}
// ----------------------------------------

// SCREW
union {
  #declare Recount= 0
  #while (Recount<=450)
    object {PIE rotate y*-4*Recount translate y*0.02*Recount}
  #declare Recount= Recount + 1
  #end
  cylinder {<0,-1,0><0,9.03,0>,0.12}
    translate y*-2
    texture {Ttex3}
}
// ----------------------------------------

// CREATE SPRAY OBJECT

// SPRAY OPTIONS
   #declare spray_location = <0,8.0,0>
   #declare use_blob = true
   #declare blob_threshold = 0.5
   #declare spray_loop = true
   #declare particle_dist = 2
   #declare particle_sep = 0.0
   #declare particle_count = 2000
   #declare particle_size = 0.20
   #declare evaporate = 1
   #declare nozzle_width = 0.275
   #declare nozzle_spin = 11
   #declare particle_stretch = 1.5
   #declare spray_turb = 0.05
   #declare spray_texture = texture {Ttex2c}

// FIRST SPRAY
   #declare particle_life = 2.0
   #declare spray_strength = 6.5
   #declare nozzle_angle = 40
   #include "Spray.inc"

// SECOND SPRAY
   #declare particle_life = 2.5
   #declare spray_strength = 8
   #declare nozzle_angle = -10
   #include "Spray.inc"
// ----------------------------------------

// END OF FILE
/*
// ----------------------------------------

EMAIL: ice@teanow4pm.demon.co.uk
NAME: Tom Nowacki
TOPIC: Great Engineering Achievements
COPYRIGHT: I SUBMIT TO THE STANDARD RAYTRACING COMPETITION COPYRIGHT.
TITLE: Vertigo aka Archimedes' Screw
COUNTRY: UK
WEBPAGE: http://www.teanow4pm.demon.co.uk
RENDERER USED: Povray 3.02 for Windows
TOOLS USED: sPatch
RENDER TIME: 1 hour 23 minutes 27 seconds @ 1024 x 768 +a.1
HARDWARE USED: Pentium-200 MMX

IMAGE DESCRIPTION:

[From 1978 edition of "How It Works" volume 2.]
The Archimedean screw has been used since ancient
Egyptian times as a primitive method of lifting
water. Essentially it consists of a screw thread
surrounded by a close fitting water-tight
cylinder. One end of this device is dipped into
the water and the whole machine is rotated. Water
in the thread at the bottom tends to be 'wound'
up the axis of the machine until it spills out
at the top, the action being like that of a
continuous moving bucket.

JACK AND JILL AT THE MILLENIUM 3000 AGRICULTURAL
EXHIBITION ON MARS...

Jack: The holo-text says it's an Archimedes'
Screw.
Jill: That's nice. Just who or what is an
Archimedes?
Jack: Archimedes? I think he was an ancient
Earthling who lived in a place they used to call
Greece.
Jill: So why did they name that thing after him?
Jack: Well, apparently this is how Archimedes
used to irrigate his garden back on Earth.
Jill: With an H2O bottle and a green screw?
Jack: Sure, why not?
Jill: Okay, to do you a favor, I will suspend
my disbelief. What's the punch line?
Jack: I'm glad you favor me that do. What part
don't you believe?
Jill: The part that Ancient Earthlings already
had H2O bottles, and they probably didn't have
screws either.
Jack: Of course they had screws. How else would
they have opened wine bottles if they didn't have
corkscrews?
Jill: Hmm.
Jack: (playing the tour guide) You're right about
one thing. Archimedes' sprinkler system didn't
work properly, because there were no machines on
Ancient Earth to power it, but in the cave
beneath the garden which we will visit next,
there was a crank handle that rotated the screw,
as well as the barrel containing the H2O supply.
You had to turn the handle very fast, otherwise
the H2O column rising up in the bottle would
fail to spurt out at the nozzle.

"By ox-eyed Lady Here and laughter-loving
Aphrodite," Archimedes panted wiping his brow,
"I must return this leaky barrel to Diomedes in
the 5th Century BC. He will be upset with if I
don't."

DESCRIPTION OF HOW THIS IMAGE WAS CREATED:

INVISIBLE DETAILS LOOK JUST RIGHT.

The Spray.
About a year or so ago I was fortunate to come
across a paperback publication in a bookshop
that was entirely devoted to the subject of
creating realistic water effects in 3D Studio.
I replaced the learn-ed book with an audible
thunk, in my head. Jawohl, I was becoming a
cynic. Just in the nick of time I was
apprehended, and then released on bail, but
the judge died before there could be any trial.
I was a free man once more, or so I believed.
A year or so later I was again staring into a
similar abyss - it happens to me a lot, I
reckon - and this time I was saved from my
frustrated ignorance by the benevolence and
wisdom of Chris Colefax who contributed
Spray.inc to the Povray apocrypha.

The Vortex.
N.B.
from Finland developed a loop for modelling the
body of a toy dinosaur. Highly inspirational, I
thought, and set to work. I adopted and this is
crucial, adapted the loop to manufacture a blob
with ridges in it that I combined with a whorl
of turgescent bubbles of my own device...

The Screw.
There are those who would dispense with all
their earthly goods and material possessions
and spend the rest of their lives in a barrel.
There are others who would say, it depends on
the barrel though. Last but not lost there is
also a small minority (I know they exist) who
would argue unreasonably that there is no such
thing as a barrel. I would never dispense with
sPatch.

The Terrain.
Invisible detail #2.
1. Too much light from point sources can be
harmful.
2. Some objects get overexposed more than
others.
3. The worst offenders are multifaceted,
nearly white and not quite invisible,
viz. spray.

The consequences may never be known in a cosmos
where chaos reigns supreme and order is a bastard
from nascence; so please don't take my word for
it. Fools rush in where angels fear to tread (from
Pope's 'Essay on Criticism' - 1711). But consider:
<3,3,3>, the ambient_light setting. And likewise
in the color_map I applied to the floor, there
were a series of... What?
Sorry, about that. Somebody just knocked on my
door and asked me for some postage stamps.
Where was I? Ah, yes... Bloopers. Quantum leaps?
<1.64, 1.14, 0.92> I have given up trying to
explain such glaring inconsistencies. I have
come to accept them as part of our unnatural
world, ad infinitum.

4. A good pattern type to emulate concentricity
is "waves".

The Bottle.
#declare H2O= ior 1.33

The Stopper.
rem - By Windows Setup

SUMMARY:

"What should the viewer conclude?"
The artist replied evasively, "I have a sense
of humor and something else. A good many people
have neither and still get away with it, so at
the very least I would expect the viewer to ask
the next person he or she meets, a friend, a
close relative, Elvis, merely an acquaintance,
a total stranger: in the structure of your ethics,
is preventing reproduction somehow more humane,
or whatever your equivalent word is, than
terminating the creatures directly?"

$64,000:

Is the screw turning, let me see now, clockwise
or counterclockwise?

I will accept the correct answer as proof that
you are not a lazy person.

Wrong answers will also be evaluated.

SOURCES:

In my sources.zip there are 3 files you need
to put into the appropriate directory on your
harddisk, which is assuming you would like to
render Vertigo too.
// ----------------------------------------
*/
