//texture include for yerkes.pov
#declare base_color =
color rgb <.976, .898, .802>

#declare base_color2 =
color rgb <.96, .93, .91>

#declare base_texture =
texture {
pigment {
color rgb <.868, .778, .682>
}
finish {ambient 0.05 diffuse .8 crand 0.05}
normal {
quilted .3 control0 0 control1 0 scale <1, .5, 1>
}
}

#declare light_stone =
texture {
pigment {
base_color
}
finish {ambient 0.06 diffuse .8 crand 0.05}
}

#declare dome_texture =
texture {
pigment {color White}
finish {ambient .05 diffuse .7 reflection .1}
normal {quilted .2
control0 0
control1 0
scale <2, .5, 2>}
}

#declare dome_texture2 =
texture {
pigment {color White}
finish {ambient .05 diffuse .7 reflection .1}
normal {gradient y .2 scale <1, 1.1, 1>
slope_map {
      [0    <0.5, 1>]   
      [0.35 <1.0, 0>]   
      [0.5  <0.5,-1>]   
      [0.65 <0.0, 0>]   
      [1    <0.5, 1>]   
    }
}
}

#declare dome_texture3 =
texture {
pigment {color White}
finish {ambient .05 diffuse .7 reflection .1}
normal {gradient y .2 scale <1, 3, 1>
slope_map {
      [0    <0.5, 1>]   // start in middle and slope up
      [0.35 <1.0, 0>]   // flat slope at top of wave
      [0.5  <0.5,-1>]   // slope down at mid point
      [0.65 <0.0, 0>]   // flat slope at bottom
      [1    <0.5, 1>]   // finish in middle and slope up
    }
}

}

#declare window_frame =
texture {
pigment {color rgb <.704, .592, .512>}
finish {ambient .1 phong .2 phong_size 10 crand .05}
}

#declare frilly =
texture {
pigment {
radial
frequency 80
color_map {
[0 base_color]
[.2 base_color]
[.3 0.5*base_color]
[.9 0.5*base_color]
[1 base_color]
}
}
finish {ambient .05 diffuse .7 crand .05 phong .3 phong_size 20}
}

#declare frillyx =
texture {
pigment {
gradient x
color_map {
[0 base_color]
[.2 base_color]
[.3 0.5*base_color]
[.9 0.5*base_color]
[1 base_color]
}
}
finish {ambient .05 diffuse .7 crand .05 phong .3 phong_size 20}
}

#declare frillyz =
texture {
pigment {
gradient z
color_map {
[0 base_color]
[.2 base_color]
[.3 0.5*base_color]
[.9 0.5*base_color]
[1 base_color]
}
}
finish {ambient .05 diffuse .7 crand .05 phong .3 phong_size 20}
}

#declare light_band =
texture {
pigment {
radial
frequency 30
color_map {
[0 base_color2]
[.9 base_color2]
[.9 0.8*base_color2]
[1 0.8*base_color2]
}
}
finish {ambient 0.05 diffuse .7 crand .05}
}

#declare light_band2 =
texture {
pigment {
image_map {
tga "brick.tga"
interpolate 2
map_type 2
}
scale <10, 25, 10>
}
finish {ambient .1 diffuse .7}
normal {
quilted .3 control0 0 control1 0 scale <1, .5, 1>
}
}

#declare light_band3 = //stairs
texture {
pigment {
gradient x
color_map {
[0 base_color2]
[.9 base_color2]
[.9 0.9*base_color2]
[1 0.9*base_color2]
}
}
finish {ambient 0.05 diffuse .7 crand .05}
}

#declare light_band4 = //bricks for steps
texture {
pigment {
brick
0.8*base_color2, base_color2
}
finish {ambient 0.05 diffuse .7 crand .05}
}


#declare rail_texture =
texture {
pigment {color rgbt <.868, .854, .823, .1>}
finish {ambient 0.05 diffuse .7 phong .1 phong_size 1 }
}

#declare column_cap =
texture {
pigment {base_color*0.7}
finish {ambient 0.05 diffuse .5 phong .2 phong_size 20 crand 0.05}
normal {crackle 1 scale .3}
}

#declare bottom_texture = //needs work
texture {
pigment {base_color}
finish {ambient .05 diffuse .7 crand .05}
normal {
quilted .3 control0 0 control1 0 scale <1, .5, 1>
}
}

#declare window_glass =
texture {
pigment {color rgbt <0.95, 0.98, 0.97, 0.95>}
finish {ambient 0 phong .1 phong_size 40 reflection .2}
}
