//  Persistance of Vision Raytracer V3.0
//  World definition file.
//
//  Contains 6 lights, 10 textures and 59 primitives.
//
//  This file was generated for POV-Ray V3.0 by
//  MORAY.EXE V2.5b.wat(c) 1991-1995 Lutz + Kretzschmar
//

//  Date : 04/27/1998    (27.04.1998)
//

//
//  This is the standard include file for POV-Ray. It is included with
//  every scene that Moray exports for POV-Ray.
//





global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.8
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera camer01
  location  <9.049, -53.539, 10.210>
  direction <0.0,     0.0,  1.9398>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  look_at   <5.395, -9.596, 8.595>
}

// *******  L I G H T S *******
light_source {   // Light2
  <12.325, 80.148, 37.339>
  color rgb <0.400, 0.400, 0.400>
  atmospheric_attenuation on
}

light_source {   // Light1
  <4.635, -18.300, 13.726>
  color rgb <2.008, 2.008, 1.102>
  fade_distance  1.0
  fade_power 10.0
  atmospheric_attenuation on
}

light_source { // AreaL001
  <11.095, 25.279, 11.000>
  color  rgb<2.008, 1.294, 0.710>
  area_light <5.000, 0.000, 0.000>, <0.000, 0.000, -12.000>, 3, 3
  adaptive 1
}


light_source { // AreaL2
  <24.095, 25.279, 11.000>
  color  rgb<2.008, 1.294, 0.710>
  area_light <5.000, 0.000, 0.000>, <0.000, 0.000, -12.000>, 3, 3
  adaptive 1
  atmospheric_attenuation on
}


light_source {   // Light001
  <80.389, -9.651, 37.339>
  color rgb <0.400, 0.400, 0.400>
}

light_source {   // Spotlight SpotL001
  <4.564, -18.360, 14.803>
  color  rgb <0.796, 0.796, 0.902>
  spotlight
    point_at  <4.564, -18.360, 13.803>
    falloff   20.0  // outer radius (in deg)
      radius    15.0  // inner radius
}


// ********  TEXTURES  *******
//

#include "aett.inc"



// ********  REFERENCED OBJECTS  *******



// ********  OBJECTS  *******

#declare Alien2 = difference {
  box { // Cube24
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 0.2, 1.0>
  }
  box { // Cube25
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 0.3, 1.0>
    rotate -30.0*y
    translate  <-0.82584, 0.0, 0.860982>
  }
  texture {
    Texture08
  }
  rotate 180.0*z
  translate  <-8.0, 7.5, 22.0>
}
#declare Alien1 = difference {
  box { // Cube004
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 0.2, 1.0>
  }
  box { // Cube23
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 0.3, 1.0>
    rotate -30.0*y
    translate  <-0.82584, 0.0, 0.860982>
  }
  texture {
    Texture08
  }
  translate  <-2.0, 7.5, 22.0>
}
union { // ALIEN
  object { Alien2 }
  object { Alien1 }
  texture {
    Texture08
  }
  no_shadow
  scale 1.2
  translate  <-20.017224, 134.715105, -23.35284>
}


cylinder { // MOON
  <0,0,1>, <0,0,0>, 1 
  texture {
    Texture07
  }
  no_shadow
  scale <30.0, 30.0, 0.1>
  rotate -90.0*x
  translate  <-180.941648, 587.926125, 116.988386>
}




union { // BRIDGE
  cylinder { // BridgeCLMN
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 5.0>
    translate  <-48.144703, 80.0, -0.202916>
  }
  cylinder { // BridgeCLMN1
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 5.0>
    translate  <-48.144703, 90.0, -0.202916>
  }
  cylinder { // BridgeCLMN2
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 5.0>
    translate  <-48.144703, 100.0, -0.202916>
  }
  cylinder { // BridgeCLMN3
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 5.0>
    translate  <-48.144703, 110.0, -0.202916>
  }
  cylinder { // BridgeCLMN4
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 5.0>
    translate  <-48.144703, 120.0, -0.202916>
  }
  cylinder { // BridgeCLMN5
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 5.0>
    translate  <-48.144703, 130.0, -0.202916>
  }
  cylinder { // BridgeCLMN6
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 5.0>
    translate  <-48.144703, 140.0, -0.202916>
  }
  cylinder { // BridgeCLMN7
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 5.0>
    translate  <-48.144703, 150.0, -0.202916>
  }
  cylinder { // BridgeCLMN8
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 5.0>
    translate  <-48.144703, 160.0, -0.202916>
  }
  cylinder { // BridgeCLMN9
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 5.0>
    translate  <-48.144703, 170.0, -0.202916>
  }
  cylinder { // BridgeCLMN10
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 5.0>
    translate  <-48.144703, 180.0, -0.202916>
  }
  cylinder { // BridgeCLMN11
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 5.0>
    translate  <-48.144703, 70.0, -0.202916>
  }
  box { // BridgeLine
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Texture03
    }
    scale <3.0, 200.0, 1.0>
    translate  <-48.137879, 0.276025, 5.0>
  }
  box { // BridgeFloor
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Texture03
    }
    scale <10.0, 200.0, 1.0>
    translate  <-48.137879, 0.276025, -1.0>
  }
  cylinder { // BridgeCLMN12
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 5.0>
    translate  <-48.144703, 190.0, -0.202916>
  }
  cylinder { // BridgeCLMN13
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 5.0>
    translate  <-48.144703, 200.0, -0.202916>
  }
  texture {
    Texture03
  }
  translate  2.0*z
}




#declare Fence = union {
  box { // Cube5
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.5, 6.0>
    rotate -90.0*y
    translate  <4.0, 0.0, -6.0>
  }
  box { // Cube4
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.5, 6.0>
    rotate -90.0*y
    translate  4.0*x
  }
  box { // Cube3
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.5, 6.0>
    rotate -90.0*y
    translate  <4.0, 0.0, 6.0>
  }
  box { // Cube2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.5, 12.0>
    translate  4.0*x
  }
}
#declare Frame = difference {
  box { // Cube6
    <-1, -1, -1>, <1, 1, 1>
    scale <7.2, 1.0, 14.4>
    translate  4.0*x
  }
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 1.1, 12.0>
    translate  4.0*x
  }
}
#declare Frame2 = difference {
  box { // Cube19
    <-1, -1, -1>, <1, 1, 1>
    scale <8.2, 1.0, 14.4>
    translate  4.0*x
  }
  box { // Cube20
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 1.1, 12.0>
    translate  4.0*x
  }
  texture {
    Texture05
  }
  scale <1.0, 1.2, 1.2>
  rotate <0.0, 0.0, 0.0>
  translate  <0.0, -0.220713, 0.0>
}
union { // Window
  object { Fence }
  object { Frame }
  object { Frame2 }
  texture {
    Texture05
  }
  scale 0.4
  rotate <0.0, 0.0, 0.0>
  translate  <9.654619, 24.5, 11.0>
}


merge { // LOWER_LINE
  box { // Cube17
    <-1, -1, -1>, <1, 1, 1>
    scale <17.534117, 11.042548, 0.455809>
    translate  <20.331761, 36.208281, 21.29257>
  }
  box { // Cube15
    <-1, -1, -1>, <1, 1, 1>
    scale <17.932364, 11.501431, 0.455809>
    translate  <20.349968, 36.358413, 22.061066>
  }
  box { // Cube18
    <-1, -1, -1>, <1, 1, 1>
    scale <18.29833, 11.736154, 0.455809>
    translate  <20.324812, 36.358413, 22.798588>
  }
  texture {
    Texture05
  }
  scale <0.955, 0.95, 0.75>
  rotate -180.0*y
  translate  <39.475221, 0.0, 17.395963>
}


merge { // UPPER_LINE
  box { // Cube16
    <-1, -1, -1>, <1, 1, 1>
    scale <17.534117, 11.042548, 0.455809>
    translate  <20.331761, 36.208281, 21.29257>
  }
  box { // Cube14
    <-1, -1, -1>, <1, 1, 1>
    scale <17.932364, 11.501431, 0.455809>
    translate  <20.349968, 36.358413, 22.061066>
  }
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    scale <18.29833, 11.736154, 0.455809>
    translate  <20.324812, 36.358413, 22.798588>
  }
  texture {
    Texture05
  }
  scale <0.955, 0.95, 0.9>
  translate  <0.5, 0.0, 3.5>
}


#declare Fence1 = union {
  box { // Cube8
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.5, 6.0>
    rotate -90.0*y
    translate  <4.0, 0.0, -6.0>
  }
  box { // Cube9
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.5, 6.0>
    rotate -90.0*y
    translate  4.0*x
  }
  box { // Cube10
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.5, 6.0>
    rotate -90.0*y
    translate  <4.0, 0.0, 6.0>
  }
  box { // Cube11
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.5, 12.0>
    translate  4.0*x
  }
}
#declare Frame1 = difference {
  box { // Cube12
    <-1, -1, -1>, <1, 1, 1>
    scale <7.2, 1.0, 14.4>
    translate  4.0*x
  }
  box { // Cube13
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 1.1, 12.0>
    translate  4.0*x
  }
}
#declare Frame3 = difference {
  box { // Cube21
    <-1, -1, -1>, <1, 1, 1>
    scale <8.2, 1.0, 14.4>
    translate  4.0*x
  }
  box { // Cube22
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 1.1, 12.0>
    translate  4.0*x
  }
  texture {
    Texture05
  }
  scale <1.0, 1.2, 1.2>
  rotate <0.0, 0.0, 0.0>
  translate  <-0.5, -0.220713, 0.0>
}
union { // Window1
  object { Fence1 }
  object { Frame1 }
  object { Frame3 }
  texture {
    Texture05
  }
  scale 0.4
  translate  <22.654619, 24.5, 11.0>
}




difference { // building
  box { // Building
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Texture06
    }
    hollow
    scale <-16.569477, -10.198684, -13.580651>
    rotate <-180.0, 0.0, -180.0>
    translate  <20.372161, 34.230919, 14.220332>
  }
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Texture04
    }
    scale <2.433877, 3.787161, 5.725349>
    translate  <11.251296, 24.089143, 11.0>
  }
  box { // Cube7
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Texture04
    }
    scale <2.433877, 3.787161, 5.725349>
    translate  <24.251296, 24.089143, 11.0>
  }
  texture {
    Texture03
  }
  hollow
}


box { // buildfloor
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Texture03
  }
  scale <-18.078436, 14.937541, 1.0>
  translate  <19.350781, 32.99738, -1.08807>
}


box { // lampfloor
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Texture03
  }
  scale <-18.078436, 14.937541, 1.0>
  translate  <19.248937, -30.0, -1.08807>
}


#include "lamp.inc"

#declare glass_Ref = object {
  glass
  texture {
    Texture01
  }
}
#declare part2_Ref = object {
  part2
  texture {
    Texture02
  }
  rotate -45.0*z
}
#declare part1_Ref = object {
  part1
  texture {
    Texture02
  }
}
union { // lamp_obj
  object { glass_Ref }
  object { part2_Ref }
  object { part1_Ref }
  no_shadow
  scale <0.0025, 0.0025, 0.0025>
  translate  <4.750235, -18.3, 15.971812>
}


plane { // Floor
  z,0
  texture {
    check
  }
  scale 200.0
  translate  <0.048525, -0.208253, -1.026635>
}


sphere { // SKY
  <0,0,0>,1
  texture {
    Blue_Sky3
  }
  scale 10000.0
  translate  157.890235*y
}


