// Persistence of Vision Ray Tracer Scene Description File
// File: AmpMBox.pov
// Vers: 3
// Desc: The Magic Box (for IRTC)
// Date: Created 3-7-1998, Finished 3-21-1998
// Auth: Arthur Peters

// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#include "woods.inc"
#include "metals.inc"
#include "plastics.inc"
#include "glass.inc"
#include "stones.inc"

global_settings { max_trace_level 4 }

camera
{
 location <2.0,2.3,-9.0>
 look_at <0.1,2.7,0>
}

background { color Blue/6 }

#declare Area_Light_Size = 4

#declare Fire = sphere {
  0, 1
  pigment { color rgbf <1, 1, 1, 1> }
  halo {
    emitting
    spherical_mapping
    linear
    turbulence 0.5
    lambda 4
    color_map {
      [ 0.0 color rgbt <1, 0, 0, 1> ]
      [ 1.0 color rgbt <1, 1, 0, -2> ]
    }
  }
  hollow
 scale <.2,.7,.2>
}

// A Candle
#declare Candle = union // and holder
{
	cylinder { <0,0,0>, <0,0,-1>, 0.1 }
	torus { 0.5, 0.1 rotate z*90 translate <0,0.5,-1> }
	cylinder { <0,0.5,-1.5>, <0,2,-1.5>, 0.1 }
	disc { <0,2,-1.5>, y, 0.3 }
	torus { 0.3, 0.05 translate <0,2,-1.5> }
	cone { <0,2,-1.5>, 0.05, <0,2.3,-1.5>, 0.25 open }
	torus { 0.25, 0.03 translate <0,2.3,-1.5> }

	cone { <0,2,-1.5>, 0.049, <0,2.3,-1.5>, 0.249 texture { White_Plastic } }
	cylinder { <0,2,-1.5>, <0.1,2.5,-1.3>, 0.01 pigment { color Black } }
	object { Fire scale 0.3 translate <0.1,2.5,-1.3> }
	light_source
	{
		0*x
		color Yellow/2
		fade_distance 2
		fade_power 1
		area_light <-0.001, 0, 0> <0.001, 0.001, 0>  1, Area_Light_Size
		adaptive 0
		jitter
		translate <0.1,2.501,-1.3>
	}

}
#declare SlatY = box { <0.05,0,0.1>, <-0.05,1,0> }
#declare SlatX = object { SlatY rotate z*90 translate <0.5,0,0> }

#declare Amb = finish { ambient .4 }
#declare Sill = union // with stuff on it
{
	box { <-2,0,0.25>, <2,-0.2,-0.35> }

	union
	{
		sphere { <-1.5,0.1,-0.1>, 0.2 texture { T_Copper_1A finish{Amb} } }
		julia_fractal
		{
			<-0.03,0.5,-0.2,-0.5>
			texture { T_Grnt27 finish{Amb} }
			scale 0.25
			translate <1.5,0.1,-0.1>
		}
		// Marble Box
		union
		{
			difference
			{
				box { <0.48,0.16,0.32>, <0,0,0> }
				box { <0.464,0.32,0.304>, <0,0.008,0> translate <0.008,0,0.008> }
			}
			union
			{
				box { <0.48,0.168,0.32>, <0,0.16,0> }
				sphere { <0.24,0.2,0.16>, 0.02 texture { T_Grnt4 finish{Amb} } }
				rotate -y*40
				translate <0,0,-0.08>
				texture { T_Grnt4 finish{Amb} }
			}
			light_source { <0.21,0.12,0.14> color Green fade_distance 0.9 fade_power 2 }
			texture { T_Grnt3 finish{Amb} }
			rotate y*90
			translate <0.3,0,0.21>
		}
		texture { finish{Amb} }
	}
	bounded_by { box { <-2,1,0.25>, <2,-0.2,-0.35> } }
}
#declare MainWall = union
{
	difference // wall with window holl
	{
		box { <4.1,10,0.25>, <-4,-2,-0.25> }
		box { <-2,0,1>, <2,4,-1> }
		sphere { <0,4,0>, 2 }
		sphere { x*0, 0.25 texture { T_Wood1 scale 0.5 finish { ambient 0.2 } } scale <1,3,1> translate <3,3,-0.25> }
	}

	object
	{
		Candle
		scale 0.3
		texture { T_Copper_1A finish { ambient 0.3 } }
		translate <3,2.5,0.1>
	}
	object { Sill }

	object { SlatY scale <1,6,1> }
	object { SlatY scale <1,6,1> translate <-1,0,0> }
	object { SlatY scale <1,6,1> translate <1,0,0> }

	object { SlatX scale <4,1,1> translate <0,1,0> }
	object { SlatX scale <4,1,1> translate <0,2,0> }
	object { SlatX scale <4,1,1> translate <0,3,0> }
	object { SlatX scale <4,1,1> translate <0,4,0> }
	texture { T_Wood1 scale 0.7 }
}
#declare Room = union
{
	object { MainWall }
	plane { x, -4 texture { T_Wood1 scale 0.7 rotate y*90 } clipped_by { plane { z,0 } } }
	plane { -x, -3.5 texture { T_Wood1 scale 0.7 rotate y*90 } clipped_by { plane { z,0 } } }
	plane { z, -10 texture { T_Wood1 } clipped_by { plane { z,0 } } }
	plane { y, -2 texture { T_Grnt10 } clipped_by { plane { z,0 } } }
	plane { -y, -10 texture { T_Wood3 } clipped_by { plane { z,0 } } }
}

object { Room }

#declare LightInt = 1

light_source
{
	x*0
	color rgb <LightInt,LightInt,LightInt>
	area_light <4, 0, 0> <0, 0, 4>  Area_Light_Size, Area_Light_Size
	adaptive 0
	jitter
	rotate <45,45,0>
	translate <2,8,2>
}

#if (0)
sphere { <0,0,5>, 3 scale <0.5,1,0.5> }
sphere { <-2,0,5>, 2 scale <1,2,1> }
plane { y, -3 pigment { Black } }
#else
union
{
	height_field
	{
		tga "hills.tga"
        smooth
        translate <-0.5, 0, 0.01>
        scale <100, 10, 100>
    }
    plane { y, 0 }
	pigment { Black }
	bounded_by { box { <-50,0,0>, <50,10,110> } }
	translate <0,-1,0>
}
#end
