// Persistence of Vision Ray Tracer Scene Description File
// File: blind.pov
// Vers: 1
// Titl: Blind
// Desc: Night
// Date: 23/05/98
// Auth: T.N.
#version 3.02
global_settings
{ assumed_gamma 2.2
  ambient_light 1
}
// ----------------------------------------

// INCLUDE FILES
#include "colors.inc"
#include "textures.inc"
#include "metals.inc"
// ----------------------------------------

// TEXTURES
#declare TEX01 = texture {T_Chrome_5E}
#declare TEX02 = texture {T_Gold_5E}
#declare Pynk = texture {pigment {color red 0.94 green 0.74 blue 0.74} finish {ambient 0.3 diffuse 0.3 reflection 0.1}}
#declare Whylow = texture {pigment {color red 0.94 green 0.94 blue 0.84} finish {ambient 0.3 diffuse 0.3}}
// ----------------------------------------

// POEM
// Text (image_map)
box { <0,0,0><1,1,0.0000001>
  pigment {
    image_map {
    gif "Lo.gif"
    map_type 0
    interpolate 2
    transmit 17, 1
    once
    }
  }
  finish {ambient 1 diffuse 1}
  translate <-0.5,-0.5,0>
  scale <14,14,1>
  translate <0.0,7,14.75>
}
// ----------------------------------------

// FANLIGHT
box {<0,0,0><1,1,0.0001>
  pigment {
  image_map {tga "flowers.tga" map_type 0 interpolate 2 once}
  }
  finish {ambient 0.9 diffuse 0.9}
  translate <-0.5,-0.5,0>
  scale <4.5,2.25,1>
  translate y*2.25/2
  translate <-5.5+2.25,8.5,14.85>
}
// ----------------------------------------

// WALLS
box {<-7.5,-9,-15><-7,30,15> texture {Whylow}}
box {<-7,-9,-14.5><7.5,30,-15> texture {Whylow}}
box {<7.0,-9,-15><7.5,30,-6.75> texture {Whylow}}
// ----------------------------------------

// DOORS
#declare Jamb =
difference {
  prism {
    linear_sweep
    cubic_spline
    -9
    8
    7
    <0,0.5>,
    <0,0>,<-0.5,0>,
    <-0.5,0.5>,<0,0.5>,
    <0,0>,<-0.5,0>
    sturm
    texture {Pynk}
  }
  box {<-1,0,-1><1,1,1> rotate z*45 translate y*8 texture {Pynk}}
}
#declare Lintel =
difference {
  prism {
    linear_sweep
    cubic_spline
    0
    4.5
    7
    <0,0.5>,
    <0,0>,<-0.5,0>,
    <-0.5,0.5>,<0,0.5>,
    <0,0>,<-0.5,0>
    sturm
    texture {Pynk}
  }
  box {<-1,0,-1><1,1,1> rotate z*45 translate y*4.5 texture {Pynk}}
  box {<-1,0,-1><1,-1,1> rotate z*-45 texture {Pynk}}
  rotate z*90
}
#declare DoorFrame =
difference {
union {
  object {Jamb translate <-0.5,0,14.5>}
  object {Jamb translate <0.25,0,-0.25> rotate y*180 translate <-0.25,0,0.25> translate <-4.5,0,14.5>}
  object {Lintel translate <-0.5,8,14.5>}
}
  box {<-4.5,-9,14><-1,7.5,15.5> texture {Pynk}}
}
object {DoorFrame translate x*-0.5}
object {DoorFrame translate <2.75,0,-14.75> rotate y*90 translate <7.25,0,3.75>}
// ----------------------------------------

// THRONE, DAIS
  union {
    cylinder {<0.5,-3,4.5><0.5,0.25,4.5>, 3 texture {TEX01}}
    cylinder {<0.5,0.25,4.5><0.5,0.5,4.5>, 2.5 texture {TEX01}}
    cylinder {<0.5,0.5,4.5><0.5,0.75,4.5>, 2 texture {TEX01}}
  }

#declare Master =
blob { threshold 1 sphere { 0, 2, 3 }
    sphere { <-2, 0, 0>, 1.01, 1.1 texture { TEX01 } }
    sphere { <-2, 0, 0>, 1.01, 1.1 rotate 30*z texture { TEX01 } }
    sphere { <-2, 0, 0>, 1.01, 1.1 rotate 60*z texture { TEX01 } }
    sphere { <-2, 0, 0>, 1.01, 1.1 rotate 90*z texture { TEX01 } }
    sphere { <-2, 0, 0>, 1.01, 1.1 rotate 120*z texture { TEX01 } }
    sphere { <-2, 0, 0>, 1.01, 1.1 rotate 150*z texture { TEX01 } }
    sphere { <-2, 0, 0>, 1.01, 1.1 rotate 180*z texture { TEX01 } }
    sphere { <-2, 0, 0>, 1.01, 1.1 rotate 210*z texture { TEX01 } }
    sphere { <-2, 0, 0>, 1.01, 1.1 rotate 240*z texture { TEX01 } }
    sphere { <-2, 0, 0>, 1.01, 1.1 rotate 270*z texture { TEX01 } }
    sphere { <-2, 0, 0>, 1.01, 1.1 rotate 300*z texture { TEX01 } }
    sphere { <-2, 0, 0>, 1.01, 1.1 rotate 330*z texture { TEX01 } }
    sphere { <-2, 0, 0>, 1.01, 1.1 rotate 30*y texture { TEX01 } }
    sphere { <-2, 0, 0>, 1.01, 1.1 rotate 60*y texture { TEX01 } }
    sphere { <-2, 0, 0>, 1.01, 1.1 rotate 90*y texture { TEX01 } }
    sphere { <-2, 0, 0>, 1.01, 1.1 rotate 120*y texture { TEX01 } }
    sphere { <-2, 0, 0>, 1.01, 1.1 rotate 150*y texture { TEX01 } }
    sphere { <-2, 0, 0>, 1.01, 1.1 rotate 210*y texture { TEX01 } }
    sphere { <-2, 0, 0>, 1.01, 1.1 rotate 240*y texture { TEX01 } }
    sphere { <-2, 0, 0>, 1.01, 1.1 rotate 270*y texture { TEX01 } }
    sphere { <-2, 0, 0>, 1.01, 1.1 rotate 300*y texture { TEX01 } }
    sphere { <-2, 0, 0>, 1.01, 1.1 rotate 330*y texture { TEX01 } }
    sphere { <0, 0, 2>, 1.01, 1.1 rotate 30*x texture { TEX01 } }
    sphere { <0, 0, 2>, 1.01, 1.1 rotate 60*x texture { TEX01 } }
    sphere { <0, 0, 2>, 1.01, 1.1 rotate 120*x texture { TEX01 } }
    sphere { <0, 0, 2>, 1.01, 1.1 rotate 150*x texture { TEX01 } }
    sphere { <0, 0, 2>, 1.01, 1.1 rotate 210*x texture { TEX01 } }
    sphere { <0, 0, 2>, 1.01, 1.1 rotate 240*x texture { TEX01 } }
    sphere { <0, 0, 2>, 1.01, 1.1 rotate 300*x texture { TEX01 } }
    sphere { <0, 0, 2>, 1.01, 1.1 rotate 330*x texture { TEX01 } }
    sphere { <0, 0, 2>, 1.01, 1.1 rotate 30*x rotate z*30 texture { TEX01 } }
    sphere { <0, 0, 2>, 1.01, 1.1 rotate 60*x rotate z*30 texture { TEX01 } }
    sphere { <0, 0, 2>, 1.01, 1.1 rotate 120*x rotate z*30 texture { TEX01 } }
    sphere { <0, 0, 2>, 1.01, 1.1 rotate 150*x rotate z*30 texture { TEX01 } }
    sphere { <0, 0, 2>, 1.01, 1.1 rotate 210*x rotate z*30 texture { TEX01 } }
    sphere { <0, 0, 2>, 1.01, 1.1 rotate 240*x rotate z*30 texture { TEX01 } }
    sphere { <0, 0, 2>, 1.01, 1.1 rotate 300*x rotate z*30 texture { TEX01 } }
    sphere { <0, 0, 2>, 1.01, 1.1 rotate 330*x rotate z*30 texture { TEX01 } }
    sphere { <0, 0, 2>, 1.01, 1.1 rotate 30*x rotate z*60 texture { TEX01 } }
    sphere { <0, 0, 2>, 1.01, 1.1 rotate 60*x rotate z*60 texture { TEX01 } }
    sphere { <0, 0, 2>, 1.01, 1.1 rotate 120*x rotate z*60 texture { TEX01 } }
    sphere { <0, 0, 2>, 1.01, 1.1 rotate 150*x rotate z*60 texture { TEX01 } }
    sphere { <0, 0, 2>, 1.01, 1.1 rotate 210*x rotate z*60 texture { TEX01 } }
    sphere { <0, 0, 2>, 1.01, 1.1 rotate 240*x rotate z*60 texture { TEX01 } }
    sphere { <0, 0, 2>, 1.01, 1.1 rotate 300*x rotate z*60 texture { TEX01 } }
    sphere { <0, 0, 2>, 1.01, 1.1 rotate 330*x rotate z*60 texture { TEX01 } }
    sphere { <0, 0, 2>, 1.01, 1.1 rotate 30*x rotate z*-30 texture { TEX01 } }
    sphere { <0, 0, 2>, 1.01, 1.1 rotate 60*x rotate z*-30 texture { TEX01 } }
    sphere { <0, 0, 2>, 1.01, 1.1 rotate 120*x rotate z*-30 texture { TEX01 } }
    sphere { <0, 0, 2>, 1.01, 1.1 rotate 150*x rotate z*-30 texture { TEX01 } }
    sphere { <0, 0, 2>, 1.01, 1.1 rotate 210*x rotate z*-30 texture { TEX01 } }
    sphere { <0, 0, 2>, 1.01, 1.1 rotate 240*x rotate z*-30 texture { TEX01 } }
    sphere { <0, 0, 2>, 1.01, 1.1 rotate 300*x rotate z*-30 texture { TEX01 } }
    sphere { <0, 0, 2>, 1.01, 1.1 rotate 330*x rotate z*-30 texture { TEX01 } }
    sphere { <0, 0, 2>, 1.01, 1.1 rotate 30*x rotate z*-60 texture { TEX01 } }
    sphere { <0, 0, 2>, 1.01, 1.1 rotate 60*x rotate z*-60 texture { TEX01 } }
    sphere { <0, 0, 2>, 1.01, 1.1 rotate 120*x rotate z*-60 texture { TEX01 } }
    sphere { <0, 0, 2>, 1.01, 1.1 rotate 150*x rotate z*-60 texture { TEX01 } }
    sphere { <0, 0, 2>, 1.01, 1.1 rotate 210*x rotate z*-60 texture { TEX01 } }
    sphere { <0, 0, 2>, 1.01, 1.1 rotate 240*x rotate z*-60 texture { TEX01 } }
    sphere { <0, 0, 2>, 1.01, 1.1 rotate 300*x rotate z*-60 texture { TEX01 } }
    sphere { <0, 0, 2>, 1.01, 1.1 rotate 330*x rotate z*-60 texture { TEX01 } }
  pigment { Yellow }
  scale 0.79
}

#declare Slave =
  difference {
    box {<-1.001,-0.5,-1><1.001,2.5,1> translate <-1.001,0,0> texture {TEX02}}
    height_field { gif "death.gif"
      texture {TEX01}
      translate <-0.5,-0.5,-0.5>
      scale <2,-0.05,2>
      rotate x*-90
      rotate y*-90
      translate y*0.25
    }
    translate <1.001,0,0>
  }

difference {
  object {Master rotate y*90 rotate z*90}
  union {
    box {<-1.001,-0.499,-1><1.001,2.5,1> texture {TEX01}}
    object {Slave translate <-1.001,0.5,0> rotate z*-10 translate <1.001,-0.5,0> texture {TEX02}}
    difference {
      box {<-2.5,-0.5,-2.5><1,2.5,2.5> texture {TEX01}}
      cylinder {<-2.501,-0.5,-1.5><1.001,-0.5,-1.5>,0.5 texture {TEX01}}
      cylinder {<-2.501,-0.5,1.5><1.001,-0.5,1.5>,0.5 texture {TEX01}}
    }
    difference {
      union {
        box {<-2.5,-0.751,-1><-0.25,2.5,1> texture {TEX01}}
        box {<-2.5,-2.5,-1><-0.5,-0.75,1> texture {TEX01}}
      }
      cylinder {<-0.25,-0.75,-1.001><-0.25,-0.75,1.001>,0.25 texture {TEX01}}
    }
  }
  rotate y*-35
  translate <0.5,2.25,4.5>
}
// ----------------------------------------

// CAMERA, LIGHTS, HALOS
// CAMERA
camera {
  location <-5.5,1.0,-3.5>
  up <0.0, 1.0, 0.0>
  right <4/3, 0.0, 0.0>
  look_at <2.0, 4, 9.5>
  angle 60
}

// LIGHTS
object {light_source {<0.0, 20.0, 0.0> color red 1.0 green 1.0 blue 2.5
        fade_distance 20.0
        fade_power 1
        spotlight
        point_at <0.5,0,4.5>
        radius 8
        falloff 10
        tightness 10
        }}
object {light_source {<-5.5, 1.0, -3.5> color red 1.0 green 0.75 blue 0.75 fade_distance 3 fade_power 1}}

// HALOS
// Halo 1 (right)
sphere { 0, 1.1
  pigment { color rgbt <1, 1, 1, 1> }
    halo {
    emitting
    spherical_mapping
    linear
     color_map {
      [ 0 color rgbt <1.0, 0.0, 0.0, 1> ]
      [ 1 color rgbt <0.95, 0.2, 0.1, -1> ]
    }
  }
  hollow
  scale <0.05,0.05,0.05>
  translate <0,0.371,-0.16>
  translate <0,0.5,0> rotate z*-10 translate <0.97,-0.5,0> rotate y*-35 translate <0.5,2.25,4.5>
}
// Halo 2 (left)
sphere { 0, 1.1
  pigment { color rgbt <1, 1, 1, 1> }
    halo {
    emitting
    spherical_mapping
    linear
    color_map {
      [ 0 color rgbt <1.0, 0.0, 0.0, 1> ]
      [ 1 color rgbt <0.95, 0.2, 0.1, -1> ]
    }
  }
  hollow
  scale <0.05,0.05,0.05>
  translate <0,0.371,0.14>
  translate <0,0.5,0> rotate z*-10 translate <0.97,-0.5,0> rotate y*-35 translate <0.5,2.25,4.5>
}
// Halo 3 (center)
cone { <0,-1,0>, 1 <0,1,0>, 1
  pigment { color rgbt <1, 1, 1, 1> }
  halo {
    dust
    dust_type 1
    cylindrical_mapping
    linear
    color_map {
      [ 0 color rgbt <0.9, 1, 1, 1> ]
      [ 1 color rgbt <0.9, 1, 1, 0.9> ]
    }
  }
  hollow
  no_shadow
  scale <3.3,15,3.3>
  translate <0,10,0>
  rotate z*-1.5
  rotate x*-12.7
  translate <0.5, 0, 4.5>
}
// ----------------------------------------

