// -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//  Nightcap
//  created by Robert Fremin 1998
//  for the IRTC contest
// -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
// Render options: [800x600, AA 0.3] +fn +am2 +qr

// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions

// ==== Additional Includes ====
#include "chars.inc"   // FIXME-add comments describing each of these
#include "consts.inc"
#include "metals.inc"
#include "stones.inc"
#include "glass.inc"

// Level of detail:
//
// level	the glass		the table	the wall	clock-radio			lamp
// --------------------------------------------------------------------------
//	1:		red primitive	plain		plain		plain
//	2:		+transparent	+wood					+digits&glass
//	3:		+real glass		+varnished				+glow
//	4:		+whiskey								+chrome,+speaker	+cable
//	5:		+grooves					+surface						+lace
//
//  3: poster +image
//
#declare level = 5

global_settings
{
	#if (level > 2)
		max_trace_level 10
	#end

	radiosity {
		count 800				// Ensure that we get good, accurate samples
		error_bound 0.2			// And calculate lots of them.  (more important than count)
		gray_threshold 0.5
		distance_maximum 8		// Scene-dependant! (orgiginal: 4)
		low_error_factor 0.7	// force many extra samples to be calculated...
		nearest_count 9			// so we can average them together for smoothness
		minimum_reuse 0.01		// get quite tightly into corners
		brightness 3.3			// doesn't really matter.  Not used in final output.
		recursion_limit 1		// Try this = 2, but drop the count to maybe 300
	}
}

// These constants are defined in "consts.inc"
// #declare Radiosity_Debug = 1
// #declare Radiosity_Fast = 2
// #declare Radiosity_Normal = 3
// #declare Radiosity_2Bounce = 4
// #declare Radiosity_Final = 5
//#declare Rad_Quality = Radiosity_Final
//#include "rad_def.inc"

camera
{
	location  <10+6, 16,-36+2>
//	location  <10+6, 16,-36+2+40>	// frame closeup
//	location  <10, 16-5,-36+1.5>
//	location  <10, 16+30,-36-80>
//	location <0,100,-1>
	look_at   <9+1, 5, 0>
//	look_at   <9+1-15, 5, 0+40>		// frame
//	look_at   <0, 0, 0>
//	rotate <1,2,3>
}

//light_source { <2000,2000,-2000> color White }

//sphere { <15,20,-10> 2 pigment { Red } }

#declare main_light =
light_source
{
//	<2000, 2000, -2000>
//	<20,20,-30>
	<40,20,-30>
	color Gray10
	spotlight
//	point_at <0,-5,0>
	point_at <20,20,0>
	radius 5
	falloff 8
	tightness .1
	fade_distance 25
	fade_power 3
	shadowless
}

sky_sphere
{
//	pigment { SkyBlue }
	pigment { Gray10 }
//	pigment { White }
}

#declare floor_ =
plane
{
	y,-50
//	pigment { Green }
//	pigment { checker ForestGreen,Green scale 10 rotate y*10 }
	pigment { checker White,Black scale 10 rotate y*10 }
}

#declare wall =
plane
{
	-z,-14
//	pigment { White }
//	pigment { rgb <.9,1,.9> }
//	pigment { rgb <.8,1,.8> }
//	pigment { rgb <.9,.9,1> }

//	pigment { rgb <1,1,.8> }

	#if (level > 4)
		pigment { image_map { png "tegel.png" interpolate 2 } scale 20 }
		normal  { bump_map  { png "tegel_b.png" interpolate 2 bump_size 1.5 } scale 20 }
		finish { ambient .3 crand .025 }
//		normal { granite scale 5 turbulence .05 }
	#else
		pigment { SkyBlue }
	#end
//	finish { ambient .4 diffuse .8 roughness .05 }
}

#declare tableTex =
texture
{
	#if (level > 1)
		pigment { image_map { gif "whiteash.gif" } scale <5,10,5> rotate <12,34,56> }
		finish { reflection .03 phong .4 ambient .5 }
	#else
		pigment { Yellow }
	#end
}

#declare table =
union
{
	// top side
	#declare c = 0
	#while (c < 4)
		box
		{
			<-25,-2,-20+8*c> <25,0,-20+8*(c+.987)>
			#if (level > 1)
				pigment { image_map { gif "whiteash.gif" interpolate 2 } translate x*-(.35-.3*c/4) scale <40,15,30> rotate <90-c*4,0,5+c*10> }
				normal  { bump_map  { gif "whiteash.gif" interpolate 2 } translate x*-(.35-.3*c/4) scale <40,16,30> rotate <90-c*4,0,5+c*10> }
				#if (level > 2)
					finish { reflection .03 phong .4 ambient .5 }
				#end
			#else
				pigment { Yellow }
			#end
		}
		#declare c = c + 1
	#end

	box { <-2,-2,-2> <2,-50,2> translate <-21,0,-16> texture { tableTex } }
	box { <-2,-2,-2> <2,-50,2> translate <-21,0,  8> texture { tableTex } }
	box { <-2,-2,-2> <2,-50,2> translate < 21,0,-16> texture { tableTex } }
	box { <-2,-2,-2> <2,-50,2> translate < 21,0,  8> texture { tableTex } }

/*
	// side panel
	box
	{
		<-25,-2,-20> <25,0,-20.01>
		#if (level > 1)
			pigment { image_map { gif "whiteash.gif" interpolate 2 } translate x*-.5 scale <60,2,10> rotate z*0 }
			normal  { bump_map  { gif "whiteash.gif" interpolate 2 } translate x*-.5 scale <60,2,10> rotate z*0 }
			#if (level > 2)
				finish { reflection .05 specular .2 phong 1 ambient .25 roughness .005 }
			#end
		#else
			pigment { Brown }
		#end
	}
*/
}

#declare the_glass =
#if (level = 1)
cylinder { y*0 y*6 3.1 pigment { Red } }
#else
merge
{
	difference
	{
		cylinder { y*0 y*6 3.1 }
		cylinder { y*1 y*9 2.9 }
		#if (level > 4)
			#declare c = 0
			#declare N = 30
			#while (c < N)
				box { <-.1,-5,-.1> <.1,5,.1> rotate y*45 rotate x*-40 translate x*3.15+y*3 rotate y*c*360/N }
				box { <-.1,-5,-.1> <.1,5,.1> rotate y*45 rotate x*40 translate x*3.15+y*3 rotate y*c*360/N }
				#declare c = c + 1
			#end
		#end
	}
	torus { 3 .1 scale <1,1.2,1> translate y*6 }

	#if (level < 3)
		pigment { White filter .7 }
	#else
		texture { T_Glass3 }
	#end
}
#end

#declare WhiskeyTexture =
texture
{
	pigment { color rgbf <.9,.7,.3,1> }
	finish { ambient 0 diffuse 0.1 reflection .25 refraction 1 ior 1.5 specular 1 roughness 0.001 caustics .3 }
	normal { ripples }
}

#declare whiskey =
cylinder
{
	y*1.0001 y*3 2.89
	texture { WhiskeyTexture }
}

#declare complete_glass =
union
{
	object { the_glass }
	#if (level > 3)
		object { whiskey }
	#end
}

#declare bed =
union
{
	union
	{
		#declare rr = 10
		torus
		{
			rr 2
			rotate x*90
			clipped_by { plane { -y,0 } }
			clipped_by { plane { x,0 } }
		}
		cylinder { x*-rr x*-rr-y*50 2 }
		cylinder { y*rr x*50+y*rr 2 }

		translate <30+rr,-5,10>
		texture { T_Chrome_4C }
	}

	superellipsoid
	{
		<.3,.1>
		pigment { gradient z pigment_map { [0 Black][1 White] } translate z*-.5 scale 2 }
		finish { ambient .4 diffuse .7 roughness .1 crand .1 }
//		normal { bumps scale <.5,.04,.03> }
		normal { bumps scale <.08,.1,.05> }

		scale <40,10,90>
		translate <72,-15+1,-72+1-4>
	}
}

#declare poster =
union
{
	box { <0,0,.000001> <1,1,.000001> pigment { White } finish { ambient .4 } }
	box
	{
		<0,0,0> <1,1,0>
		#if (level > 2)
//			pigment { image_map { png "wwell.png" interpolate 2 once } }
			#error "The file wwell.png is not included in the package due to it's size."
			finish { reflection .15 ambient .3 specular .2 phong .6 phong_size 100 }
		#else
			pigment { Grey }
		#end
		translate <-.03,.03,0>
	}
	difference
	{
		union
		{
			box { <0,0,.01> <1.03,-.03,-.3> }
			box { <1,0,.01> <1.03,1,-.3> }
		}
		box { <-.0005,-1,-2> <.0005,1,2> rotate z*45 translate x*1 }

		texture { T_Gold_4A }
		normal { dents scale .1 }
	}

	rotate x*-1
	scale <70,70*(600/800),1>
	translate <-65,8-2,13.9>
}

/*
merge
{
	sphere { 0 1 scale <1,.3,1> translate <15,0,-15> }
	sphere { 0 .4 scale <1,.8,1> translate <16,0,-15> }
	sphere { 0 .5 scale <1,.5,1.1> translate <14.5,0,-16> }
	texture { WhiskeyTexture }
}
*/

// ============================================

#include "clock.inc"
#include "lamp.inc"

//object { floor_ }
object { wall }
object { table }
object { complete_glass translate <10-4+6,.000001,-15+1> }
object { clock_radio rotate y*-55 translate <-12+3+1,0,-5-3> }
object { lamp scale 1.4 rotate y*-20 translate x*14-z*2+z*3 }
object { bed }
object { poster }
