// clock.inc

#declare led_col = color Cyan
#declare led_lean = 1

#declare digit = 2
#declare led_digit2 =
#include "digit.inc"

#declare digit = 3
#declare led_digit3 =
#include "digit.inc"

#declare digit = 4
#declare led_digit4 =
#include "digit.inc"

#declare digit = 7
#declare led_digit7 =
#include "digit.inc"

#declare clock_digits =
union
{
	object { led_digit2 translate x*-26 }
	object { led_digit3 translate x*-14 }
	object { led_dots_lit }
	object { led_digit4 translate x*6 }
	object { led_digit7 translate x*18 }

	translate y*10.5
	scale .18
	translate <2.5,0,-9.01>
}


//#declare ClockTex = texture { T_Chrome_4B }
#declare ClockTex = texture { pigment { Red } finish { ambient .2 reflection .05 specular .2 phong .7 phong_size 100 } }

#declare clock_radio =
union
{
	difference
	{
		superellipsoid
		{
			.1
			scale <12,4,10>
			#if (level > 3)
				texture { ClockTex }
			#else
				pigment { Red }
			#end
		}

		// cut-through
//		box { <-20,-.05,-20> <-9.5,.05,20> pigment { Black } }	// left
		box { <9.5,-.05,-20> <20,.05,20> pigment { Black } }	// right

		// front
		superellipsoid
		{
			.1
			scale <12,4,10>
			scale <.8,.8,.9>
			translate z*-18
			pigment { color Gray10 }
		}

		// holes
		superellipsoid { .4 scale <1.3,.4,.8> scale <1.1,1,1.3> translate <7.5,4.1,-6>    pigment { Black } }
		superellipsoid { .4 scale <1.1,.4,.6> scale <1.1,1,1.3> translate <7-3,4.1,-6>  pigment { Black } }
		superellipsoid { .4 scale <1.1,.4,.6> scale <1.1,1,1.3> translate <7-6,4.1,-6>  pigment { Black } }
		superellipsoid { .4 scale <1.1,.4,.6> scale <1.1,1,1.3> translate <7-9,4.1,-6> pigment { Black } }
//		superellipsoid { .4 scale <1.1,.4,.6> scale <1.1,1,1.3> translate <7-12,4.1,-6> pigment { Black } }

		// speaker hole
		superellipsoid { .5 scale <6,.6,5> translate <3,4,2> pigment { Gray30 } }
	}

	// speaker grid
	#if (level > 3)
		#declare c = 0
		#while (c < 23)
			cylinder
			{
				z*-2.5 z*8 .2 scale <1,1.2,1> translate <-2.5+c*.5,3.75,0>
				#if (level > 3)
					texture { ClockTex }
				#else
					pigment { Red }
				#end
			}
			#declare c = c + 1
		#end
		disc { <3.25,3.8,2>,y,4 pigment { Black } }
	#end

	// plastic LED-display cover
	#if (level > 1)
		box { <-11,-3.5,-9.3> <11,3.5,-9.4> pigment { White filter .8 } finish { specular .5 phong .6 reflection .22 ambient .05 } }
	#end

	#if (level > 2)
		light_source { 0 color <.5,1,1> spotlight point_at <0,-15,0> radius 80 falloff 90
					   looks_like { clock_digits } fade_distance 100 fade_power 2 }
	#else
		#if (level > 1)
			object { clock_digits }
		#end
	#end

	superellipsoid { .4 scale <1.3,.4,.8> translate <7.5,4.1,-6>    pigment { Gray30 } finish { specular .3 } }
	superellipsoid { .4 scale <1.1,.4,.6> translate <7-3,4.1,-6>  pigment { Gray50 } finish { specular .3 } }
	superellipsoid { .4 scale <1.1,.4,.6> translate <7-6,4.1,-6>  pigment { Gray50 } finish { specular .3 } }
	superellipsoid { .4 scale <1.1,.4,.6> translate <7-9,4.1,-6> pigment { Gray50 } finish { specular .3 } }
//	superellipsoid { .4 scale <1.1,.4,.6> translate <7-12,4.1,-6> pigment { Gray50 } finish { specular .3 } }

	scale <1, .8, 1>
	scale .9
	translate y*3.5*.9
}
