// lamp.inc
//
// objects:	lamp
//			(lamp_screen)
//			(lamp_foot)

#declare boarder_tex =
texture { pigment { color <1,.7,.7> } finish { ambient .5 crand .1 roughness .05 } }

#declare lamp_screen =
difference
{
	merge
	{
		#declare c = 0
		#declare N = 12
		#while (c <= N)
			difference
			{
				merge
				{
					// laces
					#if (level > 4 /* not visible anyway: */ & c<6)
						// lace
						#declare cc = 0
						#declare Rr = seed(4576657)
						#while (cc < 21)
							sphere
							{
								0 .1
								scale <.1,1,1>
								translate y*.1
								rotate z*(rand(Rr)*20)	// pointing out
								translate <2.58,.09,0>
								rotate y*(cc*5-50)
								texture { boarder_tex }
							}
							#declare cc = cc + 1
						#end
					#end

					// borders
					torus { 2.5 .1 scale <1,2,1> texture { boarder_tex } }
					cone { y*0 2.5 y*10 1.1 }
//					torus { 1.1 .1 translate y*10 texture { boarder_tex } }
				}
				// inside of one cone
				cone { y*-.1 2.5-.1 y*10.1 1.1-.1 }

				scale <1.75,1,1>
				rotate z*15 translate x*5 rotate y*c*(360/N)
			}

			#declare c = c + 1
		#end
	}
	// big inside
	cone { y*-2 8.85 y*15 1.05 }

	pigment { rgb <1,.97,.94> }
	finish { ambient .5 crand .1 roughness .1 }
//	finish { ambient .5 }
}

#declare T_StoneXX =
texture{
	pigment{color White}
	finish{ambient 0.3 diffuse 0.6 crand 0.03}
}
texture{T_Grnt22 scale <1.5, 0.7, 0.5> rotate <0, 0, 40>}
texture{T_Grnt20a scale <2.5, 2, 0.5> rotate <0, 0, -50>}
texture{T_Crack4 scale <0.7, 1, 1> rotate <10, 0, -20>
        finish{phong 1.0 phong_size 90}
}

#declare lamp_foot =
union
{
	// feet
	sphere { <5.5,.25,0> .5 rotate y*45 }	// front
	sphere { <5.5,.25,0> .5 rotate y*135 }	// front
	sphere { <5.5,.25,0> .5 rotate y*225 }	// back
	sphere { <5.5,.25,0> .5 rotate y*315 }	// back

	// stand
	difference
	{
		cylinder { y*.6 y*2 6 }
		torus { 6,.4 scale <1,.5,1> translate y*2 }
	}

	// pin
	cylinder { y*2.1 y*9 1.2 no_shadow }
	cone { y*2 1.3 y*2.1 1.2 no_shadow }

	// bolb socket
	cylinder { y*9 y*11.7 1.3 no_shadow pigment { White } finish { ambient .4 specular .4 } }
	cylinder
	{
		y*0 y*.6 1.30001
		clipped_by { plane { z,-1.264 } }
		pigment { image_map { png "ce_.png" } scale .6 rotate y*14 }
		finish { ambient .4 diffuse .3 specular .4 }
		rotate y*-20
		translate y*9.3
		no_shadow
	}

	// on/off switch
	union
	{
		difference
		{
			cylinder { y*0 y*.16 .7 }
			cylinder { y*-1 y*1 .38 }
		}
		cylinder { y*0 y*.45 .35 }
		sphere { 0 .35 scale <1,.3,1> translate y*.45 }

		scale 1.3
		translate x*3.5+y*2
		pigment { White }
		finish { ambient .2 specular .15 phong .8 phong_size 50 }
	}

	// cable
	#if (level > 3)
	blob
	{
		threshold .3
		#declare c = 0
		#declare N = 150
		#while (c < N)
			sphere { <.7+c*.08, 5-0.00001*c*c*c, 0> .3 strength 1 }
			#declare c = c + 1
		#end
		translate <5,.3-4.6,0>
		rotate y*-1

		pigment { White }
		finish { specular .3 phong 1 phong_size 60 ambient .3 }
	}
	#end

//	pigment{ granite color_map { [0 Gray80][.7 Grey][1 Black] } turbulence .3 scale 6 rotate y*10 }
//	pigment { Blue }
	texture { T_Gold_5A } normal { dents scale 2 }
	texture { T_Stone15 scale 7 }
//	finish { ambient .3 specular .2 phong .4 phong_size 50 reflection .04 }
}

#declare bolb =
sphere { 0 2.5 hollow pigment { White } finish { ambient 1 } }

#declare lamp =
union
{
//	light_source { 0 color <.01,.01,.01> fade_distance 10 fade_power 3 looks_like { lamp_screen } scale .9 rotate y*-1 translate y*10 }
	object { lamp_screen scale .9 rotate y*-1 translate y*10 }
	object { lamp_foot }

	// bolb
	light_source { 0 color <.5,.5,.49> looks_like { bolb } fade_distance 25 fade_power 3 translate y*14 }

	// highlight
	light_source { <5,14,-20> color <.3,.3,.3> cylinder point_at <0,14,0> radius 10 falloff 20 fade_distance 20 fade_power 3 shadowless }

	// wall light
//	light_source { <0,15,5> color Gray40 fade_distance 15 fade_power 4 shadowless }
}
