//  Alexander Fried, (c) 29.4.1998


// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions

#include "stones1.inc"
//#include "objects.inc"


// An infinite planar surface
// plane {<A, B, C>, D } where: A*x + B*y + C*z = D
plane
{
  y, // <X Y Z> unit surface normal, vector points "away from surface"
  -.8 // distance from the origin in the direction of the surface normal
}

#declare wallTex=
    texture{
      pigment{
        brick scale 1/21
      }
      normal{brick scale 1/21}
      finish{ ambient .3}
    }
    texture{
      pigment{
        bozo
        turbulence .4
        color_map{
          [0 rgbt <1,1,1,1>]
          [.45 rgbt <1,1,1,1>]
          [.45  color White]
          [1 color White]
        }
      }
      finish{ ambient .2 }
      scale 15
    }

#declare wallTexfront=
    texture{
      pigment{
        brick scale 1/21
      }
      normal{brick scale 1/21}
      finish{ ambient .3}
    }
    texture{
      pigment{
        bozo
        turbulence .4
        color_map{
          [0 rgbt <1,1,1,1>]
          [.45 rgbt <1,1,1,1>]
          [.45  color White]
          [1 color White]
        }
      }
      finish{ ambient .2 }
    }


#declare wall=union{
  box{<-100,-1,1>,<-3,7,1.3> texture{wallTexfront}}
  box{<-100,7,0.9>,<-2.9,7.3,1.4> texture{pigment{ color White}}}

  box{<100,-1,1>,<3,7,1.3> texture{wallTexfront}}
  box{<100,7,0.9>,<2.9,7.3,1.4> texture{pigment{ color White}}}

  box{<-100,-1,1>,<-100-.3,7,300> texture{wallTex}}
  box{<-100.1,7,.9>,<-100-.4,7.3,300.1> texture{pigment{ color White}}}

  box{<100,-1,1>,<100-.3,7,300> texture{wallTex}}
  box{<100.1,7,.9>,<100-.4,7.3,300.1> texture{pigment{ color White}}}

  box{<-100,-1,300>,<100,7,300.3> texture{wallTex}}
  box{<-100,7,299.9>,<100,7.3,300.4> texture{pigment{ color White}}}

}

#declare r=6.5
#declare dr_num=16
#declare phi=360/dr_num
#declare dr=(r*sqrt(2*(1-cos(phi*pi/180))))/2
#declare height=80

#declare circle=union{
#declare i=0
#while (i<dr_num)
  cylinder{<0,-0.1,0>,<0,height+.1,0>,dr
    translate x*r
    rotate y*(phi*i)
  }
#declare i=i+1
#end
}

#declare griech_saeule=
difference{
  cylinder{0,<0,height,0>,r}
  object{circle}
  bounded_by{cylinder{0,<0,height,0>,r}}
}

#declare c_cross=union{
  box{<-.5, 0, -.5> < .5,  10,  .5>}
  box{<-20/3, 20/3-.5, -.5> < 20/3, 20/3+.5,  .5>}
}

#declare roof_dif=union{
  plane{<-1,-1,0>,-1}
  plane{<0,-1,-1>,-1}
  plane{<1,-1,0>,-1}
  plane{<0,-1,1>,-1}
}

#declare roof_tex=texture{pigment{color Red}}
#declare door_tex=texture{pigment{color Black}}

#declare chapel=
difference{
union{
  box{<-9,-1,0>,<9,12,40>}

  difference{
    box{<(-18-2)/(sqrt(2)*2),(-18-2)/(sqrt(2)*2),-2>,<(18+2)/(sqrt(2)*2),(18+2)/(sqrt(2)*2),42>
      rotate <0,0,45>
      scale <1,.8,1>
    }
    plane{y,0}
    translate<0,12,0>
    texture{roof_tex}
  }
  difference{
    box{<-3,-1,40-6>,<3,50,40>}
    object{roof_dif
      scale <1,3,1>
      translate <0,35,40-3>
      texture{roof_tex}
    }
    cylinder{
      <-4,25,40-3>,<-2.9,25,40-3>,2
      texture{door_tex}
    }
    box{
      <-4,25-2,40-5>,<-2.9,25,40-1>
      texture{door_tex}
    }
   }
  object{ c_cross
    scale 1/2
    translate <0,37,40-3>
    texture{ pigment { color Black}}
  }
  texture{
    pigment{
      crackle
      color_map{
        [0 color Black]
        [0.03 color Black]
        [0.03 color White]
        [1 color White]
      }
      turbulence .4
      scale 10
     // color White
    }
    finish{ ambient .15}
//    wallTex //front
  }
//  scale 1.4
  rotate <0,-90,0>
  translate<9,0,0>
}
  union{
    box{<-6/1.6,-1,-10>,<6/1.6,6,-8>}
    cylinder{<0,6,-10>,<0,6,-8>,6/1.6}
    texture{door_tex}
  }
  #declare wr=2.5
  cylinder{
    <-25,6-wr+6/1.6,-10>,<-25,6-wr+6/1.6,-8>,wr
    texture{door_tex}
  }
  box{
    <-25-wr,6-2*wr+6/1.6,-10>,<-25+wr,6-wr+6/1.6,-8>
    texture{door_tex}
  }

  cylinder{
    <-13,6-wr+6/1.6,-10>,<-13,6-wr+6/1.6,-8>,wr
    texture{door_tex}
  }
  box{
    <-13-wr,6-2*wr+6/1.6,-10>,<-13+wr,6-wr+6/1.6,-8>
    texture{door_tex}
  }
  translate <0,0,20*7>
}
union{

#declare d=28
union{
#declare c=40
  cylinder{<-d*1.5,4,c*1.5>,<-d*1.5,4,0>,.15}
#while (c>=0)
  cylinder{<-d*1.5,-1,c*1.5>,<-d*1.5,4,c*1.5>,.15}
#declare c=c-1
#end
  translate <-6/1.6,0,0>
}

union{
#declare c=d
  cylinder{<0,4,0>,<-c*1.5,4,0>,.15}
#while (c>=0)
  cylinder{<-c*1.5,-1,0>,<-c*1.5,4,0>,.15}
#declare c=c-1
#end
  translate <-6/1.6,0,0>
}

union{
#declare c=d
  cylinder{<0,4,0>,<-c*1.5,4,0>,.15}
#while (c>=0)
  cylinder{<-c*1.5,-1,0>,<-c*1.5,4,0>,.15}
#declare c=c-1
#end
  translate <-6/1.6,0,40*1.5>
}

#declare d=12
union{
#declare c=40
  cylinder{<d*1.5,4,c*1.5>,<d*1.5,4,0>,.15}
#while (c>=0)
  cylinder{<d*1.5,-1,c*1.5>,<d*1.5,4,c*1.5>,.15}
#declare c=c-1
#end
  translate <6/1.6,0,0>
}

union{
#declare c=d
  cylinder{<0,4,0>,<c*1.5,4,0>,.15}
#while (c>=0)
  cylinder{<c*1.5,-1,0>,<c*1.5,4,0>,.15}
#declare c=c-1
#end
  translate <6/1.6,0,0>
}

union{
#declare c=d
  cylinder{<0,4,0>,<c*1.5,4,0>,.15}
#while (c>=0)
  cylinder{<c*1.5,-1,0>,<c*1.5,4,0>,.15}
#declare c=c-1
#end
  translate <6/1.6,0,40*1.5>
}

difference{
  torus{6/1.6,.3
    rotate <90,0,0>
  }
  plane{y,0}
  translate <0,6,0>
}
cylinder{<-6/1.6,0,0>,<-6/1.6,6,0>,.3}
cylinder{<6/1.6,0,0>,<6/1.6,6,0>,.3}
texture{Rusty_Iron //finish{ambient 1}
}
translate <0,0,20*5>
}

#declare wcross=union{

#declare r1=seed(234)
#declare r2=seed(682)
#declare r3=seed(892)
#declare r4=seed(5635)

#declare dj=200
#declare di=110
#declare i=0
#while (i<16)
  #declare j=0
  #while (j<15)
  #declare v1=rand(r1)
  #declare v2=rand(r2)
  #declare v3=rand(r3)
  #declare v4=rand(r4)

#switch (v4)
#range(0,.3) // wooden cross
    box{<-3, -1, -3> < 3,  50,  3>
      rotate<-25+50*v1,-45+90*v2,-25+50*v3>
      translate <(8-i)*di-di/2,-.7,j*dj+40>
      texture{ DMFWood6 scale 10 rotate x*93}
    }
    box{<-15, 35-3, -3.1> < 15, 35+3,  3>
      rotate<-25+50*v1,-45+90*v2,-25+50*v3>
      translate <(8-i)*di-di/2,-.7,j*dj+40>
      texture{ DMFWood6 scale 20 rotate x*10}
    }
#break
#range(.3,.65) // tombstone
difference{
 union{
   box{<-15,-1,-3> <15,35+3,3>
      rotate<-25+50*v1,-45+90*v2,-25+50*v3>
      translate <(8-i)*di-di/2,-.7,j*dj+40>
      texture{T_Stone17 scale 20 }
   }
   cylinder{<0,0,-3>,<0,0,3>,1
      scale<15,12,1>
      translate<0,35+3,0>
      rotate<-25+50*v1,-45+90*v2,-25+50*v3>
      translate <(8-i)*di-di/2,-.7,j*dj+40>
      texture{T_Stone17 scale 20 }
   }
  }
// create a TrueType text shape
text
{
  ttf          // font type (only TrueType format for now)
  "arial.ttf", // Microsoft Windows-format TrueType font file name
  "RIP",       // the string to create
  .19,           // the extrusion depth
  <.2,0,0>            // offset
  scale 10
  translate <-10,30,-4>
      rotate<-25+50*v1,-45+90*v2,-25+50*v3>
      translate <(8-i)*di-di/2,-.7,j*dj+40>
  texture{pigment{color Black} finish{ambient 0}}
}
}
#break
#range(.65,.95)
  union{
    cylinder{<0,-1,0>,<0,60,0>,2}
    cylinder{<-15,43,0>,<15,43,0>,2}
    rotate<-25+50*v1,-45+90*v2,-25+50*v3>
    translate <(8-i)*di-di/2,-.7,j*dj+40>
    texture{Rusty_Iron scale 20}
  }
#break
#range(.95,1)
   object{griech_saeule
    rotate<-25+50*v1,-45+90*v2,-25+50*v3>
    translate <(8-i)*di-di/2,-.7,j*dj+40>
     texture{
       pigment{color White}
     }
   }

#end

    #declare j=j+1
    #end
  #declare i=i+1
#end

}

#declare Orig_Fog = 1
#declare Ground_Mist= 2

#declare first_fog=fog{
    fog_type Ground_Mist
    fog_alt .6//.4//1 //0.35 // fr zweifach 0.95
    fog_offset .6//-7 //-4.5
    distance 3 //1.5
    //color LightSteelBlue
    color Gray60 filter 0.3
    //color Red*0.8 filter 0.4
    //color rgbf<-0.5,0,0.5,0.4>
    turbulence 0.9//0.15
    omega .6//0.35
    lambda 1.7//1.25
    octaves 6
}

#declare second_fog=fog{
    fog_type Ground_Mist
    fog_alt 0.4
    fog_offset -4.5
    distance 1.5
    //color LightSteelBlue
    color Orange filter 0.4
    turbulence 0.2
    omega 0.4
    lambda 1.25
    octaves 5
}

#declare Clouds =
pigment {
    bozo
    turbulence 0.5
    color_map {
        [0.2 color rgbf <0.8, 0.8, 0.8, 0.0>]
        [0.5 color rgbf <1.0, 1.0, 1.0, 1.0>]
    }
}

#declare Sky=
sphere { <0,-20,0>,310
  hollow
  texture{ Clouds
  finish {ambient 0.4 }
  rotate <-3,0,0>
  scale 30
  }
  scale <10,1,10>
}

#declare moon =
normal {
    marble 300
    scale 3
    turbulence 1.8
//    normal_map { moon_Map }
}

#declare Moon = sphere
{ <0,1,2>,2
  texture{
    pigment{
//    color Gray35
      bozo
      scale 3
      turbulence 1.8
      color_map{
        [0 Gray30]
        [.3 Gray30]
        [.4 Gray35]
        [1 Gray35]
     }
    }
    normal {
      bozo 500
      scale 2.5
      turbulence 1.8
    }
  }
}

background{ color rgb <0,0,0.2>}

// create a regular point light source
light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <-50, 200, 400>
}

camera
{
  location  <0.0 , 5.0 ,-5.0> look_at   <0.0 , 1 , 15>
//  location <30,5,15*4>  look_at <30,1,20*7>
  translate <0,3,0>
}



object{wall}
object{wcross scale 1/10 translate <0,-1,10>}
fog{ first_fog}
object{Sky rotate <0,30,0>translate z*-100}
object{Moon scale 120 translate <600,400,3000> finish {ambient 2} }
object{chapel}
