// This file is written by Micha Riser
// Visit my homepage:
// http://www.geocities.com/SiliconValley/Pines/7992/
// my email address: mriser@usa.net

// ==== Standard POV-Ray Includes ====
#include "colors.inc"   // Standard Color definitions
#include "textures.inc" // Standard Texture definitions
#include "woods.inc"
#include "golds.inc"
#include "stones.inc"
#include "glass.inc"

//global_settings{max_trace_level 20}

camera
{
//  location  <1 , 1.75 ,-5>
location <0.9,1.8,-5>
  look_at   <0 , 0 , .0>

//location  <1.5 , 0 ,-2>
//look_at   <1.5 , 0 , .0>


/*location <0,13,0>
look_at <0,0,0>
orthographic*/

//location <-5,0.5,1>
//look_at<0,0,0>

}


// create a regular point light source

/*
light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <1,2.5,-4>
}
*/


#declare kaktnorm1= normal{radial
  slope_map{
     [0   <0,0>]
     [0.5 <1,0>]
     [0.5 <1,0>]
     [1   <0,0>]

   }
  frequency 15
 }

#declare kaktnorm2= normal{gradient y
  slope_map{
     [0   <0.5,0>] //0.7 !
     [0.5 <1,0>]
     [0.5 <1,0>]
     [1   <0.5,0>] //0.7 !

   }
  turbulence 0.15
  frequency 8
 }



#declare kakt=texture{pigment{rgb<0.465,0.813,0.094>}
normal{
 average
 normal_map{
 [kaktnorm1]
 [kaktnorm2]
// [bumps 0.75 scale 0.075]
  }
 }
}


#declare hut=union{
lathe {
 cubic_spline
 14,
 <0   ,0.48>
 <0   ,0.48>
 <0.05,0.51>
 <0.12,0.52>
 <0.20,0.47>
 <0.28,0.31>
 <0.36,0.09>
 <0.44,0.04>
 <0.52,0.02>
// <0.60,0.05>
 <0.68,0.025>
 <0.80,0.025>
 <0.94,0.08>
 <0.94,0.08>
 <0.94,0.08>
// <0.94,0.08>
// pigment{rgb<0.75,0.75,0.75>}
texture{pigment{rgb<1,0.855,0.498>} finish{ambient rgb<1,1,0.5>*0.22}}
scale <0.8,1,1.05>
//rotate x*90
}



prism{quadratic_spline
  linear_sweep
  0,3.1
  24
  <0,1.2>,
  <0,0>,<0.4,-.2>,<0.8,0>,<0.8,1.2>,<1.35,1.2>,<1.7,1.6>,<1.8,3.2>,<1.5,3.5>,<1.2,3.2>,<1.1,2.2>,<1,1.95>,<0.8,1.95>,<0.8,4.2>,<0.4,4.8>,
  <0,4.2>,<0,1.95>,  <-.4,1.95>,<-.4,3.6>,<-.7,4>,<-1,3.6>,<-1,1.2>,<0,1.2>,<0,0>

//texture{T_Gold_4D}
texture{T_Gold_5A}
scale 0.075
rotate x*-70
translate <-.05,0.07,-.15>
}

}

#declare kaktobj=union{
sphere{<0,0,0>,0.1 scale<1,0.05,0.05> rotate z*40}
sphere{<0,0,0>,0.1 scale<1,0.05,0.05> rotate z*38 rotate x*120}
sphere{<0,0,0>,0.1 scale<1,0.05,0.05> rotate z*41 rotate x*170}
sphere{<0,0,0>,0.1 scale<1,0.05,0.05> rotate z*35 rotate x*-86}

pigment{Red}

}

#declare sr=seed(2)

//---- Kaktus 1 ----
#declare kaktus1=
union{

#declare hohe=3.5
union{


#declare sz=0
#while (sz<hohe)
#declare sz=sz+0.01
union{
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*30}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*28 rotate x*120}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*31 rotate x*170}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*25 rotate x*-86}
pigment{rgb<0.8,1,0.8>}
translate<.27,sz,0> rotate y*(4800*sz+12)}
#end


cylinder{<0,0,0>,<0,hohe,0>,.27}
sphere{<0,0,0>,.27 scale<1,0.999,1>}
sphere{<0,0,0>,.27 scale<1,0.999,1> translate <0,hohe,0>}
texture{kakt}


scale 0.7
translate<0,-1,0>
}

#declare hohe=1
union{

#declare sz=0
#while (sz<hohe)
#declare sz=sz+0.01
union{
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*30}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*28 rotate x*120}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*31 rotate x*170}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*25 rotate x*-86}
pigment{rgb<0.8,1,0.8>}
translate<.27,sz,0> rotate y*(4800*sz+12)}
#end

cylinder{<0,0,0>,<0,hohe,0>,.27}
sphere{<0,0,0>,.27 scale<1,0.999,1>}
sphere{<0,0,0>,.27 scale<1,0.999,1> translate <0,hohe,0>}
texture{kakt}

rotate x*15
scale 0.7
translate<0,1.45,0>
}


#declare hohe=1.4
union{

#declare sz=0
#while (sz<hohe)
#declare sz=sz+0.01
union{
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*30}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*28 rotate x*120}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*31 rotate x*170}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*25 rotate x*-86}
pigment{rgb<0.8,1,0.8>}
translate<.25,sz,0> rotate y*(4800*sz+12)}
#end

cylinder{<0,0,0>,<0,hohe,0>,.25}
sphere{<0,0,0>,.25 scale<1,0.999,1>}
sphere{<0,0,0>,.25 scale<1,0.999,1> translate <0,hohe,0>}
texture{kakt}

scale 0.65
rotate z*70
translate<-.25,0.2,0>
}


#declare hohe=1.85
union{

#declare sz=0
#while (sz<hohe)
#declare sz=sz+0.01
union{
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*30}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*28 rotate x*120}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*31 rotate x*170}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*25 rotate x*-86}
pigment{rgb<0.8,1,0.8>}
translate<.25,sz,0> rotate y*(4800*sz+12)}
#end
#declare sz=3 #while (sz<90)
#declare sz=sz+18
#declare sz2=0 #while (sz2<360)
#declare sz2=sz2+(360/15)*(int(sz/30)+1)
union{
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*30}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*28 rotate x*120}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*31 rotate x*170}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*25 rotate x*-86}
translate<.25,0,0> rotate z*sz translate<0,hohe,0> rotate y*(sz2+12)
}
#end #end


cylinder{<0,0,0>,<0,hohe,0>,.25}
sphere{<0,0,0>,.25 scale<1,0.999,1>}
sphere{<0,0,0>,.25 scale<1,0.999,1> translate <0,hohe,0>}
texture{kakt}

scale 0.65
rotate x*10
rotate z*-10
translate<-1.10512,0.511238,0>
}


#declare hohe=1.3
union{

 union{

#declare sz=0
#while (sz<hohe)
#declare sz=sz+0.01
union{
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*30}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*28 rotate x*120}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*31 rotate x*170}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*25 rotate x*-86}
pigment{rgb<0.8,1,0.8>}
translate<.25,sz,0> rotate y*(4800*sz+12)}
#end

 cylinder{<0,0,0>,<0,1.3,0>,.25}
 sphere{<0,0,0>,.25 scale<1,0.999,1>}
 sphere{<0,0,0>,.25 scale<1,0.999,1> translate <0,1.3,0>}
 texture{kakt}
 rotate z*-90
 }
 union{

#declare sz=0
#while (sz<2)
#declare sz=sz+0.01
union{
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*30}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*28 rotate x*120}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*31 rotate x*170}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*25 rotate x*-86}
translate<.25,sz,0> rotate y*(4800*sz+12)
pigment{rgb<0.8,1,0.8>}}
#end

#declare sz=3 #while (sz<90)
#declare sz=sz+18
#declare sz2=0 #while (sz2<360)
#declare sz2=sz2+(360/15)*(int(sz/30)+1)
union{
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*30}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*28 rotate x*120}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*31 rotate x*170}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*25 rotate x*-86}
translate<.25,0,0> rotate z*sz translate<0,2,0> rotate y*(sz2+12)
}
#end #end

 cylinder{<0,0,0>,<0,2,0>,.25}
 sphere{<0,0,0>,.25 scale<1,0.999,1>}
 sphere{<0,0,0>,.25 scale<1,0.999,1> translate <0,2,0>}
 texture{kakt}
 translate<1.3,0,0>
 }

rotate y*-10
scale 0.65
translate<.25,0.1,0>
}

object{hut rotate x*5 rotate z*35 translate <-0.2,2.05,0> //finish{ambient 0.5}
texture{finish{ambient 1}}
}

}

//---- Kaktus 2 ----

#declare kaktus2=union{


#declare hohe=4.5
union{

#declare sz=0
#while (sz<hohe)
#declare sz=sz+0.01
union{
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*30}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*28 rotate x*120}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*31 rotate x*170}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*25 rotate x*-86}
pigment{rgb<0.8,1,0.8>}
translate<.27,sz,0> rotate y*(4800*sz+12)}
#end

cylinder{<0,0,0>,<0,hohe,0>,.27}
sphere{<0,0,0>,.27 scale<1,0.999,1>}
sphere{<0,0,0>,.27 scale<1,0.999,1> translate <0,hohe,0>}
texture{kakt}

scale 0.7
translate<0,-1,0>
}


#declare hohe=1.4
union{

#declare sz=0
#while (sz<hohe)
#declare sz=sz+0.01
union{
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*30}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*28 rotate x*120}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*31 rotate x*170}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*25 rotate x*-86}
pigment{rgb<0.8,1,0.8>}
translate<.25,sz,0> rotate y*(4800*sz+12)}
#end

cylinder{<0,0,0>,<0,hohe,0>,.25}
sphere{<0,0,0>,.25 scale<1,0.999,1>}
sphere{<0,0,0>,.25 scale<1,0.999,1> translate <0,hohe,0>}
texture{kakt}

scale 0.65
rotate z*-110
translate<.25,0.4,0>
}

#declare hohe=1.2
union{

union{

#declare sz=0
#while (sz<hohe)
#declare sz=sz+0.01
union{
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*30}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*28 rotate x*120}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*31 rotate x*170}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*25 rotate x*-86}
pigment{rgb<0.8,1,0.8>}
translate<.25,sz,0> rotate y*(4800*sz+12)}
#end

cylinder{<0,0,0>,<0,hohe,0>,.25}
sphere{<0,0,0>,.25 scale<1,0.999,1>}
sphere{<0,0,0>,.25 scale<1,0.999,1> translate <0,hohe,0>}
texture{kakt}}

union{

#declare sz=0
#while (sz<.35)
#declare sz=sz+0.01
union{
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*30}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*28 rotate x*120}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*31 rotate x*170}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*25 rotate x*-86}
pigment{rgb<0.8,1,0.8>}
translate<.25,sz,0> rotate y*(4800*sz+12)}
#end

#declare sz=3 #while (sz<90)
#declare sz=sz+18
#declare sz2=0 #while (sz2<360)
#declare sz2=sz2+(360/15)*(int(sz/30)+1)
union{
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*30}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*28 rotate x*120}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*31 rotate x*170}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*25 rotate x*-86}
translate<.25,0,0> rotate z*sz translate<0,0.35,0> rotate y*(sz2+12)
}
#end #end

cylinder{<0,0,0>,<0,0.35,0>,.25}
sphere{<0,0,0>,.25 scale<1,0.999,1>}
sphere{<0,0,0>,.25 scale<1,0.999,1> translate <0,0.35,0>}
texture{kakt}

rotate x*-60
translate<0,hohe,0>
}


scale 0.65
rotate z*-50
rotate y*15
translate<1.1051,0.08876,0>
}

#declare hohe=1.4
union{

#declare sz=0
#while (sz<hohe)
#declare sz=sz+0.01
union{
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*30}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*28 rotate x*120}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*31 rotate x*170}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*25 rotate x*-86}
pigment{rgb<0.8,1,0.8>}
translate<.25,sz,0> rotate y*(4800*sz+12)}
#end

cylinder{<0,0,0>,<0,hohe,0>,.25}
sphere{<0,0,0>,.25 scale<1,0.999,1>}
sphere{<0,0,0>,.25 scale<1,0.999,1> translate <0,hohe,0>}
texture{kakt}

scale 0.65
rotate z*70
translate<-.25,0.4,0>
rotate y*-60
}


#declare hohe=1.7
union{
#declare sz=0
#while (sz<hohe)
#declare sz=sz+0.01
union{
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*30}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*28 rotate x*120}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*31 rotate x*170}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*25 rotate x*-86}
pigment{rgb<0.8,1,0.8>}
translate<.25,sz,0> rotate y*(4800*sz+12)}
#end
#declare sz=3 #while (sz<90)
#declare sz=sz+18
#declare sz2=0 #while (sz2<360)
#declare sz2=sz2+(360/15)*(int(sz/30)+1)
union{
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*30}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*28 rotate x*120}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*31 rotate x*170}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*25 rotate x*-86}
translate<.25,0,0> rotate z*sz translate<0,1.7,0> rotate y*(sz2+12)
}
#end #end
#declare sz=3 #while (sz<90)
#declare sz=sz+18
#declare sz2=0 #while (sz2<360)
#declare sz2=sz2+(360/15)*(int(sz/30)+1)
union{
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*30}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*28 rotate x*120}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*31 rotate x*170}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*25 rotate x*-86}
translate<.25,0,0> rotate z*-sz rotate y*(sz2+12)
}
#end #end


cylinder{<0,0,0>,<0,hohe,0>,.25}
sphere{<0,0,0>,.25 scale<1,0.999,1>}
sphere{<0,0,0>,.25 scale<1,0.999,1> translate <0,hohe,0>}
texture{kakt}

scale 0.65
rotate z*3
translate<-1.106,0.71123,0>
rotate y*-60
}

object{hut scale 0.92 rotate x*20 rotate y*-30
translate<0,2.05,0>
finish{ambient 0.5}}

}

//--- Kaktus 3

declare kaktus3=union{

union{

#declare hohe=4
union{

#declare sz=0
#while (sz<hohe-.1)
#declare sz=sz+0.01
union{
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*30}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*28 rotate x*120}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*31 rotate x*170}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*25 rotate x*-86}
pigment{rgb<0.8,1,0.8>}
translate<.27,sz,0> rotate y*(4800*sz+12)}
#end

cylinder{<0,0,0>,<0,hohe,0>,.27}
sphere{<0,0,0>,.27 scale<1,0.999,1>}
sphere{<0,0,0>,.27 scale<1,0.999,1> translate <0,hohe,0>}
texture{kakt}
scale 0.7
translate<0,-1,0>
}

#declare hohe=1.3
union{

#declare sz=0
#while (sz<hohe)
#declare sz=sz+0.01
union{
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*30}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*28 rotate x*120}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*31 rotate x*170}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*25 rotate x*-86}
pigment{rgb<0.8,1,0.8>}
translate<.25,sz,0> rotate y*(4800*sz+12)}
#end

cylinder{<0,0,0>,<0,hohe,0>,.25}
sphere{<0,0,0>,.25 scale<1,0.999,1>}
sphere{<0,0,0>,.25 scale<1,0.999,1> translate <0,hohe,0>}
texture{kakt}


scale 0.65
rotate z*130
translate<-.2,0.5,0>
rotate y*73
}

#declare hohe=1.1
union{

#declare sz=0
#while (sz<hohe)
#declare sz=sz+0.01
union{
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*30}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*28 rotate x*120}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*31 rotate x*170}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*25 rotate x*-86}
pigment{rgb<0.8,1,0.8>}
translate<.25,sz,0> rotate y*(4800*sz+12)}
#end

cylinder{<0,0,0>,<0,hohe,0>,.25}
sphere{<0,0,0>,.25 scale<1,0.999,1>}
sphere{<0,0,0>,.25 scale<1,0.999,1> translate <0,hohe,0>}
texture{kakt}

scale 0.65
rotate z*55
translate<-.8473,0.0014,0>
rotate y*73
}

#declare hohe=0.32
union{

#declare sz=0
#while (sz<hohe)
#declare sz=sz+0.01
union{
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*30}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*28 rotate x*120}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*31 rotate x*170}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*25 rotate x*-86}
pigment{rgb<0.8,1,0.8>}
translate<.25,sz,0> rotate y*(4800*sz+12)}
#end

cylinder{<0,0,0>,<0,hohe,0>,.25}
sphere{<0,0,0>,.25 scale<1,0.999,1>}
sphere{<0,0,0>,.25 scale<1,0.999,1> translate <0,hohe,0>}
texture{kakt}

scale 0.65

rotate z*-20

translate <0,0.715,0>
rotate z*55
translate<-.8473,0.0014,0>
rotate y*73
}

#declare hohe=1.1
union{

#declare sz=0
#while (sz<hohe)
#declare sz=sz+0.01
union{
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*30}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*28 rotate x*120}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*31 rotate x*170}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*25 rotate x*-86}
pigment{rgb<0.8,1,0.8>}
translate<.25,sz,0> rotate y*(4800*sz+12)}
#end

cylinder{<0,0,0>,<0,hohe,0>,.25}
sphere{<0,0,0>,.25 scale<1,0.999,1>}
sphere{<0,0,0>,.25 scale<1,0.999,1> translate <0,hohe,0>}
texture{kakt}

scale 0.65
rotate z*-100
translate<.2,0.4,0>
rotate y*125
}

#declare hohe=1.5
union{

#declare sz=0
#while (sz<hohe)
#declare sz=sz+0.01
union{
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*30}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*28 rotate x*120}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*31 rotate x*170}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*25 rotate x*-86}
pigment{rgb<0.8,1,0.8>}
translate<.25,sz,0> rotate y*(4800*sz+12)}
#end

#declare sz=3 #while (sz<90)
#declare sz=sz+18
#declare sz2=0 #while (sz2<360)
#declare sz2=sz2+(360/15)*(int(sz/30)+1)
union{
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*30}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*28 rotate x*120}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*31 rotate x*170}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*25 rotate x*-86}
translate<.25,0,0> rotate z*sz translate<0,1.5,0> rotate y*(sz2+12)
}
#end #end

#declare sz=3 #while (sz<90)
#declare sz=sz+18
#declare sz2=0 #while (sz2<360)
#declare sz2=sz2+(360/15)*(int(sz/30)+1)
union{
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*30}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*28 rotate x*120}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*31 rotate x*170}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*25 rotate x*-86}
translate<.25,0,0> rotate -z*sz rotate y*(sz2+12)
}
#end #end


cylinder{<0,0,0>,<0,hohe,0>,.25}
sphere{<0,0,0>,.25 scale<1,0.999,1>}
sphere{<0,0,0>,.25 scale<1,0.999,1> translate <0,hohe,0>}
texture{kakt}

scale 0.65
rotate z*-5
translate<0.904137,0.2758,0>
rotate y*125
}


translate<2,0,-1.8>
}

object{hut scale 0.9
rotate x*-25 
translate<0,0,0.1>
rotate y*-90 translate <2,1.55,-1.8> finish{ambient 0.5}}

}


//-------- Kaktus 4 ----------

#declare kaktus4=union{

#declare hohe=0.75
union{

#declare sz=0
#while (sz<hohe)
#declare sz=sz+0.01
union{
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*30}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*28 rotate x*120}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*31 rotate x*170}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*25 rotate x*-86}
pigment{rgb<0.8,1,0.8>}
translate<.27,sz,0> rotate y*(4800*sz+12)}
#end

cylinder{<0,0,0>,<0,hohe,0>,.27}
sphere{<0,0,0>,.27 scale<1,0.999,1>}
sphere{<0,0,0>,.27 scale<1,0.999,1> translate <0,hohe,0>}
texture{kakt}
scale 0.7
rotate x*20
translate<0,-1,0>
}

#declare hohe=0.8
union{

#declare sz=0
#while (sz<hohe)
#declare sz=sz+0.01
union{
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*30}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*28 rotate x*120}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*31 rotate x*170}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*25 rotate x*-86}
pigment{rgb<0.8,1,0.8>}
translate<.27,sz,0> rotate y*(4800*sz+12)}
#end

cylinder{<0,0,0>,<0,hohe,0>,.27}
sphere{<0,0,0>,.27 scale<1,0.999,1>}
sphere{<0,0,0>,.27 scale<1,0.999,1> translate <0,hohe,0>}
texture{kakt}
scale 0.7
rotate x*76
translate<0,0.49333-1,0.1796>
}

#declare hohe=2.5
union{

#declare sz=0
#while (sz<hohe)
#declare sz=sz+0.01
union{
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*30}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*28 rotate x*120}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*31 rotate x*170}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*25 rotate x*-86}
pigment{rgb<0.8,1,0.8>}
translate<.27,sz,0> rotate y*(4800*sz+12)}
#end

cylinder{<0,0,0>,<0,hohe,0>,.27}
sphere{<0,0,0>,.27 scale<1,0.999,1>}
sphere{<0,0,0>,.27 scale<1,0.999,1> translate <0,hohe,0>}
texture{kakt}
scale 0.7
rotate x*-5
translate<0,-0.25,0.8>

}

#declare hohe=1.2
union{

#declare sz=0
#while (sz<hohe)
#declare sz=sz+0.01
union{
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*30}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*28 rotate x*120}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*31 rotate x*170}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*25 rotate x*-86}
pigment{rgb<0.8,1,0.8>}
translate<.25,sz,0> rotate y*(4800*sz+12)}
#end

cylinder{<0,0,0>,<0,hohe,0>,.25}
sphere{<0,0,0>,.25 scale<1,0.999,1>}
sphere{<0,0,0>,.25 scale<1,0.999,1> translate <0,hohe,0>}
texture{kakt}

scale 0.65
rotate z*50
translate<-.25,0.1,0>
rotate y*-23
translate<0,0,0.8>
}


#declare hohe=1.1
union{

#declare sz=0
#while (sz<hohe)
#declare sz=sz+0.01
union{
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*30}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*28 rotate x*120}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*31 rotate x*170}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*25 rotate x*-86}
pigment{rgb<0.8,1,0.8>}
translate<.25,sz,0> rotate y*(4800*sz+12)}
#end

#declare sz=3 #while (sz<90)
#declare sz=sz+18
#declare sz2=0 #while (sz2<360)
#declare sz2=sz2+(360/15)*(int(sz/30)+1)
union{
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*30}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*28 rotate x*120}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*31 rotate x*170}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*25 rotate x*-86}
translate<.25,0,0> rotate z*-sz rotate y*(sz2+12)
}
#end #end


cylinder{<0,0,0>,<0,hohe,0>,.25}
sphere{<0,0,0>,.25 scale<1,0.999,1>}
sphere{<0,0,0>,.25 scale<1,0.999,1> translate <0,hohe,0>}
texture{kakt}

rotate x*-120

translate <0,1.2,0>
scale 0.65
rotate z*50
translate<-.25,0.1,0>
rotate y*-23
translate<0,0,0.8>
}

#declare hohe=0.3
union{

#declare sz=0
#while (sz<hohe)
#declare sz=sz+0.01
union{
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*30}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*28 rotate x*120}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*31 rotate x*170}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*25 rotate x*-86}
pigment{rgb<0.8,1,0.8>}
translate<.25,sz,0> rotate y*(4800*sz+12)}
#end

#declare sz=3 #while (sz<90)
#declare sz=sz+18
#declare sz2=0 #while (sz2<360)
#declare sz2=sz2+(360/15)*(int(sz/30)+1)
union{
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*30}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*28 rotate x*120}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*31 rotate x*170}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*25 rotate x*-86}
translate<.25,0,0> rotate z*sz translate<0,.3,0> rotate y*(sz2+12)
}
#end #end
#declare sz=3 #while (sz<90)
#declare sz=sz+18
#declare sz2=0 #while (sz2<360)
#declare sz2=sz2+(360/15)*(int(sz/30)+1)
union{
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*30}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*28 rotate x*120}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*31 rotate x*170}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*25 rotate x*-86}
translate<.25,0,0> rotate z*-sz rotate y*(sz2+12)
}
#end #end

cylinder{<0,0,0>,<0,hohe,0>,.25}
sphere{<0,0,0>,.25 scale<1,0.999,1>}
sphere{<0,0,0>,.25 scale<1,0.999,1> translate <0,hohe,0>}
texture{kakt}

rotate x*-30

translate <0,1.1,0>

rotate x*-120
translate <0,1.2,0>
scale 0.65
rotate z*50
translate<-.25,0.1,0>
rotate y*-23
translate<0,0,0.8>
}


#declare hohe=1.2
union{

#declare sz=0
#while (sz<hohe)
#declare sz=sz+0.01
union{
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*30}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*28 rotate x*120}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*31 rotate x*170}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*25 rotate x*-86}
pigment{rgb<0.8,1,0.8>}
translate<.25,sz,0> rotate y*(4800*sz+12)}
#end

cylinder{<0,0,0>,<0,hohe,0>,.25}
sphere{<0,0,0>,.25 scale<1,0.999,1>}
sphere{<0,0,0>,.25 scale<1,0.999,1> translate <0,hohe,0>}
texture{kakt}

scale 0.65
rotate z*-120
translate<.25,0.2,0>
rotate y*5
translate<0,0,0.8>
}

#declare hohe=1.25
union{

#declare sz=0
#while (sz<hohe)
#declare sz=sz+0.01
union{
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*30}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*28 rotate x*120}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*31 rotate x*170}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*25 rotate x*-86}
pigment{rgb<0.8,1,0.8>}
translate<.25,sz,0> rotate y*(4800*sz+12)}
#end

cylinder{<0,0,0>,<0,hohe,0>,.25}
sphere{<0,0,0>,.25 scale<1,0.999,1>}
sphere{<0,0,0>,.25 scale<1,0.999,1> translate <0,hohe,0>}
texture{kakt}

rotate x*-95
rotate y*30
translate <0,1.2,0>
scale 0.65
rotate z*-120
translate<.25,0.2,0>
rotate y*5
translate<0,0,0.8>
}

#declare hohe=.3
union{

#declare sz=0
#while (sz<hohe)
#declare sz=sz+0.01
union{
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*30}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*28 rotate x*120}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*31 rotate x*170}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*25 rotate x*-86}
pigment{rgb<0.8,1,0.8>}
translate<.25,sz,0> rotate y*(4800*sz+12)}
#end

#declare sz=3 #while (sz<90)
#declare sz=sz+18
#declare sz2=0 #while (sz2<360)
#declare sz2=sz2+(360/15)*(int(sz/30)+1)
union{
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*30}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*28 rotate x*120}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*31 rotate x*170}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*25 rotate x*-86}
translate<.25,0,0> rotate z*sz translate<0,.3,0> rotate y*(sz2+12)
}
#end #end
#declare sz=3 #while (sz<90)
#declare sz=sz+18
#declare sz2=0 #while (sz2<360)
#declare sz2=sz2+(360/15)*(int(sz/30)+1)
union{
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*30}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*28 rotate x*120}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*31 rotate x*170}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*25 rotate x*-86}
translate<.25,0,0> rotate z*-sz rotate y*(sz2+12)
}
#end #end


cylinder{<0,0,0>,<0,hohe,0>,.25}
sphere{<0,0,0>,.25 scale<1,0.999,1>}
sphere{<0,0,0>,.25 scale<1,0.999,1> translate <0,hohe,0>}
texture{kakt}

rotate z*30
rotate x*-45
translate<0,1.25,0>
rotate x*-95
rotate y*30
translate <0,1.2,0>
scale 0.65
rotate z*-120
translate<.25,0.2,0>
rotate y*5
translate<0,0,0.8>
}


object{hut scale 0.85
rotate z*18
rotate x*-8
translate <0,1.6,0>
rotate x*-5
translate <0,0,0.8>
 }

}

//------ Kaktus 5 ------

#declare kaktus5=union
{

#declare hohe=1
union{

#declare sz=0
#while (sz<hohe)
#declare sz=sz+0.01
union{
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*30}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*28 rotate x*120}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*31 rotate x*170}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*25 rotate x*-86}
pigment{rgb<0.8,1,0.8>}
translate<.27,sz,0> rotate y*(4800*sz+12)}
#end

cylinder{<0,0,0>,<0,hohe,0>,.27}
sphere{<0,0,0>,.27 scale<1,0.999,1>}
sphere{<0,0,0>,.27 scale<1,0.999,1> translate <0,hohe,0>}
texture{kakt}
scale 0.7
rotate z*-20
translate<0,-.75,0>
}


#declare hohe=3.1
union{

#declare sz=0
#while (sz<hohe)
#declare sz=sz+0.01
union{
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*30}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*28 rotate x*120}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*31 rotate x*170}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*25 rotate x*-86}
pigment{rgb<0.8,1,0.8>}
translate<.27,sz,0> rotate y*(4800*sz+12)}
#end

cylinder{<0,0,0>,<0,hohe,0>,.27}
sphere{<0,0,0>,.27 scale<1,0.999,1>}
sphere{<0,0,0>,.27 scale<1,0.999,1> translate <0,hohe,0>}
texture{kakt}
scale 0.7
translate<0,-hohe+.75+.1,0>
rotate z*-90
translate<0,-.75,0>
}


#declare hohe=1
union{

#declare sz=0
#while (sz<hohe)
#declare sz=sz+0.01
union{
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*30}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*28 rotate x*120}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*31 rotate x*170}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*25 rotate x*-86}
pigment{rgb<0.8,1,0.8>}
translate<.27,sz,0> rotate y*(4800*sz+12)}
#end

cylinder{<0,0,0>,<0,hohe,0>,.27}
sphere{<0,0,0>,.27 scale<1,0.999,1>}
sphere{<0,0,0>,.27 scale<1,0.999,1> translate <0,hohe,0>}
texture{kakt}

rotate z*130
scale 0.7
translate<-2.25,-.75,0>
}



#declare hohe=1.5-.35
union{

#declare sz=0
#while (sz<hohe)
#declare sz=sz+0.01
union{
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*30}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*28 rotate x*120}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*31 rotate x*170}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*25 rotate x*-86}
pigment{rgb<0.8,1,0.8>}
translate<.25,sz,0> rotate y*(4800*sz+12)}
#end

cylinder{<0,0,0>,<0,hohe,0>,.25}
sphere{<0,0,0>,.25 scale<1,0.999,1>}
sphere{<0,0,0>,.25 scale<1,0.999,1> translate <0,hohe,0>}
texture{kakt}

translate <0,.35,0>
scale 0.65
rotate z*-95
rotate y*50
translate<-1.65,-.75,0>
}


#declare hohe=1.45
union{

#declare sz=0
#while (sz<hohe)
#declare sz=sz+0.01
union{
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*30}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*28 rotate x*120}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*31 rotate x*170}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*25 rotate x*-86}
pigment{rgb<0.8,1,0.8>}
translate<.25,sz,0> rotate y*(4800*sz+12)}
#end

#declare sz=3 #while (sz<90)
#declare sz=sz+18
#declare sz2=0 #while (sz2<360)
#declare sz2=sz2+(360/15)*(int(sz/30)+1)
union{
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*30}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*28 rotate x*120}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*31 rotate x*170}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*25 rotate x*-86}
translate<.25,0,0> rotate z*sz translate<0,1.45,0> rotate y*(sz2+12)
}
#end #end

cylinder{<0,0,0>,<0,hohe,0>,.25}
sphere{<0,0,0>,.25 scale<1,0.999,1>}
sphere{<0,0,0>,.25 scale<1,0.999,1> translate <0,hohe,0>}
texture{kakt}

rotate x*75
translate<0,1.5-.35,0>
translate<0,.35,0>
scale 0.65
rotate z*-95
rotate y*50
translate<-1.65,-.75,0>
}


#declare hohe=1.5-.35
union{

#declare sz=0
#while (sz<hohe)
#declare sz=sz+0.01
union{
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*30}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*28 rotate x*120}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*31 rotate x*170}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*25 rotate x*-86}
pigment{rgb<0.8,1,0.8>}
translate<.25,sz,0> rotate y*(4800*sz+12)}
#end

cylinder{<0,0,0>,<0,hohe,0>,.25}
sphere{<0,0,0>,.25 scale<1,0.999,1>}
sphere{<0,0,0>,.25 scale<1,0.999,1> translate <0,hohe,0>}
texture{kakt}

translate <0,.35,0>
scale 0.65
rotate z*(93)
rotate y*(180-20)
translate<-1.8,-.75,0>
}

#declare hohe=1.2
union{

#declare sz=0
#while (sz<hohe)
#declare sz=sz+0.01
union{
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*30}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*28 rotate x*120}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*31 rotate x*170}
sphere{<0,0,0>,0.08 scale<1,0.05,0.05> rotate z*25 rotate x*-86}
pigment{rgb<0.8,1,0.8>}
translate<.25,sz,0> rotate y*(4800*sz+12)}
#end

cylinder{<0,0,0>,<0,hohe,0>,.25}
sphere{<0,0,0>,.25 scale<1,0.999,1>}
sphere{<0,0,0>,.25 scale<1,0.999,1> translate <0,hohe,0>}
texture{kakt}

rotate x*20
translate<0,1.5-.35,0>
translate<0,.35,0>
scale 0.65
rotate z*93
rotate y*160
translate<-1.8,-.75,0>
}




object{hut scale 0.8
rotate y*90
rotate z*-20
translate<.2,0,0>
}

}

//------- Stein 1 -------

#declare stein1=

blob{ threshold 0.3
sphere{<0,0,0>,0.5,1}
sphere{<2.5,2.5>,3.5,-6}
//pigment{Gray}
texture{T_Stone13}
scale <2,1.3,1>
translate<0.1,-0.85,0.8>
}




//------- Stein 2 -------

#declare stein2=

blob{ threshold 0.3
sphere{<0,0,0>,0.5,1}
sphere{<2.5,2.5>,3.5,-6}
sphere{<0,-.1,-.3>,0.3,0.4}
sphere{<-1.75,1.75,-1.5>,2.75,-25}
//pigment{Gray}
texture{T_Stone13}
//rotate y*180
rotate y*90
scale <2.5,1.75,1.4>
scale 0.85
translate<0,-0.8,0>
rotate y*-65
translate<1.85,0,-1.75>

}



//------ Gitarre ------

#declare T12 = texture { T_Wood12  rotate x*90  finish { specular 0.15 roughness 0.025 ambient 0.25 } }
#declare T34 = texture { T_Wood34 scale 2.4 rotate y*90 translate <0,-1,0> finish { specular 0.15 roughness 0.025 ambient 0.25  reflection 0.1 }}

#declare gkorp=
prism{
 linear_sweep
 cubic_spline
 0,0.5,
 15
 <.28,-.6>

 <0,0>,
 <0.28,.6>,
// <0.52,.61>,
 <.8,.61>,
 <1.2,.46>,
 <1.74,.49>,
 <2.05,.24>,
 <2.08,0>,

 <2.05,-.24>,
 <1.74,-.49>,
 <1.2,-.46>,
 <.8,-.61>,
// <0.52,-.61>,
 <0.28,-.6>,
 <0,0>
 
 <0.28,.6>
}

#declare gitarre=union{

difference{
prism{
 linear_sweep
 linear_spline
 0.4,0.535,
 5
 <3,0.12>, <3,-.12>, <3.6,-.16>,<3.6,.16>,<3,0.12>}

prism{
 linear_sweep
 linear_spline
 0.3,0.55,
 5  
 <3.08,0.03>, <3.08,0.08>, <3.5,0.10>, <3.5,0.03>,<3.08,0.03>}

prism{
 linear_sweep
 linear_spline
 0.3,0.55,
 5  
 <3.08,-.03>, <3.08,-.08>, <3.5,-.10>, <3.5,-.03>,<3.08,-0.03>}

texture{T12}
} 

#declare dobj=cylinder{<0,-0.007,0>,<0,0.007,0>,0.04 scale<1,1,0.5>}

union{
cylinder{<3.2,0.47,-0.18><3.2,0.47,.18>,0.017}
cylinder{<3.3,0.47,-0.18><3.3,0.47,.18>,0.017}
cylinder{<3.4,0.47,-0.18><3.4,0.47,.18>,0.017}

object{dobj rotate z*67  translate <3.2,0.47,-0.2>}
object{dobj rotate z*167 translate <3.2,0.47,0.2>}
object{dobj rotate z*43  translate <3.3,0.47,-0.2>}
object{dobj rotate z*173 translate <3.3,0.47,0.2>}
object{dobj rotate z*05  translate <3.4,0.47,-0.2>}
object{dobj rotate z*34  translate <3.4,0.47,0.2>}

pigment{White}
}

cylinder{<3.2,0.54,-0.015>,<0.6,0.54,-0.015>,0.005 pigment{Gray}}
cylinder{<3.2,0.54,0.015>,<0.6,0.54,0.015>,0.005 pigment{Gray}}
cylinder{<3.3,0.54,-0.045>,<0.6,0.54,-0.045>,0.005 pigment{Gray}}
cylinder{<3.3,0.54,0.045>,<0.6,0.54,0.045>,0.005 pigment{Gray}}
cylinder{<3.4,0.54,0.08>,<0.6,0.54,0.08>,0.005 pigment{Gray}}
cylinder{<3.4,0.54,-0.08>,<0.6,0.54,-0.08>,0.005 pigment{Gray}}


difference{
object{gkorp}
object{gkorp scale 0.9 translate<0.05,0.025,0>}
cylinder{<1.5,0.1,0>,<1.5,3,0>,0.18}
texture{T34}


}

difference{
box{<1.5,0.5,0.12>,<2,0.535,-0.12>}
cylinder{<1.5,0.1,0>,<1.5,3,0>,0.18}
texture{T12}
}

#declare pos=3.2
#declare n=0
#while (n<14)
#declare n=n+1
#declare pos=pos-(0.1495*pow(0.9393,(n-1)))
box{<pos,0.535,0.115>,<pos-0.02,0.5355,-.115> texture{T_Gold_3B}}

#end

box{<0.55,0.2,0.28>,<0.65,0.535,-.26> texture{T12}}
box{<2,0.4,0.12>,<3,0.535,-.12> texture{T12}}

translate <-2,0,0>
}


//------------ Feuer ----------------------

#declare feuersteine=union{

#declare r= seed(120)
#declare r2= seed(1093)
#declare r3= seed(2377)

#declare za=0
#while (za<13)
#declare za=za+1
//intersection{
blob{ threshold 0.3
sphere{<rand(r)*0.05,rand(r)*0.06,rand(r)*0.03>,0.5+(rand(r)-.5)*0.05,1}
sphere{<2.5+(rand(r)-.5)*0.2,2.5+(rand(r)-.5)*0.13>,3.5+(rand(r)-.5)*0.1,-6+(rand(r)-.5)*0.3}
sphere{<rand(r)*0.01,-.1+(rand(r)-.5)*0.05,-.3+(rand(r)-.5)*0.07>,0.3+(rand(r)-.5)*0.09,0.4+(rand(r)-.5)*0.03}
sphere{<-1.75,1.75,-1.5>,2.75+(rand(r)*.5)*0.2,-25+(rand(r)*.5)*2}

sturm
//}

//sphere{<0,0,0>,0.5}
//bounded_by {sphere{<0,0,0>,0.3}}

scale 0.75+(rand(r)-.5)*0.1

rotate y*rand(r)*360
rotate x*rand(r)*360
rotate z*(rand(r)-.5)*180
//translate<.3,-.7,0>
translate <sin(za*0.48332)*1.2,-.85-rand(r2)*0.05,cos(za*0.48332)*1.2> 

//translate<1.5+(rand(r)-.5)*0.07,0,0>
//-.95+(rand(r)-.5)*0.05,0>
//rotate y*(za*(360/10))


//pigment{Gray}
texture{T_Stone13 finish{phong 0 phong_size 30}}

}

#end


}

#declare flammen=sphere{<0,0.01,0>,1.4
   pigment{ color rgbt<1,1,1,1>}
   halo{
    max_value 0.85
    emitting
    planar_mapping
    poly
    linear
//    exponent 2.5
    omega 0.95
    lambda 1.5
    turbulence <10,1,10>
    color_map{
     [0 color  rgbt <0.5,0,0,1>]
     [.85 color rgbt<1.75,1.5,0,0>*.8]
     [1 color rgbt <2,2,0,0>*.6]
//     [1 color  rgbt <0.5,0,0,1>]
//     [1 color rgbt<2,2,0,-0.5>*0.4]
    }
    translate<5,-.3,0>
    scale <1,.7,1>
    samples 20
   }
   hollow
scale <0.8,2,.8>
translate<0,-1,0>
}


#declare feuer=union{
//cylinder{<0,0.01,0>,<0,1.1,0>,1.4

object{flammen}

cylinder{<0,0.009-1,0>,<0,-1.2,0>,1.2
texture{granite
  texture_map{
  [0 pigment{rgb <0.6,0.6,0.6>} normal{bumps scale 2} finish{ambient 0.2}]
  [0.15 pigment{rgb <0.5,0.5,0.5>} normal{bumps}]
  [0.2 pigment{rgb<1,0.2,0>} finish{ambient 1.0} normal{bumps scale 0.5}]
  [0.23 pigment{rgb<1,0.4,0>} finish{ambient 0.9} normal{bumps}]
  [0.26 pigment{rgb<0.8,0.2,0>} finish{ambient 0.8}] 
  [0.3 pigment{rgb<0.5,0.3,0.1>} finish{ambient 0.7} normal{bumps scale 0.5}]
  [0.4 pigment{rgb<0.4,0.4,0.4>} normal{bumps} finish{ambient 0.3}]
  [1 pigment{rgb <0.6,0.6,0.6>} normal{bumps} finish{ambient 0.2}]
  }
  turbulence 1.5
  scale 0.5
   }

}


}


//light_source{<0,0.7,0> color rgb<1,1,0.65>*1.4
/*fade_distance 6
fade_power 0.5*/
//}

#declare ld=1.08

#declare feuerlicht=union{
light_source{<.23,.1,-0.12> color rgb<1,1,0.5>*0.1*ld }
//light_source{<-0.04,-.3,.1029> color rgb<1,1,0.5>*0.1*ld }
light_source{<.16,.4,.034> color rgb<1,1,0.5>*0.1*ld }
light_source{<0,.7,0> color rgb<1,1,0.5>*0.1*ld }

#declare fr=seed(1832)

#declare za=0
#while (za<360)
#declare za=za+72
light_source{
<0.3+(rand(fr)-.5)*0.1,(rand(fr)-.5)*0.2+.2,0>   color rgb<1,1,0.5>*0.1*ld rotate y*(za+rand(fr)*39)
}
light_source{
<0.2+(rand(fr)-.5)*0.1,(rand(fr)-.5)*0.2+0.35,0>   color rgb<1,1,0.5>*0.07*ld rotate y*(za+rand(fr)*39+35)
}
light_source{<0.1+(rand(fr)-.5)*0.1,(rand(fr)-.5)*0.2+.5,0>   color rgb<1,1,0.5>*0.04*ld rotate y*(za+rand(fr)*39+15)
}
//light_source{<0.4,-.3,0>  color rgb<1,1,0.5>*0.07*ld rotate y*(za+34)}
//light_source{<0.25,.3,0>  color rgb<1,1,0.5>*0.04*ld rotate y*(za+15)}
#end
}

//------------- Flasche ----

#declare flasche=
lathe{quadratic_spline
 11,
/* <0,.2>,//
<1.2,0.2>, 
<1.7,.35>,
 <2,.55>,
 <2.4,.7>,
 <3.6,.7>,
 <5.2,.7>,
 <5.35,.6>,
 <5.2,.2>,
 <5.2,0>
*/
 <.16,0>,
 <.23,0>,
<0.23,1.2>, 
<.35,1.7>,
 <.55,2>,
 <.7,2.4>,
 <.7,3.6>,
 <.7,5.2>,
 <.6,5.35>,
 <.2,5.2>,
 <0,5.2>
 
/* <0,5.3>,
 <.2,5.3>,
 <.65,5.4>,
 <.6,5.2>,
 <.6,3.6>,
 <.6,2.4>,
 <.465,1.98>,
 <0.3,1.65>,
 <0.16,1.2>,
 <0.16,0>,
 <0.23,0>*/

sturm

scale 0.2
rotate x*180
texture{T_Glass3}
//pigment{Blue}
}


//--------- Strucher 

#declare r1=seed(848)

#declare pflanz=0
#while (pflanz<5)
#declare pflanz=pflanz+1
union{

#declare z2=0
#while (z2<25)
#declare z2=z2+1

#declare xkor=0
#declare ykor=0
#declare zkor=0
#declare zahler=-1
#declare winkel1=0
#declare winkel2=0

blob{threshold 0.2
#while (zahler<20)
#declare zahler=zahler+1
#declare dwinkel1=(rand(r1)-0.5)*55
#declare dwinkel2=(rand(r1)-0.5)*55
#declare winkel1=winkel1+dwinkel1
#declare winkel2=winkel2+dwinkel2

 cylinder{<0,0,0>,<0,0,0.40+zahler*0.005>,0.2-(zahler*0.0099),1
 rotate x*winkel2
 rotate y*winkel1
 translate <xkor,ykor,zkor>}

#declare zkor=zkor+cos(radians(winkel1))*cos(radians(winkel2))*0.5
#declare xkor=xkor+cos(radians(winkel2))*sin(radians(winkel1))*0.5
#declare ykor=ykor+sin(radians(-winkel2))*0.5
#end

scale 0.35

#declare rotatex=-70
rotate x*rotatex
rotate y*z2*14.4
translate <0,0,1.5>
}
#end


scale 0.08

pigment{
//  wood
//  pigment_map{
//  [0 
rgb<0.572,0.418,0.165>*0.5
//Blue
// ]
//  [0.5 rgb<0.297,0.451,0.275>]
//  [1 rgb<0.572,0.418,0.165>]}
//  turbulence 0.5
//  scale 0.08*0.4
  }
finish{ambient .5}
scale 4
#if (pflanz=1)  translate <2,-1.05,2> #end
#if (pflanz=2) translate <-3,-1.05,-1.5> #end 
#if (pflanz=3) translate <0,-0.95,3> #end  
#if (pflanz=4)  translate <-5.1,-.5,1.2>  #end
#if (pflanz=5)  translate <-3,-.5,9>  #end
//#if (pflanz=6) translate<1.75,0.1,1.65> scale 0.7 #end
}

#end



//--------------------------------------------------------
//--------------------------------------------------------


#declare Starfield = 
texture {
    pigment {
	granite  
	color_map {
	    [ 0.00  0.80 color rgbft<0,0,0,1,1> color rgbft<0,0,0,1,1>]  // No Stars in this area
	    [ 0.80  0.81 color Gray20 color Gray40 ] // Very Very Faint Stars
	    [ 0.81  0.82 color Gray40 color Gray60 ] // Very Faint Stars
//              [0.78 0.81 color rgbft<0,0,0,1,1> color rgbft<0,0,0,1,1>]
	    [ 0.82  0.83 color Gray60 color Gray80 ] // Faint Stars
	    [ 0.83  0.84 color Gray80 color Gray95 ] // Medium White Stars
	    [ 0.84  0.85 color Gray95 color White  ] // White Stars 
	    [ 0.85  1.00 color rgbft<0,0,0,1,1> color rgbft<0,0,0,1,1>]  // No Stars in this area
	}
    scale .015
    }
    finish { ambient 1 }
}


sphere{<0,0,0>,100
texture{Starfield scale 150 rotate x*90}
no_shadow
hollow
}

sky_sphere{
 pigment{
   gradient y
   color_map{
    [0.5 color MidnightBlue*0.7]
    [.58 color Black]
   }
  scale 2
  translate -1
  }
}


object{kaktus1 
rotate y*-10
translate <0,0,2.4>
rotate y*-80
translate <0,0,-.75>
}

union{
object{kaktus2}
object{kaktus3}
translate (x+z)*1.3
translate <-0.5,0,0.9>
}


union{
object{kaktus4}
object{stein1}
object{gitarre rotate y*-20 rotate x*-75 scale 0.7 translate <0.4,0.2,0.45>}
scale 1.1

translate<0,0,1.7>
rotate y*-40
}


object{stein2 translate<0,0,0>}
object{kaktus5 
translate <1.3,-.1,-1.8>
}

object{feuer}
object{feuersteine
bounded_by{box{<-1.4,-1,-1.4>,<1.4,-0.6,1.4>}}
}
//box{<-1.4,-1,-1.4>,<1.4,-.625,1.4> pigment{Blue}}


object{flasche 
rotate z*90
rotate y*210
translate<-0.3,-0.87,-2.6>}


object{flasche
rotate z*90
rotate y*-30
translate<-2.2,-0.87,-1.9>}


object{flasche
rotate z*90
rotate y*(-30+160)
translate<-1.6,-0.87,-0.9>}

object{flasche
rotate z*90
rotate y*-80
translate<2.45,-0.87,-2.35>}


#declare sandfarbe=texture{pigment{
//rgb<1,200/255,0>
rgb<1,210/255,50/255>
} 
finish{crand 0.1}
normal{ bumps 0.3}
}



height_field{
tga "/fat/graphik/bilder/duene2.tga"
scale <6,0.6,3.3>
texture{sandfarbe}
translate<-3,0,-1.75>
rotate y*-90
scale 35
translate<10,-3.35,65>
rotate y*-45
//rotate x*-4
//normal{bumps 0.2
//scale 0.1
//}

smooth}

plane{y,-1 
texture{sandfarbe}
normal{bumps 0.2}
}


light_source
{
  0*x // light's position (translated below)
 // color red 1.0  green 1.0  blue 1.0  // light's color
  color rgb<1,1,1>*0.25
    translate <2500,2500,-5000>
shadowless
//looks_like{sterne}
}

object{feuerlicht}
