
// Persistence of Vision Ray Tracer Scene Description File
// File: flying.pov
// Vers: 3.2
// Desc: flying
// Date: 26. April 1998.
// Auth: Anto Matkovic
// e-mail: anto.matkovic@zg.tel.hr

//Note: meshes generated with Rhinoceros beta aren't included.

#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions

global_settings { assumed_gamma 2.2 }


background { color rgb <0.05, 0.1, 0.15>}

//window metal
#declare plet = texture { pigment {  colour rgb <0.3, 0.1, 0.03>}
finish { ambient 0.2 diffuse 0.55 specular 0.6 roughness 0.05 brilliance 9}}

 //wood1
#declare drvo1 = texture {pigment {colour rgb <0.25, 0.1, 0.08>}
finish {ambient 0.2 diffuse 0.6 phong 0.2 phong_size 23}
normal {granite 0.07 scale 0.2}}

 //wood2
#declare drvo2 = texture {pigment {colour rgb <0.35, 0.12, 0.1>}
finish {ambient 0.2 diffuse 0.6 phong 0.9 phong_size 33}
normal {granite 0.01 scale 0.2}}

//floor
#declare pod =texture { wood turbulence 0.1
texture_map {[0 drvo1]
             [1 drvo2]}}

//window wood
#declare okvir =texture { wood turbulence 0.2
texture_map {[0 drvo1]
             [1 drvo2]} rotate x*90}

//glass
#declare staklo = texture { pigment { colour rgbf <0.9, 0.9, 0.9, 0.98>}
finish { ambient 0.5 diffuse 0.55 phong 0.7 phong_size 256
reflection 0.2
}}

//pillow
#declare jastuk = texture {pigment { colour rgb <0.99, 0.99, 0.99>}
finish {ambient 0.2 diffuse 0.6 specular 0.8 roughness 0.05 brilliance 9 reflection 0.03}
normal { crackle scale 0.4
normal_map {[0 granite 0.05 scale 0.1]
            [0.04 granite 0.05 scale 0.1]
            [0.05 granite 0.001 scale 0.1]
            [1 granite 0.001 scale 0.1]}}}

//pillow2
#declare pokrivac = texture {pigment { colour rgb <0.99, 0.99, 0.99>}
finish {ambient 0.2 diffuse 0.6 specular 0.8 roughness 0.05 brilliance 9 reflection 0.03 }
normal { crackle scale 0.4
normal_map {[0 granite 0.05 scale 0.1]
            [0.04 granite 0.05 scale 0.1]
            [0.05 granite 0.001 scale 0.1]
            [1 granite 0.001 scale 0.1]}}}

//skin
#declare skin1=
texture { pigment { colour rgb <0.99, 0.55, 0.54>}
            finish {ambient 0.45 diffuse 0.55}}

texture { pigment {colour rgbf <0.93, 0.99, 0.93, 0.33>}
finish {ambient 0.15 diffuse 0.75 phong 0.05 phong_size 12}
normal {granite 0.01 scale 0.1}}

//eyebrows
#declare obrve = texture { pigment { granite scale 0.02
colour_map {[0 colour rgbt <0.12, 0.12, 0.12, 0>]
            [0.3 colour rgbt <0.12, 0.12, 0.12, 0>]
            [0.4 colour rgbt <0.12, 0.12, 0.12, 1>]
            [1 colour rgbt <0.12, 0.12, 0.12, 1>]}}
finish { ambient 0.25 diffuse 0.55}}

//hair
#declare kosa = texture { pigment {colour rgb <0.2, 0.2, 0.2>}
finish {ambient 0.2 diffuse 0.55  specular 0.7 roughness 0.1 brilliance 9 }
normal {radial sine_wave frequency 98 turbulence 0.2 rotate x*90 translate <0.5, 3.1, 7>}}

//lips
#declare usta = texture {pigment {colour rgb <0.99, 0.64, 0.64>}
finish {ambient 0.25 diffuse 0.55 phong 0.1 phong_size 34}}

//nails
#declare nokti = texture {pigment {colour rgb <0.99, 0.64, 0.64>}
finish { ambient 0.2 diffuse 0.6 phong 0.9 phong_size 78}}



//book1
#declare knjiga = texture { pigment { colour rgb 0.8}
finish {ambient 0.2 diffuse 0.62}}

//book2
#declare knjiga_korice = texture { pigment { colour rgb <0.1, 0.1, 0.1>}
finish {ambient 0.3 diffuse 0.5 phong 0.8 phong_size 7 reflection 0.1}
normal {granite 0.02 scale 0.03}}

//shoes
#declare cipele = texture { pigment { colour rgb <0.99, 0.4, 0.01>}
finish {ambient 0.25 diffuse 0.6 specular 0.7 roughness 0.05 brilliance 9 reflection 0.17}
normal {granite 0.01 scale 0.1}}

//shoes holes
#declare cipele_potpl = texture { pigment { colour <0.99, 0.4, 0.01>}
finish {ambient 0.25 diffuse 0.6 specular 0.7 roughness 0.05 brilliance 9 reflection 0.17}}

sky_sphere{pigment{ wrinkles
colour_map {[0 colour rgb <0.05, 0.1, 0.15>]
            [0.3 colour rgb <0.1, 0.15, 0.25>]
            [0.7 colour rgb <0.27, 0.27, 0.45>]
            [1 colour rgb <0.3, 0.3, 0.55>]}} scale 0.07}



camera { location <-12, 21, -9>look_at <-0.2, 4, 3> angle 33}



light_source
{ 0*x color rgb <0.3, 0.3, 0.32>translate <-12, 21, -9>}


light_source {  0*x color rgb 0.52
 area_light <0.012, 0.012, 0.012> <0.012, 0.012, 0.012>
  4, 4  adaptive 0  jitter translate <4.5, 7, 1.5>}

light_source {  0*x color rgb <0.86, 0.96, 1.29>
  area_light <4, 4, 4> <0, 0, 0>
  4, 4  adaptive 1  jitter translate <-1000, 1100, 1000>}


#include "flying_room.inc"
object {soba scale <-0.9, 0.9, 0.9> rotate x*-90 translate <5, -4, 10>}
#include "flying_lamp.inc"
object {lampa rotate <-90, 0, 0> scale <0.9, 1, 0.9>  translate <4.5, 0, 1.5>}

#include "flying_floor.inc"

//inc files with meshes:

//#include "asleep_tijelo.inc"
//#include "asleep_ruke.inc"
//#include "asleep_nokti.inc"
//#include "asleep_usta.inc"
//#include "asleep_jastuk.inc"
//#include "asleep_pokrivac.inc"
//#include "asleep_kosa.inc"
//#include "asleep_obrve.inc"
//#include "asleep_obrub.inc"
//#include "asleep_cipele.inc"
//#include "asleep_knjiga.inc"




















