//Magical African Nights head file

//By Mick Hazelgrove

#include "Mclaws.inc"

//-------------------------------------------
#declare eye = intersection{
object{Icosahedron rotate <-90,0,36> }
object{Icosahedron rotate <-90,0,72>}
object{Icosahedron rotate <-90,0,90>}
object{Icosahedron rotate <-90,0,-90>}
}

#declare broach = union{
  object{height_field {
    tga "spiral3.tga"
    smooth
    scale <1, 0.15, 1>
      rotate x*90
    translate<-0.5,0.5,0>
    }
    clipped_by { object { Cylinder_Z } scale 0.5 }
    texture { T_Gold_1A}
}
object{torus{0.5,0.1}texture{T_Gold_1A}
normal{
waves 3
frequency 6
}
rotate x*90}
}

//-----------------------------------------
#declare base = difference{
object {sphere{<0,0,0>,0.5 }}
object{sphere{<-0.25,0,-0.4>,0.175}}
object{sphere{<0.25,0,-0.4>,0.175}}
scale<2,4,2>
}

#declare ear = union{
         object{disc{<0, 0, 0>  z,1.0,}}
         object{torus{1.00,0.15}rotate x*90 translate<0,0,-0.15>}
}

#declare head_shape = union{
object{base}
object{sphere{<0,-1.65,-0.25>0.3}}
object{cylinder{<0,1.20,0>, <0,0.05,0>, 1.05 scale<1,1,1.2> translate<0,0,-0.25>  }}
object{torus{0.95,0.1 scale<1,1,1.2> translate<0,0,-0.25> } texture{Ebony} normal {radial 0.33 frequency 66 scallop_wave}}
object {sphere{<0,1.45,0>,1.05 scale<1,1,1.2> translate<0,0,-0.25>  }}
object{cylinder{<0,-2.5,1.25>, <0,0,0>, 0.5 scale<1,1,1.5> }}
//Nose
object{cylinder{<0,1.2,-0.2>, <0,-0.8,-0.3>, 0.15 }scale<1,1,3.5>}
object{sphere{<0,-0.8,-0.3>,0.15}scale<1,1,3.5>}
object{torus{0.15,0.01}rotate x*90 translate<0,-1.05,-1.4> texture{T_Gold_1A}}
//nostrils
sphere{<0,0,0> 0.15  scale<1.6,1.2,1> clipped_by {plane{<0,1,0> ,0.075 }}rotate x*180
               translate<-0.1,-0.8,-0.25>  scale<1,1,3.5>}
sphere{<0,0,0> 0.15  scale<1.6,1.2,1> clipped_by {plane{<0,1,0> ,0.075 }}rotate x*180
               translate<0.1,-0.8,-0.25>  scale<1,1,3.5>}
//ears
object{ear scale <1,1.5,1> rotate z*-25 rotate y*-50 rotate x*-15 translate<2.9,-0.6,0> scale 0.35}
object{ear scale <1,1.5,1> rotate z*25 rotate y*50 rotate x*-15 translate<-2.9,-0.6,0> scale 0.35}
object{torus{0.15,0.015 } rotate x*90 rotate y*-65  translate<-1.05,-0.675,0.2> texture{T_Gold_1A}}
object{torus{0.15,0.015 } rotate x*90 rotate y*65  translate<1.05,-0.675,0.2> texture{T_Gold_1A}}
//necklace
object {torus{0.7,0.2 rotate x*-30 translate<0,-2,1.5>}
texture{T_Gold_1A}
normal{gradient x+z 0.5 frequency 7 scallop_wave}
}
object{eye scale 0.15 texture{Blue_Glass}translate<0,-2.45,0.6> }
object{torus{0.2,0.05}
texture{T_Gold_1A}
normal{gradient x+y+z 0.5 frequency 7 scallop_wave}
rotate x*90
translate<0,-2.45,0.55>
}

//headband
object{torus{1.00,0.1 scale<1,1,1.2> translate<0,1.1,-0.25>}texture{Stripey}}
object{torus{1.00,0.1 scale<1,1,1.2> translate<0,0.8,-0.25>}texture{Stripey}}
rotate x*15
}

#declare head_dress = union{
object{head_shape}
//middle coil
object{torus{1.5,0.2}
texture{Ebony}
normal{gradient x 0.5 frequency 7 scallop_wave}
rotate z*90 translate<0,1.5,0.2>
}
//right side
object{torus{1,0.2} rotate z*75 translate<0.3,1.78,0> scale<1,1,1.2> rotate x*10}
object{torus{0.95,0.2} rotate z*60 translate<0.6,1.74,0> scale<1,1,1.2> rotate x*12}
object{torus{0.8,0.2} rotate z*45 translate<0.9,1.68,0> scale<1,1,1.2> rotate x*14}
object{torus{0.55,0.2} rotate z*30 translate<1.2,1.60,0> scale<1,1,1.2> rotate x*16}
object{torus{0.40,0.2} rotate z*15 translate<1.35,1.50,0> scale<1,1,1.2> rotate x*25}
//left side
object{torus{1,0.2} rotate z*105 translate<-0.3,1.78,0> scale<1,1,1.2> rotate x*10}
object{torus{0.95,0.2} rotate z*120 translate<-0.6,1.74,0> scale<1,1,1.2> rotate x*12}
object{torus{0.8,0.2} rotate z*135 translate<-0.9,1.68,0> scale<1,1,1.2> rotate x*14}
object{torus{0.55,0.2} rotate z*150 translate<-1.2,1.6,0> scale<1,1,1.2> rotate x*16}
object{torus{0.40,0.2} rotate z*165 translate<-1.35,1.5,0> scale<1,1,1.2> rotate x*25}
}
#declare face = union{
object {head_dress }
//mouth
object {torus{0.1,0.05}
texture{Ebony}
rotate x*83 scale <1.5,1,1>  translate<0,-1,-1.15>
}
//eyes


object{eye texture{Eye} scale 0.25 translate<-0.5,0.15,-0.55> }
object{eye texture{Eye} scale 0.25 translate<0.5,0.15,-0.55> }
}



#declare final_face = union {
object{face}
object{broach scale 0.5 translate<0,1.225,-1.63>}
}

//twister
#declare Rad = 3//same or larger than SDiam
#declare No_of_Strands = 3
#declare StAngle = 5
#declare Inc = 360/No_of_Strands
#declare SDiam = 1.00
#declare SDiam_inc = 0.25
#declare Count = 5
#declare VertInc = 0.175 //if bigger then .25 spheres show
#declare Iterations = 0

#declare Twister = union{
#while(Count <720)
     //Strand one
            #declare Angle = radians(StAngle + Count)
            #declare Cox = Rad + SDiam_inc *(sin(Angle))
            #declare Coy = Rad + SDiam_inc *(cos(Angle))
            #declare Point = <Cox,VertInc,Coy>
                object{sphere{<0,0,0>,SDiam
                //+ SDiam_inc
                }
                translate Point texture{GMetal}}
     //Strand two
            #declare Angle = radians((StAngle +120)+ Count)
            #declare Cox = Rad + SDiam_inc*(sin(Angle))
            #declare Coy = Rad + SDiam_inc *(cos(Angle))
            #declare Point = <Cox,VertInc,Coy>
                object{sphere{<0,0,0>,SDiam
                //+ SDiam_inc
                }
                translate Point texture{GMetal}}
     //Strand three
            #declare Angle = radians((StAngle+240) + Count)
            #declare Cox = Rad + SDiam_inc *(sin(Angle))
            #declare Coy = Rad + SDiam_inc*(cos(Angle))
            #declare Point = <Cox,VertInc,Coy>
                object{sphere{<0,0,0>,SDiam
                //+ SDiam_inc
                }
                translate Point texture{GMetal}}

           #declare SDiam_inc = SDiam_inc + 0.025
        #declare Count = Count + 5
      #declare VertInc = VertInc + 0.175
#end
}


//earing ends
#declare Base_object = intersection{
         object{sphere {<0,0,0> 1.00} translate <-0.5,0,0.5>}
         object{sphere {<0,0,0> 1.00} translate <0.5,0,0.5>}
         object{sphere {<0,0,0> 1.00} translate <-0.5,0,-0.5>}
         object{sphere {<0,0,0> 1.00} translate <0.5,0,-0.5>}
     }

#declare Combined_object = intersection{ //rounded double ended cone, difference gives ribs, union gives ribbed cone
#declare inc = 2//greater than 0
#declare Angle = 0
#while (Angle <90)
         object{Base_object rotate y*Angle}
#declare Angle = Angle + inc
#end
}

#declare Nhead = union{

object{final_face texture{Ebony}
no_shadow
scale 1.25
}

object{Claw_necklace
rotate x*60
scale 0.15
translate<0,-3.4,1.5>
}

object {Twister translate y*-8
rotate z*180
scale 0.04
translate<-1.2,-1.425,0.15>
}

object {Twister translate y*-8
rotate z*180
scale 0.04
translate<1.475,-1.425,0.15>
}

object{Combined_object
        texture{Blue_Glass}
        scale 0.75 translate<-1.3,-2.55,0.2>
        }

object{Combined_object
        texture{Blue_Glass}
        scale 0.75 translate<1.35,-2.55,0.2>
        }
}
//---------------Twisted post-----------------
#declare Rad = 1//same or larger than SDiam
#declare No_of_Strands = 3
#declare StAngle = 5
#declare Inc = 360/No_of_Strands
#declare SDiam = 0.5
#declare SDiam_inc = 0.00
#declare Count = 2.5
#declare VertInc = 0.05 //if bigger then .15 spheres show
#declare Iterations = 0

#declare Twister = union{
#while(Count <2160)

          #while(Iterations < 360)

            #declare Angle = radians((StAngle + Iterations) + Count)
            #declare Cox = Rad *(sin(Angle))
            #declare Coy = Rad*(cos(Angle))
            #declare Point = <Cox,VertInc,Coy>
                object{sphere{<0,0,0>,SDiam + SDiam_inc}
                translate Point}
            #declare Iterations = Iterations +Inc
          #end

           #declare SDiam_inc = SDiam_inc + 0.00
        #declare Count = Count + 2.5
      #declare VertInc = VertInc + 0.05
   #declare Iterations = 0
#end
}
object {Twister scale 0.3 translate <0,-12,1> texture {Ebony}}
