#declare CutOut = difference
{
    box { <-0.05,-2.5,-0.05>, <0.05,2.5,0.05> rotate y*45 }
    plane { y, 0 rotate x*65 translate y*3.43 inverse }
    plane { y, 0 rotate x*-65 translate y*-3.43 }

    scale <1.5,1,1>
    translate z*-0.75
}

#declare CutOuts= union
{
    #declare stcutout = 15
    #declare cutout = stcutout
    #while (cutout > 0)
        object { CutOut rotate y*(cutout*(360/stcutout))}
        #declare cutout = cutout - 1
    #end
}

#declare CCutOut = box
{
    <-0.05,-4,-0.05>, <0.05,4,0.05>
    rotate y*45
    scale <1.5,1,1>
    rotate x*-7.6
    translate <0,3,-0.75>
}

#declare CCutOuts = union
{
    #declare stcutout = 15
    #declare cutout = stcutout
    #while (cutout > 0)
        object { CCutOut rotate y*(cutout*(360/stcutout))}
        #declare cutout = cutout - 1
    #end
}

#declare Leaf = intersection
{
    difference
    {
        union { sphere { <-0.3,0,0>, 1 } sphere { < 0.3,0,0>, 1 } }
        union { sphere { <-0.3,0,0>, 1 } sphere { < 0.3,0,0>, 1 } scale 0.995 }
    }
    cylinder { <0,-4,0>,<0,0,0>,0.1 translate z*-0.8 }

    translate <0,0,-0.01>
    texture { Silver_T }
}

#declare LeafRow = union
{
    #declare stcutout = 15
    #declare cutout = stcutout
    #while (cutout > 0)
        object { Leaf rotate y*(cutout*(360/stcutout))}
        #declare cutout = cutout - 1
    #end
}

#declare Leaves = union
{
    object { LeafRow translate <0,3.7,0> }
    object { LeafRow scale <1.04,1,1.04> translate <0,4,0> rotate y*12 }
    object { LeafRow scale <1.08,1,1.08> translate <0,4.3,0> }
    object { LeafRow scale <1.12,1,1.12> translate <0,4.6,0> rotate y*12 }
    translate y*0.05
}

#declare Capital = union
{
    difference
    {
        cone { <0,3,0>,0.75,<0,4.5,0>,0.95 }
        #if (!TEST)
            object { CCutOuts }
        #end
    }
    #if (!TEST)
        object { Leaves }
    #end
    sphere { <0,0,0>, 0.8 scale <1,0.2,1> translate y*3 }
}

#declare Column = union
{
    object { Capital }
    difference
    {
        cylinder { <0,-3,0>, <0,3,0>, 0.75 }
        #if (!TEST)
            object { CutOuts }
        #end
    }
    object { ColumnSocket scale 2 translate y*-4 }

    scale 0.8
    texture { Stone_T }
}

#declare Columns = union
{
    #declare cc = 4
    #while (cc > 0)
        object { Column translate <-6,0,(cc*4)-10> }
        object { Column translate < 6,0,(cc*4)-10> }
        #declare cc = cc - 1
    #end
    object { Column translate <-2.5,0,-6> }
    object { Column translate < 2.5,0,-6> }
    object { Column translate <-2,0, 6> }
    object { Column translate < 2,0, 6> }
    translate y*-1
}

#declare Steps = union
{
    #declare tbh = 7.15
    #declare sh = 0.5
    #declare sc = 0
    #while (sc<4)
        box { <-(tbh+(sc*sh)),-(4+((sc+1)*sh)),-(tbh+(sc*sh))>, <(tbh+(sc*sh)),-(4+(sc*sh)),(tbh+(sc*sh))> }
        #declare sc = sc + 1
    #end
    translate y*-1

    texture { Stone_T }
}

#declare Stairs = union
{
    difference
    {
        union
        {
            box { <-2,-7,-9.15>, <-1.15,-4.5,-6.65> }
            box { <1.15,-7,-9.15>, <2,-4.5,-6.65> }
        }
        plane { y, 2.5 rotate x*-45 inverse }
    }

    texture { Stone_T }
}

#declare Ornament = difference
{
    box { <-0.6,4.7,-0.13>, <0.6,6.5,0.05> }
    union
    {
        box { <-0.34,4.5,-0.5>, <-0.14,6.7,-0.01> }
        box { <0.14,4.5,-0.5>, <0.34,6.7,-0.01> }
        texture { Silver_T }
    }

    texture { Stone_T }
}

#declare Ornaments = union
{
    #declare startoc = -(rwh-0.5-0.12)
    #declare oo = (rwh-0.15)
    #declare oc = startoc
    #while (oc<7.6)
        object { Ornament translate <oc,0,-oo> }
        object { Ornament rotate y*180 translate <oc,0,oo> }
        object { Ornament rotate y*90 translate <-oo,0,oc> }
        object { Ornament rotate y*270 translate <oo,0,oc> }
    #declare oc = oc + ((abs(startoc)*2)/6)
    #end
}


#declare Roof = union
{
    box { <-rwh,4.5,-rwh>, <rwh,4.7,rwh> }
    box { <-(rwh-0.15),4.7,-(rwh-0.15)>, <(rwh-0.15),6.5,(rwh-0.15)> }
    box { <-rwh,6.5,-rwh>, <rwh,6.7,rwh> }
    box { <-(rwh-0.5),6.7,-(rwh-0.5)>, <(rwh-0.5),6.9,(rwh-0.5)> }
    difference
    {
        box { <-(rwh-1),0,-(rwh-1)>, <(rwh-1),0.6,(rwh-1)> }
        plane {z, 0 rotate x*45 translate z*-(rwh-1)}
        plane {x, 0 rotate z*-45 translate x*-(rwh-1)}
        plane {z, 0 rotate x*-45 translate z*(rwh-1) inverse }
        plane {x, 0 rotate z*45 translate x*(rwh-1) inverse }
        translate y*6.9
    }
    #if (!TEST)
        object { Ornaments }
    #end
    translate y*-2

    texture { Stone_T }
}

#declare Room = union
{
    difference
    {
        box { <-4,-6,-4>, <4,2,4> }
        box { <-3.75,-7,-3.75>, <3.75,1.75,3.75> }

        box { <-0.75,-7,-5>, <0.75,-3,-3.5> }

        texture { Stone_T }
    }
    // Door
    union
    {
        box { <-1,-6,-4.05>, <-0.75,-3,-4> texture { T_Stone16 scale <0.3,0.3,0.3> translate x*0.3 } }
        box { <0.75,-6,-4.05>, <1,-3,-4> texture { T_Stone16 scale <0.3,0.3,0.3> translate x*0.3 } }
        box { <-1,-3,-4.05>, <1,-2.75,-4> texture { T_Stone16 scale <0.3,0.3,0.3> translate y*0.3 } }
    }
    // Inner Sanctum
    box { <-2.5,-6,-2>, <2.5,1,2> }

    texture { Stone_T }
}

#declare TempleFire = union
{
    object { TempleFireVase }
    light_source { <0,1.8,0> color ((LimeGreen+Yellow)/2) fade_distance 2 fade_power 2 }
    difference
    {
        sphere
        {
            <0,0,0>,1
            pigment { Clear }
            halo
            {
                emitting
                spherical_mapping
                linear
                turbulence 1.5
                colour_map
                {
                    [0 LimeGreen transmit 0.8]
                    [0.5 Yellow transmit -1]
                    [1 LimeGreen transmit 0.8]
                }
                frequency 2
                samples 20
                scale 0.5
            }
            hollow
        }
        plane { y,-0.2 pigment { Clear } }

        no_shadow
        scale <1,1.7,1>
        scale 1
        translate <0,2.1,0>
    }
}

#declare TorchFire1 = union
{
    #declare TRY=0
    #include "Flame.inc"
    cone { <0,-1.5,0>, 0.2, <0,-0,0>, 0.25 texture { Silver_T } rotate x*-25 translate y*-0.2 }
    scale <1,1.7,1>
    scale 0.15
    translate <0,-4,-2.05>
}

#declare TorchFire2 = union
{
    #declare TRY=77
    #include "Flame.inc"
    cone { <0,-1.5,0>, 0.2, <0,-0,0>, 0.25 texture { Silver_T } rotate x*-25 translate y*-0.2 }
    scale <1,1.7,1>
    scale 0.15
    translate <0,-4,-2.05>
}

#declare TempleOfOrpan = union
{
    object { Roof }
    object { Columns }
    object { Room }
    object { Steps }
    object { Stairs }
    #if (!TEST)
        object { TorchFire1 translate x*-0.5 }
        object { TorchFire2 translate x*+0.5 }
        object { TorchFire1 translate x*-1.75 }
        object { TorchFire2 translate x*+1.75 }
        object { TorchFire2 translate <-1.5,0,-2> }
        object { TorchFire1 translate <+1.5,0,-2> }
        object { TempleFire scale 0.3 rotate y*73 translate <-4.5,-5,-5> }
        object { TempleFire scale 0.3 translate <4.5,-5,-5> }
    #end

    translate y*5.65
}
