// Chair include by Ch CUSSAT-BLANC
// finished the 30 Mars 1998
// Size    = 0.9 x 1 x 0.85 
// Chair position :
//    _
//   { }
//   { }
//    | ___.....    
//    +{___}+  +
//          |  |  0.8125
//   +------+  +
//

#render "\nChair Include by Ch. CUSSAT-BLANC\n"
#render "(c) 30 Mars 1998\n"

#ifndef (chairTisTex) 
#declare chairTisTex=texture {
   pigment { rgb <1,1,1> }
   finish { 
      diffuse 1 
      ambient 0.1
      reflection 0.1
      refraction 0
      phong 0.2
      brilliance 0.2
   }
   normal { 
      crackle 0.2
      scale 0.25
      turbulence 0.5
   }  
}
#end

#ifndef (chairMetTex)
#declare chairMetTex=texture {
   pigment { rgb <0.7, 0.8,1 > }
   finish {
      diffuse 0.5
      ambient 0.0
      reflection 1
      phong 1
      metallic
      brilliance 0.4
   }
}
#end

// de -1 a 1... Tete de rayon 1... Axe Y
#declare chairVis=union {
   // La tete...
   difference {
      sphere { <0,0,0>, 1 }
      box { <-2,-2,-2>, <2,0,2> }
      box { <-2,2,-0.1>, <-2, 0.2, 0.1> }
   }
   // Le reste
   cylinder { <0,0,0>, <0,-1,0>, 0.25 }
   texture { chairMetTex }
}

#declare chairAxe=union {
// L'axe..
   difference {
      cylinder {
	 <-3, 0, 0>, <3, 0, 0>, 0.3
	 texture { chairMetTex }
      }
      cylinder {<-2.9, 0,0>, <-3.2,0,0>, 0.16 }
      cylinder { <2.9,0,0>, <3.2, 0,0>, 0.16 }
      difference {
	 cylinder { <-2.9, 0, 0>, <-2.91, 0, 0>, 0.5 }
	 cylinder { <-2, 0,0>, <-3, 0,0>, 0.15 }
      }
      difference {
	 cylinder { <2.9, 0, 0>, <2.91, 0, 0>, 0.5 }
	 cylinder { <2, 0,0>, <3, 0,0>, 0.15 }
      }
   }
   
// La fixation de l'axe dans le coussin
   cylinder {
      <-2.005,0,0>, <2.005,0,0>, 0.44
   } 
   
// Les 4 vis de la fixation
   #declare i=0
   #declare chairSeed=seed(0)
   #while ( i<4) 
// Cote droit...
   object { chairVis scale 0.05
      rotate y*rand(chairSeed) rotate -z*90 translate <2,0.37,0>
      rotate (i*90+45)*x
   }
// Cote gauche...
   object { chairVis scale 0.05
      rotate y*rand(chairSeed) rotate z*90 translate <-2,0.37,0>
      rotate (i*90+45)*x
   }
   #declare i=i+1
   #end
 
// Les 4 vis de la rondelle
   #declare i=0
   #declare chairSeed=seed(0)
   #while ( i<4) 
// Cote droit...
   object { chairVis scale 0.05
      rotate y*rand(chairSeed) rotate -z*90 translate <3,0.23,0>
      rotate (i*90)*x
   }
// Cote gauche...
   object { chairVis scale 0.05
      rotate y*rand(chairSeed) rotate z*90 translate <-3,0.23,0>
      rotate (i*90)*x
   }
   #declare i=i+1
   #end   
   texture { chairMetTex }
}
      
#declare chairCous=union {
// Le coussin
   superellipsoid {
      <0.5,0.75>
      scale <2,1.5,0.75>
      texture { chairTisTex }
   }	 
}

// Le dossier...
#declare chairDossier=union {
   object { chairCous }
   object { chairAxe }
   rotate x*15
   translate <0,2.5, 2.5>
}

// Le siege
#declare chairSiege=union {
   object { chairCous scale y*1.5}
   object { chairAxe }
   rotate x*90
}

#declare chairFr=0.1
#declare chairAngle=intersection {
   torus { 0.5, chairFr }
   box { <0,-chairFr,0>, <2, chairFr*2, 2> }
   rotate z*90
}

// Les fixations des deux coussins
#declare chairFix=union {
   cylinder { <0, 3.5, 2.5>, <0, 0.5, 2.5> , chairFr }
   cylinder { <0,0,2>, <0,0,-2>, chairFr }
   cylinder { <0, -0.5, -2.5>, <0, -2, -2.5>, chairFr }
   cylinder { <0, -2.5, -2>, <0, -2.5, 3>, chairFr }
   
   sphere { < 0, 3.5, 2.5>, chairFr }
   sphere { < 0, -2.5, 3> , chairFr }
   
   object { chairAngle rotate x*90 translate <0,0.5, 2> }
   object { chairAngle rotate -x*90 translate <0,-0.5, -2> }
   object { chairAngle rotate -x*180 translate <0, -2, -2> }

   texture { chairMetTex }
}

// Acoudoire.

// Le coussin de l'acoudoir...
#declare chairCousAcoud=superellipsoid {
   <0.5,0.75>
   scale <0.75,0.4,1.5>
   translate y*0.75
   texture { chairTisTex }
}

#declare chairFixAcoud=union {
   cylinder { <0,0.5,1.5>, <0, 0.5, -1.5>, chairFr }
   cylinder { <0,0, -2>, <0, -0.5, -2>, chairFr }
   cylinder { <0, -1, -1.5>, <0, -1, -0.5>, chairFr }
   cylinder { <0, -0.5, 0>, <0, 0, 0>, chairFr }

   sphere { <0, 0.5, 1.5>, chairFr }

   object { chairAngle rotate -x*90 translate <0,0, -1.5> }
   object { chairAngle rotate -x*180 translate <0,-0.5, -1.5> }
   object { chairAngle rotate x*90 translate <0, -0.5, -0.5> }
   
   texture { chairMetTex }
}

#declare chairAcoudDroit=union {
   object { chairFixAcoud translate x*2.75 }
   object { chairCousAcoud translate x*2.5 }
}

#declare chairAcoudGauche=union {
   object { chairFixAcoud translate -x*2.75 }
   object { chairCousAcoud translate -x*2.5 }
}
   
   
// La chaise dans sa totalite...
#declare chair=union {
   object { chairDossier } 
   object { chairSiege }
   object { chairAcoudDroit }
   object { chairAcoudGauche }
   object { chairFix translate x*2.5 }
   object { chairFix translate -x*2.5 }
   translate y*(2.5+chairFr)
   scale 0.15
}