#declare cm_location=<0,0.4,-1.5>
#declare cm_location=vrotate (cm_location, <0,clock*360*2, 0> )
#declare cm_look_at=<0, 0.5, 0>
#declare cm_angle=90
#declare cm_prop=<2,1,0>
#include "camera/Camera.inc"


#declare Trans=on

#declare reChair=on
#declare reTv=on
#declare reVer=on
#declare radio=on
#declare reBlob=on
#declare lightLooksLike=on

// Light Setting
#declare lightAlt=1.5
#declare lightSpc=1
#declare rdLgVal=0.5

// Tv Setting...
#declare setAngle=10	// Z rotation
#declare setYRot=10
#declare setXRot=30
#declare setXAdj=0.5
#declare setZAdj=1
#declare setAlt=0.5


#if (radio)
global_settings {
   radiosity {
      count 130 
      error_bound 0.06
      gray_threshold 0.4
      distance_maximum 0
      low_error_factor 0.85
      nearest_count 5
      minimum_reuse 0.01
      brightness 3.3
      recursion_limit 1
   }
}
#end

#if (reBlob)
// Le blob !
#declare blobText=texture {
   #if (Trans)
   pigment { rgbf <0.8, 0.5, 0, 0.5> }
   #else
   pigment { rgb <0.8, 0.5, 0> }
   #end
   finish {
      ambient 0.0
      reflection 0.3
      refraction 0.9
      phong 1
      specular 0.2
      diffuse 0.3
      ior 1.33
      fade_distance 0.75
      fade_power 1.2
      caustics 0.4
   }
}

#declare bs=seed(0)

blob {
   #declare l=4
   #while ( l > -2 )
   #declare i=0
   #while ( i < 5 )

   #declare j = 0
   #while ( j <= i )
   
   #declare k = 0 
   #while ( k <= (i -j) )
   sphere {
      <i,k,j>, 1, 1
      scale <0.5, 0.5, 0.5>*<rand(bs), rand(bs), rand(bs)>+0.25
      translate <rand(bs), rand(bs), rand(bs)>*<0.25,0.25,0.25>
      translate <-2-(2-abs(l)/2), 0, l>
  }
   #declare k=k+1
   #end
   #declare j=j+1
   #end
   #declare i=i+1
   #end
   #declare l = l-1
   #end
      

//    scale <0.5,0.1, 0.5>
   
   texture { blobText }
}
#end

#declare SeedLight=seed(1)


#declare colon=0
#declare i=-4
#while (i < 5)
#declare colon=colon+1
#if (mod(colon,2))
#declare j=-4
#else
#declare j=-4+lightSpc/2
#end
#while (j <= 4)

#if (lightLooksLike)

#declare lightSph=sphere {
   <0,0,0>, 1
   pigment { rgbt <1,1,1,1> }
   finish {
      ambient 1
      reflection 0
      diffuse 0
   }
   halo {
      emitting
      spherical_mapping
      linear
       colour_map {
	 [ 0   color rgbt <1, 1, 1, 1> ]
	 [ 0.5   color rgbt <1, 1, 1, 1> ]
	 [ 1   color rgbt <1, 1, 1, -1> ]	
      }
      samples 10
      turbulence <rdLgVal*rand(SeedLight), rdLgVal*rand(SeedLight), rdLgVal*rand(SeedLight)>
   }
   hollow
   no_shadow
   scale 0.25
}
#end

union {
   light_source {
      <0,lightAlt,0>
      color <1,1,1>
      spotlight
      point_at <0,0,0>
      radius 30
      falloff 45
      #if (lightLooksLike)
      looks_like { object { lightSph }}
      #end
   }
   
   light_source {
      <0,lightAlt,0>
      color <1,1,1>
      spotlight
      point_at <0,2.8,0>
      radius 60
      falloff 70
   }
   translate <i*0.9, 0, j*0.9>+
   (<(rand(SeedLight)-0.5)*2*lightSpc,
      (rand(SeedLight)-0.5),
      (rand(SeedLight)-0.5)*2*lightSpc>)
}

#declare j=j+lightSpc
#end
#declare i=i+lightSpc
#end

background { rgb <1,1,1> }


#if (reVer)
#include "verre.inc"
object { verre scale 3 translate <-0.2, 0, -0.3> }
#end

#if (reTv)
#include "tvSet.inc"
object { tvSet 
   rotate -y*setYRot
   translate -x*0.6
   rotate x*setXRot
   rotate -z*setAngle 
   translate <setXAdj, setAlt, setZAdj> 
}

light_source {
   <0,lightAlt,0>
   color <1,1,1>
   spotlight
   point_at <0,0,0>
   radius 30
   falloff 45
   #if (lightLooksLike)
   looks_like { object { lightSph }}
   #end
   translate -x*0.6+<setXAdj, setAlt, setZAdj>
}
#end

#if (reChair)
#include "chair.inc"
object { chair translate x*0.65 }
#end

// Moquette...
plane {
   <0,1,0>, 0
   pigment { rgb <0, 0.7, 0.5> }
   finish {  diffuse 0.8 }
   normal {
      bumps 1
      scale 0.01
   }
   hollow
} 

#declare texMur=texture {
   pigment { rgb <1,1,1> }
   finish { 
      diffuse 1 
      phong 1
      ambient 0.2
      reflection 0.1
      refraction 0
      brilliance 0.2
   }
}

#declare texPlaf=texture {
   pigment { rgb <1,1,0.9> }
   finish { 
      diffuse 1 
      phong 1
      ambient 0.2
      reflection 0.0
      refraction 0
      brilliance 0.0
   }
}

// une plaintes !
#declare Plainte=union {
   box { <-0.01,0,-4>, <0.01, 0.1, 4> }
   cylinder { <0,0.1,-4>, <0,0.1, 4>, 0.01 }
   texture { texMur }
}


// Un mur blanc derriere...
plane {
   <0,0,1>, 4
   texture { texMur } 
   hollow 
}
object { Plainte rotate x*90 translate z*4 }
     

// Un mur blanc devant...
plane {
   <0,0,1>, -4
   texture { texMur } 
   hollow 
}
object { Plainte rotate x*90 scale <1,1,2> translate -z*4 }


// Un mur blanc sur le cote !
plane {
   <1,0,0>, 4
   texture { texMur } 
   hollow
}
object { Plainte translate x*4 }

// Et de l'autre aussi
// Un mur blanc sur le cote !
plane {
   <1,0,0>, -4
   texture { texMur } 
  hollow
}
object { Plainte translate -x*4 }


// Un plafond maintenant...
plane {
   <0,1,0>, 2
   texture { texPlaf } 
   hollow
}

