// TvSet par Ch. CUSSAT-BLANC...
// Finished the 30.Mars.1998
// Size = 1.20 x 0.55 x 0.25
// Chair position :
//    _
//   { }
//   { }
//    | ___.....    
//    +{___}+  +
//          |  |  0.8125
//   +------+  +
//

#render "\nTvSet Include by Ch. CUSSAT-BLANC\n"
#render "(c) 30 Mars 1998\n"

#ifndef (tvTexHp)
#declare tvTexHp=texture {
   pigment { rgb <0.2, 0.2, 0.2>   }
   finish {
      diffuse 1
      phong 1
      reflection 0.1
      refraction 0
      specular 0
   }
   normal {
      quilted 2
      control0 0.67
      control1 0.67
   }
   scale 0.05
   rotate z*45
}  
#end

#ifndef (tvTubeTex)
#declare tvSeed=seed(1*clock)
#declare tvBlack=rgb <0.0, 0.0, 0.0>
#declare tvDif=0.025
#declare tvSize=0.02
#declare tvTubeTex=texture {   
   pigment {
      bozo
      color_map {
	 #declare i=0.01 
	 #while (i<1) 
	 
	 [i-tvSize tvBlack ]
	 #declare tvVar=rand(tvSeed)
	 [i        rgb <tvVar, tvVar*1.2, tvVar*2> ]
	 [i+tvSize tvBlack ]
	 #declare i=i+(rand(tvSeed)*tvSize+tvDif)
	 #end
      }
      scale 0.01
   }
   
   finish {
      diffuse 0.5
      ambient 0.5
      reflection 0.1
      refraction 0
      ior 0
      phong 1
   }
}
#end

#ifndef (tvBoxTex)
#declare tvBoxTex=texture {
   pigment { rgb <0.2, 0.2, 0.2> }
   finish {
      diffuse 1
      phong 1
      reflection 0.1
      refraction 0
      specular 0
   }
}
#end

// L'ecran...
#declare tvEst=0.05
#declare tvNorth=0.5
#declare tvTubeEp=0.1
#declare tvTube=   superellipsoid {
   <tvEst, tvNorth>
   scale <1.6,0.9,0.2>
   texture { tvTubeTex }
   hollow
   no_shadow
}

#declare lightTube=light_source {
   <0,0,-tvTubeEp>
   color <0.2, 0.3, 0.5>*0.1
   // area_light <1.6, 0,0>, <0,0.9, 0>, 5, 5
   looks_like { object { tvTube } }
}



#declare tvHpDroit=union {
   intersection {
      cylinder { <0,-0.9,0>, <0,0.9, 0>, 1 scale <0.4, 1, 0.05> }
      box { <0, 1, 1>, <0.5, -1, -1> }
   }
   intersection {
      cylinder { <0,-0.9,0>, <0,0.9, 0>, 1 scale <0.01, 1, 0.05> }
      box { <0, 1, 1>, <-0.5, -1, -1> }
   }

   texture { tvTexHp }
}
   
#declare tvHpGauche=union {
   intersection {
      cylinder { <0,-0.9,0>, <0,0.9, 0>, 1 scale <0.4, 1, 0.05> }
      box { <0, 1, 1>, <-0.5, -1, -1> }
   }
   intersection {
      cylinder { <0,-0.9,0>, <0,0.9, 0>, 1 scale <0.01, 1, 0.05> }
      box { <0, 1, 1>, <0.5, -1, -1> }
   }

   texture { tvTexHp }
}

#declare tvBox=difference {
   superellipsoid {
      <0.05, 0.2>
      scale <2.4,1.1,0.5>
      translate z*0.4
   }
   
   superellipsoid {
      <0.4, 0.1>
      scale <5, 0.9, 0.5>
      translate -z*0.55
   }
   
   intersection {
      union {
	 superellipsoid {
	    <tvEst, tvNorth>
	    scale <1.6,0.9,tvTubeEp>
	 translate -z*4.9
	 }
	 
	 superellipsoid {
	    <tvEst, tvNorth>
	    scale <1.7, 1.0, tvTubeEp+0.1>
	    translate -z*5
	 }
      }
      box { <2,2,0>, <-2,-2,-10> }
   } 
   
   texture { tvBoxTex }
}

#declare tvSet=union {
   object { tvBox }
   object { tvHpDroit translate <1.8,0,-0.1> }
   object { tvHpGauche translate <-1.8,0,-0.1> }
   light_source {  lightTube }   
   translate 1.1*y
   scale 0.25
}