#ifndef (Trans) #declare Trans=on #end
#ifndef (VerEpais) #declare VerEpais=0.05 #end

#ifndef(VerreTex)
#declare VerreText=texture {
   #if (Trans)
   pigment { rgbt <1,0.8,0.7, 0.95> }
   #else
   pigment { rgb <1,0.8,0.7> }
   #end
   
   normal { bumps 0.1 scale 0.2 }

   finish {
      #if (Trans)
      ambient 0.0
      #else
      ambient 0.2
      #end
      reflection 0.3
      refraction 0.9
      phong 1
      specular 0.2
      #if (Trans)
      diffuse 0.1
      #else
      diffuse 0.8
      #end
      ior 1.5
   }
}
#end

// TEXTURE DU LIQUIDE //
#ifndef (LiquideText) #declare LiquideText=texture {
   #if (Trans)
   pigment { rgbf <0.8, 0.5, 0, 0.5> }
   #else
   pigment { rgb <0.8, 0.5, 0> }
   #end
   finish {
      ambient 0.0
      reflection 0.3
      refraction 0.9
      phong 1
      specular 0.2
      diffuse 0.3
      ior 1.33
      fade_distance 0.75
      fade_power 1.2
      caustics 0.4
   }
}
#end

// UN VERRE //
#declare Verre=difference {
   merge {
      cylinder {
	 <0,VerEpais,0>, <0,3,0>, 1
      }
      
      torus {
	 1-VerEpais, VerEpais
	    translate <0, VerEpais, 0>
      }
      
      cylinder {
	 <0,0,0>, <0, 2, 0>, 1-VerEpais
      }
	 
      torus {
	 1-VerEpais, VerEpais
	 translate <0,3,0>
      }
   }

   merge {
      cylinder {
	 <0,0.7,0>, <0, 5, 0>, 1-2*VerEpais
      }
      sphere {
	 <0,0,0>, 1-2*VerEpais
	 scale <1,0.1,1>
	 translate <0,0.7,0>
      }
   }
   texture { VerreText }
}

// EAU DANS LE VERRE //
#declare LiqVerre=  merge {
   cylinder {
      <0,0.5,0>, <0, 2, 0>, 1-2*VerEpais
   }
   sphere {
      <0,0,0>, 1-2*VerEpais
      scale <1,0.1,1>
      translate <0,0.5,0>
   }
   texture { LiquideText }
}



// LE VERRE DEBOUT //
#declare verre=
union {
   object { Verre }
   object { LiqVerre }
   scale 0.04
}


