// ************************************************************
// Author: Mauro Pierluigi - http://www.worldnet.it/p/pierl/mp/
// ************************************************************
// Please do not use this source file or any part included
// for any commercial purpose.
// ************************************************************

#include "dxfexp.inc"
#include "colors.inc"
#include "textures.inc"
#include "glass.inc"
#include "skies.inc"
#include "woods.inc"
#include "stones.inc"

fog{
  color White
  fog_type 2
  fog_alt 10
  fog_offset -150
  distance 400
  turbulence <0.15, 0.15, 0.15>
  omega 0.35
  lambda 1.25
  octaves 5
}

sky_sphere { S_Cloud1 }

camera {
  location <0, 0, -140>
  look_at <4, -18, 0>
}

light_source { <60, 2000, 0> color Gray75  shadowless}

light_source { <0, 0, -2000> color Gray50  shadowless}

light_source { <60, 100, 0> color White
  spotlight
  point_at -y
  radius 150
}

#declare Insect = union {
  object { COLOR_2
    texture {
      pigment { checker
        pigment {
          gradient x
          color_map {
            [0.0 Black]
            [1.0 Yellow]
          }
          scale 0.08
        }
        pigment { Gray15 }
      }
      scale <80, 800, 80>
    }
    finish {
      reflection 0.2
      phong 0.75
      phong_size 25
    }
  }
  object { COLOR_4
    pigment { Black }
    finish {
      reflection 0.2
      phong 0.75
      phong_size 25
    }
  }
  object { COLOR_0
    pigment { Black }
    finish {
      reflection 0.2
      phong 0.75
      phong_size 25
    }
  }
  object { COLOR_37
    pigment { Black }
  }
  object { COLOR_254
    texture { T_Glass4 }
  }
  object { COLOR_91
    texture {
      pigment { color rgbf <0.98, 1.0, 0.99, 0.75> }
      finish {
        ambient 0.1
        diffuse 0.1
        reflection 0
        refraction 1
        ior 1.5
        specular 1
        roughness 0.001
      }
    }
  }
  object { COLOR_251
    texture { T_Glass4 }
  }
  object { COLOR_67
    texture {
      pigment { color rgbf <0.98, 1.0, 0.99, 0.75> }
      finish {
        ambient 0.1
        diffuse 0.1
        reflection 0
        refraction 1
        ior 1.5
        specular 1
        roughness 0.001
      }
    }
  }
}

object { Insect
  translate <60, 60.5, 0>
  rotate <-90, 30, 0>
}

#declare Trk = blob { threshold 0.5
  cylinder { <-20, 0, 0>, <20, 0, 0>, 3, 2 }
  cylinder { <-5.5, 0, 0>, <-10, 8, 0>, 2, 2 }
  cylinder { <-1, 0, 0>, <-8, 0, -10>, 1, 2 }
}

object { Trk
  texture { T_Stone37 scale 2}
  normal {
     bumps 1
     scale 0.1
  }
  rotate 30*y
  scale <20, 21, 20>
  translate <0, -91, 29>
}

height_field { gif "map.gif"
  scale <5000, 1000, 5000>
  texture {
    pigment {
      crackle
      turbulence 0.3
      lambda 2.5
      omega 0.75
      octaves 5
      scale 0.45
      rotate <0, 5, 60>
      color_map {
        [ 0.02 color rgbf <0.30, 0.60, 0.45, 0.0> ]
        [ 0.10 color rgbf <0.25, 0.25, 0.20, 0.0> ]
        [ 1.00 color rgbf <0.75, 0.75, 0.60, 0.0> ]
      }
    }
    scale <500, 100, 100>
  }
  normal {
    bumps 0.95
    scale 1.5
  }
  translate <-2500, -800, 100>
  smooth
}

plane { <0, 1, 0>, -150
  pigment { Black }
  normal{
    agate 0.8
    scale 200
  }
  finish{
    reflection 0.35
    phong 0.8
    phong_size 200
  }
}

