// Aquamarine
// Martin Bhend 1998
// email: martin.bhend@zurich.com
/*
Ŀ
    fix syntax version                                          

*/
#declare AQUAMAR_INC_Version = version
#version 3.0
/*
Ŀ
    debugging controls                                          

*/
#ifdef (View_POV_Include_Stack)
#debug "++ including AQUAMAR.INC / version V1.4.0\n"
#end
/*
Ŀ
    includes                                                    

*/
#include "aquamar.r00"
/*
Ŀ
    general F/X flags                                           

*/
#ifndef (I_AQM_Quick)
#declare I_AQM_Quick = off
#end

#ifndef (I_AQM_InnerLight)
#declare I_AQM_InnerLight = off
#end

#ifndef (I_AQM_SpotLight)
#declare I_AQM_SpotLight = on
#end
/*
Ŀ
    derived flags                                               

*/
#if (I_AQM_Quick = on)
#declare I_AQM_InnerLight = off
#declare I_AQM_SpotLight = off
#end
/*
Ŀ
    blobby base stone                                           

*/
#declare I_AQM_BSTONE_RMIN =  200
#declare I_AQM_BSTONE_RVAR =  100

#declare I_AQM_BSTONE_RANX = 1200
#declare I_AQM_BSTONE_RANY =   50
#declare I_AQM_BSTONE_RANZ =  600

#declare I_AQM_BSTONE_TX = texture {
//HK_BlackStone scale 500
  T_Stone31 scale 500
//T_Stone39 scale 500
//T_Stone41 scale 500
  pigment { quick_color Red }
}

#declare I_AQM_BSTONE = object {
  blob {
    threshold 1
    #include "aquamar.in2"
    sturm
  }
  texture { I_AQM_BSTONE_TX
    rotate < I_AQM_BSTONE_RX,I_AQM_BSTONE_RY,I_AQM_BSTONE_RZ >
  }
}
/*
Ŀ
    fractal stones                                              

*/
#declare I_AQM_FSTONE_RMIN =    8 // radius - minimum amount
#declare I_AQM_FSTONE_RVAR =   17 // radius - variable amount

#declare I_AQM_FSTONE_RANX = 1300 // X random distribution
#declare I_AQM_FSTONE_RANY =   50 // Y random distribution
#declare I_AQM_FSTONE_RANZ =  700 // Z random distribution

#declare I_AQM_FSTONE_QMIN =  0.6 // Y-squeeze - minimum amount
#declare I_AQM_FSTONE_QVAR =  0.1 // Y-squeeze - variable amount

#declare I_AQM_FSTONE_AI   =    5 // angle of inclination (hor)
#declare I_AQM_FSTONE_AT   =   10 // angle of torsion (Y)

#declare I_AQM_FSTONE_TX = texture {
  T_Grnt9 scale 150
  pigment {
    quick_color Green
  }
  normal {
    wrinkles 0.9
  }
}

#include "aquamst.inc"

#declare I_AQM_FSTONES = union {
  #include "aquamar.in3"
}
/*
Ŀ
    color examples                                              

*/
#declare I_AQM_MediumAquamarine = color rgb <0.196078,0.8,0.6>
#declare I_AQM_Aquamarine       = color rgb <0.439216,0.858824,0.576471>
/*
Ŀ
    basic color and ior                                         

*/
#ifndef (I_AQM_COL)
#declare I_AQM_COL = color I_AQM_Aquamarine
#end

#declare I_AQM_Ior = 1.45
/*
Ŀ
    glass texture                                               

*/
#declare I_AQM_FILTER = rgbf <0,0,0,0.75>

#declare I_AQM_F0 = finish {
  ambient 0
  diffuse 0
  reflection 0.5
  refraction 1
  ior I_AQM_Ior
  phong 0.3
  phong_size 60

//finish {
//  ambient 0.1
//  diffuse 0.1
//  specular 0.8
//  reflection 0.1
//  refraction 0.9
//  roughness 0.0003
//  phong 1 phong_size 400
//}
}

#declare I_AQM_CRYSTAL_TX = texture {
  pigment { color I_AQM_COL + I_AQM_FILTER quick_color Yellow }
//finish  { F_Glass2 }
  finish  { I_AQM_F0 }
}
/*
Ŀ
    octagonal prism up Y axis, 2 flat caps                      

*/
#declare I_AQM_Octagon_YH = 10 // height

#declare I_AQM_Octagon_Y = intersection {

  plane { x, 1 }
  plane { x, 1 rotate <0, 45,0> }
  plane { x, 1 rotate <0, 90,0> }
  plane { x, 1 rotate <0,135,0> }
  plane { x, 1 rotate <0,180,0> }
  plane { x, 1 rotate <0,225,0> }
  plane { x, 1 rotate <0,270,0> }
  plane { x, 1 rotate <0,315,0> }
  plane { y, I_AQM_Octagon_YH/2 }
  plane {-y, I_AQM_Octagon_YH/2 }

  translate <0,I_AQM_Octagon_YH/2,0>

#if (I_AQM_Quick = off)
  texture { I_AQM_CRYSTAL_TX }
#else
  pigment { color I_AQM_COL }
#end

}
/*
Ŀ
    inner light source                                          

*/
#declare I_AQM_LIGHT = light_source { 0
  color White
}
/*
Ŀ
    large crystals with light                                   

*/
#declare I_AQM_LC_XOFS = 100 // basic offset

#declare I_AQM_LC_LEFT = object {
  I_AQM_Octagon_Y scale 60
//rotate z *  13
  rotate z *  15
  rotate x *  20
  translate < -I_AQM_LC_XOFS-110,0,-20 >
}

#declare I_AQM_LC_MIDDLE = object {
//I_AQM_Octagon_Y scale <100,40,100>
  I_AQM_Octagon_Y scale <110,50,110>
  rotate y * 5
//rotate x * -15
  rotate x * -25
  translate < -I_AQM_LC_XOFS,0,-40 >
}

#declare I_AQM_LC_MIDDLE_LIGHT = object {
  I_AQM_LIGHT
  translate < -I_AQM_LC_XOFS,0,-40 >
}

#declare I_AQM_LC_RIGHT = object {
//I_AQM_Octagon_Y scale <70,50,70>
  I_AQM_Octagon_Y scale <80,50,80>
  rotate y * -1
  rotate z * -10
  rotate x *  25
}
/*
Ŀ
    small crystals                                              

*/
#declare I_AQM_SCRYST_HMIN =   20 // height - minimum amount
#declare I_AQM_SCRYST_HVAR =   12 // height - variable amount

#declare I_AQM_SCRYST_SMIN =   12 // X/Z size - minimum amount
#declare I_AQM_SCRYST_SVAR =   12 // X/Z size - variable amount

#declare I_AQM_SCRYST_RANX =  740 // X random distribution
#declare I_AQM_SCRYST_RANY =   40 // Y random distribution
#declare I_AQM_SCRYST_RANZ =  500 // Z random distribution

#declare I_AQM_SCRYST_FIXX =  145 // X fix distribution
#declare I_AQM_SCRYST_FIXZ =  100 // Z fix distribution

#declare I_AQM_SCRYST_AI   =   25 // angle of inclination

#declare I_AQM_SCRYSTALS = union {
  #include "aquamar.in1"
  translate < -I_AQM_LC_XOFS,0,0 >
}
/*
Ŀ
    spotlight                                                   

*/
#declare I_AQM_COL = color White

#declare I_AQM_SPOT_R = 10 // inner spot radius

#declare I_AQM_SPOT = light_source {
  0
  color  I_AQM_COL
  spotlight
  point_at -y
  radius  I_AQM_SPOT_R/2
  falloff I_AQM_SPOT_R/2*2
  tightness 10

  translate < -30, 100, 0 >
}

//sphere { < -30, 100, 0 >, 30 pigment { color Red } } // find spot
/*
Ŀ
    assembly                                                    

*/
#declare I_AQM = union {

  object { I_AQM_BSTONE }
  object { I_AQM_FSTONES }
  object { I_AQM_SCRYSTALS }
  object { I_AQM_LC_RIGHT }
  object { I_AQM_LC_LEFT }
  object { I_AQM_LC_MIDDLE }

#if (I_AQM_InnerLight = on)
  object { I_AQM_LC_MIDDLE_LIGHT }
#end

#if (I_AQM_SpotLight = on)
  object { I_AQM_SPOT }
#end

}
/*
Ŀ
    restore syntax version                                      

*/
#version AQUAMAR_INC_Version

//(EOF)
