#!c:/bin/perl/bin/perl.exe

########################################################################
#
# program: grass.pl
# version: 24 May 1998, v1.1
# author : Steven L. Reid
# purpose: Randomly places blades of grass for rendering in POV-Ray.
#
########################################################################

# include libs

# global variables
$size   =  75; # max size of patch
$patch  =  20; # size of patch center
$grass  = 100; # minimum number of seeds
$blades =  50; # max blades per patch
$levels =  20; # levels of path recursion
$growth = .25; # random growth
$tilt   =  10; # degress of tilt
srand; # seed the random function

# main loop

while ($levels--) {
  # print level
  print "// level $levels - ";

  # get number of seeds
  $seeds = $grass + int rand $blades;
  print "$seeds seeds\n";

  # starting patch
  $px = int rand $patch; $patch -= $patch/2;
  $py = int rand $patch; $patch -= $patch/2;

  while ($seeds--) {
    # get seed placement and blade growth pattern
    $x = int rand $size; $x -= $size/2; $x -= $px;
    $y = int rand $size; $y -= $size/2; $y -= $py;
    $h = rand $growth; $h -= $growth/2;
    $t = int rand $tilt;
    $r = int rand 360; # rotation
    print "object {blade rotate <-$t,$r,0> translate <$x,$h,$y>}\n";
  }
}

# end main
########################################################################
