#version 3

#ifndef (Header_Inc)

#declare Header_Inc = 1

global_settings {
  assumed_gamma 1.8
}

#ifndef (Seed)
  #declare Seed = seed(27271)
#end

#ifndef (Foot)
  #declare Foot = 12
#end

//////////////////////////////////////////
// parameters
//


#declare Base_Distance        = 90 * Foot
#declare Mound_Distance       = 60.5 * Foot
#declare Mound_R              = 8 * Foot
#declare Mound_Position       = <0, 0, Mound_Distance>
#declare Home_Position        = <0, 0, 0>
#declare First_Position       = vrotate ( < 0, 0, Base_Distance>, 45 * y )
#declare Third_Position       = vrotate ( < 0, 0, Base_Distance>, -45 * y )
#declare Second_Position      = First_Position + Third_Position
#declare Mound_H              = 10
#declare Base_Circle_R        = 13 * Foot
#declare BasePath_R           = 3 * Foot
#declare Infield_R            = 96 * Foot
#declare Infield_C            = Mound_Position
#declare Infield_Crown        = 4  // total rise of infield
#declare BasePath_X           = Mound_Distance + Infield_R + 1

#declare Warning_Track        = 10 * Foot
#declare Fence_H              = 9 * Foot
#declare Fence_Numbers_H      = 4 * Foot
#declare Fence_Numbers_W      = 9 * Foot

#ifndef (Fence_Circular_Flag)
  #declare Fence_Circular_Flag = 0
#end

#if (Fence_Circular_Flag)
  #declare Fence_Lines          = 330 * Foot
  #declare Fence_Center         = 410 * Foot
  #declare Fence_C   =  z *( pow(Fence_Center, 2) - pow(Fence_Lines, 2) ) /
                           ( 2 * Fence_Center - sqrt(2) * Fence_Lines )
                                                             // fence circle center (for circular fence)
  #declare Fence_R              = Fence_Center - Fence_C.z   // fence radius (for circular fence)
  #declare Fence_Theta_Lines    = 43                         // position of numbers (for circular fence)
  #declare Fence_Theta_Alley    = 22.5                       // position of numbers (for circular fence)
#else
  #declare Fence_Lines          = 350 * Foot
  #declare Fence_Center         = 400 * Foot
  #declare Fence_Z = sqrt(2) * Fence_Center - Fence_Lines    // length of side fence sections
  #declare Fence_X = Fence_Lines * sqrt(2) - Fence_Center    // half-width of center fence section
  #declare Fence_T = 6                                       // thickness of fence
  #declare Fence_Alleys =
                vlength ( < Fence_Lines, Fence_Z, 0 > )
  #render concat("Fence_Alleys = ", str(int(0.5 + Fence_Alleys/12),6,4), "\n")
#end

#declare dY                  = 0.01   // small distance

#declare Y   = 0.5                        // plate height
#declare dXplate  = Y;                    // plate bevel
#declare Xplate   = 8.5+dXplate           // half plate-width
#declare Xplate2  = 2*(Xplate+dXplate)    // top of plate

#declare Base_X = 7.5                     // base half-dimension
#declare Base_Y = 2                       // base half-dimension

#declare PitchersPlate_X = 12              // half dimensions of pitchers-plate
#declare PitchersPlate_Y = 0.25
#declare PitchersPlate_Z = 3

#declare Xbox  = 14.5          // position of inside of box
#declare Zbox  = 0.05          // thickness of chalk
#declare Wbox  = 48            // width of box
#declare Wline = 3             // width of lines... these are inside the box
#declare Ybox  = 36            // position of front and back of box relative to center
#declare Tbox  = Ybox + Xplate // position of top of box
#declare Bbox  = -Ybox + Xplate// position of bottom of box

#declare FoulPole_H  = 65 * Foot
#declare FoulPole_W  = 3 * Foot

#declare Ball_R = 9.125 / (2 * pi)

#declare Bat_Length = 36
#declare Bat_Theta = degrees ( atan2(0.0347 - 0.025, 0.9800 - 0.0075) )
              // amount to tilt bat to have it lay on ground
#declare Bat_X0    = 0.025 * Bat_Length + 0.0075 *  tan( radians ( Bat_Theta ) )

#declare Bat_Tape_Start = 0.020
#declare Bat_Tape_End   = 0.300
#declare Bat_Band_X     = 0.75 / Bat_Length
#declare Bat_Label_L    = 0.19    // full length of label (normalized)
#declare Bat_Label_X    = 0.7     // center of label (normalized)

#declare Score_W         = 320        // full width
#declare Score_H         = 72.5       // full height of main board
#declare Score_D         = 12         // full depth of main board
#declare Score_P         = <0, Fence_H + Score_H/2 + 4 * Foot, 6 * Foot>
                                      // position of main board relative to fence
#if (Fence_Circular_Flag)
  #declare Score_Theta     = -45      // rotation of scoreboard on circular fence
#else
  #declare Score_Z         =  0.5 * Fence_Z  // position of scoreboard on straight fence
#end
#declare Score_Border_X  = 6
#declare Score_Border_Z  = 6
#declare Score_Support_X = 8
#declare Score_Support_Z = Score_P.y / 2


//////////////////////////////////////////////
// textures
//

#declare Dirt_Color = color rgb <0.8, 0.4, 0.1>

#declare Dirt_Texture =
  texture {
    pigment{color Dirt_Color}
    normal{
      average
      normal_map {
        [1 granite 0.08  scale 0.005]
        [1 granite 0.08  scale 0.015]
        [1 granite 0.12  scale 0.06]
        [1 bozo 0.16     scale 0.24]
      }
    }
    finish { crand 0.025 }
  }

#declare Grass_Texture =
  texture {
    pigment{color rgb <0, 0.5, 0>}
    normal{granite 0.08 scale 0.001}
    finish { crand 0.2 }
  }

#declare Worn_Grass =
  texture {
    granite
    texture_map {
      [-0.5 Dirt_Texture]
      [0.3 Grass_Texture]
      [1  Grass_Texture]
    }
    frequency (0.025)
  }

#declare Chalk_Texture =
  texture {
    Dirt_Texture
    pigment {
      granite
      color_map {
        [0.3  color rgbt <1, 1, 1, 1>]
        [0.6  color rgbt <1, 1, 1, 0>]
      }
      scale 0.25
      turbulence 0.5
    }
    finish {
      crand 0.05
      specular 0.1
      roughness 0.5
    }
  }

#declare Plate_Texture =
  texture {
   granite
   texture_map {
     [-3  Dirt_Texture ]
     [1 pigment{ color rgb <1, 1, 1> } ]
   }
   sine_wave
   scale 15
  }

#declare Base_Texture =
  texture {
    pigment {
      granite
      color_map {
        [-2  color Dirt_Color]
        [1   color rgb 1]
      }
      triangle_wave
      scale 15
    }
    normal {
      granite 0.2
      scale 3
    }
    finish {
      specular 0.05
      roughness 0.25
      diffuse 0.3
      ambient 0.2
    }
  }

#declare Bat_Wood_Texture =
  texture {
    pigment {
      wood
      color_map {
        [0.0 color rgb <0.8, 0.7, 0.1>]
        [0.5 color rgb <0.8, 0.6, 0>  ]
        [1.0 color rgb <0.8, 0.7, 0.1>]
      }
      scale 0.005
      translate 0.1 * z        // move wood away from trunk center
      sine_wave
      rotate <90, 2, 2>
    }
    finish {
      specular 0.09
      roughness 0.2
    }
  }
  texture {
    pigment {
      image_map {
        png "bat_label.png"
        transmit 1, 1
        map_type 2
        interpolate 2
        once
      }
      translate -0.5 * y
      scale Bat_Label_L
      translate Bat_Label_X * y
      rotate 180 * y
    }
    finish {
      specular 0.13
      roughness 0.2
    }
  }

#declare Bat_Tape_Pigment = pigment { color rgb 0.1 }
#declare Bat_Band_Pigment = pigment { color rgb <0.05, 0.2, 0.05> }
#declare Bat_Tape_Finish =
  finish {
    specular 0.05
    roughness 0.2
    ambient 0.1
    diffuse 0.9
    crand 0.1
  }
#declare Bat_Band_Finish =
  finish {
    specular 0.2
    roughness 0.1
    ambient 0.1
    diffuse 0.9
  }

#declare Bat_Tape_Texture =
  texture {
    pigment { Bat_Tape_Pigment }
    finish { Bat_Tape_Finish }
    normal {
      // gradient y yields bands of tape
      spiral1 2 0.05
      ramp_wave
      scale 0.03
      slope_map {
        [0, <0, 0>]
        [1, <1, 0>]
      }
    }
  }

#declare Bat_Band_Texture =
  texture {
    pigment { Bat_Band_Pigment }
    finish { Bat_Band_Finish }
  }

#declare Bat_Texture =
  texture {
    gradient y
    texture_map {
      [Bat_Tape_Start                Bat_Wood_Texture]
      [Bat_Tape_Start                Bat_Tape_Texture]
      [(Bat_Tape_End - Bat_Band_X)   Bat_Tape_Texture]
      [(Bat_Tape_End - Bat_Band_X)   Bat_Band_Texture]
      [Bat_Tape_End                  Bat_Band_Texture]
      [Bat_Tape_End                  Bat_Wood_Texture]
    }
  }


#declare Ball_Clean_Texture =
  texture {
    pigment {
      image_map {
        gif "baseball_texture2.gif"
        interpolate 2
      }
    }
    normal {
      bump_map {
        gif "baseball_bump2.gif"
        interpolate 2
      }
    }
    finish {
      specular 0.15
      roughness 0.1
      crand 0
      diffuse 0.4
      ambient 0.1
    }
  }

#declare Ball_Dirty_Texture =
  texture {
    pigment {
      image_map {
        gif "baseball_dirty2.gif"
      }
    }
    normal {
      bump_map {
        gif "baseball_bump2.gif"
        interpolate 2
      }
    }
    finish {
      specular 0.15
      roughness 0.15
      crand 0.4
      diffuse 0.5
      ambient 0.1
    }
  }

#declare Ball_Texture =
  texture {
    granite
    texture_map {
      [-1.5  Ball_Dirty_Texture]
      [1.5   Ball_Clean_Texture]
    }
    frequency 1
    translate <-1, -1, 0>/2
    scale 3 * Ball_R
    triangle_wave
  }

#declare Fence_Color = color rgb <0, 0.4, 0.1>

#declare FoulPole_Texture =
  texture {
    pigment {
      color Fence_Color transmit 0.75
    }
  }

#if (Fence_Circular_Flag)
 #declare Fence_Texture =
  texture {
    pigment {
      color Fence_Color
    }
  }
  texture {
    pigment {
      image_map {
        gif "fencenumbers_330.gif"
        transmit 0, 1
        interpolate 2
        once
      }
      translate <-0.5, -0.5, 0>
      scale     <Fence_Numbers_W, Fence_Numbers_H, 1>
      translate <0, Fence_H / 2, Fence_R>
      rotate    -y * Fence_Theta_Lines
    }
  }
  texture {
    pigment {
      image_map {
        gif "fencenumbers_330.gif"
        transmit 0, 1
        interpolate 2
        once
      }
      translate <-0.5, -0.5, 0>
      scale     <Fence_Numbers_W, Fence_Numbers_H, 1>
      translate <0, Fence_H / 2, Fence_R>
      rotate    y * Fence_Theta_Lines
    }
  }
  texture {
    pigment {
      image_map {
        gif "fencenumbers_392.gif"
        transmit 0, 1
        interpolate 2
        once
      }
      translate <-0.5, -0.5, 0>
      scale     <Fence_Numbers_W, Fence_Numbers_H, 1>
      translate <0, Fence_H / 2, Fence_R>
      rotate    -y * Fence_Theta_Alley
    }
  }
  texture {
    pigment {
      image_map {
        gif "fencenumbers_392.gif"
        transmit 0, 1
        interpolate 2
        once
      }
      translate <-0.5, -0.5, 0>
      scale     <Fence_Numbers_W, Fence_Numbers_H, 1>
      translate <0, Fence_H / 2, Fence_R>
      rotate    y * Fence_Theta_Alley
    }
  }
  texture {
    pigment {
      image_map {
        gif "fencenumbers_410.gif"
        transmit 0, 1
        interpolate 2
        once
      }
      translate <-0.5, -0.5, 0>
      scale     <Fence_Numbers_W, Fence_Numbers_H, 1>
      translate <0, Fence_H / 2, Fence_R>
    }
  }
#else
  #declare Fence_Texture =
    texture {
      finish {
        diffuse 0.6
        ambient 0.1
      }
      pigment { color Fence_Color }
    }
  #declare Fence_L_Texture =
    texture {
      Fence_Texture
    }
    texture {
      pigment {
        image_map {
          gif "fencenumbers_350.gif"
          transmit 0, 1
          interpolate 2
          once
        }
        translate <-0.5, -0.5, 0>
        scale     <Fence_Numbers_W, Fence_Numbers_H, 1>
        rotate -90 * y
        translate <-Fence_Lines, Fence_H / 2, Fence_Numbers_W>
      }
    }
    texture {
      pigment {
        image_map {
          gif "fencenumbers_411.gif"
          transmit 0, 1
          interpolate 2
          once
        }
        translate <-0.5, -0.5, 0>
        scale     <Fence_Numbers_W, Fence_Numbers_H, 1>
        rotate -90 * y
        translate <-Fence_Lines, Fence_H / 2, Fence_Z - Fence_Numbers_W>
      }
    }
  #declare Fence_R_Texture =
    texture {
      Fence_Texture
    }
    texture {
      pigment { color Fence_Color }
      pigment {
        image_map {
          gif "fencenumbers_350.gif"
          transmit 0, 1
          interpolate 2
          once
        }
        translate <-0.5, -0.5, 0>
        scale     <Fence_Numbers_W, Fence_Numbers_H, 1>
        rotate  90 * y
        translate <Fence_Lines, Fence_H / 2, Fence_Numbers_W>
      }
    }
    texture {
      pigment {
        image_map {
          gif "fencenumbers_411.gif"
          transmit 0, 1
          interpolate 2
          once
        }
        translate <-0.5, -0.5, 0>
        scale     <Fence_Numbers_W, Fence_Numbers_H, 1>
        rotate 90 * y
        translate <Fence_Lines, Fence_H / 2, Fence_Z - Fence_Numbers_W>
      }
    }
  #declare Fence_C_Texture =
    texture {
      Fence_Texture
    }
    texture {
      pigment { color Fence_Color }
      /****************************
      pigment {
        image_map {
          gif "fencenumbers_400.gif"
          transmit 0, 1
          interpolate 2
          once
        }
        translate <-0.5, -0.5, 0>
        scale     <Fence_Numbers_W, Fence_Numbers_H, 1>
        translate <0, Fence_H / 2, Fence_Center>
      }
      ****************************/
    }

#end

#declare Score_Texture =
  texture {
    pigment {
      color  <0, 0.25, 0>
    }
  }

#end

